
$(document).ready(function(){

	  $('.js-slider-structural-framing').each(function () {
		var slider = $(this);
		slider.slick({
			slidesToShow: 3,
			slidesToScroll: 1,
		/* 	centerMode: true,
			centerPadding: '2%',
			variableWidth: true, */
			arrows: true,
			speed: 300,
			infinite: true,
			prevArrow: slider.closest('.js-slider-container').find('.slider-arrow-prev'),
			nextArrow: slider.closest('.js-slider-container').find('.slider-arrow-next'),
			responsive: [
			{
				breakpoint: 768,
				settings: {
					slidesToShow: 1,
					slidesToScroll: 1
				}
			  }
			]
		});
	  })

	$('.js-slider-gallery').slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		arrows: false,
		fade: true,
		asNavFor: '.js-slider-gallery-nav'
	  });
	  $('.js-slider-gallery-nav').slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		mobileFirst: true,
		rows: 1,
		asNavFor: '.js-slider-gallery',
		dots: false,
		arrows: true,
		prevArrow: $('.slider-arrow-prev'),
		nextArrow: $('.slider-arrow-next'),
		focusOnSelect: true,
		responsive: [
			{
				breakpoint: 576,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1,
					rows: 1,

					infinite: true
				}
			  },
			  {
				breakpoint: 991,
				settings: {
				  slidesToShow: 3,
				  slidesToScroll: 1,
				  rows: 1
				}
			  }
			]
			
	  });
	
	  $('.js-slider-project-gallery').slick({
		slidesToShow: 4,
		slidesToScroll: 4,
		centerMode: true,
		arrows: false,
		dots: true,
		appendDots: $('.slick-slider-dots'),
		responsive: [
			{
				breakpoint: 600,
				settings: {
					slidesToShow: 1
				}
			},
			{
				breakpoint: 992,
				settings: {
					slidesToShow: 2
				}
			},
			{
				breakpoint: 1500,
				settings: {
					slidesToShow: 3
				}
			}
			  
			]
	  });


	  $("#jsSliderHeader").slick({
		dots: true,
		infinite: true,
		autoplay: true,
		speed: 300,
		appendDots: $('.js-slider-header-btns'),
		customPaging: function(slider, i) { 
			if($(slider.$slides[i]).children().data('id') == 'masonry-service'){
				return `<a data-slide="${i}" class="lh-lg-mob" href="#${$(slider.$slides[i]).children().data('id')}"">${$(slider.$slides[i]).children().attr('title')}</a>`;
			}
			return `<a data-slide="${i}" href="#${$(slider.$slides[i]).children().data('id')}"">${$(slider.$slides[i]).children().attr('title')}</a>`;
		},
		arrows: false,
		slidesToShow: 1,
		slidesToScroll: 1
	});

	$('.js-slider-header-btns li').mouseover(function() {
		var nr = $(this).children().data('slide');
		$("#jsSliderHeader").slick('slickGoTo', nr)
	});
	
});

