/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* MASONRY OFFER */
var masonryOfferEl = document.getElementById('masonryOffer');
if (masonryOfferEl) {
	var masonryOfferDescEl = document.getElementById('masonryOfferDesc');
	var masonryOfferDescCollapseElementList = [].slice.call(masonryOfferDescEl.querySelectorAll('.collapse'))
	var masonryOfferDescCollapseList = masonryOfferDescCollapseElementList.map(function (collapseEl) {
	  return new bootstrap.Collapse(collapseEl, {
		toggle: false
	  })
	})
	
	var masonryOfferCollapseElementList = [].slice.call(masonryOfferEl.querySelectorAll('.collapse'))
	var masonryOfferCollapseList = masonryOfferCollapseElementList.map(function (collapseEl) {
	  var collapse = new bootstrap.Collapse(collapseEl, {
		toggle: false
	  });
	
	  collapseEl.addEventListener('hide.bs.collapse', function () {
		for (const key in masonryOfferDescCollapseList) {
		  masonryOfferDescCollapseList[key].hide();
		} 
	  })  
	
	  return collapse;
	})
}


/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');
		if (!thumbnailElement?.style.backgroundImage) {
			inputElement.click();
		}
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
});

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').classList.add('d-none');
	}

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);		
	}

	let dropZoneElementName = dropZoneElement.querySelector('.drop-zone-thumb-name');

	if (!dropZoneElementName) {
		dropZoneElementName = document.createElement('div');
		dropZoneElementName.classList.add('drop-zone-thumb-name');
		dropZoneElementName.innerText = file.name;
		thumbnailElement.appendChild(dropZoneElementName);		

		let deleteThumbnailBtn = document.createElement('span');
		deleteThumbnailBtn.className = 'fi-rr-cross drop-zone-delete-thumbnail'
		dropZoneElementName.appendChild(deleteThumbnailBtn);

		deleteThumbnailBtn.addEventListener('click', (e) => {
			thumbnailElement.remove();
			dropZoneElement.querySelector('.drop-zone-prompt').classList.remove('d-none');
			dropZoneElement.querySelector('.drop-zone-input').value = '';
			e.preventDefault();
		});
	}

	// thumbnailElement.dataset.label = file.name;

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else {
		thumbnailElement.style.backgroundImage = null;
	}
}

/* IMAGES BACKROUND SRC */
let list = document.getElementsByClassName('js-image-src');

for (let i = 0; i < list.length; i++) {
  let src = list[i].getAttribute('data-image-src');
  list[i].style.backgroundImage="url('" + src + "')";
}

/* FORM SUBSCRIBE NUMBER  */
let formSubscribeNumberInput = document.getElementById('formSubscribeNumber').querySelector('#formSubscribeNumberInput');
let modalRequestCallBack = document.getElementById('modalRequestCallBack');
let formRequestCallBackNumInput = modalRequestCallBack.querySelector('#formRequestCallBackNumInput');

modalRequestCallBack.addEventListener('show.bs.modal', function () {
	formRequestCallBackNumInput.value = formSubscribeNumberInput.value;
  })