/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* MASONRY OFFER */
var masonryOfferEl = document.getElementById('masonryOffer');
if (masonryOfferEl) {
	var masonryOfferDescEl = document.getElementById('masonryOfferDesc');
	var masonryOfferDescCollapseElementList = [].slice.call(masonryOfferDescEl.querySelectorAll('.collapse'))
	var masonryOfferDescCollapseList = masonryOfferDescCollapseElementList.map(function (collapseEl) {
	  return new bootstrap.Collapse(collapseEl, {
		toggle: false
	  })
	})
	
	var masonryOfferCollapseElementList = [].slice.call(masonryOfferEl.querySelectorAll('.collapse'))
	var masonryOfferCollapseList = masonryOfferCollapseElementList.map(function (collapseEl) {
	  var collapse = new bootstrap.Collapse(collapseEl, {
		toggle: false
	  });
	
	  collapseEl.addEventListener('hide.bs.collapse', function () {
		for (const key in masonryOfferDescCollapseList) {
		  masonryOfferDescCollapseList[key].hide();
		} 
	  })  
	
	  return collapse;
	})
}


/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	addDropZoneEvents(inputElement);
});

function addDropZoneEvents(inputElement) {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
		// let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');
		// if (!thumbnailElement) {
		// 	inputElement.click();
		// }
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
}

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}	

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);		
	}

	let dropZoneElementName = dropZoneElement.querySelector('.drop-zone-thumb-name');

	if (!dropZoneElementName) {
		dropZoneElementName = document.createElement('div');
		dropZoneElementName.classList.add('drop-zone-thumb-name');
		dropZoneElementName.innerText = file.name;
		thumbnailElement.appendChild(dropZoneElementName);		

		let deleteThumbnailBtn = document.createElement('span');
		deleteThumbnailBtn.className = 'fi-rr-cross drop-zone-delete-thumbnail'
		dropZoneElementName.appendChild(deleteThumbnailBtn);

		deleteThumbnailBtn.addEventListener('click', (e) => {

			dropZoneElement.remove();
			e.stopImmediatePropagation();
		});
	}

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else if (file.name.split('.').pop() == 'pdf') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PDF.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'docx') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/DOC.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'psd') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PSD.svg)';
		thumbnailElement.classList.add('bg-not-cover');
	} 
	else {
		thumbnailElement.style.backgroundImage = null;
	}
	addDropZone();

}

function addDropZone() {
	let dropZoneContainer = document.getElementById('dropZone');
	
	let dropZone = document.createElement('div');
	dropZone.className = 'drop-zone mb-4';
	dropZoneContainer.append(dropZone);

	let dropZonePrompt = document.createElement('div');
	dropZonePrompt.className = 'drop-zone-prompt';
	dropZone.append(dropZonePrompt);

	let dropZonePromptIcon = document.createElement('span');
	dropZonePromptIcon.className = 'drop-zone-prompt-img fi-rr-upload me-2';
	dropZonePrompt.append(dropZonePromptIcon);


	let dropZonePromptTitle = document.createElement('span');
	dropZonePromptTitle.innerText = 'Drag & Drop Project Files';
	dropZonePrompt.append(dropZonePromptTitle);
	
	let dropZoneInput = document.createElement('input');
	dropZoneInput.type = 'file';
	dropZoneInput.name = 'File[]';
	dropZoneInput.className = 'drop-zone-input';
	dropZone.append(dropZoneInput);

	addDropZoneEvents(dropZoneInput);
}

/* IMAGES BACKROUND SRC */
let list = document.getElementsByClassName('js-image-src');

for (let i = 0; i < list.length; i++) {
  let src = list[i].getAttribute('data-image-src');
  list[i].style.backgroundImage="url('" + src + "')";
}

/* FORM SUBSCRIBE NUMBER  */
let formSubscribeNumberInput = document.getElementById('formSubscribeNumber').querySelector('#formSubscribeNumberInput');
let modalRequestCallBack = document.getElementById('modalRequestCallBack');
let formRequestCallBackNumInput = modalRequestCallBack.querySelector('#formRequestCallBackNumInput');

modalRequestCallBack.addEventListener('show.bs.modal', function () {
	formRequestCallBackNumInput.value = formSubscribeNumberInput.value;
  })