/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* MASONRY OFFER */
var masonryOfferEl = document.getElementById('masonryOffer');
if (masonryOfferEl) {
	var masonryOfferDescEl = document.getElementById('masonryOfferDesc');
	var masonryOfferDescCollapseElementList = [].slice.call(masonryOfferDescEl.querySelectorAll('.collapse'))
	var masonryOfferDescCollapseList = masonryOfferDescCollapseElementList.map(function (collapseEl) {
	  return new bootstrap.Collapse(collapseEl, {
		toggle: false
	  })
	})
	
	var masonryOfferCollapseElementList = [].slice.call(masonryOfferEl.querySelectorAll('.collapse'))
	var masonryOfferCollapseList = masonryOfferCollapseElementList.map(function (collapseEl) {
	  var collapse = new bootstrap.Collapse(collapseEl, {
		toggle: false
	  });
	
	  collapseEl.addEventListener('hide.bs.collapse', function () {
		for (const key in masonryOfferDescCollapseList) {
		  masonryOfferDescCollapseList[key].hide();
		} 
	  })  
	
	  return collapse;
	})
}


/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	addDropZoneEvents(inputElement);
});

function addDropZoneEvents(inputElement) {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
		// let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');
		// if (!thumbnailElement) {
		// 	inputElement.click();
		// }
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
}

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}	

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);		
	}

	let dropZoneElementName = dropZoneElement.querySelector('.drop-zone-thumb-name');

	if (!dropZoneElementName) {
		dropZoneElementName = document.createElement('div');
		dropZoneElementName.classList.add('drop-zone-thumb-name');
		dropZoneElementName.innerText = file.name;
		thumbnailElement.appendChild(dropZoneElementName);		

		let deleteThumbnailBtn = document.createElement('span');
		deleteThumbnailBtn.className = 'fi-rr-cross drop-zone-delete-thumbnail'
		dropZoneElementName.appendChild(deleteThumbnailBtn);

		deleteThumbnailBtn.addEventListener('click', (e) => {

			dropZoneElement.remove();
			e.stopImmediatePropagation();
		});
	}

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else if (file.name.split('.').pop() == 'pdf') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PDF.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'docx') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/DOC.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'psd') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PSD.svg)';
		thumbnailElement.classList.add('bg-not-cover');
	} 
	else {
		thumbnailElement.style.backgroundImage = null;
	}
	addDropZone();

}

function addDropZone() {
	let dropZoneContainer = document.getElementById('dropZone');
	
	let dropZone = document.createElement('div');
	dropZone.className = 'drop-zone mb-4';
	dropZoneContainer.append(dropZone);

	let dropZonePrompt = document.createElement('div');
	dropZonePrompt.className = 'drop-zone-prompt';
	dropZone.append(dropZonePrompt);

	let dropZonePromptIcon = document.createElement('span');
	dropZonePromptIcon.className = 'drop-zone-prompt-img fi-rr-upload me-2';
	dropZonePrompt.append(dropZonePromptIcon);


	let dropZonePromptTitle = document.createElement('span');
	dropZonePromptTitle.innerText = 'Drag & Drop Project Files';
	dropZonePrompt.append(dropZonePromptTitle);
	
	let dropZoneInput = document.createElement('input');
	dropZoneInput.type = 'file';
	dropZoneInput.name = 'File[]';
	dropZoneInput.className = 'drop-zone-input';
	dropZone.append(dropZoneInput);

	addDropZoneEvents(dropZoneInput);
}

/* IMAGES BACKROUND SRC */
let list = document.getElementsByClassName('js-image-src');

for (let i = 0; i < list.length; i++) {
  let src = list[i].getAttribute('data-image-src');
  list[i].style.backgroundImage="url('" + src + "')";
}

/* FORM SUBSCRIBE NUMBER  */
let formSubscribeNumberInput = document.getElementById('formSubscribeNumber').querySelector('#formSubscribeNumberInput');
let modalRequestCallBack = document.getElementById('modalRequestCallBack');
let formRequestCallBackNumInput = modalRequestCallBack.querySelector('#formRequestCallBackNumInput');

modalRequestCallBack.addEventListener('show.bs.modal', function () {
	formRequestCallBackNumInput.value = formSubscribeNumberInput.value;
})


/* FORMS */

var forms = document.getElementsByClassName('js-send-form');

Array.from(forms).forEach((form) => {

	form.addEventListener('submit', function(event) {
		event.preventDefault();
        
        if (!form.checkValidity()) {
            form.classList.add('form-validated')
            return false;
        }

        var formData = new FormData(form);

		var inputsFile = document.querySelectorAll('input[type="file"]');
		
		if(inputsFile){
			//var upload_counter = 0;
			inputsFile.forEach(input =>{
				if(input.files.length == 1){
					//upload_counter++;
					formData.append(`FileUpload[]`,input.files[0]);
				}
			})
		}

		grecaptcha.ready(function() {
			grecaptcha.execute('6LdMLa4cAAAAALe3fZb0afV_C_TMjLxsMwqDqD_l', {action:'submit'}).then(function(token) {

				formData.append('wa-recaptcha', token);

				var req = new XMLHttpRequest();
				req.open('POST', 'https://mailer.apps.webarray.com/post/ASwvlV3rN1b9DiC0r8f85c4MBI9KGShb', false);
				
				// are files being uploaded?
				    // if true then show upload dialog if there are files to upload


				req.onreadystatechange = function() {

					if (this.readyState === XMLHttpRequest.DONE && this.status === 200) {

						// hide upload modal if it's been shown

						// if status code = 200
						     // show success message
				        // else
						    // show error message

						let bsModalFormSuccess = new bootstrap.Modal(document.getElementById('modalRequestSendSuccess'), {})
                        bsModalFormSuccess.show();

						let bsModalCallBack = document.getElementById('modalRequestCallBack');
                        let modalCallBack = bootstrap.Modal.getInstance(bsModalCallBack);
                        modalCallBack.hide();
					}	
				}
				req.send(formData);
			});
		});
	});
});


/* *********************** AOS ************************** */
$(window).on('load', function() {
	AOS.init({
		// Global settings:
		disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
		startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
		initClassName: 'aos-init', // class applied after initialization
		animatedClassName: 'aos-animate', // class applied on animation
		useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
		disableMutationObserver: false, // disables automatic mutations' detections (advanced)
		debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
		throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)
		
	
		// Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
		offset: 120, // offset (in px) from the original trigger point
		delay: 0, // values from 0 to 3000, with step 50ms
		duration: 400, // values from 0 to 3000, with step 50ms
		easing: 'ease', // default easing for AOS animations
		once: true, // whether animation should happen only once - while scrolling down
		mirror: false, // whether elements should animate out while scrolling past them
		anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation
	});
});

