	
/* *********************** AOS ************************** */

AOS.init({
	// Global settings:
	disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
	startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
	initClassName: 'aos-init', // class applied after initialization
	animatedClassName: 'aos-animate', // class applied on animation
	useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
	disableMutationObserver: false, // disables automatic mutations' detections (advanced)
	debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
	throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)
	

	// Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
	offset: 120, // offset (in px) from the original trigger point
	delay: 0, // values from 0 to 3000, with step 50ms
	duration: 400, // values from 0 to 3000, with step 50ms
	easing: 'ease', // default easing for AOS animations
	once: true, // whether animation should happen only once - while scrolling down
	mirror: false, // whether elements should animate out while scrolling past them
	anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation

});

/* *********************** BUTTONS ANIMATION ************************** */
document.querySelectorAll('.btn-animation').forEach((el)=>{
	el.addEventListener('mouseenter', function (event) {
	  	let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
	el.addEventListener('mouseout', function (event) {
		let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
});

 /* *********************** MAIN MENU ************************** */
let btnBurger = document.getElementById('navbarNavAltMarkup')
let navbar = document.querySelector('.navbar');

btnBurger.addEventListener('show.bs.collapse', function () {
	navbar.classList.add('active');
	
})
btnBurger.addEventListener('hidden.bs.collapse', function () {
	navbar.classList.remove('active');

})

 /* *********************** ADD MY TOM SELECT ************************** */
 document.querySelectorAll('.tom-select').forEach((el)=>{
    new TomSelect(el,{
		maxOptions: null,
		render:{
			option: function(data, escape) {
				let text = escape(data.text);
				let img = data.$option.dataset.icon;

				let option = '<div class="d-flex align-items-center py-3">';
				if(img){
					option = option + '<img class="mx-4 icon-flyer" src="' + img + '">';
				}
				option = option + text;
				option = option + '</div>';
				return option;
			},
			item: function(data, escape) {
				let text = escape(data.text);
				let img = data.$option.dataset.icon;

				let option = '<div class="d-flex align-items-center">';

				if(img){
					if(img == 'dist/images/dropdown/map-dot.svg'){ /* @todo change this to be full url with / */
						option = option + '<img class="me-4 icon-flyer" src="dist/images/dropdown/map-marker.svg">'; /* @todo change this to be full url with / */
					}
					else {
						option = option + '<img class="me-4 icon-flyer" src="' + img + '">';
					}
				}
				option = option + text;
				option = option + '</div>';
				return option;
			}
		}
	});

});

 /* *********************** BTN FAQ MORE ************************** */
let collapseFaq = document.getElementById('js-collapseFaq');
let faqButton = document.getElementById('faqBtn');
collapseFaq.addEventListener('hide.bs.collapse', function () {
	faqButton.innerHTML = 'Show all <i class="icon-arrow-down-1 fw-semibold ms-3"></i>';
})
collapseFaq.addEventListener('shown.bs.collapse', function () {
	faqButton.innerHTML = 'Show less <i class="icon-arrow-up-2 fw-semibold ms-3"></i>';
})

 /* ***********************  SELECT MAPS ************************** */
 let mapCard = document.getElementById('mapCard');
 let mapSelect = document.getElementById('mapSelect')
 mapSelect.addEventListener('change', function(event){
	let imgSrc = event.target.options[event.target.selectedIndex].dataset.img;
	let totalHouses = event.target.options[event.target.selectedIndex].dataset.totalHouses;
	let totalCost = event.target.options[event.target.selectedIndex].dataset.totalCost;
	
	/****** ADD IMAGE *****/  
	let cardImage = mapCard.querySelector('.js-card-img');
	cardImage.innerHTML = '';

	let imgElement = document.createElement('img');
	imgElement.className = 'top-rounded-6';
	imgElement.setAttribute('src', `${imgSrc}`);
	imgElement.style.maxHeight = '434px';
	cardImage.append(imgElement);


	/****** ADD TOTAL HOUSES *****/ 
	let cardTotalHourse = mapCard.querySelector('.js-total-houses');
	cardTotalHourse.innerHTML =''

	let elementHousNum = document.createElement('h3');
	elementHousNum.className = 'text-black fw-bold';
	elementHousNum.innerHTML = `${totalHouses}`;
	cardTotalHourse.append(elementHousNum);


	/****** ADD TOTAL COST *****/ 
	let cardTotalCost = mapCard.querySelector('.js-total-cost');
	cardTotalCost.innerHTML =''

	let elementCostNum = document.createElement('h3');
	elementCostNum.className = 'text-primary fw-bold';
	elementCostNum.innerHTML = `${totalCost}`;
	cardTotalCost.append(elementCostNum);

 });
 /* *********************** TABLE PRICE ************************** */
let pricingTable = document.getElementById('pricingTable');
let pricingSelect = document.getElementById('pricingSelect');
pricingSelect.addEventListener('change', function () {
	let tbody = pricingTable.querySelector('tbody');
	tbody.innerHTML = '';
	if (this.value == 1){
		table1Data.forEach(element => {
			tbody.innerHTML += `<tr><td class="bg-light-primary">${element.PricingTiers}</td><td class="text-center">${element.Price}</td></tr>`;
		});
	} else if(this.value == 2) {
		table2Data.forEach(element => {
			tbody.innerHTML += `<tr><td class="bg-light-primary">${element.PricingTiers}</td><td class="text-center">${element.Price}</td></tr>`;
		});
	} else if(this.value == 3) {
		table3Data.forEach(element => {
			tbody.innerHTML += `<tr><td class="bg-light-primary">${element.PricingTiers}</td><td class="text-center">${element.Price}</td></tr>`;
		});
	}
})

let table1Data = [
	{ PricingTiers: 3000, Price: '$ 350'},
	{ PricingTiers: 5000, Price: '$ 600'},
	{ PricingTiers: 7000, Price: '$ 750'},
	{ PricingTiers: 3000, Price: '$ 350'},
	{ PricingTiers: 5000, Price: '$ 600'},
	{ PricingTiers: 7000, Price: '$ 750'},
	{ PricingTiers: 7000, Price: '$ 750'}
];
let table2Data = [
	{ PricingTiers: 3333, Price: '$ 350'},
	{ PricingTiers: 5000, Price: '$ 600'},
	{ PricingTiers: 7777, Price: '$ 750'},
	{ PricingTiers: 3000, Price: '$ 350'},
	{ PricingTiers: 5555, Price: '$ 600'},
	{ PricingTiers: 7000, Price: '$ 750'},
	{ PricingTiers: 7000, Price: '$ 750'}
];
let table3Data = [
	{ PricingTiers: 3000, Price: '$ 350'},
	{ PricingTiers: 5555, Price: '$ 600'},
	{ PricingTiers: 7000, Price: '$ 750'},
	{ PricingTiers: 3111, Price: '$ 350'},
	{ PricingTiers: 5000, Price: '$ 600'},
	{ PricingTiers: 7111, Price: '$ 750'},
	{ PricingTiers: 7000, Price: '$ 750'}
];