/* *********************** API ************************** */
 function getApi(action, callback){

	var xhr = new XMLHttpRequest();
	xhr.open('GET', `https://doormarketing.buildmy.ca/api/pricing.php?${action}`, true);
	xhr.withCredentials = false;

	xhr.onload = function() {
 
	   var jsonData = JSON.parse(xhr.responseText);
 
	   if(callback) callback(jsonData);
 
	   if (xhr.readyState == 4 && xhr.status == 200) {
 
		  console.log('ok');
 
	 }  else {
 
		   console.log('error');
 
	 }
	};
 
	 xhr.send();
}

/* let pricingSelect = document.getElementById('pricingSelect');
let pricingTable = document.getElementById('pricingTable'); */

let printingSelect = document.getElementById('printingSelect');
let printingTable = document.getElementById('printingTable');

let sharedMarketingSelect = document.getElementById('sharedMarketingSelect');
let sharedMarketingCard = document.getElementById('sharedMarketingCard');

let fullServiceData, printingData, sharedMarketingData;

/* getApi('FullService', function(jsonData){
	fullServiceData = jsonData.result;
	createSelect(jsonData.result, pricingSelect);
	createTable(jsonData.result[0].prices, pricingTable);
}); */

getApi('Printing', function(jsonData){
	printingData = jsonData.result;
	createSelect(jsonData.result, printingSelect);
	createTable(jsonData.result[0].prices, printingTable);
});

getApi('SharedMarketing', function(jsonData){
	sharedMarketingData = jsonData.result;
	createSelect(jsonData.result, sharedMarketingSelect);
	createCard(jsonData.result[0], sharedMarketingCard);
});

/* *********************** CHANGE SELECT ************************** */
/* pricingSelect.addEventListener('change', function () {

	for(let i in fullServiceData){
		if(this.value == fullServiceData[i].value){
			let selectedData = fullServiceData[i].prices;
			createTable(selectedData, pricingTable);
		}
	}
}) */

printingSelect.addEventListener('change', function () {

	for(let i in printingData){
		if(this.value == printingData[i].value){
			let selectedData = printingData[i].prices;
			createTable(selectedData, printingTable);
		}
	}
})


sharedMarketingSelect.addEventListener('change', function(){

	for(let i in sharedMarketingData){
		if(this.value == sharedMarketingData[i].value){
			createCard(sharedMarketingData[i], sharedMarketingCard);
		}
	}
})

 /* *********************** TOM SELECT SETTINGS ************************** */
 let tomSelectSettings = {
	maxOptions: null,
	render:{
		option: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center py-3">';
			if(img){
				option = option + '<img class="mx-4 icon-flyer" src="' + img + '">';
			}
			option = option + text;
			option = option + '</div>';
			return option;
		},
		item: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center">';

			if(img){
				if(img == 'dist/images/dropdown/map-dot.svg'){ /* @todo change this to be full url with / */
					option = option + '<img class="me-4 icon-flyer" src="dist/images/dropdown/map-marker.svg">'; /* @todo change this to be full url with / */
				}
				else {
					option = option + '<img class="me-4 icon-flyer" src="' + img + '">';
				}
			}
			option = option + text;
			option = option + '</div>';
			return option;
		}
	}
};

/* *********************** CREATE SELECT ************************** */
function createSelect(options, id) {
	
	options.forEach(el => {
		let option = document.createElement('option');
		option.value = el.value;
		option.dataset.icon = el.icon;
		option.dataset.prices = {};
		for (const property in el.prices) {
			option.dataset.prices[property] = el.prices[property];
		}
		option.innerText = el.title;

		id.append(option);
	})

	/* *********************** ADD MY TOM SELECT ************************** */
    new TomSelect(id, tomSelectSettings);

}

/* *********************** CREATE TABLE ************************** */
function createTable(prices, id) {

	let tbody = id.querySelector('tbody');
	tbody.innerHTML = '';

	for (let [key, value] of Object.entries(prices)) {
		let tr = document.createElement('tr');
		tbody.append(tr);

		let tdPricing = document.createElement('td');
		tdPricing.className = 'col-8 bg-light-primary';
		tdPricing.innerText = key;
		tr.append(tdPricing);

		let tdPrice = document.createElement('td');
		tdPrice.className = 'col-4 text-center';
		tdPrice.innerText = value;
		tr.append(tdPrice);
	}
}

/* ***********************  CREATE CARD ************************** */

function createCard(item, id) {
	
	/****** ADD IMAGE *****/  
	let cardImage = id.querySelector('.js-card-img');
	cardImage.innerHTML = '';

	let imgElement = document.createElement('img');
	imgElement.className = 'top-rounded-6';
	imgElement.setAttribute('src', item.image);
	imgElement.style.maxHeight = '434px';
	cardImage.append(imgElement);


	/****** ADD TOTAL HOUSES *****/ 
	let cardTotalHourse = id.querySelector('.js-total-houses');
	cardTotalHourse.innerHTML =''

	let elementHousNum = document.createElement('h3');
	elementHousNum.className = 'text-black fw-bold';
	elementHousNum.innerText = item.houses;
	cardTotalHourse.append(elementHousNum);


	/****** ADD TOTAL COST *****/ 
	let cardTotalCost = id.querySelector('.js-total-cost');
	cardTotalCost.innerHTML =''

	let elementCostNum = document.createElement('h3');
	elementCostNum.className = 'text-primary fw-bold';
	elementCostNum.innerText = item.cost;
	cardTotalCost.append(elementCostNum);
}	


/* *********************** BUTTONS ANIMATION ************************** */
document.querySelectorAll('.btn-animation').forEach((el)=>{
	el.addEventListener('mouseenter', function (event) {
	  	let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
	el.addEventListener('mouseout', function (event) {
		let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
});

 /* *********************** MAIN MENU ************************** */
let btnBurger = document.getElementById('navbarNavAltMarkup')
let navbar = document.querySelector('.navbar');

btnBurger.addEventListener('show.bs.collapse', function () {
	navbar.classList.add('active');
	
})
btnBurger.addEventListener('hidden.bs.collapse', function () {
	navbar.classList.remove('active');

})

 /* *********************** ADD MY TOM SELECT ************************** */
 document.querySelectorAll('.tom-select').forEach((el)=>{
    new TomSelect(el, tomSelectSettings)
});


 /* *********************** BTN FAQ MORE ************************** */
let collapseFaq = document.getElementById('js-collapseFaq');
let faqButton = document.getElementById('faqBtn');
collapseFaq.addEventListener('hide.bs.collapse', function () {
	faqButton.innerHTML = 'Show all <i class="icon-arrow-down-1 fw-semibold ms-3"></i>';
})
collapseFaq.addEventListener('shown.bs.collapse', function () {
	faqButton.innerHTML = 'Show less <i class="icon-arrow-up-2 fw-semibold ms-3"></i>';
})
 
/* *********************** AOS ************************** */
AOS.init({
	// Global settings:
	disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
	startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
	initClassName: 'aos-init', // class applied after initialization
	animatedClassName: 'aos-animate', // class applied on animation
	useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
	disableMutationObserver: false, // disables automatic mutations' detections (advanced)
	debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
	throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)
	

	// Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
	offset: 120, // offset (in px) from the original trigger point
	delay: 0, // values from 0 to 3000, with step 50ms
	duration: 400, // values from 0 to 3000, with step 50ms
	easing: 'ease', // default easing for AOS animations
	once: true, // whether animation should happen only once - while scrolling down
	mirror: false, // whether elements should animate out while scrolling past them
	anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation

});