/* *********************** API ************************** */
 function getApi(action, callback){

	var xhr = new XMLHttpRequest();
	xhr.open('GET', `https://doormarketing.buildmy.ca/api/pricing.php?${action}`, true);
	xhr.withCredentials = false;

	xhr.onload = function() {
 
	   var jsonData = JSON.parse(xhr.responseText);
 
	   if(callback) callback(jsonData);
 
	   if (xhr.readyState == 4 && xhr.status == 200) {
 
		  console.log('ok');
 
	 }  else {
 
		   console.log('error');
 
	 }
	};
 
	 xhr.send();
}

/* let pricingSelect = document.getElementById('pricingSelect');
let pricingTable = document.getElementById('pricingTable'); */

let printingSelect = document.getElementById('printingSelect');
let printingTable = document.getElementById('printingTable');

let sharedMarketingSelect = document.getElementById('sharedMarketingSelect');
let sharedMarketingCard = document.getElementById('sharedMarketingCard');

let fullServiceData, printingData, sharedMarketingData;

/* getApi('FullService', function(jsonData){
	fullServiceData = jsonData.result;
	createSelect(jsonData.result, pricingSelect);
	createTable(jsonData.result[0].prices, pricingTable);
}); */

getApi('Printing', function(jsonData){
	printingData = jsonData.result;
	createSelect(jsonData.result, printingSelect);
	createTable(jsonData.result[0].prices, printingTable);
});

getApi('SharedMarketing', function(jsonData){
	sharedMarketingData = jsonData.result;
	createSelect(jsonData.result, sharedMarketingSelect);
	createCard(jsonData.result[0], sharedMarketingCard);
});

/* *********************** CHANGE SELECT ************************** */
/* pricingSelect.addEventListener('change', function () {

	for(let i in fullServiceData){
		if(this.value == fullServiceData[i].value){
			let selectedData = fullServiceData[i].prices;
			createTable(selectedData, pricingTable);
		}
	}
}) */

printingSelect.addEventListener('change', function () {

	for(let i in printingData){
		if(this.value == printingData[i].value){
			let selectedData = printingData[i].prices;
			createTable(selectedData, printingTable);
		}
	}
})


sharedMarketingSelect.addEventListener('change', function(){

	for(let i in sharedMarketingData){
		if(this.value == sharedMarketingData[i].value){
			createCard(sharedMarketingData[i], sharedMarketingCard);
		}
	}
})

 /* *********************** TOM SELECT SETTINGS ************************** */
 let tomSelectSettings = {
	maxOptions: null,
	render:{
		option: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center py-3">';
			if(img){
				option = option + '<img class="mx-4 icon-flyer" src="' + img + '">';
			}
			option = option + text;
			option = option + '</div>';
			return option;
		},
		item: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center">';

			if(img){
				if(img == 'dist/images/dropdown/map-dot.svg'){ /* @todo change this to be full url with / */
					option = option + '<img class="me-4 icon-flyer" src="dist/images/dropdown/map-marker.svg">'; /* @todo change this to be full url with / */
				}
				else {
					option = option + '<img class="me-4 icon-flyer" src="' + img + '">';
				}
			}
			option = option + text;
			option = option + '</div>';
			return option;
		}
	}
};

/* *********************** CREATE SELECT ************************** */
function createSelect(options, id) {
	
	options.forEach(el => {
		let option = document.createElement('option');
		option.value = el.value;
		option.dataset.icon = el.icon;
		option.dataset.prices = {};
		for (const property in el.prices) {
			option.dataset.prices[property] = el.prices[property];
		}
		option.innerText = el.title;

		id.append(option);
	})

	/* *********************** ADD MY TOM SELECT ************************** */
    new TomSelect(id, tomSelectSettings);

}

/* *********************** CREATE TABLE ************************** */
function createTable(prices, id) {

	let tbody = id.querySelector('tbody');
	tbody.innerHTML = '';

	for (let [key, value] of Object.entries(prices)) {
		let tr = document.createElement('tr');
		tbody.append(tr);

		let tdPricing = document.createElement('td');
		tdPricing.className = 'col-8 bg-light-primary';
		tdPricing.innerText = key;
		tr.append(tdPricing);

		let tdPrice = document.createElement('td');
		tdPrice.className = 'col-4 text-center';
		tdPrice.innerText = value;
		tr.append(tdPrice);
	}
}

/* ***********************  CREATE CARD ************************** */

function createCard(item, id) {
	
	/****** ADD IMAGE *****/  
	let cardImage = id.querySelector('.js-card-img');
	cardImage.innerHTML = '';

	cardImage.style.backgroundImage = `url(${item.image})`;


	/****** ADD TOTAL HOUSES *****/ 
	let cardTotalHourse = id.querySelector('.js-total-houses');
	cardTotalHourse.innerHTML =''

	let elementHousNum = document.createElement('h3');
	elementHousNum.className = 'text-black fw-bold';
	elementHousNum.innerText = item.houses;
	cardTotalHourse.append(elementHousNum);


	/****** ADD TOTAL COST *****/ 
	let cardTotalCost = id.querySelector('.js-total-cost');
	cardTotalCost.innerHTML =''

	let elementCostNum = document.createElement('h3');
	elementCostNum.className = 'text-primary fw-bold';
	elementCostNum.innerText = item.cost;
	cardTotalCost.append(elementCostNum);
}	

/* *********************** CREATE ROW ELEMENT ************************** */
function createRowElement() {
	let element = document.createElement('div');
	element.className = 'row justify-content-center align-items-center mb-5';

	return element;
}
/* *********************** CREATE INPUT TYPE HIDDEN ************************** */
function createInputHidden(name, dataDeliveryValue) {
	let inputEl = document.createElement('input');
	inputEl.value = dataDeliveryValue;
	inputEl.name =  name;
	inputEl.type = 'hidden';

	return inputEl;
}

/* *********************** GET A QUOTE SECTION ************************** */
let getQuoteContent = document.getElementById('getQuoteContent');
let getQuoteForm = document.getElementById('getQuote');
let buttonsQuote = getQuoteForm.querySelectorAll('button');
let quoteStartContent = getQuoteForm.querySelector('.quote-start-content');

let dataDeliveryValue;

buttonsQuote.forEach((btn) => {
	btn.addEventListener('click', function(event) {
	quoteStartContent.classList.add('d-none');

	/* ************** CREATE INPUT ************** */
		dataDeliveryValue = btn.dataset.delivery;
		let inputElement = createInputHidden('delivery', dataDeliveryValue);
		getQuoteForm.append(inputElement);

		createStepCardType(dataDeliveryValue);
	})
})

function createStepCardType(dataDeliveryValue) {
	getQuoteContent.innerHTML = '';	

	if(dataDeliveryValue == 'direct'){
		/* ************** CREATE HEADING ************** */
		let rowEl = createRowElement();
		getQuoteContent.append(rowEl);

		let heading = createSectionHeading('Get A Quote', "Doing business online means different things to different businesses.We've got the tools to get your business online easily.");
		rowEl.append(heading);

		/* ************** CREATE ROW ************** */
		let rowEl2 = createRowElement();
		getQuoteContent.append(rowEl2);
		
		/* ************** CREATE COLUMNS ************** */
		let columnEl = createCardFlyer('Flyers', 'Cost effective flyers that can be placed in mailboxes by the door', 'flyers-double.svg', 'card-type', 'flyers', false, false, onCardTypeBtnClicked);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Door Hangers', 'Thick card stock that can be easily hung on door handles for maximized visibility', 'doorhanger-double.svg', 'card-type', 'door-hangers', true, false, onCardTypeBtnClicked);
		rowEl2.append(columnEl2);

		let columnEl3 = createCardFlyer('Postcards', 'Small and durable cards the can be placed in mailboxes or between the door', 'card-double.svg', 'card-type', 'postcards', false, false, onCardTypeBtnClicked);
		rowEl2.append(columnEl3);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	
	}
	if(dataDeliveryValue == 'mailbox'){
		/* ************** CREATE HEADING ************** */
		let rowEl = createRowElement();
		getQuoteContent.append(rowEl);

		let heading = createSectionHeading('Get A Quote 2', "Doing business online means different things to different businesses.We've got the tools to get your business online easily.");
		rowEl.append(heading);
		
		/* ************** CREATE ROW ************** */
		let rowEl2 = createRowElement();
		getQuoteContent.append(rowEl2);
		
		/* ************** CREATE COLUMNS ************** */
		let columnEl = createCardFlyer('Postcards', 'Small and durable cards the can be placed in mailboxes or between the door', 'card-double.svg', 'card-type', 'postcards', true, false, onCardTypeBtnClicked);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Flyers', 'Cost effective flyers that can be placed in mailboxes by the door', 'flyers-double.svg', 'card-type', 'flyers', false, false, onCardTypeBtnClicked);
		rowEl2.append(columnEl2);
		
		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	}
}

/* ************** CREATE SECTION HEADING ************** */
function createSectionHeading(title, desc) {

	/* ************** CREATE COLUMN ************** */
	let column = document.createElement('div');
	column.className = 'col-12 col-sm-10 pe-lg-5 text-center mb-4';

	/* ************** CREATE TITLE ************** */
	let titleEl = document.createElement('h2');
	titleEl.className = 'fw-bold pb-md-3';
	titleEl.innerHTML = title;
	column.append(titleEl);

	/* ************** CREATE DESCRIPTION ************** */
	let descriptionEl = document.createElement('p');
	descriptionEl.className = 'lh-sm my-4 py-2';
	descriptionEl.innerHTML = desc;
	column.append(descriptionEl);

	return column;
}

/* ************** CREATE CARD FLYER ************** */
function createCardFlyer(title, desc, iconName, dataName, dataValue, active, cardSize, onclickFunc) {

	/* ************** CREATE COLUMN ************** */
	let columnEl = document.createElement('div');
	columnEl.className = 'col-12 col-sm-10 col-lg-4 mb-5 mb-lg-0';

	/* ************** CREATE CARD CONTAINER ************** */
	let cardContainer = document.createElement('div');
	cardContainer.className = 'card-flyer';
	if(active){
		cardContainer.classList.add('active');
	}
	if(cardSize){
		cardContainer.classList.add('card-medium');
	}
	columnEl.append(cardContainer);

	/* ************** CREATE CARD BODY ************** */
	let cardBody = document.createElement('div');
	cardBody.className = 'card-flyer-body d-flex flex-column align-items-center h-100';
	cardContainer.append(cardBody);
	
	/* ************** CREATE CARD BODY ICON ************** */
	let cardBodyIcon = document.createElement('div');
	cardBodyIcon.className = 'card-flyer-body-icon';
	cardBody.append(cardBodyIcon);

	let img = document.createElement('img');
	img.src = `dist/images/icons/${iconName}`;
	cardBodyIcon.append(img);

	/* ************** CREATE CARD BODY TEXT ************** */
	let cardBodyText = document.createElement('div');
	cardBodyText.className = 'card-flyer-body-text d-flex justify-content-center';
	cardBody.append(cardBodyText);

	let cardBodyTextCont = document.createElement('div');
	cardBodyTextCont.className = 'mt-auto mb-auto';
	cardBodyText.append(cardBodyTextCont);

	/* ************** CREATE CARD BODY TEXT TITLE ************** */
	let titleEl = document.createElement('h5');
	titleEl.className = 'my-2 fw-semibold text-xl';
	titleEl.innerText = title;
	cardBodyTextCont.append(titleEl);

	/* ************** CREATE CARD BODY TEXT DESC ************** */
	let descriptionEl = document.createElement('p');
	descriptionEl.className = 'lh-sm text-md';
	descriptionEl.innerText = desc;
	cardBodyTextCont.append(descriptionEl);

	/* ************** CREATE CARD BODY BUTTON ************** */
/* 	let buttonMob = document.createElement('button');
	buttonMob.className = 'd-lg-none border-0 bg-trasparent ms-auto';
	buttonMob.setAttribute('data-name', dataName);
	buttonMob.setAttribute('data-value', dataValue);
	buttonMob.type = 'button';
	cardBody.append(buttonMob);
	
	let icon = document.createElement('i');
	icon.className = 'icon-arrow-right-3 text-light-blue fs-1 fw-bold';
	buttonMob.append(icon);
	buttonMob.addEventListener('click', onclickFunc);	 */
	


	/* ************** CREATE CARD FOOTER ************** */
	let cardFooter = document.createElement('div');
	cardFooter.className = 'card-flyer-footer d-flex justify-content-center align-items-center';
	cardContainer.append(cardFooter);

	let button = document.createElement('button');
	button.className = 'btn btn-primary';
	button.setAttribute('data-name', dataName);
	button.setAttribute('data-value', dataValue);
	button.type = 'button';
	button.innerText = 'Select';
	cardFooter.append(button);

	button.addEventListener('click', onclickFunc);	

	return columnEl;
}

/* ************** FUNCTION STEP BACK ************** */
function createBtnStepBack() {
	let col = document.createElement('div');
	col.className = 'col-12 text-center btn-back';

	let button = document.createElement('a');
	button.className = 'btn btn-link btn-link-gray d-inline-flex mb-2 mb-sm-0 align-items-center link-arrow-icon-left';
	button.setAttribute('href', 'javascript:void(0)');
	button.innerText = 'Back';
	col.append(button);

	let icon = document.createElement('i');
	icon.className = 'icon-arrow-circle-left me-2 fw-semibold';
	button.append(icon);

	button.addEventListener('click', stepBack);

	return col;
}

function stepBack() {

	let inputDelivery = getQuoteForm.querySelector('input[name="delivery"]');
	let inputCardType = getQuoteForm.querySelector('input[name="card-type"]');
	let inputCardSize = getQuoteForm.querySelector('input[name="card-size"]');
	let inputCardPrinting = getQuoteForm.querySelector('input[name="card-printing"]');

	getQuoteContent.innerHtml = '';

	if (inputCardPrinting){
		inputCardPrinting.remove(); 
	
		createStepCardPrinting(inputCardPrinting.value);

	} else if (inputCardSize){
		inputCardSize.remove(); 

		createStepCardSize(inputCardType.value);

	} else if (inputCardType){
		inputCardType.remove(); 

		createStepCardType(inputDelivery.value);

	} else if (inputDelivery){
		inputDelivery.remove(); 
		quoteStartContent.classList.remove('d-none');
		getQuoteContent.innerText = '';

	} 

}

/* ************** ONCLICKED CARD TYPE BUTTON ************** */
function onCardTypeBtnClicked(event) {
	let dataName = event.currentTarget.dataset.name;
	let dataValue = event.currentTarget.dataset.value;
	let inputElement = createInputHidden(dataName, dataValue);

	getQuoteForm.append(inputElement);

	createStepCardSize(dataValue);
}

function createStepCardSize(dataValue){
	getQuoteContent.innerHTML = '';	
	
	/* ************** CREATE HEADING ************** */
	let rowEl = createRowElement();
	getQuoteContent.append(rowEl);

	let heading = createSectionHeading('Choose A Size', "Doing business online means different things to different businesses.We've got the tools to get your business online easily.");
	rowEl.append(heading);

	/* ************** CREATE ROW ************** */
	let rowEl2 = createRowElement();
	getQuoteContent.append(rowEl2);
	
	if(dataValue == 'door-hangers'){
		
		/* ************** CREATE COLUMNS ************** */
		let columnEl = createCardFlyer('Oversized', '4.5 x 11 Inches', 'doorhanger-double.svg', 'card-size', 'oversized', true, true, onCardSizeBtnClicked);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Standard', '3.5 x 8.5 Inches', 'doorhanger-double.svg', 'card-size', 'standard', false, true,onCardSizeBtnClicked);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	}
	if(dataValue == 'postcards'){

		/* ************** CREATE COLUMNS ************** */
		let columnEl = createCardFlyer('Oversized', '8.5 x 5.5 Inches', 'card-double.svg', 'card-size', 'oversized', true, true,onCardSizeBtnClicked);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Standard', '4 x 7 Inches', 'card-double.svg', 'card-size', 'standard', false, true,onCardSizeBtnClicked);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	}
	if(dataValue == 'flyers'){
		
		/* ************** CREATE COLUMNS ************** */
		let columnEl = createCardFlyer('Full Page', '8.5 x 11 Inches', 'flyers-double.svg', 'card-size', 'full-page', true, true,onCardSizeBtnClicked);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Half Page', '8.5 x 5.5 Inches', 'flyers-double.svg', 'card-size', 'half-page', false, true,onCardSizeBtnClicked);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	}
}

/* ************** ONCLICKED CARD TYPE SIZE ************** */
function onCardSizeBtnClicked(event) {

	let dataName = event.currentTarget.dataset.name;
	let dataValue = event.currentTarget.dataset.value;
	let inputElement = createInputHidden(dataName, dataValue);

	getQuoteForm.append(inputElement);
	createStepCardPrinting(dataValue);

}
function createStepCardPrinting() {
	getQuoteContent.innerHTML = '';	
	
	/* ************** CREATE HEADING ************** */
	let rowEl = createRowElement();
	getQuoteContent.append(rowEl);

	let heading = createSectionHeading('Printing Location', "Doing business online means different things to different businesses. We've got the tools to get your business online easily.");
	rowEl.append(heading);

	/* ************** CREATE ROW ************** */
	let rowEl2 = createRowElement();
	getQuoteContent.append(rowEl2);


	let inputDelivery = getQuoteForm.querySelector('input[name="delivery"]');
	let inputCardType = getQuoteForm.querySelector('input[name="card-type"]');

	
	if(inputDelivery.value == 'direct' && inputCardType.value == 'door-hangers'){
		let columnEl = createCardFlyer('Double Sided', 'Printed on the front and back sides.', 'doorhanger-double.svg', 'card-printing', 'double', true, true,createDistributionAreas);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Single Sided', 'Only printed on the front side.', 'doorhanger-single.svg', 'card-printing', 'single', false, true,createDistributionAreas);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);

	} else if((inputDelivery.value == 'direct' || inputDelivery.value == 'mailbox') && inputCardType.value == 'postcards'){

		let columnEl = createCardFlyer('Double Sided', 'Printed on the front and back sides.', 'card-double.svg', 'card-printing', 'double', true, true,createDistributionAreas);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Single Sided', 'Only printed on the front side.', 'card-single.svg', 'card-printing', 'single', false, true,createDistributionAreas);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);

	} else if((inputDelivery.value == 'direct' || inputDelivery.value == 'mailbox') &&  inputCardType.value == 'flyers'){
		
		let columnEl = createCardFlyer('Double Sided', 'Printed on the front and back sides.', 'flyers-double.svg', 'card-printing', 'double', true, true,createDistributionAreas);
		rowEl2.append(columnEl);

		let columnEl2 = createCardFlyer('Single Sided', 'Only printed on the front side.', 'flyers-single.svg', 'card-printing', 'single', false, true,createDistributionAreas);
		rowEl2.append(columnEl2);

		let columnElBtnBlack = createBtnStepBack();
		getQuoteContent.append(columnElBtnBlack);
	}
}


function createDistributionAreas(event) {
	let dataName = event.currentTarget.dataset.name;
	let dataValue = event.currentTarget.dataset.value;
	let inputElement = createInputHidden(dataName, dataValue);

	getQuoteForm.append(inputElement);

	getQuoteContent.innerHTML = '';	

	/* ************** CREATE HEADING ************** */
	let rowEl = createRowElement();
	getQuoteContent.append(rowEl);

	let heading = createSectionHeading('Distribution Areas', `Let us know what areas you want to distribute your ${dataDeliveryValue} in.` + "<p class='mt-5'>" + "Click on the areas below that you would like to have included in your distribution area. As you select the areas, they will be added to your list and your estimated price will be updated. To unselect and area, simply click on that area again."+ "</p>");
	rowEl.append(heading);


/* 	let columnElBtnBlack = createBtnStepBack();
	getQuoteContent.append(columnElBtnBlack); */

	/* ************** CREATE ROW MAPS ************** */
	let row = document.createElement('div');
	row.className = 'row text-white';
	getQuoteContent.append(row);

	let colMaps = document.createElement('div');
	colMaps.className = 'col-12 mb-5';
	row.append(colMaps);

	/* ************** CREATE MAPS ************** */
	var mapDelivery = document.createElement('div');
	colMaps.append(mapDelivery);
	if (dataDeliveryValue == 'direct'){
		mapDelivery.id = 'mapDirectDelivery';
		mapDelivery.style.height = '500px';
		mapDelivery.style.width = '100%';
		
		initDirectMap(mapDelivery);
	}
	if (dataDeliveryValue == 'mailbox'){
		mapDelivery.id = 'mapMailboxDelivery';
		mapDelivery.style.height = '500px';
		mapDelivery.style.width = '100%';

		initMailboxMap(mapDelivery);
	}

	
	
	/* ************** CREATE TABLE ************** */
	let colTable = document.createElement('div');
	colTable.className = 'col-12 col-lg-7 pe-lg-4';
	row.append(colTable);

	let prices = {
		"500":"70.00",
		"1,000":"100.00",
		"2,000":"175.00",
		"3,000":"225.00",
		"4,000":"300.00",
		"5,000":"350.00",
		"7,500":"450.00",
		"10,000":"600.00",
		"15,000":"850.00",
		"20,000":"1,100.00"
	}
	let table = document.createElement('table');
	table.className = 'table text-white rounded-5 dark-table';
	table.style.backgroundColor = '#1f1f4a';
	colTable.append(table);

	let thead = document.createElement('thead');
	table.append(thead);

	let tr = document.createElement('tr');
	thead.append(tr);

	let th = document.createElement('th');
	th.className = 'col-8 p-3 p-sm-4';
	th.innerText = 'Area';
	tr.append(th);

	let th2 = document.createElement('th');
	th2.className = 'col-4 p-3 p-sm-4 text-center';
	th2.innerText = 'Total Houses';
	tr.append(th2);

	let tbody = document.createElement('tbody');
	if (dataDeliveryValue == 'direct'){
		tbody.id = 'idTableDirect';
	}
	if (dataDeliveryValue == 'mailbox'){
		tbody.id = 'idTableMailbox';
	}
	table.append(tbody);

	createTableQuote(prices, tbody.id);

	/* ************** CREATE PRICING ************** */

	let colPricing = document.createElement('div');
	colPricing.className = 'col-12 col-lg-5 ps-lg-4 text-center text-lg-start';
	row.append(colPricing);

	let pricingTitle = document.createElement('h2');
	pricingTitle.className = 'fw-semibold text-xll my-3 mt-lg-0 mb-lg-4';
	pricingTitle.innerText = 'Pricing';
	colPricing.append(pricingTitle);

	let pricingDesc = document.createElement('p');
	pricingDesc.className = 'lh-sm text-md';
	pricingDesc.innerText = 'Your estiamted cost to design, print, and distribute 47,000 double sided door hangers is:';
	colPricing.append(pricingDesc);

	let pricingPrice = document.createElement('h2');
	pricingPrice.className = 'text-primary fw-bold text-center py-2 border rounded-2 border-dark-primary my-4';
	pricingPrice.innerHTML = '$12000';
	colPricing.append(pricingPrice);

	let pricingButton = document.createElement('button');
	pricingButton.className = 'btn btn-purple w-100 d-flex justify-content-center align-items-center lh-base';
	pricingButton.innerHTML = 'Finalize My Estimate';
	pricingButton.setAttribute('type', 'button');
	pricingButton.setAttribute('data-bs-toggle', 'modal');
	pricingButton.setAttribute('data-bs-target', '#modalFinalizeEstimate');
	colPricing.append(pricingButton);

	
	let pricingButtonIcon = document.createElement('i');
	pricingButtonIcon.className = 'icon-arrow-right-1 ms-2';
	pricingButton.append(pricingButtonIcon);

}


function createTableQuote(prices, tbodyEl) {

	let tbody = getQuoteForm.querySelector( '#'+ tbodyEl);
	tbody.innerHTML = '';

	for (let [key, value] of Object.entries(prices)) {
		let tr = document.createElement('tr');
		tbody.append(tr);

		let tdPricing = document.createElement('td');
		tdPricing.className = 'bg-dark-purple col-8 p-3 p-sm-4';
		tdPricing.innerText = key;
		tr.append(tdPricing);

		let tdPrice = document.createElement('td');
		tdPrice.className = 'text-center col-4 p-3 p-sm-4';
		tdPrice.innerText = value;
		tr.append(tdPrice);
	}

	return tbody;
}




/* *********************** MAPS ************************** */


/* *********************** BUTTONS ANIMATION ************************** */
document.querySelectorAll('.btn-animation').forEach((el)=>{
	el.addEventListener('mouseenter', function (event) {
	  	let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
	el.addEventListener('mouseout', function (event) {
		let relX = event.pageX - this.offsetLeft;
	  	let relY = event.pageY - this.offsetTop;
		let span = this.querySelector('span');
		span.style.top = `${relY}px`;
		span.style.left = `${relX}px`;
	})
});

 /* *********************** MAIN MENU ************************** */
let btnBurger = document.getElementById('navbarNavAltMarkup')
let navbar = document.querySelector('.navbar');

btnBurger.addEventListener('show.bs.collapse', function () {
	navbar.classList.add('active');
	
})
btnBurger.addEventListener('hidden.bs.collapse', function () {
	navbar.classList.remove('active');

})

 /* *********************** ADD MY TOM SELECT ************************** */
 document.querySelectorAll('.tom-select').forEach((el)=>{
    new TomSelect(el, tomSelectSettings)
});


 /* *********************** BTN FAQ MORE ************************** */
let collapseFaq = document.getElementById('js-collapseFaq');
let faqButton = document.getElementById('faqBtn');
collapseFaq.addEventListener('hide.bs.collapse', function () {
	faqButton.innerHTML = 'Show all <i class="icon-arrow-down-1 fw-semibold ms-3"></i>';
})
collapseFaq.addEventListener('shown.bs.collapse', function () {
	faqButton.innerHTML = 'Show less <i class="icon-arrow-up-2 fw-semibold ms-3"></i>';
})
 
/* *********************** AOS ************************** */
AOS.init({
	// Global settings:
	disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
	startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
	initClassName: 'aos-init', // class applied after initialization
	animatedClassName: 'aos-animate', // class applied on animation
	useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
	disableMutationObserver: false, // disables automatic mutations' detections (advanced)
	debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
	throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)
	

	// Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
	offset: 120, // offset (in px) from the original trigger point
	delay: 0, // values from 0 to 3000, with step 50ms
	duration: 400, // values from 0 to 3000, with step 50ms
	easing: 'ease', // default easing for AOS animations
	once: true, // whether animation should happen only once - while scrolling down
	mirror: false, // whether elements should animate out while scrolling past them
	anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation

});


let map;

function initDirectMap(mapDiv) {
	map = new google.maps.Map(mapDiv, {
		zoom: 4,
		center: { lat: -28, lng: 137 },
	  })

	// Load GeoJSON.
	map.data.loadGeoJson(
		"https://storage.googleapis.com/mapsdevsite/json/google.json"
	);

	// Color each letter gray. Change the color when the isColorful property
	// is set to true.
	map.data.setStyle((feature) => {
		let color = "gray";

		if (feature.getProperty("isColorful")) {
		color = feature.getProperty("color");
		}
		return /** @type {!google.maps.Data.StyleOptions} */ {
		fillColor: color,
		strokeColor: color,
		strokeWeight: 2,
		};
	});



	// When the user clicks, set 'isColorful', changing the color of the letters.
	map.data.addListener("click", (event) => {

		let areaId = event.feature.getProperty('color');
		  // if colorful property is true
		  if (event.feature.getProperty('isColorful') === true) {
			// set isColorful to FALSE
			event.feature.setProperty('isColorful', false);
			
			// get the name/id via property and remove the hidden input that has the same value
			let input = document.querySelector(`input[name="areas[]"][value="${areaId}"]`);
			input.remove();
			// loop through name="areas[]" and search for a value that has the areaId and remove it

		}
		// else
		else {
			// set colorful to TRUE
			event.feature.setProperty('isColorful', true);
			// get the name/id via property and add a hidden input with the value of the name/id
			
			let inputHidden = document.createElement('input');
			inputHidden.type = 'hidden';
			inputHidden.value = areaId;
			inputHidden.name = 'areas[]';
			getQuoteForm.append(inputHidden);
		}
	});
}

function initMailboxMap(mapDiv) {
	map = new google.maps.Map(mapDiv, {
		center: { lat: -34, lng: 150 },
		zoom: 8
	})

	const drawingManager = new google.maps.drawing.DrawingManager({
		drawingMode: google.maps.drawing.OverlayType.MARKER,
		drawingControl: true,
		drawingControlOptions: {
		  position: google.maps.ControlPosition.TOP_CENTER,
		  drawingModes: [
			google.maps.drawing.OverlayType.POLYGON
		  ],
		},
		markerOptions: {
		  icon: "https://developers.google.com/maps/documentation/javascript/examples/full/images/beachflag.png",
		},
		circleOptions: {
		  fillColor: "#ffff00",
		  fillOpacity: 1,
		  strokeWeight: 5,
		  clickable: false,
		  editable: true,
		  zIndex: 1,
		},
	  });
	
	  drawingManager.setMap(map);

	  google.maps.event.addListener(drawingManager, 'polygoncomplete', function (polygon) {
		var coordinates = (polygon.getPath().getArray());
		// console.log(coordinates);
		window.alert("success"+coordinates);
	});
}



