
/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* BTN MENU BURGER */
let btnBurger = document.getElementById('btnBurger');
btnBurger.addEventListener('click', function(event) {
    this.classList.toggle('active');
});

document.addEventListener('click', function (event) {
	// if the clicked element isn't child of the navbar, you must close it if is open
	if (!event.target.closest('#mainMenu') && document.getElementById('mainMenu').classList.contains('show')) {
		document.getElementById('btnBurger').click();
	}

	if (!event.target.closest('#lang-selector') && document.getElementById('lang-selector').classList.contains('active')) {
		langSelector.classList.remove('active');
	}
});

/* MAIN CATEGORY  */
let checkContainerHeight = document.querySelectorAll('.js-check-container-height');

checkContainerHeight.forEach((elem) =>{
  let menuCategoryLink = elem.parentElement.querySelector('.main-category-card-list');

  if (elem.offsetHeight >= 600){
    menuCategoryLink.classList.add('main-category-card-big');
  }
})

/* LANGUAGE DROPDOWN*/
function show(el) {
	selectLangBtn.querySelector('img').src = el.querySelector('img').src;
	langSelector.classList.remove('active');
}
let langSelector = document.getElementById('lang-selector');
let selectLangBtn = langSelector.querySelector('.selected-lang');
selectLangBtn.onclick = function() {
    langSelector.classList.toggle('active');
}

/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
});

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);
	}

	thumbnailElement.dataset.label = file.name;

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else {
		thumbnailElement.style.backgroundImage = null;
	}
}