let containerOurDesignProject = document.getElementById('containerOurDesignProject');
let designCards;
if(containerOurDesignProject){
    designCards = containerOurDesignProject.querySelectorAll('.design-card');
    /* CLICK DESIGN CARD */
    designCards.forEach(designCard =>{
        designCard.addEventListener('click',function(){
            createDesignModalBody('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', ['Straight Corners', 'Flyer 4.5x6 in', 'Dobule Sided', 'Custom Made']);
            modalDesignFlyer.show();
        })
    })
}
let modalDesignFlyerBody = document.getElementById('modalDesignFlyerBody');

let modalDesignFlyerContaniner = document.getElementById('modalDesignFlyer');
let modalDesignFlyer = new bootstrap.Modal(modalDesignFlyerContaniner, {});


/* CREAT NEW ELEMENT */
function createNewElemenet(tag, className='', text=''){
    let el = document.createElement(tag);
    el.className = className;
    el.innerHTML = text;
    return el;
}





function createDesignModalBody(urlFront, urlBack, options){

    modalDesignFlyerBody.innerHTML = '';

    let row = createNewElemenet('div', 'row');

    modalDesignFlyerBody.append(row);

    /* FRONT */
    let columnFront = createNewElemenet('div', 'col-12 col-sm-6');
    row.append(columnFront);

    let columnFrontImgContainer = createNewElemenet('div', 'bg-dark-blue mb-5 rounded-6 overflow-hidden text-white text-center p-4');
    columnFront.append(columnFrontImgContainer);

    let columnFrontHeading = createNewElemenet('p', 'mb-4', 'Front');
    columnFrontImgContainer.append(columnFrontHeading);
    
    let columnFrontImgWrap = createNewElemenet('div', 'modal-design-flyer-img');
    columnFrontImgContainer.append(columnFrontImgWrap);

    let columnFrontImg = createNewElemenet('img');
    columnFrontImg.src = urlFront;
    columnFrontImg.alt = 'Image Front';
    columnFrontImgWrap.append(columnFrontImg);

    /* BACK */
    let columnBack = createNewElemenet('div', 'col-12 col-sm-6');
    row.append(columnBack);

    let columnBackImgContainer = createNewElemenet('div', 'bg-dark-blue mb-5 rounded-6 overflow-hidden text-white text-center p-4');
    columnBack.append(columnBackImgContainer);

    let columnBackHeading = createNewElemenet('p', 'mb-4', 'Back');
    columnBackImgContainer.append(columnBackHeading);
    
    let columnBackImgWrap = createNewElemenet('div', 'modal-design-flyer-img');
    columnBackImgContainer.append(columnBackImgWrap);

    let columnBackImg = createNewElemenet('img');
    columnBackImg.src = urlBack;
    columnBackImg.alt = 'Image Back';
    columnBackImgWrap.append(columnBackImg);


    /* DESCRIPTION  */
    
    let columnDescription = createNewElemenet('div', 'col-12 col-md-10 m-auto mb-3');
    row.append(columnDescription);

    let divDescription = createNewElemenet('div', 'text-center');
    columnDescription.append(divDescription);

    let title = createNewElemenet('h4', 'text-xll', 'Flyer Design For Architecture Studio');
    divDescription.append(title);

    let descText = createNewElemenet('p', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
    divDescription.append(descText);


    /*  OPTION  LIST*/

    let optionList = createNewElemenet('div', 'd-flex justify-content-between justify-content-lg-center justify-content-xl-between flex-wrap ');
    modalDesignFlyerBody.append(optionList);

    for( let i in options){
        let optionItem = createNewElemenet('div', 'd-flex align-items-center text-primary fw-normal me-md-5 me-xl-3 mb-2 mb-xl-0');
        optionList.append(optionItem);

        let iconCheck = createNewElemenet('span', 'icon-tick-circle fw-normal me-2');
        optionItem.append(iconCheck);
        optionItem.innerHTML += options[i];
    }
}
