/* STICKY MENU */
let navbar = document.getElementById('js-navbar');
var stickyOffset = navbar.offsetTop + navbar.offsetHeight;

window.addEventListener('scroll', () => {
	if (window.pageYOffset >= stickyOffset) {
		navbar.classList.add('sticky');
	}  else  {
		navbar.classList.remove('sticky')
	}
})

/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* BTN MENU BURGER */
let btnBurger = document.getElementById('btnBurger');
btnBurger.addEventListener('click', function(event) {
    this.classList.toggle('active');
});

document.addEventListener('click', function (event) {
	// if the clicked element isn't child of the navbar, you must close it if is open
	if (!event.target.closest('#mainMenu') && !event.target.closest('.form-search-input') && document.getElementById('mainMenu').classList.contains('show')) {
		document.getElementById('btnBurger').click();
	}

	if (!event.target.closest('#langHeader') && document.getElementById('langHeader').classList.contains('active')) {
		langHeaderSelected.classList.remove('active');
	}
});

/* MAIN CATEGORY  */
let checkContainerHeight = document.querySelectorAll('.js-check-container-height');

checkContainerHeight.forEach((elem) =>{
  let menuCategoryLink = elem.parentElement.querySelector('.main-category-card-list');

  if (elem.offsetHeight >= 600){
    menuCategoryLink.classList.add('main-category-card-big');
  }
})

/* LANGUAGE DROPDOWN*/
function show(el) {
	selectLangBtn.querySelector('img').src = el.querySelector('img').src;
	langHeaderSelected.classList.remove('active');

	if(el.closest('#langFooter')){
		selectLangBtnFooter.innerHTML = el.innerHTML;
		langFooterSelector.classList.remove('active');
	}
}
/* LANG MENU HEADER */
let langHeaderSelected = document.getElementById('langHeader');
let selectLangBtn = langHeaderSelected.querySelector('.selected-lang');
selectLangBtn.onclick = function() {
    langHeaderSelected.classList.toggle('active');
}

/* LANG MENU FOOTER */
let langFooterSelector = document.getElementById('langFooter');
let selectLangBtnFooter;
if(langFooterSelector){
	selectLangBtnFooter = langFooterSelector.querySelector('.selected-lang');
	let selectedLangContent = langFooterSelector.querySelector('.selected-lang-content');
	
	selectedLangContent.onclick = function() {
		langFooterSelector.classList.toggle('active');
	}
}


/* MODAL GET A DESIGN QUOTE */
let modalGetADesignQuote = document.getElementById('modalGetADesignQuote');
let jsModalGetDesignDropZone = document.getElementById('jsModalGetDesignDropZone');
let jsModalGetDesignTextarea = document.getElementById('jsModalGetDesignTextarea');

var radios = modalGetADesignQuote.querySelectorAll('input[type=radio][name="Upload_Own_Design"]');

function changeHandler() {

   if ( this.value === 'true' ) {
	
	jsModalGetDesignTextarea.querySelector('textarea').value='';
	jsModalGetDesignTextarea.classList.add('d-none');
	jsModalGetDesignDropZone.classList.remove('d-none');

   } else if ( this.value === 'false' ) {
	jsModalGetDesignDropZone.classList.add('d-none');
	jsModalGetDesignTextarea.classList.remove('d-none');
     
   }  
}

Array.prototype.forEach.call(radios, function(radio) {
   radio.addEventListener('change', changeHandler);
});



/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
});

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);
	}

	thumbnailElement.dataset.label = file.name;

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else {
		thumbnailElement.style.backgroundImage = null;
	}
}

 /*  ADD TOM SELECT */
let quantitySelectOptions = {
	controlInput: null,
	render: {
		item: function(data, escape) {
			let selectedText = escape(data.text);

			let option = `<div class="d-flex align-items-center text-start">Quantity:<span class="fw-bold ms-1 me-5"> ${selectedText}</span> <span class="fw-bold text-green">$11,100.00</span></div>`;
			return option;
		}
	}
}

document.querySelectorAll('.tom-select-cart').forEach((el)=>{
	new TomSelect(el, quantitySelectOptions);
});  
document.querySelectorAll('.tom-select').forEach((el)=>{
	new TomSelect(el, {});
});  


/* CALCULATE SHIPPING & TURNAROUND */
let formPrintDetailsCalculate = document.getElementById('formPrintDetailsCalculate');

if (formPrintDetailsCalculate) {
	let btnShippingCalculate = document.getElementById('btnShippingCalculate');
	let inputCodeShipping = document.getElementById('inputCodeShipping');
	let labelCodeShipping = document.getElementById('labelCodeShipping');
	let btnCodeShippingChange = document.getElementById('codeShippingChange');
	
	let formPrintDetailsCalculateTS = new TomSelect(formPrintDetailsCalculate, {controlInput: null});
	
	
	btnShippingCalculate.addEventListener('click', (e) =>{
		e.preventDefault();
		
		labelCodeShipping.querySelector('span').innerText = 'Shipping to ' + inputCodeShipping.value;
		btnCodeShippingChange.classList.remove('d-none');
	
		inputCodeShipping.closest('div').classList.add('d-none');
		formPrintDetailsCalculateTS.wrapper.classList.remove('d-none');
	});
	
	btnCodeShippingChange.addEventListener('click', (e) =>{
		e.preventDefault();
	
		labelCodeShipping.querySelector('span').innerText = 'Shipping & Turnaround';
		inputCodeShipping.value = '';
		inputCodeShipping.closest('div').classList.remove('d-none');
		btnCodeShippingChange.classList.add('d-none');
		formPrintDetailsCalculateTS.wrapper.classList.add('d-none');
	});
	
	inputCodeShipping.addEventListener('keyup', (e) => {
		if (inputCodeShipping.value.length > 0){
			btnShippingCalculate.classList.remove('text-drab');
			btnShippingCalculate.classList.add('text-primary');
	
		} else {
			btnShippingCalculate.classList.add('text-drab');
			btnShippingCalculate.classList.remove('text-primary');
		}
	});
}




/* COOKIE */
function setCookie(cname,cvalue,exdays) {
	const d = new Date();
	d.setTime(d.getTime() + (exdays*24*60*60*1000));
	let expires = 'expires=' + d.toUTCString();
	document.cookie = cname + '=' + cvalue + ';' + expires + ';path=/';
  }
  
  function getCookie(cname) {
	let name = cname + '=';
	let decodedCookie = decodeURIComponent(document.cookie);
	let ca = decodedCookie.split(';');
	for(let i = 0; i < ca.length; i++) {
	  let c = ca[i];
	  while (c.charAt(0) == ' ') {
		c = c.substring(1);
	  }
	  if (c.indexOf(name) == 0) {
		return c.substring(name.length, c.length);
	  }
	}
	return '';
  }
  
  function checkCookie() {
	let cookieDate = getCookie('cookie-date');
	let cookieBanner = document.getElementById('cookieBanner');

	if (cookieDate == '') {
		cookieBanner.classList.remove('d-none');
	} 
  }
  
  function applyCookie() {
	var date = new Date();
    var dateString = date.toGMTString();
	setCookie('cookie-date', dateString, 20);
	let cookieBanner = document.getElementById('cookieBanner');
	cookieBanner.classList.add('d-none');

  }

