
let uploadDesignContainer = document.getElementById('uploadDesignContainer');
let uploadDesignAddNewPageBtn = document.getElementById('uploadDesignAddNewPageBtn');


let getThisProfessionally = true;
let countRow = 0;

createUploadDesignRow(getThisProfessionally);

/* CREATE UPLOAD DESUGN ROW FUNCTION */
function createUploadDesignRow(professionalDesign){

    let countColumn = 2;

    countRow++;

    let row = createNewElement('div', 'row justify-content-center my-5');
    uploadDesignContainer.append(row);

    /*  COLUMNS */
    for (let col = 0; col < countColumn; col++) {

        let column = createNewElement('div', 'col-12 col-lg-6 col-xxl-5 py-4 py-lg-0');
        row.append(column);
        
        let title = createNewElement('p', 'text-center mb-4 fw-normal');
        column.append(title);
        
        if(col == 0){
            title.innerText = 'Front';
            
        } else if(col == 1){
            title.innerText = 'Back';
        }

        let uploadDesignCard = createNewElement('div', 'upload-your-design-card mb-4');
        column.append(uploadDesignCard);

        if(professionalDesign){
            
            uploadDesignCard.classList.add('drop-zone');
           
            let dropZonePrompt = createDropZone();
            uploadDesignCard.append(dropZonePrompt);

            let columnButtons = createNewElement('div', 'text-center mt-4');
            column.append(columnButtons);

            let btnBrowseComputer = createNewElement('button', 'btn btn-primary me-sm-4 mb-2 mb-sm-0', 'Browse Computer');
            btnBrowseComputer.type = 'button';
            btnBrowseComputer.setAttribute('onclick', 'browseComputer(this)');
            columnButtons.append(btnBrowseComputer);

            let btnRemove = createNewElement('button', 'btn btn-white-with-border px-40 mb-2 mb-sm-0', 'Remove');
            btnRemove.type = 'button';
            columnButtons.append(btnRemove);

        } else {

            uploadDesignCard.classList.add('custom-design-card');

            let cardName = createNewElement('span', 'text-xl fw-bold text-easy-blue d-block text-center lh-sm');
            uploadDesignCard.append(cardName);


            let projectDescTextarea = createNewElement('textarea', 'form-control text-xxs w-100');
            projectDescTextarea.setAttribute('placeholder', 'Describe Your Project');
            projectDescTextarea.setAttribute('rows', '6');



            if(col == 0){
            
                let projectDescLabel = createNewElement('label', 'form-label d-block mb-3');

                projectDescLabel.innerText = 'Front page project description';
                projectDescLabel.setAttribute('for', 'project-front-desc');

                projectDescTextarea.id = 'project-front-desc';
                projectDescTextarea.name = 'Project_Front_Description';

                cardName.innerHTML = 'CUSTOM<br>DESIGN';

                column.append(projectDescLabel);

            } else if (col == 1){

                let formChekContainer = createNewElement('div', 'form-check d-flex align-items-center');
                column.append(formChekContainer);

                let inputCheckBox = createNewElement('input', 'form-check-input mb-1 me-3');
                inputCheckBox.type = 'checkbox';
                inputCheckBox.id = 'custom-project-back-check';
                formChekContainer.append(inputCheckBox);

                let custProjectBackCheckLabel = createNewElement('label', 'form-label mb-0');
                custProjectBackCheckLabel.innerText = 'Back page project description';
                custProjectBackCheckLabel.setAttribute('for', 'custom-project-back-check');

                formChekContainer.append(custProjectBackCheckLabel);

                projectDescTextarea.id = 'project-back-desc';
                projectDescTextarea.name = 'Project_Back_Description';

                cardName.innerText = 'BLANK';


            }
            column.append(projectDescTextarea);


        }
        
    }

    /* COUNT ROW */
    if (countRow >= 2){
        row.className = 'row justify-content-center bg-white-gradient border-light-purple interval-between-rows';

        let headerCountRow = createNewElement('div', 'col-12 col-xxl-10 d-flex justify-content-between align-content-center my-3');
        row.prepend(headerCountRow);

        let titleCountRow = createNewElement('span', 'page-number', `Page ${countRow}`);
        headerCountRow.append(titleCountRow);

        let removeRowBtn = createNewElement('button', 'btn btn-link text-red fw-normal text-md py-0 remove-upload-row-btn', 'Remove');
        removeRowBtn.type = 'button';
        removeRowBtn.setAttribute('onclick', 'removeUploadDesignRow(this)');
        headerCountRow.append(removeRowBtn);
    }
}

/* REMOVE ROW FUNCTION*/
function removeUploadDesignRow(btn) {
    let row = btn.parentElement.parentElement;
    row.remove();
    countRow--;

    let pageNumbers = document.querySelectorAll('.page-number');
    let count = 2;
    pageNumbers.forEach((pageNumb) =>{
        pageNumb.innerText = `Page ${count}`;
        count++;
    })
}

/* EVENT BTN ADD NEW PAGE */
uploadDesignAddNewPageBtn.addEventListener('click', function(){
    createUploadDesignRow(getThisProfessionally);
});






/* CREATE DROP ZONE */
function createDropZone() {

    let dropZonePrompt = createNewElement('div', 'drop-zone-prompt');

    let dropIcon = createNewElement('span', 'drop-zone-prompt-img');
    dropZonePrompt.append(dropIcon);

    let dropIconImg = document.createElement('img');
    dropIconImg.src = 'dist/images/icons/icon-add-file.svg';
    dropIconImg.alt = 'Icon Add File';
    dropIcon.append(dropIconImg);

    let dropPromptTitle = createNewElement('p', 'text-center fw-normal text-sm', 'Drag & Drop<br> Your File To Upload');
    dropZonePrompt.append(dropPromptTitle);

    let inputFile = document.createElement('input');
    inputFile.type = 'file';
    inputFile.name = 'File[]';
    inputFile.className = 'drop-zone-input';
    dropZonePrompt.append(inputFile);
    
    return dropZonePrompt;
}


/* ORDER PROCESS BTN BROWSE COMPUTER */
function browseComputer(btn){
	let inputFile = btn.parentElement.parentElement.querySelector('input[type="file"]');
	inputFile.click();
}
