let idCounter = 0;
let countRow = 0;
let getThisProfessionally = true;

let uploadDesignContainer = document.getElementById('uploadDesignContainer');
let uploadDesignAddNewPageBtn = document.getElementById('uploadDesignAddNewPageBtn');


createUploadDesignRow(getThisProfessionally);

/* CREATE UPLOAD DESUGN ROW FUNCTION */
function createUploadDesignRow(professionalDesign){

    let countColumn = 2;

    idCounter++;
    countRow++;

    let row = createNewElement('div', 'row justify-content-center my-6');
    uploadDesignContainer.append(row);

    /*  COLUMNS */
    for (let col = 0; col < countColumn; col++) {

        let column = createNewElement('div', 'col-12 col-lg-6 col-xxl-5 py-4 py-lg-0');
        row.append(column);
        
        let title = createNewElement('p', 'text-center mb-4 fw-normal');
        column.append(title);
        
        if(col == 0){
            title.innerText = 'Front';
            
        } else if(col == 1){
            title.innerText = 'Back';
        }

        let uploadDesignCard = createNewElement('div', 'upload-your-design-card mb-4');
        column.append(uploadDesignCard);

        if(professionalDesign){
            
            uploadDesignCard.classList.add('drop-zone');
           
            createDropZone(uploadDesignCard);

            let columnButtons = createNewElement('div', 'text-center mt-4');
            column.append(columnButtons);

            let btnBrowseComputer = createNewElement('button', 'btn btn-primary me-sm-4 mb-2 mb-sm-0 upload-browse-computer-btn', 'Browse Computer');
            btnBrowseComputer.type = 'button';
            btnBrowseComputer.setAttribute('onclick', 'browseComputer(this)');
            columnButtons.append(btnBrowseComputer);

            if(col == 1){

                let btnRemove = createNewElement('button', 'btn btn-white-with-border px-40 mb-2 mb-sm-0 uploaded-file-remove-btn d-none', 'Remove');
                btnRemove.type = 'button';
                btnRemove.setAttribute('onclick', 'uploadedFileRemove(this)');
                columnButtons.append(btnRemove);
            }

        } else {


            let cardName = createNewElement('span', 'text-xl fw-bold d-block text-center lh-sm');
            uploadDesignCard.append(cardName);

            let projectDescTextarea = createNewElement('textarea', 'form-control text-xxs w-100');
            projectDescTextarea.setAttribute('placeholder', 'Describe Your Project');
            projectDescTextarea.setAttribute('rows', '6');

            if(col == 0){

                uploadDesignCard.classList.add('bg-dark-grey');
            
                let projectDescLabel = createNewElement('label', 'form-label');
                projectDescLabel.innerText = 'Front page project description';
                projectDescLabel.setAttribute('for', `project-front-desc-${idCounter}`);

                projectDescTextarea.id = `project-front-desc-${idCounter}`;
                projectDescTextarea.name = 'Project_Front_Description';

                cardName.innerHTML = 'CUSTOM<br>DESIGN';

                column.append(projectDescLabel);

            } else if (col == 1){

                uploadDesignCard.classList.add('bg-easy-blue');

                let formChekContainer = createNewElement('div', 'form-check d-flex align-items-center mb-3');
                column.append(formChekContainer);

                let inputCheckBox = createNewElement('input', 'form-check-input mb-1 me-3');
                inputCheckBox.type = 'checkbox';
                inputCheckBox.id = `custom-project-back-check-${idCounter}`;

                formChekContainer.append(inputCheckBox);
                inputCheckBox.addEventListener('change', onBackPageChekboxChange);

                let custProjectBackCheckLabel = createNewElement('label', 'form-label mb-0');
                custProjectBackCheckLabel.innerText = 'Back page project description';
                custProjectBackCheckLabel.setAttribute('for', `custom-project-back-check-${idCounter}`);

                formChekContainer.append(custProjectBackCheckLabel);

                projectDescTextarea.id = `project-back-desc-${idCounter}`;
                projectDescTextarea.name = 'Project_Back_Description';

                cardName.classList.add('text-dark-grey');
                cardName.innerText = 'BLANK';

            }

            column.append(projectDescTextarea);

            if (col == 1){

                projectDescTextarea.addEventListener('keyup', onProjectDescKeyup);
            }

        }
        
    }

    /* COUNT ROW */
    if (countRow >= 2){
        row.className = 'row justify-content-center bg-white-gradient border-light-purple interval-between-rows';

        let headerCountRow = createNewElement('div', 'col-12 col-xxl-10 d-flex justify-content-between align-content-center my-3');
        row.prepend(headerCountRow);

        let titleCountRow = createNewElement('span', 'page-number', `Page ${countRow}`);
        headerCountRow.append(titleCountRow);

        let removeRowBtn = createNewElement('button', 'btn btn-link text-red fw-normal text-md py-0 remove-upload-row-btn', 'Remove');
        removeRowBtn.type = 'button';
        removeRowBtn.setAttribute('onclick', 'removeUploadDesignRow(this)');
        headerCountRow.append(removeRowBtn);
    }

}

/* REMOVE ROW FUNCTION*/
function removeUploadDesignRow(btn) {
    let row = btn.parentElement.parentElement;
    row.remove();
    countRow--;

    let pageNumbers = document.querySelectorAll('.page-number');
    let count = 2;
    pageNumbers.forEach((pageNumb) =>{
        pageNumb.innerText = `Page ${count}`;
        count++;
    })
}

/* CREATE DROP ZONE */
function createDropZone(dropZoneEl) {

    let dropZonePrompt = createNewElement('div', 'drop-zone-prompt');

    let dropIcon = createNewElement('span', 'drop-zone-prompt-img');
    dropZonePrompt.append(dropIcon);

    let dropIconImg = document.createElement('img');
    dropIconImg.src = 'dist/images/icons/icon-add-file.svg';
    dropIconImg.alt = 'Icon Add File';
    dropIcon.append(dropIconImg);

    let dropPromptTitle = createNewElement('p', 'text-center fw-normal text-sm', 'Drag & Drop<br> Your File To Upload');
    dropZonePrompt.append(dropPromptTitle);

    let inputFile = document.createElement('input');
    inputFile.type = 'file';
    inputFile.name = 'File';
    inputFile.className = 'drop-zone-input';
    dropZonePrompt.append(inputFile);
    inputFile.addEventListener('change', onBrowseComputerChange);

    dropZoneEl.append(dropZonePrompt);
    dropZoneEvents(inputFile);
}

/* ORDER PROCESS BTN BROWSE COMPUTER */
function browseComputer(btn){
	let dropZone = btn.parentElement.parentElement.querySelector('.drop-zone');
	dropZone.click();
}

/*UPLOADED FILE REMOVE */
function uploadedFileRemove(btn) {
    let dropZoneEl = btn.parentElement.parentElement.querySelector('.drop-zone')
    let dropZoneThumb = dropZoneEl.querySelector('.drop-zone-thumb');
    dropZoneThumb.remove();
    let dropZonePrompt =  dropZoneEl.querySelector('.drop-zone-prompt');
    dropZonePrompt.classList.remove('d-none');
    btn.classList.add('d-none');

    btn.parentElement.querySelector('.upload-browse-computer-btn').innerHTML = 'Browse Computer';
}

/* EVENT BTN ADD NEW PAGE */
uploadDesignAddNewPageBtn.addEventListener('click', function(){
    createUploadDesignRow(getThisProfessionally);
});

/* EVENT DROP ZONE UPLOADED FILE */
function onBrowseComputerChange(e) {
    
    let dropZoneElement = e.target.closest('.drop-zone');
    let btnContainer =  dropZoneElement.nextSibling;

    btnContainer.querySelector('.upload-browse-computer-btn').innerHTML = 'Upload New Design';

    btnContainer.querySelector('.uploaded-file-remove-btn').classList.remove('d-none'); 
}

/* EVENT ON PRIJECT DESC KEYUP*/
function onProjectDescKeyup(event) {

    let inputCheckbox = event.target.parentElement.querySelector('.form-check-input');

    if(event.target.value){
        if (!inputCheckbox.checked) inputCheckbox.click();
    } else {
        if (inputCheckbox.checked) inputCheckbox.click();
    }
}

/* EVENT ON BACK PAGE CHECKBOX CHANGE */

function onBackPageChekboxChange(event) {

    let dropZoneCard =event.target.parentElement.parentElement.querySelector('.upload-your-design-card');

    if(event.target.checked){

        dropZoneCard.firstChild.innerHTML = 'CUSTOM<br>DESIGN';
        dropZoneCard.firstChild.classList.add('text-easy-blue');
        dropZoneCard.classList.remove('bg-easy-blue');
        dropZoneCard.classList.add('bg-dark-grey');

    } else{

        dropZoneCard.firstChild.innerHTML = 'BLANK';
        dropZoneCard.firstChild.classList.remove('text-easy-blue');
        dropZoneCard.classList.add('bg-easy-blue');
        dropZoneCard.classList.remove('bg-dark-grey');
    }
}