let containerOurDesignProject = document.getElementById('containerOurDesignProject');
let designCards;
if(containerOurDesignProject){
    designCards = containerOurDesignProject.querySelectorAll('.design-card');
    /* CLICK DESIGN CARD */
    designCards.forEach(designCard =>{
        designCard.addEventListener('click',function(){
            createDesignModalBody('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', ['Straight Corners', 'Flyer 4.5x6 in', 'Dobule Sided', 'Custom Made']);
            modalDesignFlyer.show();
        })
    })
}
let modalDesignFlyerBody = document.getElementById('modalDesignFlyerBody');

let modalDesignFlyerContaniner = document.getElementById('modalDesignFlyer');
let modalDesignFlyer = new bootstrap.Modal(modalDesignFlyerContaniner, {});


/* CREAT NEW ELEMENT */
function createNewElement(tag, className='', text=''){
    let el = document.createElement(tag);
    el.className = className;
    el.innerHTML = text;
    return el;
}





function createDesignModalBody(urlFront, urlBack, options){

    modalDesignFlyerBody.innerHTML = '';

    let row = createNewElement('div', 'row');

    modalDesignFlyerBody.append(row);

    /* FRONT */
    let columnFront = createNewElement('div', 'col-12 col-sm-6');
    row.append(columnFront);

    let columnFrontImgContainer = createNewElement('div', 'bg-dark-blue mb-5 rounded-6 overflow-hidden text-white text-center p-4');
    columnFront.append(columnFrontImgContainer);

    let columnFrontHeading = createNewElement('p', 'mb-4', 'Front');
    columnFrontImgContainer.append(columnFrontHeading);
    
    let columnFrontImgWrap = createNewElement('div', 'modal-design-flyer-img');
    columnFrontImgContainer.append(columnFrontImgWrap);

    let columnFrontImg = createNewElement('img');
    columnFrontImg.src = urlFront;
    columnFrontImg.alt = 'Image Front';
    columnFrontImgWrap.append(columnFrontImg);

    /* BACK */
    let columnBack = createNewElement('div', 'col-12 col-sm-6');
    row.append(columnBack);

    let columnBackImgContainer = createNewElement('div', 'bg-dark-blue mb-5 rounded-6 overflow-hidden text-white text-center p-4');
    columnBack.append(columnBackImgContainer);

    let columnBackHeading = createNewElement('p', 'mb-4', 'Back');
    columnBackImgContainer.append(columnBackHeading);
    
    let columnBackImgWrap = createNewElement('div', 'modal-design-flyer-img');
    columnBackImgContainer.append(columnBackImgWrap);

    let columnBackImg = createNewElement('img');
    columnBackImg.src = urlBack;
    columnBackImg.alt = 'Image Back';
    columnBackImgWrap.append(columnBackImg);


    /* DESCRIPTION  */
    
    let columnDescription = createNewElement('div', 'col-12 col-md-10 m-auto mb-3');
    row.append(columnDescription);

    let divDescription = createNewElement('div', 'text-center');
    columnDescription.append(divDescription);

    let title = createNewElement('h4', 'text-xll', 'Flyer Design For Architecture Studio');
    divDescription.append(title);

    let descText = createNewElement('p', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
    divDescription.append(descText);


    /*  OPTION  LIST*/

    let optionList = createNewElement('div', 'd-flex justify-content-between justify-content-lg-center justify-content-xl-between flex-wrap ');
    modalDesignFlyerBody.append(optionList);

    for( let i in options){
        let optionItem = createNewElement('div', 'd-flex align-items-center text-primary fw-normal me-md-5 me-xl-3 mb-2 mb-xl-0');
        optionList.append(optionItem);

        let iconCheck = createNewElement('span', 'icon-tick-circle fw-normal me-2');
        optionItem.append(iconCheck);
        optionItem.innerHTML += options[i];
    }
}
