
/* CREATE CUSTOM DESIGN IN PROGRESS LIST */
let accordionCustomDesignInProgressList = document.getElementById('accordionCustomDesignInProgressList');

if (accordionCustomDesignInProgressList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemOne);

    let accordionCustomDesignInProgressItemTwo = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemTwo);
}


/* CREATE CUSTOM DESIGN COMPLETED LIST */
let accordionCustomCompletedDesignList = document.getElementById('accordionCustomCompletedDesignList');

if (accordionCustomCompletedDesignList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', true);
    accordionCustomCompletedDesignList.append(accordionCustomDesignInProgressItemOne);

}

/* FUNCTION CREATE CUSTOM DESIGN ITEM */
function createCustomDesignItem( urlFront='', urlBack='', completedDesigns){

    let customDesignItem = createNewElement('div', 'custom-design-item mb-4 mb-xl-5');

    /* ROW */
    let customDesignItemRow = createNewElement('div', 'row align-items-center');
    customDesignItem.append(customDesignItemRow);

    /* COLUMN INPUT */
     let colInput = createNewElement('div', 'col-12 col-md-8');
     customDesignItemRow.append(colInput);

     let colInputContainer = createNewElement('div', 'position-relative');
     colInput.append(colInputContainer);

     let customDesignNameInput =  createNewElement('input', 'form-control text-xxs input-number-without-arrow custom-designs-name-input');
     customDesignNameInput.name = 'Custom_Design_Name';
     customDesignNameInput.type = 'text';
     customDesignNameInput.placeholder = 'Your custom design name';
     colInputContainer.append(customDesignNameInput);

     let editCustomDesignName = createNewElement('a', 'position-absolute text-drab text-xxs top-50 translate-middle is-disabled end-0 pt-1 fw-normal js-custom-design-edit-name-btn', 'Edit Name');
     editCustomDesignName.dataset.toggle = 'tooltip';
     editCustomDesignName.setAttribute('data-toggle', 'tooltip');
     colInputContainer.append(editCustomDesignName);
     

    /* COLUMN TITLE */
    let colTitle = createNewElement('div', 'col-12 col-md-4 text-center my-3 my-md-0');
    customDesignItemRow.append(colTitle);
     
    let customDesignItemTypeTitle = createNewElement('span', 'text-orang fw-semibold', 'In Review');
    if(completedDesigns){
        customDesignItemTypeTitle.className = 'text-green fw-semibold';
        customDesignItemTypeTitle.innerText = 'Complete';
    }

    colTitle.append(customDesignItemTypeTitle);


    /* COLUMN CUSTOM DESIGN ITEM FRONT */
    let colCustomDesignItemFront = createNewElement('div', 'col-12 col-md-6 custom-design-item-front mt-md-4');
    customDesignItemRow.append(colCustomDesignItemFront);

    let colCustomDesignItemFrontBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBg);

    let colCustomDesignItemFrontBgImg = createNewElement('div', 'js-image-src custom-design-item-image');
    colCustomDesignItemFrontBgImg.dataset.imageSrc = urlFront;
    colCustomDesignItemFrontBg.append(colCustomDesignItemFrontBgImg);

    let colCustomDesignItemFrontBtnContainer = createNewElement('div', 'text-center text-lg-end d-none d-md-block');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBtnContainer);
    
    let colCustomDesignItemFrontBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemFrontBtnContainer.append(colCustomDesignItemFrontBtn);

    /* COLUMN CUSTOM DESIGN ITEM BACK */
    let colCustomDesignItemBack = createNewElement('div', 'col-12 col-md-6 custom-design-item-back mt-md-4');
    customDesignItemRow.append(colCustomDesignItemBack);

    let colCustomDesignItemBackBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemBack.append(colCustomDesignItemBackBg);

    let colCustomDesignItemBackBgImg = createNewElement('div', 'js-image-src custom-design-item-image');
    colCustomDesignItemBackBgImg.dataset.imageSrc = urlBack;
    colCustomDesignItemBackBg.append(colCustomDesignItemBackBgImg);

    let colCustomDesignItemBackBtnContainer = createNewElement('div', 'text-center text-lg-start');
    colCustomDesignItemBack.append(colCustomDesignItemBackBtnContainer);
    
    let colCustomDesignItemBackMobBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75 d-md-none mb-4', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackMobBtn);

    let colCustomDesignItemBackBtn = createNewElement('button', 'btn btn-primary w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackBtn);

    return customDesignItem;
}

/* CREATE CREDIT CARD SAVED JOBS */
let createCreditCardContainer = document.querySelectorAll('.js-create-credit-card');

if(createCreditCardContainer){
    createCreditCardContainer.forEach((el) =>{

        let selectedCard = createSavedCard();
        selectedCard.classList.add('saved-history-credit-card');

        el.append(selectedCard);

        for( let cardType of el.classList){
            if (cardType == 'mastercard-red'){

                selectedCard.classList.remove('saved-credit-card-mastercard-orang');
                selectedCard.classList.add('saved-credit-card-mastercard-red');
    
            } else if (cardType == 'mastercard-blue'){
    
                selectedCard.classList.remove('saved-credit-card-mastercard-orang');
                selectedCard.classList.add('saved-credit-card-mastercard-blue');
            }
        }
        
    })
}

/* CUSTOM DESIGN */
let customDesignsNameInput = document.querySelectorAll('.custom-designs-name-input');

if(customDesignsNameInput){
    
    customDesignsNameInput.forEach((input) => {
        input.addEventListener('keyup', () =>{

            let editNameBtn =  input.nextElementSibling;

           if (input.value){
                editNameBtn.classList.remove('text-drab');
                editNameBtn.classList.remove('is-disabled');
                editNameBtn.classList.add('text-primary');
           } else{
                editNameBtn.classList.add('text-drab');
                editNameBtn.classList.add('is-disabled ');
                editNameBtn.classList.remove('text-primary');
           }

        })
    })
}

/* CUSTOM DESIGN EDIT NAME */
let customDesignEditNameBtns = document.querySelectorAll('.js-custom-design-edit-name-btn');

if(customDesignEditNameBtns){

    customDesignEditNameBtns.forEach((btn) => {

        btn.addEventListener('click', () =>{

           let inputValue = btn.previousElementSibling.value;
           console.log(inputValue);

        })

    })
}

/* CUSTOM DESIGN CLICK ITEM SHOW MODAL  */
let customDesignCards = document.querySelectorAll('.js-custom-design-card');

if(customDesignCards){

    customDesignCards.forEach((btn) => {

        btn.addEventListener('click', () =>{

            let cardType = btn.parentElement.classList;

            for( let className of cardType){

                if(className == 'custom-design-item-front'){
                    createDesignModalBody('dist/images/img-main/img-front.png', '', [],
                    'EcoIceGrip Marketing Flyer Front', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }

                if(className == 'custom-design-item-back'){
                    createDesignModalBody('', 'dist/images/img-main/img-back.png', [],
                    'EcoIceGrip Marketing Flyer Back', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }
            }

            modalDesignFlyer.show();

        })

    })
}

/* CREATE ACCOUNT ADDRESS BOOK ITEM  */
let accountShippingAddressBookList = document.getElementById('accountAddressBookList');

if (accountShippingAddressBookList){

    let accountAddressBookItem = createShippingAddressItem();
    accountShippingAddressBookList.append(accountAddressBookItem);

}

function createShippingAddressItem() {

    let idItem = 0;
    idItem++;

    let accountShippingAddressItem = createNewElement('div', 'account-address-item');
    
    let accountShippingAddressForm = createNewElement('form', 'account-address-form');
    accountShippingAddressItem.append(accountShippingAddressForm);

    let shippingAddressTitle = createNewElement('h4', 'text-md mb-2 text-center text-lg-start');
    shippingAddressTitle.innerText = `Shipping Address-${idItem}`;
    accountShippingAddressForm.append(shippingAddressTitle);

    let hrLine = createNewElement('hr', 'text-drab mt-2');
    accountShippingAddressForm.append(hrLine);

    let row = createNewElement('div', 'row');
    accountShippingAddressForm.append(row);


    /* YOUR NAME COLUMN*/
    let yourAddressNamecol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourAddressNamecol);

    let addressNameLabel = createNewElement('label', 'form-label', 'Your Name');
    addressNameLabel.setAttribute('for', `accountAddressBookName-${idItem}`);
    yourAddressNamecol.append(addressNameLabel);

    let adressNameInput = createNewElement('input', 'form-control text-xxs');
    adressNameInput.type = 'text';
    adressNameInput.name = 'Your_Name';
    adressNameInput.placeholder = 'John';
    adressNameInput.id = `accountAddressBookName-${idItem}`;
    yourAddressNamecol.append(adressNameInput);


    /* YOUR SURNAME COLUMN*/
    let yourSurNameCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourSurNameCol);

    let surNameLabel = createNewElement('label', 'form-label', 'Your Surname');
    surNameLabel.setAttribute('for', `accountAddressBookSurName-${idItem}`);
    yourSurNameCol.append(surNameLabel);

    let surNameInput = createNewElement('input', 'form-control text-xxs');
    surNameInput.type = 'text';
    surNameInput.name = 'Your_Surname';
    surNameInput.placeholder = 'Smith';
    surNameInput.id = `accountAddressBookSurName-${idItem}`;
    yourSurNameCol.append(surNameInput);


    /* EMAIL ADDRESS COLUMN*/
    let emailAddressCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(emailAddressCol);

    let emailAddressLable = createNewElement('label', 'form-label', 'E-Mail Address');
    emailAddressLable.setAttribute('for', `accountAddressBookEmail-${idItem}`);
    emailAddressCol.append(emailAddressLable);

    let emailAddressInput = createNewElement('input', 'form-control text-xxs');
    emailAddressInput.type = 'email';
    emailAddressInput.name = 'E-Mail_Address';
    emailAddressInput.placeholder = 'john.smith@gmail.com';
    emailAddressInput.id = `accountAddressBookEmail-${idItem}`;
    emailAddressCol.append(emailAddressInput);

    /* PHONE NUMBER COLUMN*/
    let phoneNumberCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(phoneNumberCol);

    let phoneNumberLable = createNewElement('label', 'form-label', 'Phone Number');
    phoneNumberLable.setAttribute('for', `accountAddressBookPhoneNum-${idItem}`);
    phoneNumberCol.append(phoneNumberLable);

    let phoneNumberInput = createNewElement('input', 'form-control text-xxs');
    phoneNumberInput.type = 'number';
    phoneNumberInput.name = 'Phone_Number';
    phoneNumberInput.placeholder = '1 (613) 444-3212';
    phoneNumberInput.id = `accountAddressBookPhoneNum-${idItem}`;
    phoneNumberCol.append(phoneNumberInput);

    /* STREET ONE ADDRESS COLUMN*/
    let streetAddressOneCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressOneCol);

    let streetAddressOneLable = createNewElement('label', 'form-label', 'Street Address 1');
    streetAddressOneLable.setAttribute('for', `accountAddressBookStreetOne-${idItem}`);
    streetAddressOneCol.append(streetAddressOneLable);

    let streetAddressOneInput = createNewElement('input', 'form-control text-xxs');
    streetAddressOneInput.type = 'text';
    streetAddressOneInput.name = 'Street_Address_1';
    streetAddressOneInput.placeholder = 'john.smith@gmail.com';
    streetAddressOneInput.id = `accountAddressBookStreetOne-${idItem}`;
    streetAddressOneCol.append(streetAddressOneInput);

    /* STREET TWO ADDRESS COLUMN*/
    let streetAddressTwoCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressTwoCol);
   
    let streetAddressTwoLable = createNewElement('label', 'form-label', 'Street Address 2');
    streetAddressTwoLable.setAttribute('for', `accountAddressBookStreetTwo-${idItem}`);
    streetAddressTwoCol.append(streetAddressTwoLable);
   
    let streetAddressTwoInput = createNewElement('input', 'form-control text-xxs');
    streetAddressTwoInput.type = 'text';
    streetAddressTwoInput.name = 'Street_Address_2';
    streetAddressTwoInput.placeholder = 'john.smith@gmail.com';
    streetAddressTwoInput.id = `accountAddressBookStreetTwo-${idItem}`;
    streetAddressTwoCol.append(streetAddressTwoInput);

    /* SELECT COUNTRY */
    let countrySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(countrySelectCol);
   
    let countryLable = createNewElement('label', 'form-label', 'Country');
    countryLable.setAttribute('for', `accountAddressBookCountry-${idItem}`);
    countrySelectCol.append(countryLable);
   
    let countrySelect = createNewElement('select');
    countrySelect.id = `accountAddressBookCountry-${idItem}`;
    countrySelectCol.append(countrySelect);

    /* SELECT PROVINCE */
    let provinceSelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(provinceSelectCol);
    let provinceLable = createNewElement('label', 'form-label', 'Province');
    provinceLable.setAttribute('for', `accountAddressBookProvince-${idItem}`);
    provinceSelectCol.append(provinceLable);

    let provinceSelect = createNewElement('select', 'tom-select');
    provinceSelect.id = `accountAddressBookProvince-${idItem}`;
    provinceSelectCol.append(provinceSelect);

    let provinceOption = createNewElement('option');
    provinceOption.innerText = 'Ontario';
    provinceOption.value = 'Ontario';

    provinceSelect.append(provinceOption);

    /* SELECT CITY */
    let citySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(citySelectCol);
    let cityLable = createNewElement('label', 'form-label', 'city');
    cityLable.setAttribute('for', `accountAddressBookCity-${idItem}`);
    citySelectCol.append(cityLable);
    
    let citySelect = createNewElement('select', 'tom-select');
    citySelect.id = `accountAddressBookCity-${idItem}`;
    citySelectCol.append(citySelect);
    let cityOption = createNewElement('option');
    cityOption.innerText = 'Ottawa';
    cityOption.value = 'Ottawa';
    citySelect.append(cityOption);

    /* POSTAL CODE COLUMN*/
    let postalCodeCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(postalCodeCol);
    
    let postalCodeLable = createNewElement('label', 'form-label', 'Street Address 2');
    postalCodeLable.setAttribute('for', `accountAddressBookPostalCode-${idItem}`);
    postalCodeCol.append(postalCodeLable);
    
    let postalCodeInput = createNewElement('input', 'form-control text-xxs');
    postalCodeInput.type = 'text';
    postalCodeInput.name = 'Postal_Code';
    postalCodeInput.placeholder = 'A123';
    postalCodeInput.id = `accountAddressBookPostalCode-${idItem}`;
    postalCodeCol.append(postalCodeInput);

    /* FOOTER SHIPPING ADDRESS ITEM */

    let footerContainer = createNewElement('div', 'd-lg-flex justify-content-between align-items-center mt-lg-4 text-center');
    accountShippingAddressForm.append(footerContainer);

    
    
/*  
  
      
    <div class="d-lg-flex justify-content-between align-items-center mt-lg-4 text-center">
        <div>
            <div class="form-check form-check-inline mb-4 mb-lg-0">
                <input class="form-check-input form-check-input-circle form-check-input-circle-small mt-2 me-2" type="checkbox" value="" id="accountAddressBookDefault" checked>
                <label class="form-check-label text-sm text-primary fw-semibold" for="accountAddressBookDefault">
                    Default Shipping Address
                </label>
            </div>
        </div>
        <div>
            <button class="btn btn-white-with-border mb-2 mb-sm-0 me-2 me-xl-4" type="button">Delete Address</button>
            <button class="btn btn-primary mb-2 mb-sm-0" type="button">Edit Address</button>
        </div>
    </div>
</form> */

    return accountShippingAddressItem;
}

/* IMAGES BACKROUND SRC */
let listImages = document.getElementsByClassName('js-image-src');

for (let i = 0; i < listImages.length; i++) {
	let src = listImages[i].getAttribute('data-image-src');
	listImages[i].style.backgroundImage="url('" + src + "')";
}