let countries = [
	{
        name: "Canada",
        image: "dist/images/icons-language/canada.svg"
	},
	{
        name: "France",
        image: "dist/images/icons-language/france.svg"
	}
];


/* CREATE CUSTOM DESIGN IN PROGRESS LIST */
let accordionCustomDesignInProgressList = document.getElementById('accordionCustomDesignInProgressList');

if (accordionCustomDesignInProgressList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemOne);

    let accordionCustomDesignInProgressItemTwo = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemTwo);
}


/* CREATE CUSTOM DESIGN COMPLETED LIST */
let accordionCustomCompletedDesignList = document.getElementById('accordionCustomCompletedDesignList');

if (accordionCustomCompletedDesignList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', true);
    accordionCustomCompletedDesignList.append(accordionCustomDesignInProgressItemOne);

}



/* FUNCTION CREATE CUSTOM DESIGN ITEM */
function createCustomDesignItem( urlFront='', urlBack='', completedDesigns){

    let customDesignItem = createNewElement('div', 'custom-design-item mb-4 mb-xl-5');

    /* ROW */
    let customDesignItemRow = createNewElement('div', 'row align-items-center');
    customDesignItem.append(customDesignItemRow);

    /* COLUMN INPUT */
     let colInput = createNewElement('div', 'col-12 col-md-8');
     customDesignItemRow.append(colInput);

     let colInputContainer = createNewElement('div', 'position-relative');
     colInput.append(colInputContainer);

     let customDesignNameInput =  createNewElement('input', 'form-control text-xxs input-number-without-arrow custom-designs-name-input');
     customDesignNameInput.name = 'Custom_Design_Name';
     customDesignNameInput.type = 'text';
     customDesignNameInput.placeholder = 'Your custom design name';
     colInputContainer.append(customDesignNameInput);

     let editCustomDesignNameBtn = createNewElement('button', 'btn btn-link position-absolute text-drab text-xxs top-50 translate-middle is-disabled end-0 fw-normal p-0 js-custom-design-edit-name-btn', 'Edit Name');
     editCustomDesignNameBtn.type = 'button';
     editCustomDesignNameBtn.setAttribute('data-bs-toggle', 'tooltip');
     editCustomDesignNameBtn.setAttribute('data-bs-placement', 'top');
     editCustomDesignNameBtn.setAttribute('data-bs-title', 'Test 123!!!');
     colInputContainer.append(editCustomDesignNameBtn);

     new bootstrap.Tooltip(editCustomDesignNameBtn);
     

    /* COLUMN TITLE */
    let colTitle = createNewElement('div', 'col-12 col-md-4 text-center my-3 my-md-0');
    customDesignItemRow.append(colTitle);
     
    let customDesignItemTypeTitle = createNewElement('span', 'text-orang fw-semibold', 'In Review');
    if(completedDesigns){
        customDesignItemTypeTitle.className = 'text-green fw-semibold';
        customDesignItemTypeTitle.innerText = 'Complete';
    }

    colTitle.append(customDesignItemTypeTitle);


    /* COLUMN CUSTOM DESIGN ITEM FRONT */
    let colCustomDesignItemFront = createNewElement('div', 'col-12 col-md-6 custom-design-item-front mt-md-4');
    customDesignItemRow.append(colCustomDesignItemFront);

    let colCustomDesignItemFrontBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center cursor-pointer p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBg);

    let colCustomDesignItemFrontBgImg = createNewElement('div', 'custom-design-item-image');
    colCustomDesignItemFrontBgImg.style.backgroundImage = `url('${urlFront}')`;
    colCustomDesignItemFrontBg.append(colCustomDesignItemFrontBgImg);

    let colCustomDesignItemFrontBtnContainer = createNewElement('div', 'text-center text-lg-end d-none d-md-block');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBtnContainer);
    
    let colCustomDesignItemFrontBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemFrontBtnContainer.append(colCustomDesignItemFrontBtn);

    /* COLUMN CUSTOM DESIGN ITEM BACK */
    let colCustomDesignItemBack = createNewElement('div', 'col-12 col-md-6 custom-design-item-back mt-md-4');
    customDesignItemRow.append(colCustomDesignItemBack);

    let colCustomDesignItemBackBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center cursor-pointer p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemBack.append(colCustomDesignItemBackBg);

    let colCustomDesignItemBackBgImg = createNewElement('div', 'custom-design-item-image');
    colCustomDesignItemBackBgImg.style.backgroundImage = `url('${urlBack}')`;
    colCustomDesignItemBackBg.append(colCustomDesignItemBackBgImg);

    let colCustomDesignItemBackBtnContainer = createNewElement('div', 'text-center text-lg-start');
    colCustomDesignItemBack.append(colCustomDesignItemBackBtnContainer);
    
    let colCustomDesignItemBackMobBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75 d-md-none mb-4', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackMobBtn);

    let colCustomDesignItemBackBtn = createNewElement('button', 'btn btn-primary w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackBtn);

    return customDesignItem;
}



/* CUSTOM DESIGN */
let customDesignsNameInput = document.querySelectorAll('.custom-designs-name-input');

if(customDesignsNameInput){
    
    customDesignsNameInput.forEach((input) => {
        input.addEventListener('keyup', () =>{

            let editNameBtn =  input.nextElementSibling;

           if (input.value){

                let inputValue = input.value;
                editNameBtn.innerHTML = 'Save';

                editNameBtn.dataset.bsTitle = inputValue;
                editNameBtn.classList.remove('text-drab');
                editNameBtn.classList.remove('is-disabled');
                editNameBtn.classList.add('text-primary');

           } else{
                editNameBtn.classList.add('text-drab');
                editNameBtn.classList.add('is-disabled');
                editNameBtn.classList.remove('text-primary');

                editNameBtn.innerHTML = 'Edit Name';

                editNameBtn.dataset.bsTitle = '';
           }

        })
    })
}



/* CUSTOM DESIGN EDIT NAME */
let customDesignEditNameInputs = document.querySelectorAll('.custom-designs-name-input');

if(customDesignEditNameInputs){

    customDesignEditNameInputs.forEach((input) => {

        input.addEventListener('keyup', () =>{

            let inputValue = input.value;

            let editNameBtn = input.nextElementSibling;

            input.innerHTML = 'Save';

            editNameBtn.dataset.bsTitle = inputValue;

           console.log(inputValue);

        })

    })
}



/* CUSTOM DESIGN CLICK ITEM SHOW MODAL  */
let customDesignCards = document.querySelectorAll('.js-custom-design-card');

if(customDesignCards){

    customDesignCards.forEach((btn) => {

        btn.addEventListener('click', () =>{

            let cardType = btn.parentElement.classList;

            for( let className of cardType){

                if(className == 'custom-design-item-front'){
                    createDesignModalBody('dist/images/img-main/img-front.png', '', [],
                    'EcoIceGrip Marketing Flyer Front', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }

                if(className == 'custom-design-item-back'){
                    createDesignModalBody('', 'dist/images/img-main/img-back.png', [],
                    'EcoIceGrip Marketing Flyer Back', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }
            }

            modalDesignFlyer.show();

        })

    })
}




/* CREATE ACCOUNT ADDRESS BOOK ITEM  */
let shippingAddressCount = 0;

let accountShippingAddressBookList = document.getElementById('accountAddressBookList');

if (accountShippingAddressBookList){

    let accountAddressBookItem = createShippingAddressItem();
    accountShippingAddressBookList.append(accountAddressBookItem);

}

function createShippingAddressItem() {

 
    shippingAddressCount++;

    let accountShippingAddressItem = createNewElement('div', 'account-address-item mb-4 mb-lg-5');
    
    let accountShippingAddressForm = createNewElement('form', 'account-address-form');
    accountShippingAddressItem.append(accountShippingAddressForm);

    let shippingAddressTitle = createNewElement('h4', 'text-md mb-2 text-center text-lg-start');
    shippingAddressTitle.innerText = `Shipping Address-${shippingAddressCount}`;
    accountShippingAddressForm.append(shippingAddressTitle);

    let hrLine = createNewElement('hr', 'text-drab mt-2');
    accountShippingAddressForm.append(hrLine);

    let row = createNewElement('div', 'row');
    accountShippingAddressForm.append(row);


    /* YOUR NAME COLUMN*/
    let yourAddressNamecol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourAddressNamecol);

    let addressNameLabel = createNewElement('label', 'form-label', 'Your Name');
    addressNameLabel.setAttribute('for', `accountAddressBookName-${shippingAddressCount}`);
    yourAddressNamecol.append(addressNameLabel);

    let adressNameInput = createNewElement('input', 'form-control text-xxs');
    adressNameInput.type = 'text';
    adressNameInput.name = 'Your_Name';
    adressNameInput.placeholder = 'John';
    adressNameInput.id = `accountAddressBookName-${shippingAddressCount}`;
    yourAddressNamecol.append(adressNameInput);


    /* YOUR SURNAME COLUMN*/
    let yourSurNameCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourSurNameCol);

    let surNameLabel = createNewElement('label', 'form-label', 'Your Surname');
    surNameLabel.setAttribute('for', `accountAddressBookSurName-${shippingAddressCount}`);
    yourSurNameCol.append(surNameLabel);

    let surNameInput = createNewElement('input', 'form-control text-xxs');
    surNameInput.type = 'text';
    surNameInput.name = 'Your_Surname';
    surNameInput.placeholder = 'Smith';
    surNameInput.id = `accountAddressBookSurName-${shippingAddressCount}`;
    yourSurNameCol.append(surNameInput);


    /* EMAIL ADDRESS COLUMN*/
    let emailAddressCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(emailAddressCol);

    let emailAddressLable = createNewElement('label', 'form-label', 'E-Mail Address');
    emailAddressLable.setAttribute('for', `accountAddressBookEmail-${shippingAddressCount}`);
    emailAddressCol.append(emailAddressLable);

    let emailAddressInput = createNewElement('input', 'form-control text-xxs');
    emailAddressInput.type = 'email';
    emailAddressInput.name = 'E-Mail_Address';
    emailAddressInput.placeholder = 'john.smith@gmail.com';
    emailAddressInput.id = `accountAddressBookEmail-${shippingAddressCount}`;
    emailAddressCol.append(emailAddressInput);


    /* PHONE NUMBER COLUMN*/
    let phoneNumberCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(phoneNumberCol);

    let phoneNumberLable = createNewElement('label', 'form-label', 'Phone Number');
    phoneNumberLable.setAttribute('for', `accountAddressBookPhoneNum-${shippingAddressCount}`);
    phoneNumberCol.append(phoneNumberLable);

    let phoneNumberInput = createNewElement('input', 'form-control text-xxs');
    phoneNumberInput.type = 'number';
    phoneNumberInput.name = 'Phone_Number';
    phoneNumberInput.placeholder = '1 (613) 444-3212';
    phoneNumberInput.id = `accountAddressBookPhoneNum-${shippingAddressCount}`;
    phoneNumberCol.append(phoneNumberInput);


    /* STREET ONE ADDRESS COLUMN*/
    let streetAddressOneCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressOneCol);

    let streetAddressOneLable = createNewElement('label', 'form-label', 'Street Address 1');
    streetAddressOneLable.setAttribute('for', `accountAddressBookStreetOne-${shippingAddressCount}`);
    streetAddressOneCol.append(streetAddressOneLable);

    let streetAddressOneInput = createNewElement('input', 'form-control text-xxs');
    streetAddressOneInput.type = 'text';
    streetAddressOneInput.name = 'Street_Address_1';
    streetAddressOneInput.placeholder = 'john.smith@gmail.com';
    streetAddressOneInput.id = `accountAddressBookStreetOne-${shippingAddressCount}`;
    streetAddressOneCol.append(streetAddressOneInput);


    /* STREET TWO ADDRESS COLUMN*/
    let streetAddressTwoCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressTwoCol);
   
    let streetAddressTwoLable = createNewElement('label', 'form-label', 'Street Address 2');
    streetAddressTwoLable.setAttribute('for', `accountAddressBookStreetTwo-${shippingAddressCount}`);
    streetAddressTwoCol.append(streetAddressTwoLable);
   
    let streetAddressTwoInput = createNewElement('input', 'form-control text-xxs');
    streetAddressTwoInput.type = 'text';
    streetAddressTwoInput.name = 'Street_Address_2';
    streetAddressTwoInput.placeholder = 'john.smith@gmail.com';
    streetAddressTwoInput.id = `accountAddressBookStreetTwo-${shippingAddressCount}`;
    streetAddressTwoCol.append(streetAddressTwoInput);


    /* SELECT COUNTRY */
    let countrySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(countrySelectCol);
   
    let countryLable = createNewElement('label', 'form-label', 'Country');
    countryLable.setAttribute('for', `accountAddressBookCountry-${shippingAddressCount}`);
    countrySelectCol.append(countryLable);
   
    let countrySelect = createNewElement('select');
    countrySelect.id = `accountAddressBookCountry-${shippingAddressCount}`;
    countrySelectCol.append(countrySelect);

    countries.forEach(cntr => {
        let option = document.createElement('option');
        option.dataset.icon = cntr.image;
        option.innerText = cntr.name;
        countrySelect.append(option);
    })

    initTomSelectByEl(countrySelect, tomSelectCountryOptions);


    /* SELECT PROVINCE */
    let provinceSelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(provinceSelectCol);
    let provinceLable = createNewElement('label', 'form-label', 'Province');
    provinceLable.setAttribute('for', `accountAddressBookProvince-${shippingAddressCount}`);
    provinceSelectCol.append(provinceLable);

    let provinceSelect = createNewElement('select', 'tom-select');
    provinceSelect.id = `accountAddressBookProvince-${shippingAddressCount}`;
    provinceSelectCol.append(provinceSelect);

    let provinceOption = createNewElement('option');
    provinceOption.innerText = 'Ontario';
    provinceOption.value = 'Ontario';

    provinceSelect.append(provinceOption);

    initTomSelectByEl(provinceSelect, tomSelectDefaultOptions);



    /* SELECT CITY */
    let citySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(citySelectCol);
    let cityLable = createNewElement('label', 'form-label', 'city');
    cityLable.setAttribute('for', `accountAddressBookCity-${shippingAddressCount}`);
    citySelectCol.append(cityLable);
    
    let citySelect = createNewElement('select', 'tom-select');
    citySelect.id = `accountAddressBookCity-${shippingAddressCount}`;
    citySelectCol.append(citySelect);
    let cityOption = createNewElement('option');
    cityOption.innerText = 'Ottawa';
    cityOption.value = 'Ottawa';
    citySelect.append(cityOption);

    initTomSelectByEl(citySelect, tomSelectDefaultOptions);


    /* POSTAL CODE COLUMN*/
    let postalCodeCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(postalCodeCol);
    
    let postalCodeLable = createNewElement('label', 'form-label', 'Street Address 2');
    postalCodeLable.setAttribute('for', `accountAddressBookPostalCode-${shippingAddressCount}`);
    postalCodeCol.append(postalCodeLable);
    
    let postalCodeInput = createNewElement('input', 'form-control text-xxs');
    postalCodeInput.type = 'text';
    postalCodeInput.name = 'Postal_Code';
    postalCodeInput.placeholder = 'A123';
    postalCodeInput.id = `accountAddressBookPostalCode-${shippingAddressCount}`;
    postalCodeCol.append(postalCodeInput);


    /* FOOTER SHIPPING ADDRESS ITEM */
    let footerContainer = createNewElement('div', 'd-lg-flex justify-content-between align-items-center mt-lg-4 text-center');
    accountShippingAddressForm.append(footerContainer);

    let footerContainerDivLeft = createNewElement('div');
    footerContainer.append(footerContainerDivLeft);


    /* DEFAULT SHIPPING ADDRESS INPUT */
    let defaultShippingFormCheckDiv = createNewElement('div', 'form-check form-check-inline mb-4 mb-lg-0');
    footerContainerDivLeft.append(defaultShippingFormCheckDiv);

    let defaultShippingFormCheckInput = createNewElement('input', 'form-check-input form-check-input-circle form-check-input-circle-small me-2');
    defaultShippingFormCheckInput.type = 'checkbox';
    defaultShippingFormCheckInput.checked = true;
    defaultShippingFormCheckInput.id = `accountAddressBookDefault-${shippingAddressCount}`;
    defaultShippingFormCheckDiv.append(defaultShippingFormCheckInput);

    let defaultShippingFormCheckLabel = createNewElement('label', 'form-check-label text-sm text-primary fw-semibold', 'Default Shipping Address');
    defaultShippingFormCheckLabel.setAttribute('for', `accountAddressBookDefault-${shippingAddressCount}`);
    defaultShippingFormCheckDiv.append(defaultShippingFormCheckLabel);


    /* SHIPPING ADDRESS BTNS */
    let footerContainerDivRight = createNewElement('div');
    footerContainer.append(footerContainerDivRight);

    let shippingAddressDeleteBtn = createNewElement('button', 'btn btn-white-with-border mb-2 mb-sm-0 me-2 me-xl-4', 'Delete Address');
    shippingAddressDeleteBtn.type = 'button';
    footerContainerDivRight.append(shippingAddressDeleteBtn);

    let shippingAddressEditBtn = createNewElement('button', 'btn btn-white-with-border mb-2 mb-sm-0 me-2 me-xl-4', 'Edit Address');
    shippingAddressEditBtn.type = 'button';
    footerContainerDivRight.append(shippingAddressEditBtn);


    return accountShippingAddressItem;
}


/* ADD  NEW ADDRESS BTN EVENT CLICK */
let addNewAddressBtn = document.getElementById('addNewAddressBtn');

if (addNewAddressBtn) {
    addNewAddressBtn.addEventListener('click', (event) => {

        event.preventDefault();

        let accountAddressBookItem = createShippingAddressItem();
        accountShippingAddressBookList.append(accountAddressBookItem);

    });
}

/* ADD SAVED JOBS BUSINESS CARDS ITEMs  */
let savedJobsBusinessCardsContent = document.getElementById('savedJobsBusinessCardsContent');

if (savedJobsBusinessCardsContent) {

   let createSavedJobItemElOne =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsBusinessCardsContent.append(createSavedJobItemElOne);

   let createSavedJobItemElTwo =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsBusinessCardsContent.append(createSavedJobItemElTwo);

}

/* ADD SAVED JOBS FLYERS ITEMs  */
let savedJobsFlyersContent = document.getElementById('savedJobsFlyersContent');

if (savedJobsFlyersContent) {

   let createSavedJobItemElOne =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB Flyers', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsFlyersContent.append(createSavedJobItemElOne);

}

/* CREATE SAVED JOBS ITEM */
function createSavedJobItem(imgFront, imgBack, title, desc) {

    let savedJobItem = createNewElement('div', 'mb-5');

    let savedJobRow = createNewElement('div', 'row my-4');
    savedJobItem.append(savedJobRow);

    /*CREATE IMG COLUMNT  */
    let savedJobImgCol = createNewElement('div', 'col-12 col-lg-5 d-flex justify-content-center justify-content-lg-start mb-4 mb-lg-0');
    savedJobRow.append(savedJobImgCol);

    let savedJobImgColFrontImg = createNewElement('div', 'account-saved-jobs-img me-4');
    savedJobImgColFrontImg.style.backgroundImage = `url('${imgFront}')`;
    savedJobImgCol.append(savedJobImgColFrontImg);

    let savedJobImgColBackImg = createNewElement('div', 'account-saved-jobs-img');
    savedJobImgColBackImg.style.backgroundImage = `url('${imgBack}')`;
    savedJobImgCol.append(savedJobImgColBackImg);


    /*CREATE DESC COLUMNT  */
    let savedJobDescCol = createNewElement('div', 'col-12 col-lg-7 text-center text-lg-start');
    savedJobRow.append(savedJobDescCol);

    let savedJobDescTitle = createNewElement('h5', 'text-md', title);
    savedJobDescCol.append(savedJobDescTitle);

    let savedJobDescParagraph = createNewElement('p', 'text-xs', desc);
    savedJobDescCol.append(savedJobDescParagraph);


    /*CREATE ROW BTNS  */
    let savedJobsBtnsRow = createNewElement('div', 'row g-4 row-cols-1 row-cols-sm-2 row-cols-xl-3 row-cols-xxl-4 justify-content-center');
    savedJobItem.append(savedJobsBtnsRow);


    for(let col = 1; col <= 4; col++){
        
        let btnCol = createNewElement('div', 'col');

        let btnEl = createNewElement('button', 'btn btn-white-with-border w-100');
        btnEl.type = 'button';

        let btnIcon = createNewElement('span', 'me-1 me-xl-2 align-middle fw-bold');

        if(col == 1){
            btnEl.innerText = 'Remove';
            btnIcon.classList.add('fi-rr-trash');
        } else if(col == 2){
            btnEl.innerText = 'View Details';
            btnIcon.classList.add('fi-rr-eye');
        } else if(col == 3){
            btnEl.innerText = 'Add To cart';
            btnIcon.classList.add('fi-rr-shopping-cart');
        } else if(col == 4){
            btnEl.innerText = 'Checkout Now';
            btnIcon.classList.add('fi-rr-credit-card');
        }

        savedJobsBtnsRow.append(btnCol);
        btnCol.append(btnEl);
        btnEl.prepend(btnIcon);
    }


    return savedJobItem;
}

/* CREATE CREDIT CARDS ITEM */

function createCreditCardItem(cardNumberVisa = '4111 1111 1111 1111', cardType = 'mastercard', cardColor = 'orange', cardHolderName = 'JOHN SMITH', expDate = '08/23') {

    let creditCardsRow = document.getElementById('creditCardsRow');

    if (creditCardsRow){

        let creditCardCol = createNewElement('div', 'col-12 col-xl-6 js-credit-card-item');
        creditCardsRow.append(creditCardCol);

        let creditCardBlockRow = createNewElement('div', 'row w-100');
        creditCardCol.append(creditCardBlockRow);
        
        let creditCardBlockCol = createNewElement('div', 'col-12 col-lg-7 col-xl-12');
        creditCardBlockRow.append(creditCardBlockCol);

        let creditCard = createSavedCard(cardNumberVisa, cardType, cardColor, cardHolderName, expDate);
        creditCard.classList.add('m-auto');

        creditCardBlockCol.append(creditCard);  

        let creditCardColBts = createNewElement('div', 'col-12 col-lg-5 col-xl-12');
        creditCardBlockRow.append(creditCardColBts);

        let creditCardColBtsBlock = createNewElement('div', 'd-flex flex-lg-column flex-xl-row align-items-center');
        creditCardColBts.append(creditCardColBtsBlock);

        let creditCardDeleteBtn = createNewElement('button', 'btn btn-white-with-border w-50 w-lg-75 w-xl-50 me-2 me-xl-4 mb-lg-4 mb-xl-0', 'Delete Card');
        creditCardDeleteBtn.type = 'button';
        creditCardDeleteBtn.addEventListener('click', deleteCreditCardItem);
        creditCardColBtsBlock.append(creditCardDeleteBtn);

        let creditCardEditBtn = createNewElement('button', 'btn btn-primary w-50 w-lg-75 w-xl-50', 'Edit Card');
        creditCardEditBtn.type = 'button';
        creditCardColBtsBlock.append(creditCardEditBtn);

        let designLine = createNewElement('hr', 'text-drab me-xl-4 my-4');
        creditCardCol.append(designLine);

    }

}


/* DELETE CREDIT CARDS ITEM */
function deleteCreditCardItem(event) {

    let  el = event.target.closest('.js-credit-card-item');
    el.remove();
}

/* CREATE CREDIT CARD MODAL ADD YOUR CARD */
let accountAddYourCardForm = document.getElementById('accountAddYourCardForm');

if (accountAddYourCardForm){
   let accountAddYourCardEl = accountAddYourCardForm.querySelector('#accountAddYourCardEl');

   let card = createSavedCard('4111 1111 1111 1111', 'mastercard', 'red', 'JOHN SMITH', '08/23');

   accountAddYourCardEl.append(card);
}


createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');



/* CREATE ORDER HISTORY ITEM */
let accordionOrdersHistory = document.getElementById('accordionOrdersHistory');
if (accordionOrdersHistory) {
    let accordionOrdersHistoryItem = createOrderHistoryItem();
    accordionOrdersHistory.append(accordionOrdersHistoryItem);
}

function createOrderHistoryItem() {

    let accordionOrdersHistoryItem = createNewElement('div', 'accordion-item');



    return accordionOrdersHistoryItem;
    
}
{/* <div class="accordion-item">
<h2 class="accordion-header" id="accordionOrdersHistoryHeadingOne">
        <button class="accordion-button accordion-order-history-btn" type="button" data-bs-toggle="collapse" data-bs-target="#accordionOrdersHistoryCollapseOne" aria-expanded="true" aria-controls="accordionOrdersHistoryCollapseOne">
        <span>Order #0072ab12</span>
        <span class="text-green px-2 px-md-4 px-lg-5">Finished</span>
        <span>Total: <span class="fw-bold">$350.00</span></span>
        </button>
</h2>
<div id="accordionOrdersHistoryCollapseOne" class="accordion-collapse collapse show" aria-labelledby="accordionOrdersHistoryHeadingOne" data-bs-parent="#accordionOrdersHistoryOne">
    <div class="accordion-body">
            <div class="row px-4">
                <div class="col-12 col-xl-6 mb-4">
                    <h3 class="text-sm mb-3 fw-semibold">Ship To:</h3>
                    <div class="row row-cols-1 row-cols-sm-2">
                        <div>
                            <p class="text-xs lh-sm pe-xxl-5">John Smith, Company Name john.smith@gmail.com</p>
                        </div>
                        <div>
                            <p class="text-xs lh-sm">Street Address 123, A123 Ottawa, Canada</p>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-xl-6 mb-4">
                    <h3 class="text-sm mb-3 fw-semibold">Bill To:</h3>
                    <div class="row row-cols-1 row-cols-sm-2">
                        <div>
                            <p class="text-xs lh-sm">John Smith, Company Name john.smith@gmail.com</p>
                        </div>
                        <div>
                            <p class="text-xs lh-sm">Street Address 123, A123 Ottawa, Canada</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row px-4">
                <div class="col-12 col-xl-6 mb-4">
                    <h3 class="text-sm mb-3 fw-semibold">Paid by:</h3>
                    <div><span class="me-2">$100</span><span> Account Credit</span></div>
                    <div><span class="me-2">$155</span><span> Credit Card - Mastercard (**** **** **** 1234)</span></div>
                </div>
                <div class="col-12 col-xl-6 mb-4">
                    <h3 class="text-sm mb-3 fw-semibold">Paid by:</h3>
                    <div>
                        <div class="d-flex justify-content-between"><span>Items Total</span> <span class="fw-bold text-end">$190.50</span></div>
                        <div class="d-flex justify-content-between"><span>Turnaround Total</span> <span class="fw-bold text-end">$30.00</span></div>
                        <div class="d-flex justify-content-between"><span>Shipping</span> <span class="fw-bold text-end">20.00</span></div>
                        <div class="d-flex justify-content-between"><span>Tax</span> <span class="fw-bold text-end">$5.00</span></div>
                    </div>
                    <hr class="text-drab my-2">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="fw-bold text-xs mb-0">Grand Total</h4>
                        <span class="fw-bold text-xs text-primary">$255.00</span>
                    </div>
                </div>
            </div>
            <h3 class="text-sm mb-3 fw-semibold text-center text-md-start px-4">Items Ordered:</h3>
            <div class="your-carts">
                <div>
                    <div class="your-cart-container your-cart-history-container p-4">
                        <div class="your-cart-image">
                        <div class="">
                            <div class="your-cart-images m-auto js-image-src" data-image-src="dist/images/img-cart/img-cart.png"></div>
                            <a href="" class="btn-link text-drab text-xs fw-normal text-center d-none mt-3 d-lg-block">
                                <span class="fi-rr-zoom-in me-1"></span>
                                Front/Back
                            </a>
                            <a href="" class="btn-link text-drab text-xs fw-normal text-center d-block mt-3 d-lg-none">Front / Back</a>
                        </div>
                        </div>
                        <div class="your-cart-name d-lg-flex justify-content-between align-items-lg-center text-center text-sm-start my-3 my-sm-0">
                            <div class="fw-semibold mb-3 mb-lg-0">Standard Business Card</div>
                            <select class="tom-select-quontity-cart" autocomplete="off">
                                <option value="555">20.500</option>
                                <option value="123">123</option>
                                <option value="543">342</option>
                            </select>
                        </div>
                        <div class="your-cart-expected-desc my-3 my-sm-0 text-center text-sm-start">
                            <span class="expected-desc text-grey text-xs fw-semibold lh-sm">Standard Production (expected nov. 28, 2202 - dec. 1, 2022)</span>
                        </div>
                        <div class="your-cart-desc text-center text-lg-start">
                            <div class="row row-cols-2 row-cols-sm-3 row-cols-xl-4 gy-4 align-self-start">
                                <span class="text-xs"><span class="fw-semibold">Double</span> Sided</span>
                                <span class="text-xs"><span class="fw-semibold">Matte</span> Finish</span>
                                <span class="text-xs"><span class="fw-semibold">14pt</span> Card Stock</span>  
                                <span class="text-xs"><span class="fw-semibold">Rounded</span> Corners</span>  
                                <span class="text-xs"><span class="fw-semibold">14pt</span> Card Stock</span>  
                                <span class="text-xs"><span class="fw-semibold">Rounded</span> Corners</span>  
                                <span class="text-xs d-none d-xl-block"><span class="fw-semibold">Rounded</span> Corners</span> 
                                <span class="text-xs d-none d-xl-block"><span class="fw-semibold">Rounded</span> Corners</span> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
</div>
</div> */}