 /*  tom-select options */
 let tomSelectDefaultOptions = {
	controlInput: null
}

let tomSelectCartOptions = {
	controlInput: null,
	render: {
		item: function(data, escape) {
			let selectedText = escape(data.text);

			let option = `<div class="d-flex align-items-center text-start pe-4">Quantity:<span class="fw-bold ms-1 me-5"> ${selectedText}</span> <span class="fw-bold text-green">$11,100.00</span></div>`;
			return option;
		}
	}
}

let tomSelectWithQuontityOptions = {
	controlInput: null,
	render: {
		item: function(data, escape) {
			let selectedText = escape(data.text);

			let option = `<div class="d-flex align-items-center text-start fw-normal text-white">Quantity:<span class="fw-bold ms-1 me-3"> ${selectedText}</span> <span class="me-4 text-drab">$5555.55</span></div>`;
			return option;
		}
	}
}

let tomSelectWithQuontityCartOptions = {
	controlInput: null,
	render: {
		item: function(data, escape) {
			let selectedText = escape(data.text);

			let option = `<div class="d-flex align-items-center text-start fw-normal">Quantity:<span class="fw-bold ms-1 me-3"> ${selectedText}</span> <span class="me-4 text-drab">$5555.55</span></div>`;
			return option;
		}
	}
}

// tom-select country options
let tomSelectCountryOptions = {
	controlInput: null,
	render:{
		option: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.image;

			let option = '<div class="d-flex align-items-center text-start">';
			if(img){
				option = option + '<img class="mx-2 mx-sm-4" src="'+img+'" alt="Icon Flag">';
			}
			option = option + text;
			option = option + '</div>';
			return option;
		},
		item: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center text-start">';

			if(img){
				option = option + '<img class="me-2 icon-flag-country-select" src="dist/images/icons-language/canada.svg" alt="Icon Flag">'; 
			}
			option = option + text;
			option = option + '</div>';
			return option;
		}
	}
}

// init tom-select by class name
document.querySelectorAll('.tom-select').forEach((el)=>{
	new TomSelect(el, tomSelectDefaultOptions);
});  

document.querySelectorAll('.tom-select-cart').forEach((el)=>{
	new TomSelect(el, tomSelectCartOptions);
});

document.querySelectorAll('.tom-select-quontity').forEach((el)=>{
	new TomSelect(el, tomSelectWithQuontityOptions);
}); 

document.querySelectorAll('.tom-select-quontity-cart').forEach((el)=>{
	new TomSelect(el, tomSelectWithQuontityCartOptions);
}); 

document.querySelectorAll('.tom-select-country').forEach((el)=>{
	initTomSelectByEl(el, tomSelectCountryOptions);
});  




function createCountrySelect(elId, items) {
	let accountAddressBookCountry = document.getElementById(elId);

    if (accountAddressBookCountry) {
        items.forEach(el => {
            let option = document.createElement('option');
            option.dataset.icon = el.image;
            option.innerText = el.name;
            accountAddressBookCountry.append(option);
        })

        initTomSelectByEl(accountAddressBookCountry, tomSelectCountryOptions);
    }
}

function initTomSelectById(elId, tsOptions) {
    let element = document.getElementById(elId);

    if (element) {
        new TomSelect(element, tsOptions);
    }
}

function initTomSelectByEl(element, tsOptions) {
    if (element) {
        new TomSelect(element, tsOptions);
    }
}

