let countries = [
	{
        name: "Canada",
        image: "dist/images/icons-language/canada.svg"
	},
	{
        name: "France",
        image: "dist/images/icons-language/france.svg"
	}
];


/* CREATE CUSTOM DESIGN IN PROGRESS LIST */
let accordionCustomDesignInProgressList = document.getElementById('accordionCustomDesignInProgressList');

if (accordionCustomDesignInProgressList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemOne);

    let accordionCustomDesignInProgressItemTwo = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', false);
    accordionCustomDesignInProgressList.append(accordionCustomDesignInProgressItemTwo);
}


/* CREATE CUSTOM DESIGN COMPLETED LIST */
let accordionCustomCompletedDesignList = document.getElementById('accordionCustomCompletedDesignList');

if (accordionCustomCompletedDesignList){

    let accordionCustomDesignInProgressItemOne = createCustomDesignItem('dist/images/img-main/img-front.png', 'dist/images/img-main/img-back.png', true);
    accordionCustomCompletedDesignList.append(accordionCustomDesignInProgressItemOne);

}



/* FUNCTION CREATE CUSTOM DESIGN ITEM */
function createCustomDesignItem( urlFront='', urlBack='', completedDesigns){

    let customDesignItem = createNewElement('div', 'custom-design-item mb-4 mb-xl-5');

    /* ROW */
    let customDesignItemRow = createNewElement('div', 'row align-items-center');
    customDesignItem.append(customDesignItemRow);

    /* COLUMN INPUT */
     let colInput = createNewElement('div', 'col-12 col-md-8');
     customDesignItemRow.append(colInput);

     let colInputContainer = createNewElement('div', 'position-relative');
     colInput.append(colInputContainer);

     let customDesignNameInput =  createNewElement('input', 'form-control text-xxs input-number-without-arrow custom-designs-name-input');
     customDesignNameInput.name = 'Custom_Design_Name';
     customDesignNameInput.type = 'text';
     customDesignNameInput.placeholder = 'Your custom design name';
     colInputContainer.append(customDesignNameInput);

     let editCustomDesignNameBtn = createNewElement('button', 'btn btn-link position-absolute text-drab text-xxs top-50 translate-middle is-disabled end-0 fw-normal p-0 js-custom-design-edit-name-btn', 'Edit Name');
     editCustomDesignNameBtn.type = 'button';
  /*    editCustomDesignNameBtn.addEventListener('click', onclickOpenToast); */

     colInputContainer.append(editCustomDesignNameBtn);
/* 
     new bootstrap.Tooltip(editCustomDesignNameBtn); */
     new bootstrap.Toast(editCustomDesignNameBtn);
     

    /* COLUMN TITLE */
    let colTitle = createNewElement('div', 'col-12 col-md-4 text-center my-3 my-md-0');
    customDesignItemRow.append(colTitle);
     
    let customDesignItemTypeTitle = createNewElement('span', 'text-orang fw-semibold', 'In Review');
    if(completedDesigns){
        customDesignItemTypeTitle.className = 'text-green fw-semibold';
        customDesignItemTypeTitle.innerText = 'Complete';
    }

    colTitle.append(customDesignItemTypeTitle);


    /* COLUMN CUSTOM DESIGN ITEM FRONT */
    let colCustomDesignItemFront = createNewElement('div', 'col-12 col-md-6 custom-design-item-front mt-md-4');
    customDesignItemRow.append(colCustomDesignItemFront);

    let colCustomDesignItemFrontBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center cursor-pointer p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBg);

    let colCustomDesignItemFrontBgImg = createNewElement('div', 'custom-design-item-image');
    colCustomDesignItemFrontBgImg.style.backgroundImage = `url('${urlFront}')`;
    colCustomDesignItemFrontBg.append(colCustomDesignItemFrontBgImg);

    let colCustomDesignItemFrontBtnContainer = createNewElement('div', 'text-center text-lg-end d-none d-md-block');
    colCustomDesignItemFront.append(colCustomDesignItemFrontBtnContainer);
    
    let colCustomDesignItemFrontBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemFrontBtnContainer.append(colCustomDesignItemFrontBtn);

    /* COLUMN CUSTOM DESIGN ITEM BACK */
    let colCustomDesignItemBack = createNewElement('div', 'col-12 col-md-6 custom-design-item-back mt-md-4');
    customDesignItemRow.append(colCustomDesignItemBack);

    let colCustomDesignItemBackBg = createNewElement('div', 'bg-dark-blue mb-4 rounded-6 overflow-hidden text-white text-center cursor-pointer p-4 p-md-5 js-custom-design-card');
    colCustomDesignItemBack.append(colCustomDesignItemBackBg);

    let colCustomDesignItemBackBgImg = createNewElement('div', 'custom-design-item-image');
    colCustomDesignItemBackBgImg.style.backgroundImage = `url('${urlBack}')`;
    colCustomDesignItemBackBg.append(colCustomDesignItemBackBgImg);

    let colCustomDesignItemBackBtnContainer = createNewElement('div', 'text-center text-lg-start');
    colCustomDesignItemBack.append(colCustomDesignItemBackBtnContainer);
    
    let colCustomDesignItemBackMobBtn = createNewElement('button', 'btn btn-white-with-border w-100 w-sm-75 w-md-100 w-lg-75 d-md-none mb-4', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackMobBtn);

    let colCustomDesignItemBackBtn = createNewElement('button', 'btn btn-primary w-100 w-sm-75 w-md-100 w-lg-75', 'Request Changes');
    colCustomDesignItemBackBtnContainer.append(colCustomDesignItemBackBtn);

    return customDesignItem;
}



/* CUSTOM DESIGN */
let customDesignsNameInput = document.querySelectorAll('.custom-designs-name-input');

if(customDesignsNameInput){
    
    customDesignsNameInput.forEach((input) => {
        input.addEventListener('keyup', () =>{

            let editNameBtn =  input.nextElementSibling;

           if (input.value){

                let inputValue = input.value;
                editNameBtn.innerHTML = 'Save';

                editNameBtn.dataset.bsTitle = inputValue;
                editNameBtn.classList.remove('text-drab');
                editNameBtn.classList.remove('is-disabled');
                editNameBtn.classList.add('text-primary');

           } else{
                editNameBtn.classList.add('text-drab');
                editNameBtn.classList.add('is-disabled');
                editNameBtn.classList.remove('text-primary');

                editNameBtn.innerHTML = 'Edit Name';

                editNameBtn.dataset.bsTitle = '';
           }

        })
    })
}



/* CUSTOM DESIGN EDIT NAME */
let customDesignEditNameInputs = document.querySelectorAll('.custom-designs-name-input');

if(customDesignEditNameInputs){

    customDesignEditNameInputs.forEach((input) => {

        input.addEventListener('keyup', () =>{

            let inputValue = input.value;

            let editNameBtn = input.nextElementSibling;

            input.innerHTML = 'Save';

            editNameBtn.dataset.bsTitle = inputValue;

           console.log(inputValue);

        })

    })
}



/* CUSTOM DESIGN CLICK ITEM SHOW MODAL  */
let customDesignCards = document.querySelectorAll('.js-custom-design-card');

if(customDesignCards){

    customDesignCards.forEach((btn) => {

        btn.addEventListener('click', () =>{

            let cardType = btn.parentElement.classList;

            for( let className of cardType){

                if(className == 'custom-design-item-front'){
                    createDesignModalBody('dist/images/img-main/img-front.png', '', [],
                    'EcoIceGrip Marketing Flyer Front', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }

                if(className == 'custom-design-item-back'){
                    createDesignModalBody('', 'dist/images/img-main/img-back.png', [],
                    'EcoIceGrip Marketing Flyer Back', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
                }
            }

            modalDesignFlyer.show();

        })

    })
}




/* CREATE ACCOUNT ADDRESS BOOK ITEM  */
let shippingAddressCount = 0;

let accountShippingAddressBookList = document.getElementById('accountAddressBookList');

if (accountShippingAddressBookList){

    let accountAddressBookItem = createShippingAddressItem();
    accountShippingAddressBookList.append(accountAddressBookItem);

}

function createShippingAddressItem() {
 
    shippingAddressCount++;

    let accountShippingAddressItem = createNewElement('div', 'account-address-item mb-4 mb-lg-5');
    accountShippingAddressItem.id = `account-address-item-${shippingAddressCount}`;

    let accountShippingAddressForm = createNewElement('form', 'account-address-form');
    accountShippingAddressItem.append(accountShippingAddressForm);

    let shippingAddressTitle = createNewElement('h4', 'shipping-address-title text-md mb-2 text-center text-lg-start');
    shippingAddressTitle.innerText = `Shipping Address-${shippingAddressCount}`;
    accountShippingAddressForm.append(shippingAddressTitle);

    let hrLine = createNewElement('hr', 'text-drab mt-2');
    accountShippingAddressForm.append(hrLine);

    let row = createNewElement('div', 'row js-disabled');
    accountShippingAddressForm.append(row);


    /* YOUR NAME COLUMN*/
    let yourAddressNamecol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourAddressNamecol);

    let addressNameLabel = createNewElement('label', 'form-label', 'Your Name');
    addressNameLabel.setAttribute('for', `accountAddressBookName-${shippingAddressCount}`);
    yourAddressNamecol.append(addressNameLabel);

    let adressNameInput = createNewElement('input', 'form-control text-xxs');
    adressNameInput.type = 'text';
    adressNameInput.name = 'Your_Name';
    adressNameInput.placeholder = 'John';
    adressNameInput.id = `accountAddressBookName-${shippingAddressCount}`;
    yourAddressNamecol.append(adressNameInput);


    /* YOUR SURNAME COLUMN*/
    let yourSurNameCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(yourSurNameCol);

    let surNameLabel = createNewElement('label', 'form-label', 'Your Surname');
    surNameLabel.setAttribute('for', `accountAddressBookSurName-${shippingAddressCount}`);
    yourSurNameCol.append(surNameLabel);

    let surNameInput = createNewElement('input', 'form-control text-xxs');
    surNameInput.type = 'text';
    surNameInput.name = 'Your_Surname';
    surNameInput.placeholder = 'Smith';
    surNameInput.id = `accountAddressBookSurName-${shippingAddressCount}`;
    yourSurNameCol.append(surNameInput);


    /* EMAIL ADDRESS COLUMN*/
    let emailAddressCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(emailAddressCol);

    let emailAddressLable = createNewElement('label', 'form-label', 'E-Mail Address');
    emailAddressLable.setAttribute('for', `accountAddressBookEmail-${shippingAddressCount}`);
    emailAddressCol.append(emailAddressLable);

    let emailAddressInput = createNewElement('input', 'form-control text-xxs');
    emailAddressInput.type = 'email';
    emailAddressInput.name = 'E-Mail_Address';
    emailAddressInput.placeholder = 'john.smith@gmail.com';
    emailAddressInput.id = `accountAddressBookEmail-${shippingAddressCount}`;
    emailAddressCol.append(emailAddressInput);


    /* PHONE NUMBER COLUMN*/
    let phoneNumberCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(phoneNumberCol);

    let phoneNumberLable = createNewElement('label', 'form-label', 'Phone Number');
    phoneNumberLable.setAttribute('for', `accountAddressBookPhoneNum-${shippingAddressCount}`);
    phoneNumberCol.append(phoneNumberLable);

    let phoneNumberInput = createNewElement('input', 'form-control text-xxs input-number-without-arrow');
    phoneNumberInput.type = 'number';
    phoneNumberInput.name = 'Phone_Number';
    phoneNumberInput.placeholder = '1 (613) 444-3212';
    phoneNumberInput.id = `accountAddressBookPhoneNum-${shippingAddressCount}`;
    phoneNumberCol.append(phoneNumberInput);


    /* STREET ONE ADDRESS COLUMN*/
    let streetAddressOneCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressOneCol);

    let streetAddressOneLable = createNewElement('label', 'form-label', 'Street Address 1');
    streetAddressOneLable.setAttribute('for', `accountAddressBookStreetOne-${shippingAddressCount}`);
    streetAddressOneCol.append(streetAddressOneLable);

    let streetAddressOneInput = createNewElement('input', 'form-control text-xxs');
    streetAddressOneInput.type = 'text';
    streetAddressOneInput.name = 'Street_Address_1';
    streetAddressOneInput.placeholder = 'john.smith@gmail.com';
    streetAddressOneInput.id = `accountAddressBookStreetOne-${shippingAddressCount}`;
    streetAddressOneCol.append(streetAddressOneInput);


    /* STREET TWO ADDRESS COLUMN*/
    let streetAddressTwoCol = createNewElement('div', 'col-12 col-sm-6 mb-4');
    row.append(streetAddressTwoCol);
   
    let streetAddressTwoLable = createNewElement('label', 'form-label', 'Street Address 2');
    streetAddressTwoLable.setAttribute('for', `accountAddressBookStreetTwo-${shippingAddressCount}`);
    streetAddressTwoCol.append(streetAddressTwoLable);
   
    let streetAddressTwoInput = createNewElement('input', 'form-control text-xxs');
    streetAddressTwoInput.type = 'text';
    streetAddressTwoInput.name = 'Street_Address_2';
    streetAddressTwoInput.placeholder = 'john.smith@gmail.com';
    streetAddressTwoInput.id = `accountAddressBookStreetTwo-${shippingAddressCount}`;
    streetAddressTwoCol.append(streetAddressTwoInput);


    /* SELECT COUNTRY */
    let countrySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(countrySelectCol);
   
    let countryLable = createNewElement('label', 'form-label', 'Country');
    countryLable.setAttribute('for', `accountAddressBookCountry-${shippingAddressCount}`);
    countrySelectCol.append(countryLable);
   
    let countrySelect = createNewElement('select');
    countrySelect.id = `accountAddressBookCountry-${shippingAddressCount}`;
    countrySelectCol.append(countrySelect);

    countries.forEach(cntr => {
        let option = document.createElement('option');
        option.dataset.icon = cntr.image;
        option.innerText = cntr.name;
        countrySelect.append(option);
    })

    initTomSelectByEl(countrySelect, tomSelectCountryOptions);


    /* SELECT PROVINCE */
    let provinceSelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(provinceSelectCol);
    let provinceLable = createNewElement('label', 'form-label', 'Province');
    provinceLable.setAttribute('for', `accountAddressBookProvince-${shippingAddressCount}`);
    provinceSelectCol.append(provinceLable);

    let provinceSelect = createNewElement('select', 'tom-select');
    provinceSelect.id = `accountAddressBookProvince-${shippingAddressCount}`;
    provinceSelectCol.append(provinceSelect);

    let provinceOption = createNewElement('option');
    provinceOption.innerText = 'Ontario';
    provinceOption.value = 'Ontario';

    provinceSelect.append(provinceOption);

    initTomSelectByEl(provinceSelect, tomSelectDefaultOptions);



    /* SELECT CITY */
    let citySelectCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(citySelectCol);
    let cityLable = createNewElement('label', 'form-label', 'City');
    cityLable.setAttribute('for', `accountAddressBookCity-${shippingAddressCount}`);
    citySelectCol.append(cityLable);
    
    let citySelect = createNewElement('select', 'tom-select');
    citySelect.id = `accountAddressBookCity-${shippingAddressCount}`;
    citySelectCol.append(citySelect);
    let cityOption = createNewElement('option');
    cityOption.innerText = 'Ottawa';
    cityOption.value = 'Ottawa';
    citySelect.append(cityOption);

    initTomSelectByEl(citySelect, tomSelectDefaultOptions);


    /* POSTAL CODE COLUMN*/
    let postalCodeCol = createNewElement('div', 'col-12 col-sm-6 col-lg-3 mb-4');
    row.append(postalCodeCol);
    
    let postalCodeLable = createNewElement('label', 'form-label', 'Postal Code');
    postalCodeLable.setAttribute('for', `accountAddressBookPostalCode-${shippingAddressCount}`);
    postalCodeCol.append(postalCodeLable);
    
    let postalCodeInput = createNewElement('input', 'form-control text-xxs');
    postalCodeInput.type = 'text';
    postalCodeInput.name = 'Postal_Code';
    postalCodeInput.placeholder = 'A123';
    postalCodeInput.id = `accountAddressBookPostalCode-${shippingAddressCount}`;
    postalCodeCol.append(postalCodeInput);


    /* FOOTER SHIPPING ADDRESS ITEM */
    let footerContainer = createNewElement('div', 'd-lg-flex justify-content-between align-items-center mt-lg-4 text-center');
    accountShippingAddressForm.append(footerContainer);

    let footerContainerDivLeft = createNewElement('div');
    footerContainer.append(footerContainerDivLeft);


    /* DEFAULT SHIPPING ADDRESS INPUT */
    let defaultShippingFormCheckDiv = createNewElement('div', 'form-check form-check-inline js-disabled mb-4 mb-lg-0');
    footerContainerDivLeft.append(defaultShippingFormCheckDiv);

    let defaultShippingFormCheckInput = createNewElement('input', 'form-check-input form-check-input-circle form-check-input-circle-small me-2');
    defaultShippingFormCheckInput.type = 'checkbox';
    /* defaultShippingFormCheckInput.checked = true; */
    defaultShippingFormCheckInput.id = `accountAddressBookDefault-${shippingAddressCount}`;
    defaultShippingFormCheckDiv.append(defaultShippingFormCheckInput);

    let defaultShippingFormCheckLabel = createNewElement('label', 'form-check-label text-sm text-primary fw-semibold', 'Default Shipping Address');
    defaultShippingFormCheckLabel.setAttribute('for', `accountAddressBookDefault-${shippingAddressCount}`);
    defaultShippingFormCheckDiv.append(defaultShippingFormCheckLabel);


    /* SHIPPING ADDRESS BTNS */
    let footerContainerDivRight = createNewElement('div');
    footerContainer.append(footerContainerDivRight);

    let shippingAddressDeleteBtn = createNewElement('button', 'btn btn-white-with-border mb-2 mb-sm-0 me-2 me-xl-4', 'Delete Address');
    shippingAddressDeleteBtn.type = 'button';
    shippingAddressDeleteBtn.dataset.bsTarget = '#modalAreYouSureDeleteShippingAddress';
    shippingAddressDeleteBtn.dataset.bsToggle = 'modal';
    shippingAddressDeleteBtn.dataset.bsShippingAddressId = `account-address-item-${shippingAddressCount}`;
    /* shippingAddressDeleteBtn.addEventListener('click', deleteShippingAddressItem); */
    footerContainerDivRight.append(shippingAddressDeleteBtn);

    let shippingAddressEditBtn = createNewElement('button', 'btn btn-white-with-border mb-2 mb-sm-0 me-2 me-xl-4', 'Edit Address');
    shippingAddressEditBtn.type = 'button';
    shippingAddressEditBtn.dataset.bsTarget = '#modalShippingAddressEdit';
    shippingAddressEditBtn.dataset.bsToggle = 'modal';
    footerContainerDivRight.append(shippingAddressEditBtn);

    return accountShippingAddressItem;
}

/* MODAL SHOW ARE YOU SURE DELETE SHIPPING ADDRESS  */

let modalAreYouSureDeleteShippingAddress = document.getElementById('modalAreYouSureDeleteShippingAddress');
let modalAreYouSureDeleteShippingAddressContainer = new bootstrap.Modal(modalAreYouSureDeleteShippingAddress, {
    keyboard: false
  })
let shippingAddressDeleteConfirmBtn = document.getElementById('shippingAddressDeleteConfirm');

if (modalAreYouSureDeleteShippingAddress){

    modalAreYouSureDeleteShippingAddress.addEventListener('shown.bs.modal', function (event) {

       let shippingAddressId = event.relatedTarget.getAttribute('data-bs-shipping-address-id');

       shippingAddressDeleteConfirmBtn.dataset.bsShippingAddressId = shippingAddressId;

      });

    // modalAreYouSureDeleteShippingAddress.addEventListener('hide.bs.modal', function (event) {

    //     if (event.target.id == 'shippingAddressDeleteConfirm'){
            
    //     }
    //   let shippingAddressId = event.relatedTarget.getAttribute('data-bs-shipping-address-id');
 
    //   shippingAddressDeleteConfirmBtn.dataset.bsShippingAddressId = shippingAddressId;
 
    // });

}

shippingAddressDeleteConfirmBtn.addEventListener('click', deleteShippingAddressItem);

/* DELETE SHIPPING ADDRESS ITEM */
function deleteShippingAddressItem(event) {

    let shippingAddressId = event.target.getAttribute('data-bs-shipping-address-id');
    let shippingAddressitem = document.getElementById(shippingAddressId);

    shippingAddressitem.remove();

    shippingAddressCount--;

    let shippingAddressTitles = document.querySelectorAll('.shipping-address-title');
    let count = 1;
    shippingAddressTitles.forEach((el) =>{
        el.innerText = `Shipping Address-${count}`;
        count++;
    })

    modalAreYouSureDeleteShippingAddressContainer.hide();
}

/* ADD  NEW ADDRESS BTN EVENT CLICK */
let addNewAddressBtn = document.getElementById('addNewAddressBtn');

if (addNewAddressBtn) {
    addNewAddressBtn.addEventListener('click', (event) => {

        event.preventDefault();

        let accountAddressBookItem = createShippingAddressItem();

        accountShippingAddressBookList.append(accountAddressBookItem);
        
        accountAddressBookItem.scrollIntoView({behavior: "smooth", block: "center", inline: "nearest"});

    });
}

/* ADD SAVED JOBS BUSINESS CARDS ITEMs  */
let savedJobsBusinessCardsContent = document.getElementById('savedJobsBusinessCardsContent');

if (savedJobsBusinessCardsContent) {

   let createSavedJobItemElOne =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsBusinessCardsContent.append(createSavedJobItemElOne);

   let createSavedJobItemElTwo =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsBusinessCardsContent.append(createSavedJobItemElTwo);

}

/* ADD SAVED JOBS FLYERS ITEMs  */
let savedJobsFlyersContent = document.getElementById('savedJobsFlyersContent');

if (savedJobsFlyersContent) {

   let createSavedJobItemElOne =  createSavedJobItem('dist/images/img-cart/img-cart.png', 'dist/images/img-cart/img-cart.png', 'CUSTOM NAME OF THIS SAVED JOB Flyers', 'Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt. Lorem ipsum dolor sit amet, consast ectetur adipiscing elit, sed do fared eiusmod tempor incididunt.');
   savedJobsFlyersContent.append(createSavedJobItemElOne);

}



/* CREATE SAVED JOBS ITEM */
function createSavedJobItem(imgFront, imgBack, title, desc) {

    let savedJobItem = createNewElement('div', 'mb-5');

    let savedJobRow = createNewElement('div', 'row my-4');
    savedJobItem.append(savedJobRow);

    /*CREATE IMG COLUMNT  */
    let savedJobImgCol = createNewElement('div', 'col-12 col-lg-5 d-flex justify-content-center justify-content-lg-start mb-4 mb-lg-0');
    savedJobRow.append(savedJobImgCol);

    let savedJobImgColFrontImg = createNewElement('div', 'account-saved-jobs-img me-4');
    savedJobImgColFrontImg.style.backgroundImage = `url('${imgFront}')`;
    savedJobImgCol.append(savedJobImgColFrontImg);

    let savedJobImgColBackImg = createNewElement('div', 'account-saved-jobs-img');
    savedJobImgColBackImg.style.backgroundImage = `url('${imgBack}')`;
    savedJobImgCol.append(savedJobImgColBackImg);


    /*CREATE DESC COLUMNT  */
    let savedJobDescCol = createNewElement('div', 'col-12 col-lg-7 text-center text-lg-start');
    savedJobRow.append(savedJobDescCol);

    let savedJobDescTitle = createNewElement('h5', 'text-md', title);
    savedJobDescCol.append(savedJobDescTitle);

    let savedJobDescParagraph = createNewElement('p', 'text-xs', desc);
    savedJobDescCol.append(savedJobDescParagraph);


    /*CREATE ROW BTNS  */
    let savedJobsBtnsRow = createNewElement('div', 'row g-4 row-cols-1 row-cols-sm-2 row-cols-xl-3 row-cols-xxl-4 justify-content-center');
    savedJobItem.append(savedJobsBtnsRow);


    for(let col = 1; col <= 4; col++){
        
        let btnCol = createNewElement('div', 'col');

        let btnEl = createNewElement('button', 'btn btn-white-with-border w-100');
        btnEl.type = 'button';

        let btnIcon = createNewElement('span', 'me-1 me-xl-2 align-middle fw-bold');

        if(col == 1){
            btnEl.innerText = 'Remove';
            btnIcon.classList.add('fi-rr-trash');
        } else if(col == 2){
            btnEl.innerText = 'View Details';
            btnIcon.classList.add('fi-rr-eye');
        } else if(col == 3){
            btnEl.innerText = 'Add To cart';
            btnIcon.classList.add('fi-rr-shopping-cart');
        } else if(col == 4){
            btnEl.innerText = 'Checkout Now';
            btnIcon.classList.add('fi-rr-credit-card');
        }

        savedJobsBtnsRow.append(btnCol);
        btnCol.append(btnEl);
        btnEl.prepend(btnIcon);
    }


    return savedJobItem;
}



/* CREATE CREDIT CARDS ITEM */
function createCreditCardItem(cardNumberVisa = '4111 1111 1111 1111', cardType = 'mastercard', cardColor = 'orange', cardHolderName = 'JOHN SMITH', expDate = '08/23') {

    let creditCardsRow = document.getElementById('creditCardsRow');

    if (creditCardsRow){

        let creditCardCol = createNewElement('div', 'col-12 col-xl-6 js-credit-card-item');
        creditCardsRow.append(creditCardCol);

        let creditCardBlockRow = createNewElement('div', 'row w-100');
        creditCardCol.append(creditCardBlockRow);
        
        let creditCardBlockCol = createNewElement('div', 'col-12 col-lg-7 col-xl-12');
        creditCardBlockRow.append(creditCardBlockCol);

        let creditCard = createSavedCard(cardNumberVisa, cardType, cardColor, cardHolderName, expDate);
        creditCard.classList.add('m-auto');

        creditCardBlockCol.append(creditCard);  

        let creditCardColBts = createNewElement('div', 'col-12 col-lg-5 col-xl-12');
        creditCardBlockRow.append(creditCardColBts);

        let creditCardColBtsBlock = createNewElement('div', 'd-flex flex-lg-column flex-xl-row align-items-center');
        creditCardColBts.append(creditCardColBtsBlock);

        let creditCardDeleteBtn = createNewElement('button', 'btn btn-white-with-border w-50 w-lg-75 w-xl-50 me-2 me-xl-4 mb-lg-4 mb-xl-0', 'Delete Card');
        creditCardDeleteBtn.type = 'button';
        creditCardDeleteBtn.addEventListener('click', deleteCreditCardItem);
        creditCardColBtsBlock.append(creditCardDeleteBtn);

        let creditCardEditBtn = createNewElement('button', 'btn btn-primary w-50 w-lg-75 w-xl-50', 'Edit Card');
        creditCardEditBtn.type = 'button';
        creditCardColBtsBlock.append(creditCardEditBtn);

        let designLine = createNewElement('hr', 'text-drab me-xl-4 my-4');
        creditCardCol.append(designLine);

    }

}



/* DELETE CREDIT CARDS ITEM */
function deleteCreditCardItem(event) {

    let  el = event.target.closest('.js-credit-card-item');
    el.remove();
}



/* CREATE CREDIT CARD MODAL ADD YOUR CARD */
let accountAddYourCardForm = document.getElementById('accountAddYourCardForm');

if (accountAddYourCardForm){
   let accountAddYourCardEl = accountAddYourCardForm.querySelector('#accountAddYourCardEl');

   let card = createSavedCard('4111 1111 1111 1111', 'mastercard', 'red', 'JOHN SMITH', '08/23');

   accountAddYourCardEl.append(card);
}


createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem();
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');
createCreditCardItem('4111 1111 1111 1111', 'visa', 'blue', 'JOHN SMITH', '08/23');


/* CREATE ORDER HISTORY ITEM */
let orderHistoryCount = 0;

let accordionOrdersHistory = document.getElementById('accordionOrdersHistory');

if (accordionOrdersHistory) {

    let accordionOrdersHistoryItemOne = createOrderHistoryItem();
    accordionOrdersHistory.append(accordionOrdersHistoryItemOne);

    let accordionOrdersHistoryItemTwo = createOrderHistoryItem();
    accordionOrdersHistory.append(accordionOrdersHistoryItemTwo);

}
/* FUNCTION  CREATE ORDER HISTORY ITEM */
function createOrderHistoryItem() {

    let orderNumb = '#0072ab12';
    let orderStatus = 'Finished';
    let orderTotal = '$350.00';

    let shipToContactData = 'John Smith, Company Name john.smith@gmail.com';
    let shipToAddress = 'Street Address 123, A123 Ottawa, Canada';

    let accountCreditTotal = '$100';
    let creditCardPaidTotal = '$150';

    let typeCreditCardPaid = 'Mastercard (**** **** **** 1234)';

    let itemsTotal = '$190.50';
    let turnaroundTotal = '$30.30';
    let shippingTotal = '$20.00';
    let taxTotal = '$5.00';
    let paidTotalSum = '$255.00';

    orderHistoryCount++;

    let accordionOrdersHistoryItem = createNewElement('div', 'accordion-item');

    /* ACCORDION HEADER */
    let accordionHeader = createNewElement('h2', 'accordion-header');
    accordionHeader.id = `accordionOrdersHistoryHeading-${orderHistoryCount}`;
    accordionOrdersHistoryItem.append(accordionHeader);

    /* ACCORDION HEADER BTN */
    let accordionHeaderBtn = createNewElement('button', 'accordion-button accordion-order-history-btn collapsed');
    accordionHeaderBtn.type = 'button';
    accordionHeaderBtn.dataset.bsToggle = 'collapse';
    accordionHeaderBtn.dataset.bsTarget = `#accordionOrdersHistoryCollapse-${orderHistoryCount}`;
    accordionHeaderBtn.setAttribute('aria-expanded', 'true');
    accordionHeaderBtn.setAttribute('aria-controls', `accordionOrdersHistoryCollapse-${orderHistoryCount}`);
    accordionHeader.append(accordionHeaderBtn);

    /* ACCORDION HEADER SUMMARY */
    let numbOrderHistory = createNewElement('span', '', `Order ${orderNumb}`);
    accordionHeaderBtn.append(numbOrderHistory);

    let statusOrderHistory = createNewElement('span', 'text-green px-2 px-md-4 px-lg-5', orderStatus);
    accordionHeaderBtn.append(statusOrderHistory);

    let totalOrderHistory = createNewElement('span', '', 'Total: ');
    let totalNumbOrderHistory = createNewElement('span', 'fw-bold', orderTotal);

    totalOrderHistory.append(totalNumbOrderHistory);
    accordionHeaderBtn.append(totalOrderHistory);


    /* ACCORDION COLLAPSE */
    let accordionCollapse = createNewElement('div', 'accordion-collapse collapse');
    accordionCollapse.id = `accordionOrdersHistoryCollapse-${orderHistoryCount}`;
    accordionCollapse.setAttribute('aria-labelledby', `accordionOrdersHistoryCollapse-${orderHistoryCount}`);
    accordionCollapse.dataset.bsParent = '#accordionOrdersHistory';
    accordionOrdersHistoryItem.append(accordionCollapse);
    
    /* ACCORDION BODY */
    let accordionBody = createNewElement('div', 'accordion-body');
    accordionCollapse.append(accordionBody);

    let rowOne = createNewElement('div', 'row px-4');
    accordionBody.append(rowOne);


    /* ORDER HISTORY DATA */
    for (let orderHistoryData = 0; orderHistoryData < 2; orderHistoryData++) {

        let orderHistoryDataCol = createNewElement('div', 'col-12 col-xl-6 mb-4');
        rowOne.append(orderHistoryDataCol);

        let orderHistoryDataTitle = createNewElement('h3', 'text-sm mb-3 fw-semibold', 'Ship To: ');

        if (orderHistoryData == 1){

            orderHistoryDataTitle.innerHTML = 'Bill To: ';

        }

        orderHistoryDataCol.append(orderHistoryDataTitle);

        let orderHistoryDataColRow = createNewElement('div', 'row row-cols-1 row-cols-sm-2');
        orderHistoryDataCol.append(orderHistoryDataColRow);

        let orderHistoryDataContactDataDiv = createNewElement('div');
        orderHistoryDataColRow.append(orderHistoryDataContactDataDiv);

        let orderHistoryDataEl = createNewElement('p', 'text-xs lh-sm pe-xxl-5', shipToContactData);
        orderHistoryDataContactDataDiv.append(orderHistoryDataEl);

        let orderHistoryDataAddressDiv = createNewElement('div');
        orderHistoryDataColRow.append(orderHistoryDataAddressDiv);

        let orderHistoryDataAddressEl = createNewElement('p', 'text-xs lh-sm', shipToAddress);
        orderHistoryDataAddressDiv.append(orderHistoryDataAddressEl);
    }
    

    /* ORDER HISTORY PAY DATA*/
    let rowTwo = createNewElement('div', 'row px-4');
    accordionBody.append(rowTwo);

    /* ORDER HISTORY PAY DATA CARD*/
    let orderHistoryPayDataCardCol = createNewElement('div', 'col-12 col-xl-6 mb-4');
    rowTwo.append(orderHistoryPayDataCardCol);

    let orderHistoryPayDataCardTitle = createNewElement('h3', 'text-sm mb-3 fw-semibold', 'Paid by:');
    orderHistoryPayDataCardCol.append(orderHistoryPayDataCardTitle);

    let orderHistoryAccountCreditCardDiv = createNewElement('div', '', 'Account Credit');
    orderHistoryPayDataCardCol.append(orderHistoryAccountCreditCardDiv);

    let orderHistoryAccountCreditCardTotal = createNewElement('span', 'me-2', accountCreditTotal);
    orderHistoryAccountCreditCardDiv.prepend(orderHistoryAccountCreditCardTotal);

    let orderHistoryCreditCardDiv = createNewElement('div', '', `Credit Card - ${typeCreditCardPaid}`);
    orderHistoryPayDataCardCol.append(orderHistoryCreditCardDiv);

    let orderHistoryCreditCardTotal = createNewElement('span', 'me-2', creditCardPaidTotal);
    orderHistoryCreditCardDiv.prepend(orderHistoryCreditCardTotal);


    /* ORDER HISTORY PAY TOTAL*/
    let orderHistoryPayTotalCol = createNewElement('div', 'col-12 col-xl-6 mb-4');
    rowTwo.append(orderHistoryPayTotalCol);

    let orderHistoryPayTotalTitle = createNewElement('h3', 'text-sm mb-3 fw-semibold', 'Paid by:');
    orderHistoryPayTotalCol.append(orderHistoryPayTotalTitle);

    orderHistoryPayTotalColDiv = createNewElement('div');
    orderHistoryPayTotalCol.append(orderHistoryPayTotalColDiv);

    for (let totalItem = 1; totalItem <= 4; totalItem++) {

        let totalItemDiv = createNewElement('div', 'd-flex justify-content-between');
        orderHistoryPayTotalColDiv.append(totalItemDiv);

        let totalItemTitle = createNewElement('span');
        totalItemDiv.append(totalItemTitle);

        let totalItemSum = createNewElement('span', 'fw-bold text-end');
        totalItemDiv.append(totalItemSum);


        if (totalItem == 1){

            totalItemTitle.innerText = 'Items Total';
            totalItemSum.innerText = itemsTotal;

        } else if (totalItem == 2){

            totalItemTitle.innerText = 'Turnaround Total';
            totalItemSum.innerText = turnaroundTotal;

        } else if (totalItem == 3){

            totalItemTitle.innerText = 'Shipping';
            totalItemSum.innerText = shippingTotal;

        } else if (totalItem == 4){

            totalItemTitle.innerText = 'Tax';
            totalItemSum.innerText = taxTotal;

        }

    }

    let designLine = createNewElement('hr', 'text-drab my-2');
    orderHistoryPayTotalCol.append(designLine);

    let orderSummaryPaidDiv = createNewElement('div', 'd-flex justify-content-between align-items-center');
    orderHistoryPayTotalCol.append(orderSummaryPaidDiv);

    let orderSummaryPaidTitle = createNewElement('h4', 'fw-bold text-xs mb-0', 'Grand Total');
    orderSummaryPaidDiv.append(orderSummaryPaidTitle);

    let orderSummaryPaidTotalSum = createNewElement('span', 'fw-bold text-xs text-primary', paidTotalSum);
    orderSummaryPaidDiv.append(orderSummaryPaidTotalSum);


    /* ITEMS ORDERED */

    let itemsOrderedTitle = createNewElement('h3', 'text-sm mb-3 fw-semibold text-center text-md-start px-4', 'Items Ordered:');
    accordionBody.append(itemsOrderedTitle);

    let yourCartsHistory = createNewElement('div', 'your-carts-history');
    accordionBody.append(yourCartsHistory);

    return accordionOrdersHistoryItem;
    
}



/* CREATE YOUR CART ITEM */
let  yourCartHistoryItemCount = 0;

let yourCartsHistory = document.querySelectorAll('.your-carts-history');
if (yourCartsHistory){

    yourCartsHistory.forEach((yourCart) => {

        let yourCartItemOne = createYourCartHistoryItem();
        yourCart.append(yourCartItemOne);

        let yourCartItemTwo = createYourCartHistoryItem();
        yourCart.append(yourCartItemTwo);

        let yourCartItemThree = createYourCartHistoryItem();
        yourCart.append(yourCartItemThree);
    })
}

function createYourCartHistoryItem(){

    yourCartHistoryItemCount++;

    let urlFrontImg = 'dist/images/img-cart/img-cart.png';
    let yourProductName = 'Standard Business Card';
    let expectedProduct = 'Standard Production (expected nov. 28, 2202 - dec. 1, 2022)';

    let yourCartItem = createNewElement('div');

    let yourCartContainer = createNewElement('div', 'your-cart-container your-cart-history-container p-4');
    yourCartItem.append(yourCartContainer);


    /* YOUR CART IMAGES  */
    let yourCartImageContainer = createNewElement('div', 'your-cart-image');
    yourCartContainer.append(yourCartImageContainer);


    /* YOUR CART IMAGES */
    let yourCartImageDiv = createNewElement('div');
    yourCartImageContainer.append(yourCartImageDiv);

    let yourCartImage = createNewElement('div', 'your-cart-images m-auto');
    yourCartImage.style.backgroundImage = `url('${urlFrontImg}')`;
    yourCartImageDiv.append(yourCartImage);

    let yourCartImageBtn = createNewElement('a', 'btn-link text-drab text-xs fw-normal text-center d-none mt-3 d-lg-block', 'Front/Back');
    yourCartImageBtn.href = '#';
    yourCartImageDiv.append(yourCartImageBtn);

    let yourCartImageBtnIcon = createNewElement('span', 'fi-rr-zoom-in me-1');
    yourCartImageBtn.prepend(yourCartImageBtnIcon);

    let yourCartImageBtnMobile = createNewElement('a', 'btn-link text-drab text-xs fw-normal text-center d-block mt-3 d-lg-none', 'Front / Back');
    yourCartImageBtnMobile.href = '#';
    yourCartImageDiv.append(yourCartImageBtnMobile);


    /* YOUR CART NAME */
    let yourCartNameContainer = createNewElement('div', 'your-cart-name d-lg-flex justify-content-between align-items-lg-center text-center text-sm-start my-3 my-sm-0');
    yourCartContainer.append(yourCartNameContainer);

    let yourCartProductName = createNewElement('div', 'fw-semibold mb-3 mb-lg-0', yourProductName);
    yourCartNameContainer.append(yourCartProductName);

    let quantityCartSelect = createNewElement('select', 'tom-select-quantity-cart');
    quantityCartSelect.id = `quantityCartSelect-${yourCartItemCount}`;

    [
        {quantity: 3, price: "$33.00"},
        {quantity: 12, price: "$65456.00"}
    ].forEach(item => {
        let option = document.createElement('option');
        option.dataset.price = item.price;
        option.innerText = item.quantity;
        quantityCartSelect.append(option);
    })

    yourCartNameContainer.append(quantityCartSelect);

    initTomSelectByEl(quantityCartSelect, tomSelectWithQuantityCartOptions);



    /* YOUR CART EXPECTED DESC */
    let yourCartExpectedDescContainer = createNewElement('div', 'your-cart-expected-desc my-3 my-sm-0 text-center text-sm-start');
    yourCartContainer.append(yourCartExpectedDescContainer);

    let yourCartExpectedDesc = createNewElement('span', 'expected-desc text-grey text-xs fw-semibold lh-sm', expectedProduct);
    yourCartExpectedDescContainer.append(yourCartExpectedDesc);
    


    /* YOUR CART DESC */
    let yourCartDesc = createNewElement('div', 'your-cart-desc text-center text-lg-start');
    yourCartContainer.append(yourCartDesc);

    let yourCartDescRow = createNewElement('div', 'row row-cols-2 row-cols-sm-3 row-cols-xl-4 gy-4 align-self-start');
    yourCartDesc.append(yourCartDescRow);

    for (let index = 1; index <= 8; index++) {

        let cartDescCol = createNewElement('span', 'text-xs');
        let cartDescProductType = createNewElement('span', 'fw-semibold');

        if (index == 1) {
            cartDescCol.innerText = 'Sided';
            cartDescProductType.innerText = 'Double';

        } else  if (index == 2) {
            cartDescCol.innerText = 'Finish';
            cartDescProductType.innerText = 'Matte';
        } else  if (index == 3) {
            cartDescCol.innerText = 'Card Stock';
            cartDescProductType.innerText = '14pt';
        } else  if (index == 4) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 5) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 6) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 7) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 8) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        }

        yourCartDescRow.append(cartDescCol);
        cartDescCol.append(cartDescProductType);

        
    }

    return yourCartItem;
}