let idCounter = 0;
let countRow = 0;
let getThisProfessionally = true;

let uploadDesignContainer = document.getElementById('uploadDesignContainer');
let uploadDesignAddNewPageBtn = document.getElementById('uploadDesignAddNewPageBtn');


createUploadDesignRow(getThisProfessionally);

/* CREATE UPLOAD DESUGN ROW FUNCTION */
function createUploadDesignRow(professionalDesign){

    let countColumn = 2;

    idCounter++;
    countRow++;

    let row = createNewElement('div', 'row justify-content-center my-6');
    if(uploadDesignContainer){
        uploadDesignContainer.append(row);
    }

    /*  COLUMNS */
    for (let col = 0; col < countColumn; col++) {

        let column = createNewElement('div', 'col-12 col-lg-6 col-xxl-5 py-4 py-lg-0');
        row.append(column);
        
        let title = createNewElement('p', 'text-center mb-4 fw-normal');
        column.append(title);
        
        if(col == 0){
            title.innerText = 'Front';
            
        } else if(col == 1){
            title.innerText = 'Back';
        }

        let uploadDesignCard = createNewElement('div', 'upload-your-design-card mb-4');
        column.append(uploadDesignCard);

        if(professionalDesign){
            
            uploadDesignCard.classList.add('drop-zone');
           
            createDropZone(uploadDesignCard);

            let columnButtons = createNewElement('div', 'text-center mt-4');
            column.append(columnButtons);

            let btnBrowseComputer = createNewElement('button', 'btn btn-primary me-sm-4 mb-2 mb-sm-0 upload-browse-computer-btn', 'Browse Computer');
            btnBrowseComputer.type = 'button';
            btnBrowseComputer.setAttribute('onclick', 'browseComputer(this)');
            columnButtons.append(btnBrowseComputer);

            if(col == 1){

                let btnRemove = createNewElement('button', 'btn btn-white-with-border px-40 mb-2 mb-sm-0 uploaded-file-remove-btn d-none', 'Remove');
                btnRemove.type = 'button';
                btnRemove.setAttribute('onclick', 'uploadedFileRemove(this)');
                columnButtons.append(btnRemove);
            }

        } else {


            let cardName = createNewElement('span', 'text-xl fw-bold d-block text-center lh-sm');
            uploadDesignCard.append(cardName);

            let projectDescTextarea = createNewElement('textarea', 'form-control text-xxs w-100');
            projectDescTextarea.setAttribute('placeholder', 'Describe Your Project');
            projectDescTextarea.setAttribute('rows', '6');

            if(col == 0){

                uploadDesignCard.classList.add('bg-dark-grey');
            
                let projectDescLabel = createNewElement('label', 'form-label');
                projectDescLabel.innerText = 'Front page project description';
                projectDescLabel.setAttribute('for', `project-front-desc-${idCounter}`);

                projectDescTextarea.id = `project-front-desc-${idCounter}`;
                projectDescTextarea.name = 'Project_Front_Description';

                cardName.innerHTML = 'CUSTOM<br>DESIGN';

                column.append(projectDescLabel);

            } else if (col == 1){

                uploadDesignCard.classList.add('bg-easy-blue');

                let formChekContainer = createNewElement('div', 'form-check d-flex align-items-center mb-3');
                column.append(formChekContainer);

                let inputCheckBox = createNewElement('input', 'form-check-input mb-1 me-3');
                inputCheckBox.type = 'checkbox';
                inputCheckBox.id = `custom-project-back-check-${idCounter}`;

                formChekContainer.append(inputCheckBox);
                inputCheckBox.addEventListener('change', onBackPageChekboxChange);

                let custProjectBackCheckLabel = createNewElement('label', 'form-label mb-0');
                custProjectBackCheckLabel.innerText = 'Back page project description';
                custProjectBackCheckLabel.setAttribute('for', `custom-project-back-check-${idCounter}`);

                formChekContainer.append(custProjectBackCheckLabel);

                projectDescTextarea.id = `project-back-desc-${idCounter}`;
                projectDescTextarea.name = 'Project_Back_Description';

                cardName.classList.add('text-dark-grey');
                cardName.innerText = 'BLANK';

            }

            column.append(projectDescTextarea);

            if (col == 1){

                projectDescTextarea.addEventListener('keyup', onProjectDescKeyup);
            }

        }
        
    }

    /* COUNT ROW */
    if (countRow >= 2){
        row.className = 'row justify-content-center bg-white-gradient border-light-purple interval-between-rows';

        let headerCountRow = createNewElement('div', 'col-12 col-xxl-10 d-flex justify-content-between align-content-center my-3');
        row.prepend(headerCountRow);

        let titleCountRow = createNewElement('span', 'page-number', `Page ${countRow}`);
        headerCountRow.append(titleCountRow);

        let removeRowBtn = createNewElement('button', 'btn btn-link text-red fw-normal text-md py-0 remove-upload-row-btn', 'Remove');
        removeRowBtn.type = 'button';
        removeRowBtn.setAttribute('onclick', 'removeUploadDesignRow(this)');
        headerCountRow.append(removeRowBtn);
    }

}

/* REMOVE ROW FUNCTION*/
function removeUploadDesignRow(btn) {
    let row = btn.parentElement.parentElement;
    row.remove();
    countRow--;

    let pageNumbers = document.querySelectorAll('.page-number');
    let count = 2;
    pageNumbers.forEach((pageNumb) =>{
        pageNumb.innerText = `Page ${count}`;
        count++;
    })
}

/* CREATE DROP ZONE */
function createDropZone(dropZoneEl) {

    let dropZonePrompt = createNewElement('div', 'drop-zone-prompt');

    let dropIcon = createNewElement('span', 'drop-zone-prompt-img');
    dropZonePrompt.append(dropIcon);

    let dropIconImg = document.createElement('img');
    dropIconImg.src = 'dist/images/icons/add-file.svg';
    dropIconImg.alt = 'Icon Add File';
    dropIcon.append(dropIconImg);

    let dropPromptTitle = createNewElement('p', 'text-center fw-normal text-sm', 'Drag & Drop<br> Your File To Upload');
    dropZonePrompt.append(dropPromptTitle);

    let inputFile = document.createElement('input');
    inputFile.type = 'file';
    inputFile.name = 'File';
    inputFile.className = 'drop-zone-input';
    dropZonePrompt.append(inputFile);
    inputFile.addEventListener('change', onBrowseComputerChange);

    dropZoneEl.append(dropZonePrompt);
    dropZoneEvents(inputFile);
}

/* ORDER PROCESS BTN BROWSE COMPUTER */
function browseComputer(btn){
	let dropZone = btn.parentElement.parentElement.querySelector('.drop-zone');
	dropZone.click();
}

/* UPLOADED FILE REMOVE */
function uploadedFileRemove(btn) {
    let dropZoneEl = btn.parentElement.parentElement.querySelector('.drop-zone')
    let dropZoneThumb = dropZoneEl.querySelector('.drop-zone-thumb');
    dropZoneThumb.remove();
    let dropZonePrompt =  dropZoneEl.querySelector('.drop-zone-prompt');
    dropZonePrompt.classList.remove('d-none');
    btn.classList.add('d-none');

    btn.parentElement.querySelector('.upload-browse-computer-btn').innerHTML = 'Browse Computer';
}

/* EVENT BTN ADD NEW PAGE */
if(uploadDesignAddNewPageBtn){
    uploadDesignAddNewPageBtn.addEventListener('click', function(){
        createUploadDesignRow(getThisProfessionally);
    });
}


/* EVENT DROP ZONE UPLOADED FILE */
function onBrowseComputerChange(e) {
    
    let dropZoneElement = e.target.closest('.drop-zone');
    let btnContainer =  dropZoneElement.nextSibling;

    btnContainer.querySelector('.upload-browse-computer-btn').innerHTML = 'Upload New Design';

    btnContainer.querySelector('.uploaded-file-remove-btn').classList.remove('d-none'); 
}

/* EVENT ON PRIJECT DESC KEYUP*/
function onProjectDescKeyup(event) {

    let inputCheckbox = event.target.parentElement.querySelector('.form-check-input');

    if(event.target.value){
        if (!inputCheckbox.checked) inputCheckbox.click();
    } else {
        if (inputCheckbox.checked) inputCheckbox.click();
    }
}

/* EVENT ON BACK PAGE CHECKBOX CHANGE */
function onBackPageChekboxChange(event) {

    let dropZoneCard = event.target.parentElement.parentElement.querySelector('.upload-your-design-card');

    if(event.target.checked){

        dropZoneCard.firstChild.innerHTML = 'CUSTOM<br>DESIGN';
        dropZoneCard.firstChild.classList.add('text-easy-blue');
        dropZoneCard.classList.remove('bg-easy-blue');
        dropZoneCard.classList.add('bg-dark-grey');

    } else{

        dropZoneCard.firstChild.innerHTML = 'BLANK';
        dropZoneCard.firstChild.classList.remove('text-easy-blue');
        dropZoneCard.classList.add('bg-easy-blue');
        dropZoneCard.classList.remove('bg-dark-grey');
    }
}

/* EVENT ON SAVE ADDRESS CHECKBOX CHANGE */
let shippingAddressesCardInputRadio = document.querySelectorAll('.shipping-addresses-card-input-radio');
let shippingSaveAddressInput = document.getElementById('shippingSaveAddressCheckboxForm');
let newAddressCheckboxInputCheckbox = document.getElementById('newAddressCheckbox');

if(shippingAddressesCardInputRadio){
    shippingAddressesCardInputRadio.forEach((input) =>{

        if (input.checked){
            onSaveAddressChekboxChange();
        }
        input.addEventListener('change', onSaveAddressChekboxChange);
    })
}

function onSaveAddressChekboxChange(){
    let shippingSaveAddresslabel = shippingSaveAddressInput.nextElementSibling;

    newAddressCheckboxInputCheckbox.checked = false;

    shippingSaveAddressInput.checked = true;
    shippingSaveAddressInput.className = 'form-check-input bg-drab border-drab';
    shippingSaveAddressInput.setAttribute('disabled', true);

    shippingSaveAddresslabel.classList.remove('text-primary');
    shippingSaveAddresslabel.classList.add('text-drab');
    shippingSaveAddresslabel.innerText = 'Saved Addres';
}

/* EVENT ON NOT SAVE ADDRESS CHECKBOX CHANGE */
let checkOrNotSaveAddress = document.querySelectorAll('.check-or-not-save-address');

if(checkOrNotSaveAddress){
    checkOrNotSaveAddress.forEach((input) =>{
        input.addEventListener('keyup', onNotSaveAddressChekboxChange);
    })
}
function onNotSaveAddressChekboxChange(){

    let shippingSaveAddresslabel = shippingSaveAddressInput.nextElementSibling;

    newAddressCheckboxInputCheckbox.checked = true;

    shippingAddressesCardInputRadio.forEach((input) =>{
        input.checked = false;
    })
    
    shippingSaveAddressInput.checked = false;
    shippingSaveAddressInput.className = 'form-check-input';
    shippingSaveAddressInput.disabled = false;

    shippingSaveAddresslabel.classList.remove('text-drab');
    shippingSaveAddresslabel.classList.add('text-primary');
    shippingSaveAddresslabel.innerText = 'Save this address for later';
}

/* EVENT ON NEW ADDRESS CHECKBOX  */
if (newAddressCheckboxInputCheckbox){
    
    newAddressCheckboxInputCheckbox.addEventListener('input', () =>{
        onNotSaveAddressChekboxChange();
    })
}




/* EVENT ON NOT SAVED CREDIT CARD RADIO CHANGE  */
function onPaySavedCreditCardRadioChange() {
    payWhihtCreditCardCheckbox.checked = false;
}


/* EVENT ON PAY NEW CREDIT CARD CHECKBOX CHANGE  */
let payWhihtCreditCardCheckbox = document.getElementById('payWhihtCreditCardCheckbox');

if (payWhihtCreditCardCheckbox){
    payWhihtCreditCardCheckbox.addEventListener('change', (event) => {
        let savedCreditCardsInput = savedCreditCards.querySelectorAll('input[type="radio"]');
        savedCreditCardsInput.forEach((input) =>{
            if(input.checked){
                input.checked = false;
            }
        })
    });
}



/* EVENT CLICK BTN SEND PAYMENT FORM*/
let btnSendPaymentForm = document.getElementById('btnSendPaymentForm');

if (btnSendPaymentForm){

    btnSendPaymentForm.addEventListener('click', (event) =>{

        let savedCreditCardsInput = savedCreditCards.querySelectorAll('input[type="radio"]');
        
        savedCreditCardsInput.forEach((input) =>{
            if(input.checked){
                let bsModalConfirmYourCard = new bootstrap.Modal(document.getElementById('modalConfirmYourCard'), {})
                bsModalConfirmYourCard.show();
            }
        })
    
        if(payWhihtCreditCardCheckbox.checked){
            paymentOptionsForm.dispatchEvent(new Event('submit'));
        }
    });
}


/* CREATE SAVED CREDIT CARDS */
function createSavedCard(cardNumberVisa = '4111 1111 1111 1111', cardType = 'mastercard', cardColor = 'orange', cardHolderName = 'JOHN SMITH', expDate = '08/23') {
    let lastFourNumb = cardNumberVisa.slice(-4);
    let maskedNumb = cardNumberVisa.slice(0,-4).replace(/\d/g,'*');

    let cardItem = createNewElement('div', 'saved-credit-card mb-4');

    if (cardColor == 'orange') {
        cardItem.classList.add('saved-credit-card-mastercard-orange');
    } else if (cardColor == 'blue') {
        cardItem.classList.add('saved-credit-card-mastercard-blue');
    } else if (cardColor == 'red') {
        cardItem.classList.add('saved-credit-card-mastercard-red');
    }

    let cardLogoDiv = createNewElement('div');
    cardItem.append(cardLogoDiv);

    let cardLogo = createNewElement('span', 'js-image-src saved-card-logo');

    if (cardType == 'mastercard') {
        cardLogo.style.backgroundImage = 'url("dist/images/order-process/saved-card-logo-mastercard.svg")';
    } else if (cardType == 'visa') {
        cardLogo.style.backgroundImage = 'url("dist/images/order-process/credit-card-icons/visa-card-icon.svg")';
    }

    cardLogoDiv.append(cardLogo);

    let numbCardDiv = createNewElement('div');
    cardItem.append(numbCardDiv);

    let numbCardTitle = createNewElement('span', 'text-xxs fw-semibold', 'Card number');
    numbCardDiv.append(numbCardTitle);

    let numbCard = createNewElement('p', 'saved-card-number fw-bold', maskedNumb);
    numbCardDiv.append(numbCard);
    
    let lastNumbCard = createNewElement('span', 'last-number-card', lastFourNumb);
    numbCard.append(lastNumbCard);


    let cardInfoContainer = createNewElement('div', 'd-flex justify-content-between');
    cardItem.append(cardInfoContainer);

    let cardInfoLeft = createNewElement('div');
    cardInfoContainer.append(cardInfoLeft);

    let cardInfoLeftTitle = createNewElement('span', 'text-xxs fw-semibold', 'CARDHOLDER NAME');
    cardInfoLeft.append(cardInfoLeftTitle);

    let userName = createNewElement('div', 'saved-card-name fw-bold', cardHolderName);
    cardInfoLeft.append(userName);

    let cardInfoRight = createNewElement('div');
    cardInfoContainer.append(cardInfoRight);

    let cardInfoRightTitle = createNewElement('span', 'text-xxs fw-semibold', 'EXP DATE');
    cardInfoRight.append(cardInfoRightTitle);

    let validThru = createNewElement('div', 'valid-thru fw-bold', expDate);
    cardInfoRight.append(validThru);

    return cardItem;
}



function createSavedCardContainer() {
    idCounter++;

    let cardContainer = createNewElement('div', 'saved-credit-card-item');

    let cardItem = createSavedCard();
    cardContainer.append(cardItem);

    /* CHECKBOX PAY WITH CREDIT CARD */

    let payCardCheckboxContainer = createNewElement('div', 'text-center text-md-start text-lg-center');
    cardContainer.append(payCardCheckboxContainer);

    let checkboxContainer = createNewElement('div', 'form-check form-check-inline my-4 mx-auto');
    payCardCheckboxContainer.append(checkboxContainer);

    let checkBoxInput = createNewElement('input', 'form-check-input form-check-input-circle form-check-input-circle-small mt-2');
    checkBoxInput.type = 'radio';
    checkBoxInput.name = 'Pay_Saved_Credit_Card';
    checkBoxInput.id = `savedCreditCardCheckbox-${idCounter}`;
    checkBoxInput.addEventListener('change', onPaySavedCreditCardRadioChange);
    checkboxContainer.append(checkBoxInput);

    let checkBoxLabel = createNewElement('label', 'form-check-label text-sm text-primary fw-semibold', 'Pay with this Credit card');
    checkBoxLabel.setAttribute('for', `savedCreditCardCheckbox-${idCounter}`);
    checkboxContainer.append(checkBoxLabel);

    let designLine = createNewElement('hr', 'text-drab mt-0 saved-credit-card-item-border');
    cardContainer.append(designLine);

    return cardContainer;
}



let savedCreditCards = document.getElementById('savedCreditCards');

if (savedCreditCards) {
    let card1 = createSavedCardContainer();
    savedCreditCards.append(card1);
    
    let card2 = createSavedCardContainer();
    savedCreditCards.append(card2);
}


/* MODAL CONFIRM YOUR CARD */
let modalConfirmYourCardEl = document.getElementById('modalConfirmYourCard');

if (modalConfirmYourCardEl) {
    modalConfirmYourCardEl.addEventListener('show.bs.modal', function (event) {
        let cardContainer = document.querySelector('#confirmYourCardForm .card-container');
        let selectedCard = createSavedCard();
        cardContainer.append(selectedCard);
      })
      
      modalConfirmYourCardEl.addEventListener('hidden.bs.modal', function (event) {
        let cardContainer = document.querySelector('#confirmYourCardForm .card-container');
        cardContainer.innerHTML = '';
      })
}


/* MODAL PROCESSING PAYMENT */
let resultPayment = true;

let processingPayContent = document.getElementById('processingPayContent');

let modalProcessingPayment = document.getElementById('modalProcessingPayment');

if (modalProcessingPayment) {
    modalProcessingPayment.addEventListener('show.bs.modal', function (event) {

        if (resultPayment){
            setInterval(resultPaymentSuccess, 2000);
        } else {
            setInterval(resultPaymentError, 2000);
        }
    
    })
}

function hideBsModalProcessingPayment() {
    let bsModalProcessingPayment = bootstrap.Modal.getInstance(modalProcessingPayment);
    bsModalProcessingPayment.hide();
 }

function resultPaymentSuccess() {
    let processingPaymentSuccess = document.getElementById('processingPaymentSuccess');
    processingPayContent.classList.add('d-none');
    processingPaymentSuccess.classList.remove('d-none');

    setInterval(hideBsModalProcessingPayment, 3000);

}

function resultPaymentError() {
    let processingPaymentError = document.getElementById('processingPaymentError');
    processingPayContent.classList.add('d-none');
    processingPaymentError.classList.remove('d-none');
}



/* CREATE YOUR CART ITEM */
let  yourCartItemCount = 0;

let yourCarts = document.querySelectorAll('.your-carts');
if (yourCarts){

    yourCarts.forEach((yourCart) => {

        let yourCartItemOne = createYourCartItem();
        yourCart.append(yourCartItemOne);

        let yourCartItemTwo = createYourCartItem();
        yourCart.append(yourCartItemTwo);
    })
}

function createYourCartItem(){
    yourCartItemCount++;

    let urlFrontImg = 'dist/images/img-cart/img-cart.png';
    let urlBackImg = 'dist/images/img-cart/img-cart.png';
    let yourProductName = 'Standard Business Card';
    let expectedProduct = 'Standard Production (expected nov. 28, 2202 - dec. 1, 2022)';

    let yourCartItem = createNewElement('div');

    let container = createNewElement('div', 'container');
    yourCartItem.append(container);

    let yourCartContainer = createNewElement('div', 'your-cart-container');
    container.append(yourCartContainer);


    /* YOUR CART IMAGES  */
    let yourCartImageContainer = createNewElement('div', 'your-cart-image');
    yourCartContainer.append(yourCartImageContainer);

    let yourCartImageContainerDiv = createNewElement('div', 'd-flex justify-content-center justify-content-sm-start');
    yourCartImageContainer.append(yourCartImageContainerDiv);


    /* YOUR CART IMAGES FRONT */
    let yourCartImageFrontDiv = createNewElement('div', 'me-xl-4');
    yourCartImageContainerDiv.append(yourCartImageFrontDiv);

    let yourCartImageFront = createNewElement('div', 'your-cart-images');
    yourCartImageFront.style.backgroundImage = `url('${urlFrontImg}')`;
    yourCartImageFrontDiv.append(yourCartImageFront);

    let yourCartImageFrontBtn = createNewElement('a', 'btn-link text-drab text-xs fw-normal text-center d-none mt-3 d-lg-block', 'Front');
    yourCartImageFrontBtn.href = '#';
    yourCartImageFrontDiv.append(yourCartImageFrontBtn);

    let yourCartImageFrontBtnIcon = createNewElement('span', 'fi-rr-zoom-in me-1');
    yourCartImageFrontBtn.prepend(yourCartImageFrontBtnIcon);

    let yourCartImageFrontBtnMobile = createNewElement('a', 'btn-link text-drab text-xs fw-normal text-center d-block mt-3 d-lg-none', 'Front / Back');
    yourCartImageFrontBtnMobile.href = '#';
    yourCartImageFrontDiv.append(yourCartImageFrontBtnMobile);


    /* YOUR CART IMAGES BACK */
    let yourCartImageBackDiv = createNewElement('div', 'd-none d-xl-block');
    yourCartImageContainerDiv.append(yourCartImageBackDiv);

    let yourCartImageBack = createNewElement('div', 'your-cart-images');
    yourCartImageBack.style.backgroundImage = `url('${urlBackImg}')`;
    yourCartImageBackDiv.append(yourCartImageBack);

    let yourCartImageBackBtn = createNewElement('a', 'btn-link text-drab text-xs fw-normal text-center d-none mt-3 d-lg-block', 'Back');
    yourCartImageBackBtn.href = '#';
    yourCartImageBackDiv.append(yourCartImageBackBtn);

    let yourCartImageBackBtnIcon = createNewElement('span', 'fi-rr-zoom-in me-1');
    yourCartImageBackBtn.prepend(yourCartImageBackBtnIcon);


    /* YOUR CART NAME */
    let yourCartNameContainer = createNewElement('div', 'your-cart-name d-lg-flex justify-content-between align-items-lg-center text-center text-sm-start my-3 my-sm-0');
    yourCartContainer.append(yourCartNameContainer);

    let yourCartProductName = createNewElement('div', 'fw-semibold mb-3 mb-lg-0', yourProductName);
    yourCartNameContainer.append(yourCartProductName);

    let quantityCartSelect = createNewElement('select', 'tom-select-quantity-cart');
    quantityCartSelect.id = `quantityCartSelect-${yourCartItemCount}`;

    [
        {quantity: 3, price: "$33.00"},
        {quantity: 12, price: "$65456.00"}
    ].forEach(item => {
        let option = document.createElement('option');
        option.dataset.price = item.price;
        option.innerText = item.quantity;
        quantityCartSelect.append(option);
    })

    yourCartNameContainer.append(quantityCartSelect);

    initTomSelectByEl(quantityCartSelect, tomSelectWithQuantityCartOptions);



    /* YOUR CART EXPECTED DESC */
    let yourCartExpectedDescContainer = createNewElement('div', 'your-cart-expected-desc my-3 my-sm-0 text-center text-sm-start');
    yourCartContainer.append(yourCartExpectedDescContainer);

    let yourCartExpectedDesc = createNewElement('span', 'expected-desc text-grey text-xs fw-semibold lh-sm', expectedProduct);
    yourCartExpectedDescContainer.append(yourCartExpectedDesc);
    


    /* YOUR CART DESC */
    let yourCartDesc = createNewElement('div', 'your-cart-desc text-center text-lg-start');
    yourCartContainer.append(yourCartDesc);

    let yourCartDescRow = createNewElement('div', 'row row-cols-2 row-cols-sm-3 gy-4 align-self-start');
    yourCartDesc.append(yourCartDescRow);

    for (let index = 1; index <= 6; index++) {

        let cartDescCol = createNewElement('span', 'text-xs');
        let cartDescProductType = createNewElement('span', 'fw-semibold');

        if (index == 1) {
            cartDescCol.innerText = 'Sided';
            cartDescProductType.innerText = 'Double';

        } else  if (index == 2) {
            cartDescCol.innerText = 'Finish';
            cartDescProductType.innerText = 'Matte';
        } else  if (index == 3) {
            cartDescCol.innerText = 'Card Stock';
            cartDescProductType.innerText = '14pt';
        } else  if (index == 4) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 5) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        } else  if (index == 6) {
            cartDescCol.innerText = 'Corners';
            cartDescProductType.innerText = 'Rounded';
        }

        yourCartDescRow.append(cartDescCol);
        cartDescCol.append(cartDescProductType);

        
    }



    /* YOUR CART ACTION */
    let yourCartActionContainer = createNewElement('div', 'your-cart-action text-center text-lg-start mt-3 mt-sm-0');
    yourCartContainer.append(yourCartActionContainer);

    let yourCartActionRow = createNewElement('div', 'row row-cols-3 gy-4 flex-lg-column');
    yourCartActionContainer.append(yourCartActionRow);
   
    /* BTN EDIT OPTIONS */
    let cartEditOptionsBtn = createNewElement('a', 'text-primary btn-link text-xs fw-normal w-lg-100', ' Options');
    cartEditOptionsBtn.href = '#';
    yourCartActionRow.append(cartEditOptionsBtn);

    let cartEditOptionsBtnMob = createNewElement('span', 'd-none d-sm-inline-block', 'Edit ');
    cartEditOptionsBtn.prepend(cartEditOptionsBtnMob);
    
    let cartEditOptionsBtnIcon = createNewElement('span', 'fi-rr-pencil me-1 pt-1 d-inline-block align-middle');
    cartEditOptionsBtn.prepend(cartEditOptionsBtnIcon);

    /* BTN EDIT IMAGES */
    let cartEditImagesBtn = createNewElement('a', 'text-primary btn-link text-xs fw-normal w-lg-100', ' Images');
    cartEditImagesBtn.href = '#';
    yourCartActionRow.append(cartEditImagesBtn);

    let cartEditImagesBtnMob = createNewElement('span', 'd-none d-sm-inline-block', 'Edit ');
    cartEditImagesBtn.prepend(cartEditImagesBtnMob);
    
    let cartEditImagesBtnIcon = createNewElement('span', 'fi-rr-mode-landscape me-1 pt-1 d-inline-block align-middle');
    cartEditImagesBtn.prepend(cartEditImagesBtnIcon);

     /* BTN REMOVE */
     let cartRemoveBtn = createNewElement('a', 'text-red btn-link text-xs fw-normal w-lg-100', ' Remove');
     cartRemoveBtn.href = '#';
     yourCartActionRow.append(cartRemoveBtn);
     
     let cartRemoveBtnIcon = createNewElement('span', 'fi-rr-trash me-1 pt-1 d-inline-block align-middle');
     cartRemoveBtn.prepend(cartRemoveBtnIcon);


    return yourCartItem;
}


/* ON CHECK COUPONE CODE */

let resultCouponIcon = document.getElementById('resultCouponIcon');

function onCheckCouponCode(btn){

    let inputValue = btn.previousElementSibling.value;
   
    if (inputValue == 'test'){
        resultCouponIcon.className = 'fi-rr-badge-check text-green text-sm';
        showSuccessInfoToast('Saved your coupon!');

    } else {
        resultCouponIcon.className = 'fi-rr-cross-circle text-red text-sm';
        showErrorInfoToast('Your coupon has not been saved!');
    }

}

let paymentCouponCodeFormInput = document.getElementById('paymentCouponCodeForm');

if (paymentCouponCodeFormInput){
    
    paymentCouponCodeFormInput.addEventListener('keyup', () => {

        resultCouponIcon.className = 'fi-rr-plus-small text-primary text-sm';

    })
}