 /*  tom-select options */
 let tomSelectDefaultOptions = {
	controlInput: null
}

let tomSelectCartOptions = {
	controlInput: null,
	render: {
		option: function(data, escape) {
			let selectedText = escape(data.text);
			let price = data.$option.dataset.price ?? "$0.00";

			let option = `<div class="d-flex align-items-center text-start pe-4">Quantity:<span class="fw-bold ms-1 me-5"> ${selectedText}</span> <span class="fw-bold text-green">${price}</span></div>`;
			return option;
		},
		item: function(data, escape) {
			let selectedText = escape(data.text);
			let price = data.$option.dataset.price ?? "$0.00";

			let option = `<div class="d-flex align-items-center text-start pe-4">Quantity:<span class="fw-bold ms-1 me-5"> ${selectedText}</span> <span class="fw-bold text-green">${price}</span></div>`;
			return option;
		}
	}
}

let tomSelectWithQuantityOptions = {
	controlInput: null,
	render: {
		item: function(data, escape) {
			let selectedText = escape(data.text);

			let option = `<div class="d-flex align-items-center text-start fw-normal text-white">Quantity:<span class="fw-bold ms-1 me-3"> ${selectedText}</span> <span class="me-4 text-drab">$5555.55</span></div>`;
			return option;
		}
	}
}

let tomSelectWithQuantityCartOptions = {
	controlInput: null,
	render: {
		option: function(data, escape) {
			let selectedText = escape(data.text);
			let price = data.$option.dataset.price ?? "$0.00";

			let option = `<div class="d-flex align-items-center justify-content-between fw-normal"><span>Quantity:<span class="fw-bold ms-1 me-3"> ${selectedText}</span></span> <span class="text-drab text-end">${price}</span></div>`;
			return option;
		},
		item: function(data, escape) {
			let selectedText = escape(data.text);
			let price = data.$option.dataset.price ?? "$0.00";

			let option = `<div class="d-flex align-items-center text-start fw-normal">Quantity:<span class="fw-bold ms-1 me-3"> ${selectedText}</span> <span class="me-4 text-drab">${price}</span></div>`;
			return option;
		}
	}
}

// tom-select country options
let tomSelectCountryOptions = {
	controlInput: null,
	render:{
		option: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center text-start px-0">';

			if(img){
				option = option + `<img class="me-2 icon-flag-country-select" src="${img}" alt="Icon Flag">`;
			}
			option = option + text;
			option = option + '</div>';
			return option;
		},
		item: function(data, escape) {
			let text = escape(data.text);
			let img = data.$option.dataset.icon;

			let option = '<div class="d-flex align-items-center text-start">';

			if(img){
				option = option + `<img class="me-2 icon-flag-country-select" src="${img}" alt="Icon Flag">`; 
			}
			option = option + text;
			option = option + '</div>';
			return option;
		}
	}
}

// init tom-select by class name
document.querySelectorAll('.tom-select').forEach((el)=>{
	new TomSelect(el, tomSelectDefaultOptions);
});  

document.querySelectorAll('.tom-select-cart').forEach((el)=>{
	new TomSelect(el, tomSelectCartOptions);
});

document.querySelectorAll('.tom-select-quantity').forEach((el)=>{
	new TomSelect(el, tomSelectWithQuantityOptions);
}); 

document.querySelectorAll('.tom-select-quantity-cart').forEach((el)=>{
	new TomSelect(el, tomSelectWithQuantityCartOptions);
}); 

document.querySelectorAll('.tom-select-country').forEach((el)=>{
	initTomSelectByEl(el, tomSelectCountryOptions);
});  




function createCountrySelect(elId, items) {
	let accountAddressBookCountry = document.getElementById(elId);

    if (accountAddressBookCountry) {
        items.forEach(el => {
            let option = document.createElement('option');
            option.dataset.icon = el.image;
            option.innerText = el.name;
            accountAddressBookCountry.append(option);
        })

        initTomSelectByEl(accountAddressBookCountry, tomSelectCountryOptions);
    }
}

function initTomSelectById(elId, tsOptions) {
    let element = document.getElementById(elId);

    if (element) {
        new TomSelect(element, tsOptions);
    }
}

function initTomSelectByEl(element, tsOptions) {
    if (element) {
        new TomSelect(element, tsOptions);
    }
}