/* STICKY MENU */
let navbar = document.getElementById('js-navbar');
if(navbar){
	let stickyOffset = navbar.offsetTop + navbar.offsetHeight;

	window.addEventListener('scroll', () => {
		if (window.pageYOffset >= stickyOffset) {
			navbar.classList.add('sticky');
		}  else  {
			navbar.classList.remove('sticky')
		}
	})
}


/* OFFCANVAS */
let offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
let offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* BTN MENU BURGER */
let btnBurger = document.getElementById('btnBurger');

if(btnBurger){
	btnBurger.addEventListener('click', function(event) {
		this.classList.toggle('active');
	});
}


document.addEventListener('click', function (event) {
	// if the clicked element isn't child of the navbar, you must close it if is open
	if (!event.target.closest('#mainMenu') && !event.target.closest('.form-search-input') && document.getElementById('mainMenu').classList.contains('show')) {
		document.getElementById('btnBurger').click();
	}

	if (!event.target.closest('#langHeader') && document.getElementById('langHeader').classList.contains('active')) {
		langHeaderSelected.classList.remove('active');
	}
});

/* MAIN CATEGORY  */
let checkContainerHeight = document.querySelectorAll('.js-check-container-height');

checkContainerHeight.forEach((elem) =>{
  let menuCategoryLink = elem.parentElement.querySelector('.main-category-card-list');

  if (elem.offsetHeight >= 600){
    menuCategoryLink.classList.add('main-category-card-big');
  }
})

/* LANGUAGE DROPDOWN*/
function show(el) {
	selectLangBtn.querySelector('img').src = el.querySelector('img').src;
	langHeaderSelected.classList.remove('active');

	selectLangBtnFooter.innerHTML = el.innerHTML;
	langFooterSelector.classList.remove('active');
}

/* LANG MENU HEADER */
let langHeaderSelected = document.getElementById('langHeader');
let selectLangBtn = langHeaderSelected.querySelector('.selected-lang');
if(selectLangBtn){
	selectLangBtn.onclick = function() {
		langHeaderSelected.classList.toggle('active');
	}
}


/* LANG MENU FOOTER */
let langFooterSelector = document.getElementById('langFooter');
let selectLangBtnFooter = langFooterSelector.querySelector('.selected-lang');

if(langFooterSelector){
	let selectedLangContent = langFooterSelector.querySelector('.selected-lang-content');
	
	selectedLangContent.onclick = function() {
		langFooterSelector.classList.toggle('active');
	}
}


/* MODAL GET A DESIGN QUOTE */
let modalGetADesignQuote = document.getElementById('modalGetADesignQuote');
let jsModalGetDesignDropZone = document.getElementById('jsModalGetDesignDropZone');
let jsModalGetDesignTextarea = document.getElementById('jsModalGetDesignTextarea');

var radios = modalGetADesignQuote.querySelectorAll('input[type=radio][name="Upload_Own_Design"]');

function changeHandler() {

   if ( this.value === 'true' ) {
	
	jsModalGetDesignTextarea.querySelector('textarea').value='';
	jsModalGetDesignTextarea.classList.add('d-none');
	jsModalGetDesignDropZone.classList.remove('d-none');

   } else if ( this.value === 'false' ) {
	jsModalGetDesignDropZone.classList.add('d-none');
	jsModalGetDesignTextarea.classList.remove('d-none');
     
   }  
}

Array.prototype.forEach.call(radios, function(radio) {
   radio.addEventListener('change', changeHandler);
});



/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	addDropZoneEvents(inputElement);
});

function addDropZoneEvents(inputElement) {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
}

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}	

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);		
	}

	let dropZoneElementName = dropZoneElement.querySelector('.drop-zone-thumb-name');

	if (!dropZoneElementName) {
		dropZoneElementName = document.createElement('div');
		dropZoneElementName.classList.add('drop-zone-thumb-name');
		dropZoneElementName.innerText = file.name;
		thumbnailElement.appendChild(dropZoneElementName);		

		let deleteThumbnailBtn = document.createElement('span');
		deleteThumbnailBtn.className = 'fi-rr-cross drop-zone-delete-thumbnail'
		dropZoneElementName.appendChild(deleteThumbnailBtn);

		deleteThumbnailBtn.addEventListener('click', (e) => {

			dropZoneElement.remove();
			e.stopImmediatePropagation();
		});
	}

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else if (file.name.split('.').pop() == 'pdf') {
		thumbnailElement.style.backgroundImage = 'url(dist/images/icons/type-file/PDF.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'docx' || file.name.split('.').pop() == 'doc') {
		thumbnailElement.style.backgroundImage = 'url(dist/images/icons/type-file/DOC.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'psd') {
		thumbnailElement.style.backgroundImage = 'url(dist/images/icons/type-file/PSD.svg)';
		thumbnailElement.classList.add('bg-not-cover');
	} 
	else {
		thumbnailElement.style.backgroundImage = null;
	}
	addDropZone();

}

function addDropZone() {
	let dropZoneContainer = document.getElementById('dropZone');
	
	let dropZone = document.createElement('div');
	dropZone.className = 'drop-zone mb-4';
	dropZoneContainer.append(dropZone);

	let dropZonePrompt = document.createElement('div');
	dropZonePrompt.className = 'drop-zone-prompt';
	dropZone.append(dropZonePrompt);

	let dropZonePromptIcon = document.createElement('img');
	dropZonePromptIcon.className = 'drop-zone-prompt-img';
	dropZonePromptIcon.src = 'dist/images/icons/add-file.svg';
	dropZonePromptIcon.alt = 'Icon Add File';
	dropZonePrompt.append(dropZonePromptIcon);


	let dropZonePromptTitle = document.createElement('span');
	dropZonePromptTitle.innerText = 'Drag & Drop Project Files';
	dropZonePrompt.append(dropZonePromptTitle);
	
	let dropZoneInput = document.createElement('input');
	dropZoneInput.type = 'file';
	dropZoneInput.className = 'drop-zone-input';
	dropZone.append(dropZoneInput);

	addDropZoneEvents(dropZoneInput);
}



/* CALCULATE SHIPPING & TURNAROUND */
let formPrintDetailsCalculate = document.getElementById('formPrintDetailsCalculate');

if (formPrintDetailsCalculate) {
	let btnShippingCalculate = document.getElementById('btnShippingCalculate');
	let inputCodeShipping = document.getElementById('inputCodeShipping');
	let labelCodeShipping = document.getElementById('labelCodeShipping');
	let btnCodeShippingChange = document.getElementById('codeShippingChange');
	
	let formPrintDetailsCalculateTS = new TomSelect(formPrintDetailsCalculate, {controlInput: null});
	
	
	btnShippingCalculate.addEventListener('click', (e) =>{
		e.preventDefault();
		
		labelCodeShipping.querySelector('span').innerText = 'Shipping to ' + inputCodeShipping.value;
		btnCodeShippingChange.classList.remove('d-none');
	
		inputCodeShipping.closest('div').classList.add('d-none');
		formPrintDetailsCalculateTS.wrapper.classList.remove('d-none');
	});
	
	btnCodeShippingChange.addEventListener('click', (e) =>{
		e.preventDefault();
	
		labelCodeShipping.querySelector('span').innerText = 'Shipping & Turnaround';
		inputCodeShipping.value = '';
		inputCodeShipping.closest('div').classList.remove('d-none');
		btnCodeShippingChange.classList.add('d-none');
		formPrintDetailsCalculateTS.wrapper.classList.add('d-none');
	});
	
	inputCodeShipping.addEventListener('keyup', (e) => {
		if (inputCodeShipping.value.length > 0){
			btnShippingCalculate.classList.remove('text-drab');
			btnShippingCalculate.classList.add('text-primary');
	
		} else {
			btnShippingCalculate.classList.add('text-drab');
			btnShippingCalculate.classList.remove('text-primary');
		}
	});
}

window.onload = () => {
	checkCookie();
};

/* COOKIE */
function setCookie(cname,cvalue,exdays) {
	const d = new Date();
	d.setTime(d.getTime() + (exdays*24*60*60*1000));
	let expires = 'expires=' + d.toUTCString();
	document.cookie = cname + '=' + cvalue + ';' + expires + ';path=/';
}
  
function getCookie(cname) {
	let name = cname + '=';
	let decodedCookie = decodeURIComponent(document.cookie);
	let ca = decodedCookie.split(';');
	for(let i = 0; i < ca.length; i++) {
	  let c = ca[i];
	  while (c.charAt(0) == ' ') {
		c = c.substring(1);
	  }
	  if (c.indexOf(name) == 0) {
		return c.substring(name.length, c.length);
	  }
	}
	return '';
}
  
function checkCookie() {
	let cookieDate = getCookie('cookie-date');
	let cookieBanner = document.getElementById('cookieBanner');

	if (cookieDate == '') {
		cookieBanner.classList.remove('d-none');
	} 
}
  
function applyCookie() {
	var date = new Date();
    var dateString = date.toGMTString();
	setCookie('cookie-date', dateString, 30);
	let cookieBanner = document.getElementById('cookieBanner');
	cookieBanner.classList.add('d-none');

}

/* IMAGES BACKROUND SRC */
let listImages = document.getElementsByClassName('js-image-src');

if(listImages){
	for (let i = 0; i < listImages.length; i++) {
		let src = listImages[i].getAttribute('data-image-src');
		listImages[i].style.backgroundImage="url('" + src + "')";
	}
}

  

/* CREAT NEW ELEMENT */
function createNewElement(tag, className='', text=''){
    let el = document.createElement(tag);
    el.className = className;
    el.innerHTML = text;
    return el;
}


/* CREATE OFFCANVAS CART */
let cartSelectOprions = [
	{
		'Slides' : 'Double'
	},
	{
		'Corners' : 'Rounded'
	},
	{
		'Option 3' : 'Option 3'
	},
	{
		'Option 4' : 'Option 4'
	},
	{
		'Option 5' : 'Option 5'
	},
	{
		'Option 6' : 'Option 6'
	}
]

let cartProductCount = 0;
let cartItems = document.getElementById('cartItems');

if (cartItems) {

	let cartItemOne = createProductCart();
	cartItems.append(cartItemOne);

	let cartItemTwo = createProductCart();
	cartItems.append(cartItemTwo);
}

function createProductCart(){

	cartProductCount++;

	let urlImg = 'dist/images/img-cart/img-cart.png';
	let productName = 'Standart Business Card';

	let cartItem = createNewElement('div', 'cart-item');

	/* CART HEADER */
	let cartItemHeader = createNewElement('div', 'cart-item-header mb-4');
	cartItem.append(cartItemHeader);
	
	/* CART HEADER PRODUCT IMAGE */
	let cartProductImg = createNewElement('div', 'cart-item-header-img me-4');
	cartProductImg.style.backgroundImage = `url('${urlImg}')`;
	cartItemHeader.append(cartProductImg);
	
	let cartItemHeaderDiv = createNewElement('div',);
	cartItemHeader.append(cartItemHeaderDiv);
	
	/* CART HEADER PRODUCT NAME */
	let cartProductName = createNewElement('span', 'text-xs fw-bold cart-item-header-name', productName);
	cartItemHeaderDiv.append(cartProductName);

	/* CART HEADER BTNS*/
	let cartItemHeaderBtns = createNewElement('div', 'cart-item-header-btns');
	cartItemHeaderDiv.append(cartItemHeaderBtns);

	/* BTN EDIT */
	let cartItemHeaderEditBtn = createNewElement('a', 'text-primary me-3', 'Edit');
	cartItemHeaderEditBtn.href = '';
	cartItemHeaderBtns.append(cartItemHeaderEditBtn);

	let cartItemHeaderEditIcon = createNewElement('span', 'fi-rr-pencil me-1');
	cartItemHeaderEditBtn.prepend(cartItemHeaderEditIcon);


	/* BTN REMOVE */
	let cartItemHeaderRemoveBtn = createNewElement('a', 'text-red', 'Remove');
	cartItemHeaderRemoveBtn.href = '';
	cartItemHeaderBtns.append(cartItemHeaderRemoveBtn);

	let cartItemHeaderRemoveIcon = createNewElement('span', 'fi-rr-trash me-1');
	cartItemHeaderRemoveBtn.prepend(cartItemHeaderRemoveIcon);


	/* ACCORDION */
	let cartSelectOptionAccordion = createNewElement('div', 'accordion accordion-cart-options mb-4');
	cartSelectOptionAccordion.id = 'accordionCartOptions';
	cartItem.append(cartSelectOptionAccordion);

	let accordionItem = createNewElement('div', 'accordion-item');
	cartSelectOptionAccordion.append(accordionItem);

	let accordionItemHeader = createNewElement('h2', 'accordion-header');
	accordionItemHeader.id = `cartProductHeading-${cartProductCount}`;
	accordionItem.append(accordionItemHeader);

	let accordionItemHeaderBtn = createNewElement('button', 'accordion-button collapsed', 'Selected Options');
	accordionItemHeaderBtn.type = 'button';
	accordionItemHeaderBtn.dataset.bsToggle = 'collapse';
	accordionItemHeaderBtn.dataset.bsTarget = `#collapseCartProduct-${cartProductCount}`;
	accordionItemHeaderBtn.setAttribute('aria-expanded', 'true');
	accordionItemHeaderBtn.setAttribute('aria-controls', `collapseCartProduct-${cartProductCount}`);
	accordionItemHeader.append(accordionItemHeaderBtn);


	/* ACCORDION BODY */
	let accordionCollapse = createNewElement('div', 'accordion-collapse collapse');
	accordionCollapse.id = `collapseCartProduct-${cartProductCount}`;
	accordionCollapse.setAttribute('aria-labelledby', `cartProductHeading-${cartProductCount}`);
	accordionCollapse.dataset.bsParent = 'accordionCartOptions';
	accordionItem.append(accordionCollapse);

	let accordionBody = createNewElement('div', 'accordion-body px-0');
	accordionCollapse.append(accordionBody);


	/* ACCORDION BODY TABLE*/
	let table = createNewElement('table', 'table');
	accordionBody.append(table);

	let tbody = createNewElement('tbody');
	table.append(tbody);


	cartSelectOprions.forEach((option) => {

		for (let [key, value] of Object.entries(option)) {

			let tr = createNewElement('tr');
			tbody.append(tr);

			let tdKey = createNewElement('td', '', key);
			tr.append(tdKey);

			let tdValue = createNewElement('td', 'fw-semibold', value);
			tr.append(tdValue);

		}
	})

	/* CART PRODUCT SELECT */
	let cartProductSelect = createNewElement('select', 'tom-select-cart mb-4');
	cartProductSelect.id = `quantityProductCart-${cartProductCount}`;
	cartItem.append(cartProductSelect);

	[
        {quantity: 200, price: "$11,100.00"},
        {quantity: 12, price: "$65456.00"}
		
    ].forEach(item => {
        let option = document.createElement('option');
        option.dataset.price = item.price;
        option.innerText = item.quantity;
        cartProductSelect.append(option);
    })

	initTomSelectByEl(cartProductSelect, tomSelectCartOptions);

	return cartItem;
}





/* INFORMATION TOAST CHANGE */
let informationToastEl = document.getElementById('informationToast');
let informationToast = new bootstrap.Toast(informationToastEl);

function showInfoToast(text) {
    let informationToastBody = informationToastEl.querySelector('.toast-body');
    informationToastBody.innerHTML = text;

	let infoToastContainer = informationToastEl.parentElement;
    infoToastContainer.classList.add('it-block-progress-active');

	informationToast.show();
}

function showSuccessInfoToast(text) {
	resetInfoToast();
	
	informationToastEl.classList.add('bg-primary');

	showInfoToast(text);
}

function showErrorInfoToast(text) {
	resetInfoToast();

	informationToastEl.classList.add('bg-red');

	showInfoToast(text);
}

function resetInfoToast() {
	informationToastEl.classList.remove('bg-primary', 'bg-red');

	let informationToastBody = informationToastEl.querySelector('.toast-body');
    informationToastBody.innerHTML = '';
}

if(window.location.hash) { 
	var tabId = window.location.hash;
	window.location.hash = '';

	var tabEl = document.querySelector(tabId);
	if (tabEl && tabEl.role == 'tab'){
		var tab = new bootstrap.Tab(tabEl);
		tab.show();
	}
}
