/* CREATE OFFCANVAS HELP CENTER PREVIOUS TICKET  */
let previousTicketItems = document.getElementById('previousTicketItem');

if (previousTicketItems){

	let cartTicketOne = createPreviousTicketCard('new', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicketOne);

	let cartTicketTwo = createPreviousTicketCard('open', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicketTwo);

	let cartTicketTree = createPreviousTicketCard('closed', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicketTree);

	let cartTicket4 = createPreviousTicketCard('sent', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicket4);

	let cartTicket5 = createPreviousTicketCard('open', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicket5);

	let cartTicket6 = createPreviousTicketCard('closed', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicket6);

	let cartTicket7 = createPreviousTicketCard('sent', '#pp152355b', '2022-11-18');
	previousTicketItems.append(cartTicket7);
	
	
}

function createPreviousTicketCard(tiketType, ticketNumb, ticketClosed){

	let previousTicketItem = createNewElement('a', 'previous-ticket-item btn-animation-arrow');
	previousTicketItem.href = '#';

	let previousTicketDiv = createNewElement('div', 'd-flex align-items-center');
	previousTicketItem.append(previousTicketDiv);

	let previousTicketTypeIcon = createNewElement('span', 'support-center-icon me-3');

	if(tiketType == 'new'){
		previousTicketTypeIcon.classList.add('new-message-icon');
	} else if(tiketType == 'open'){
		previousTicketTypeIcon.classList.add('open-message-icon', 'text-blue');
	} else if(tiketType == 'closed'){
		previousTicketTypeIcon.classList.add('closed-message-icon', 'text-drab');
	} else if(tiketType == 'sent'){
		previousTicketTypeIcon.classList.add('sent-message-icon', 'text-drab');
	}

	previousTicketDiv.append(previousTicketTypeIcon);

	let previousTicketDescDiv = createNewElement('div');
	previousTicketDiv.append(previousTicketDescDiv);

	let previousTicketNumb = createNewElement('span', 'text-xs d-block fw-semibold lh-1', `Ticket ${ticketNumb}`);
	previousTicketDescDiv.append(previousTicketNumb);

	let previousTicketClosed = createNewElement('span', 'text-xxs d-flex align-items-center', `Closed: ${ticketClosed}`);
	previousTicketDescDiv.append(previousTicketClosed);

	let arrowRightIcon = createNewElement('span', 'icon-arrow-right-3 text-drab btn-animation-arrow-right d-inline-block');
	previousTicketItem.append(arrowRightIcon);


	return previousTicketItem;
}



function showAllTickets(){
	let previousTicketItem = document.querySelectorAll('.previous-ticket-item');

	previousTicketItem.forEach((item) => {
		item.classList.add('d-flex');
	})
}

/* SUPPORT CHAT */
let supportChatBody = document.getElementById('supportChatBody');
let messageSupportChatTextarea = document.getElementById('yourMessageSupportChat');
let sendSupportMessageBtn = document.getElementById('sendSupportMessageBtn');


let messagesHistory = [
	{
		name: "David",
		text: "Hello! My name is David. Nice to meet you! How can I help you today? Please take your time to describe yo ur problem :)",
		avatar_url: "dist/images/teams/man.jpg",
		message_date: "10:32 AM, 16.07.2022",
		is_my_message: false
	},
	{
		name: "Oliver",
		text: "Hello! I can’t find product that I need to print :(( ",
		avatar_url: false,
		message_date: "at 10:35 AM, 16.07.2022",
		is_my_message: true
	}
];

let newMessagesArr = [];

let apiResult = {
	chat_id: 12332112312,
	chat_active: '2d ago',
	conversation_start: '10:31 AM, 16.07.2022',
	messages: messagesHistory
}

let chatId = '';
let lastMessageId = '';
let typingState = false;

let offcanvasHelpCenterChat = document.getElementById('offcanvasHelpCenterChat');
offcanvasHelpCenterChat.addEventListener('show.bs.offcanvas', function () {
	createHelpChat();
})


function createHelpChat() {

	supportChatBody.innerHTML = '';

	/*  add chat id */
	let supportChatId = document.getElementById('supportChatId');
	chatId = apiResult.chat_id;
	supportChatId.innerHTML = `Chat ID: ${chatId}`;

	/*  add chat active */
	let supportChatActive = document.getElementById('supportChatActive');
	supportChatActive.innerHTML = `Active ${apiResult.chat_active}`;

	/*  add start date */
	let startedTimeConversation = document.getElementById('startedTimeConversation');
	startedTimeConversation.innerHTML = apiResult.conversation_start;

	messagesHistory.forEach((message) => {

		if(messagesHistory[0] && message.is_my_message == false){
			let startedWithEmployee = createNewElement('span', 'text-drab text-xxs', `You are connected with ${message.name}`)
			supportChatBody.prepend(startedWithEmployee);
		}

		let messageEL = createMessage(message.name, message.text, message.avatar_url, message.message_date, message.is_my_message);
		supportChatBody.append(messageEL);
	})

	/*  run ActiveChatHeartbeat */
	runChatHeartbeat();
}


function runChatHeartbeat() {
	setInterval(checkChat, 1000);
}

function checkChat() {
	/* Check if content of textarea or uploads has changed */
	var textareaChanged = false; 

	if (messageSupportChatTextarea.value){
		textareaChanged = true;
	}

	sendChatState(chatId, lastMessageId, textareaChanged);
}

function sendChatState(chatId, lastMessageId, textareaChanged) {
	let apiResult = {
		new_messages: newMessagesArr,
		is_typing: textareaChanged
	};

	updateActiveChat(apiResult.new_messages, apiResult.is_typing);
}

function updateActiveChat(newMessages, isTyping) {
	processNewMessages(newMessages);

	typingIndicator(isTyping);
}

function typingIndicator(isTyping) {
	if (typingState == isTyping)
		return;

	typingState = isTyping;

	if(isTyping){
		
		let messageContainer = createNewElement('div', 'message message-my message-writing float-end text-end');
		messageContainer.id = 'typingMsg';

		let messageContent = createNewElement('span', 'dots message-content');
		messageContainer.append(messageContent);

		let countDots = 3;
		
		for (let dot = 0; dot < countDots; dot++) {
			let dotEl = createNewElement('span');
			messageContent.append(dotEl);
		}

		let messageDetails = createNewElement('div', 'message-details');
		messageContainer.append(messageDetails);

		

		let messageDetailsTyping = createNewElement('span', 'message-details-time');
		messageDetailsTyping.innerHTML = 'Oliver is typing...';
		messageDetails.append(messageDetailsTyping);

		let messageDetailsAvatar = createNewElement('div', 'message-details-icon bg-dark-red ms-2 d-flex justify-content-center align-items-center');
		messageDetails.append(messageDetailsAvatar);

		let messageDetailsAvatarLetter = createNewElement('span', 'text-white text-xxs d-block', 'O');
		messageDetailsAvatar.append(messageDetailsAvatarLetter);


		supportChatBody.append(messageContainer);

		messageContainer.scrollIntoView();


		
	} else {
		let messageTyping = document.getElementById('typingMsg');
		messageTyping.remove();
	}
}


let newMessageId = 0;

function updateMessages(name, text, avatarUrl, date, isMyMessage){

	let updateNewMessage = {};
	updateNewMessage.id = ++newMessageId;
	updateNewMessage.name = name;
	updateNewMessage.text = text;
	updateNewMessage.avatar_url = avatarUrl;
	updateNewMessage.message_date = date;
	updateNewMessage.is_my_message = isMyMessage;

	newMessagesArr.push(updateNewMessage);
}


function processNewMessages(newMessages){

	newMessages.forEach((message) => {

		let messageEL = createMessage(message.name, message.text, message.avatar_url, message.message_date, message.is_my_message);
		supportChatBody.append(messageEL);

		lastMessageId = message.id;

		messageEL.scrollIntoView();

	})
	
	// tymczasowo usuwamy wszystkie nowe
	newMessagesArr = [];
}



function createMessage(name, text, avatarUrl, date, isMyMessage){

    let message = createNewElement('div', 'message');

	if (isMyMessage){
		message.classList.add('message-my', 'float-end');

	} else { 
		message.classList.add('message-other', 'float-start');
	}
    
    let messageContent = createNewElement('span', 'message-content', text);
    message.append(messageContent);

    let messageDetails = createNewElement('div', 'message-details');
    message.append(messageDetails);

    let messageDetailsAvatar = createNewElement('div', 'message-details-icon');

	let messageDetailsTime = createNewElement('div', 'message-details-time', name + ' ' + date);

	if(avatarUrl){
		messageDetailsAvatar.style.backgroundImage = `url('${avatarUrl}')`;

		messageDetails.append(messageDetailsAvatar);

		messageDetails.append(messageDetailsTime);

	} else {
	   	let firstLetterName = name.charAt(0);

		let iconEye = createNewElement('span', 'fi-rr-eye text-drab text-xxs pt-1');
		messageDetails.append(iconEye);

	 	messageDetails.append(messageDetailsTime);

	   	messageDetailsAvatar.className = 'message-details-icon bg-dark-red ms-2 d-flex justify-content-center align-items-center';

		let messageDetailsAvatarLetter = createNewElement('span', 'text-white text-xxs d-block', firstLetterName);
		messageDetailsAvatar.append(messageDetailsAvatarLetter);

		messageDetails.append(messageDetailsAvatar);

	}

    return message;

}

/* SEND MESSAGE EVENT */
if (sendSupportMessageBtn){
    sendSupportMessageBtn.addEventListener('click', (event) =>{
        let date = new Date();
		let time = date.getHours() + ':' + date.getMinutes() + ' AM,' + date.getDay() + '.' + date.getMonth() + 1  + '.' + date.getFullYear();
        let yourMessageValue = messageSupportChatTextarea.value;

		if(yourMessageValue){
			updateMessages('Oliver', yourMessageValue, false, time, true);

		}

		messageSupportChatTextarea.value = '';

        
    })
}

if(messageSupportChatTextarea) {
	messageSupportChatTextarea.addEventListener("keypress", function(event) {

		const keyCode = event.which || event.keyCode;

		if (keyCode === 13) {

			if (keyCode === 13 && !event.shiftKey) {

		 		event.preventDefault();
				sendSupportMessageBtn.click();
		 		
		 	}
			
			/* if(keyCode === 13 || event.target.value.length > 20){
				messageSupportChatTextarea.addEventListener('input', handleResize);
			} */

		}

	  });
}



/* function handleResize() {
	this.style.height = '55px';

} */
/* ADD FILE */
let attachFileBtn = document.getElementById('attachFileBtn');

if(attachFileBtn){
	
}

