/* SETUP GUIDES */
let apiResultProduct = [
    {
        'text': '3.5" x 2"',
        'width': 3.5,
        'height': 2,
        'file_specifications': [
            {
                'bleeds': '0.0625"'
            },
            {
                'trimmed_size': '3.5" x 3.5"'
            },
            {
                'document_size': '2.125" x 2.125"'
            },
            {
                'safe_area': '3333"'
            }
        ],
        'templates': [
            {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf'
            },
            {
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai'
            },
            {
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
            }
        ]
    },
    {
        
        'text': '2" x 3.5"',
        'width': 2,
        'height': 3.5,
        'file_specifications': [
            {
                'bleeds': '0.0625"'
            },
            {
                'trimmed_size': '2" x 3.5"'
            },
            {
                'document_size': '2.125" x 2.125"'
            },
            {
                'safe_area': '0.125"'
            }
        ],
        'templates': [
            {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf'
            },
            {
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai'
            },
            {
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
            }
        ]
    },
    {
        'text': '2" x 2"',
        'width': 2,
        'height': 2,
        'file_specifications': [
            {
                'bleeds': '0.0625"'
            },
            {
                'trimmed_size': '2" x 2"'
            },
            {
                'document_size': '2.125" x 2.125"'
            },
            {
                'safe_area': '0.125"'
            }
        ],
        'templates': [
            {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf'
            },
            {
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai'
            },
            {
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
            }
        ]
    }

];

let setupGuidesProduct = document.getElementById('setupGuidesProduct');
let setupGuidesProducts = document.querySelectorAll('.setup-guides-product-col');
let maxDimension = 0;

apiResultProduct.forEach((product) => {

    let productCol = createSetupGuidesProductCol(product.text);

    let width = product.width;
    let height = product.height;

    maxDimension = Math.max(maxDimension, width, height);
    
    let productBox = productCol.querySelector('.product-box');

    productBox.style.width = `${(width / maxDimension) * 100}%`;
    productBox.style.height = `${(height / maxDimension) * 100}%`;

    setupGuidesProduct.append(productCol);

})

let printSupportChooseProductSelect =  document.getElementById('printSupportChooseProductSelect');


function createSetupGuidesProductCol(size){

    let productCol = createNewElement('div', 'setup-guides-product-col');

    let productContainer = createNewElement('div', 'product-container');
    productCol.append(productContainer);

    let productBox = createNewElement('div', 'product-box')
    productContainer.append(productBox);

    let productSize = createNewElement('div', 'product-size');
    productSize.innerHTML = size;
    productCol.append(productSize);

    return productCol;

}

createSelectOptions();

function createSelectOptions(){
	apiResultProduct.forEach(el => {
		let option = document.createElement('option');
		option.value = el.text;
		option.innerText = el.text;

            
        for (let index = 0; index < el.file_specifications.length; index++) {
         option.dataset.bleeds = el.file_specifications[index].bleeds;
         option.dataset.trimmedSize = el.file_specifications[index].trimmed_size;
         option.dataset.documentSize = el.file_specifications[index].document_size;
         option.dataset.safeArea = el.file_specifications[index].safe_area;
            
        }
     

		printSupportChooseProductSelect.append(option);
	})
    new TomSelect(printSupportChooseProductSelect, {});

}


/* let apiResult = [
    'Business Cards' => [
        [
            'text' => '3.5" x 2"',
            'width' => 3.5,
            'height' => 2,
            'file_specifications' => [
                'bleeds' => '0.0625"',
                'trimmed_size' => '3.5" x 3.5"',
                'document_size' => '2.125" x 2.125"',
                'safe_area' => '0.125"'
              
            ],
            'templates' => [
                'pdf' => 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf',
                'ai' => 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai',
                'psd' => 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
            ]
        ],
        [
            'text' => '2" x 3.5"',
            'width' => 2,
            'height' => 3.5,
            'file_specifications' => [
                'bleeds' => '0.0625"',
                'trimmed_size' => '2" x 3.5"',
                'document_size' => '2.125" x 2.125"',
                'safe_area' => '0.125"'
              
            ],
            'templates' => [
                'pdf' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf',
                'ai' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai',
                'psd' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
            ]
        ],
        [
            'text' => '2" x 2"',
            'width' => 2,
            'height' => 2,
            'file_specifications' => [
                'bleeds' => '0.0625"',
                'trimmed_size' => '2" x 2"',
                'document_size' => '2.125" x 2.125"',
                'safe_area' => '0.125"'
              
            ],
            'templates' => [
                'pdf' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf',
                'ai' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai',
                'psd' => 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
            ]
        ]
    ]
] */

