/* SETUP GUIDES */

let apiResultProduct = {
    'Business_Cards': [
        {
            'text': '3.5" x 2"',
            'width': 3.5,
            'height': 2,
            'file_specifications': {
                'bleeds': '0.0625"',
                'trimmed_size': '3.5" x 3.5"',
                'document_size': '2.125" x 2.125"',
                'safe_area': '0.125"'
              
            },
            'templates': {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf',
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai',
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
            }
        },
        {
            'text': '2" x 3.5"',
            'width': 2,
            'height': 3.5,
            'file_specifications': {
                'bleeds': '0.0625"',
                'trimmed_size': '2" x 3.5"',
                'document_size': '2.125" x 2.125"',
                'safe_area': '0.125"'
              
            },
            'templates': {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf',
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai',
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
            }
        },
        {
            'text': '2" x 2"',
            'width': 2,
            'height': 2,
            'file_specifications': {
                'bleeds': '0.0625"',
                'trimmed_size': '2" x 2"',
                'document_size': '2.125" x 2.125"',
                'safe_area': '0.125"'
              
            },
            'templates': {
                'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf',
                'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai',
                'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
            }
        }
    ]
};

let setupGuidesProduct = document.getElementById('setupGuidesProduct');
let maxDimension = 0;

let printSupportChooseProductSelect =  document.getElementById('printSupportChooseProductSelect');

/* PRODUCT SPECIFICATIONS */
let specificationsFinalSize = document.getElementById('specificationsFinalSize');
let specificationsBleeds = document.getElementById('specificationsBleeds');
let specificationsSafeArea = document.getElementById('specificationsSafeArea');
let specificationsDocumentSize = document.getElementById('specificationsDocumentSize');

/* PRODUCT DOWNLOAD TEMPLATE LINKS */
let downloadProductPdfLink = document.getElementById('downloadProductPdfLink');
let downloadProductPsdLink = document.getElementById('downloadProductPsdLink');
let downloadProductAiLink = document.getElementById('downloadProductAiLink');

let productsData;

createSetupGuides(apiResultProduct);


printSupportChooseProductSelect.addEventListener('change', function () {

    selectActiveOptionData(this.value);
	
})

function selectActiveOptionData(selectedText) {

    for(let i in productsData.Business_Cards){
		if(selectedText == productsData.Business_Cards[i].text){

        let setupGuidesProducts = document.querySelectorAll('.setup-guides-product-col');

            setupGuidesProducts.forEach((col) => {

                col.classList.remove('active');

                if(selectedText == col.querySelector('.product-size').innerHTML){

                    col.classList.add('active');
                    
                }
            })

            specificationsFinalSize.innerHTML = productsData.Business_Cards[i].file_specifications.trimmed_size;

            specificationsBleeds.innerHTML = productsData.Business_Cards[i].file_specifications.bleeds;

            specificationsSafeArea.innerHTML = productsData.Business_Cards[i].file_specifications.safe_area;

            specificationsDocumentSize.innerHTML = productsData.Business_Cards[i].file_specifications.document_size;

			downloadProductPdfLink.href = productsData.Business_Cards[i].templates.pdf;

			downloadProductPsdLink.href = productsData.Business_Cards[i].templates.psd;

			downloadProductAiLink.href = productsData.Business_Cards[i].templates.ai;

		}
	}
}

function createSetupGuides(apiProducts) {
    productsData = apiProducts;

    productsData.Business_Cards.forEach((product) => {

        let option = createSetupGuidesProductOption(product.text);
        printSupportChooseProductSelect.append(option);
    
        let productCol = createSetupGuidesProductCol(product.text);
    
        let width = product.width;
        let height = product.height;
    
        maxDimension = Math.max(maxDimension, width, height);
        
        let productBox = productCol.querySelector('.product-box');
    
        productBox.style.width = `${(width / maxDimension) * 100}%`;
        productBox.style.height = `${(height / maxDimension) * 100}%`;
    
        setupGuidesProduct.append(productCol);
    
    })
    
    new TomSelect(printSupportChooseProductSelect, {});

    selectActiveOptionData(productsData.Business_Cards[0].text);

}

function createSetupGuidesProductCol(size){

    let productCol = createNewElement('div', 'setup-guides-product-col');

    let productContainer = createNewElement('div', 'product-container');
    productCol.append(productContainer);

    let productBox = createNewElement('div', 'product-box')
    productContainer.append(productBox);

    let productSize = createNewElement('div', 'product-size');
    productSize.innerHTML = size;
    productCol.append(productSize);

    return productCol;

}

function createSetupGuidesProductOption(text) {
    let option = document.createElement('option');
	option.value = text;
	option.innerText = text;

    return option;
}