/* SETUP GUIDES */

let apiResultProduct = {
    'result': [
        {
            'name': 'Business Cards',
            'items': [
                {
                    'text': '3.5" x 2"',
                    'width': 3.5,
                    'height': 2,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '3.5" x 3.5"',
                        'document_size': '2.125" x 2.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
                    }
                },
                {
                    'text': '2" x 3.5"',
                    'width': 2,
                    'height': 3.5,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '2" x 3.5"',
                        'document_size': '2.125" x 2.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
                    }
                },
                {
                    'text': '2" x 2"',
                    'width': 2,
                    'height': 2,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '2" x 2"',
                        'document_size': '2.125" x 2.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
                    }
                }
            ]
        },
        {
                'name': 'Flyers',
                'items': [
                {
                    'text': '3" x 2"',
                    'width': 3,
                    'height': 2,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '3" x 2"',
                        'document_size': '2.125" x 2.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
                    }
                },
                {
                    'text': '2" x 3"',
                    'width': 2,
                    'height': 3,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '2" x 3"',
                        'document_size': '32.125" x 2.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
                    }
                },
                {
                    'text': '2.5" x 2.5"',
                    'width': 2.5,
                    'height': 2.5,
                    'border_radius': 0,
                    'file_specifications': {
                        'bleeds': '0.0625"',
                        'trimmed_size': '2.5" x 2.5"',
                        'document_size': '3.125" x 3.125"',
                        'safe_area': '0.125"'
                    
                    },
                    'templates': {
                        'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf',
                        'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai',
                        'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
                    }
                }
            ]
        },
        {
            'name': 'Banner',
            'items': [
            {
                'text': '5" x 10"',
                'width': 5,
                'height': 10,
                'border_radius': 0,
                'file_specifications': {
                    'bleeds': '0.0625"',
                    'trimmed_size': '5" x 10"',
                    'document_size': '2.125" x 2.125"',
                    'safe_area': '0.125"'
                
                },
                'templates': {
                    'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.pdf',
                    'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.ai',
                    'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-3.5x3.5.psd'
                }
            },
            {
                'text': '7" x 9"',
                'width': 7,
                'height': 9,
                'border_radius': 4,
                'file_specifications': {
                    'bleeds': '1"',
                    'trimmed_size': '7" x 9"',
                    'document_size': '32.125" x 2.125"',
                    'safe_area': '0.125"'
                
                },
                'templates': {
                    'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.pdf',
                    'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.ai',
                    'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x3.5.psd'
                }
            },
            {
                'text': '7" x 7"',
                'width': 7,
                'height': 7,
                'border_radius': 100,
                'file_specifications': {
                    'bleeds': '2"',
                    'trimmed_size': '7" x 7"',
                    'document_size': '3.125" x 3.125"',
                    'safe_area': '0.125"'
                
                },
                'templates': {
                    'pdf': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.pdf',
                    'ai': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.ai',
                    'psd': 'https://cnd.printpenguin.ca/file_templates/business-card-2x2.psd'
                }
            }
        ]
        }
    ]
};

let setupGuidesProduct = document.getElementById('setupGuidesProduct');
let maxDimension = 0;

let printSupportChooseProductSelect =  document.getElementById('printSupportChooseProductSelect');

/* PRODUCT SPECIFICATIONS */
let specificationsFinalSize = document.getElementById('specificationsFinalSize');
let specificationsBleeds = document.getElementById('specificationsBleeds');
let specificationsSafeArea = document.getElementById('specificationsSafeArea');
let specificationsDocumentSize = document.getElementById('specificationsDocumentSize');

/* PRODUCT DOWNLOAD TEMPLATE LINKS */
let downloadProductPdfLink = document.getElementById('downloadProductPdfLink');
let downloadProductPsdLink = document.getElementById('downloadProductPsdLink');
let downloadProductAiLink = document.getElementById('downloadProductAiLink');

let productsData;

createSetupGuides(apiResultProduct);


printSupportChooseProductSelect.addEventListener('change', function () {

    setupGuidesProduct.innerHTML = '';
    selectActiveOptionData(this.value);
	
})

function selectActiveOptionData(selectedName) {

    for(let i in productsData.result){
		if(selectedName == productsData.result[i].name){

            createSetupGuidesProductCols(productsData.result[i]);
            selectActiveColumnData(productsData.result[i].items[0]);
		}
	}
}

function onProductBoxClick(col){

    let nameColActive = col.target.parentElement.nextSibling.innerHTML;

    let selectedProduct = printSupportChooseProductSelect.value;
    

    for(let i in productsData.result){

		if(selectedProduct == productsData.result[i].name){

            productsData.result[i].items.forEach((item) => {

                if(item.text == nameColActive){

                selectActiveColumnData(item);

                }
            })
		}
	}
  
}

function selectActiveColumnData(activeItem){
    
let setupGuidesProducts = document.querySelectorAll('.setup-guides-product-col');


    setupGuidesProducts.forEach((col) => {

        col.classList.remove('active');

        if(activeItem.text == col.querySelector('.product-size').innerHTML){

            col.classList.add('active');
            
        }

        col.addEventListener('click', onProductBoxClick);
    })

    specificationsFinalSize.innerHTML = activeItem.file_specifications.trimmed_size;

    specificationsBleeds.innerHTML = activeItem.file_specifications.bleeds;

    specificationsSafeArea.innerHTML = activeItem.file_specifications.safe_area;

    specificationsDocumentSize.innerHTML = activeItem.file_specifications.document_size;

	downloadProductPdfLink.href = activeItem.templates.pdf;

	downloadProductPsdLink.href = activeItem.templates.psd;

	downloadProductAiLink.href = activeItem.templates.ai;
}

function createSetupGuides(apiProducts) {

    productsData = apiProducts;

    productsData.result.forEach((product) => {
        let option = createSetupGuidesProductOption(product.name);
        printSupportChooseProductSelect.append(option);   
    })
    
    new TomSelect(printSupportChooseProductSelect, {});

    selectActiveOptionData(productsData.result[0].name);

}

function createSetupGuidesProductCols(product){

    maxDimension = 0;

    product.items.forEach((item) => {
        let productCol = createSetupGuidesProductCol(item.text, item.border_radius);

        let width = item.width;
        let height = item.height;

        
    
        maxDimension = Math.max(maxDimension, width, height);
        
        let productBox = productCol.querySelector('.product-box');
    
        productBox.style.width = `${(width / maxDimension) * 100}%`;
        productBox.style.height = `${(height / maxDimension) * 100}%`;
    
        setupGuidesProduct.append(productCol);
    });
}

function createSetupGuidesProductCol(size, borderRadius){

    let productCol = createNewElement('div', 'setup-guides-product-col');

    let productContainer = createNewElement('div', 'product-container');
    productCol.append(productContainer);

    let productBox = createNewElement('div', 'product-box');

    if (borderRadius > 0){
        productBox.style.borderRadius = `${borderRadius}%`;
    }

    productContainer.append(productBox);

    let productSize = createNewElement('div', 'product-size');
    productSize.innerHTML = size;
    productCol.append(productSize);

    return productCol;

}

function createSetupGuidesProductOption(text) {
    let option = document.createElement('option');
	option.value = text;
	option.innerText = text;

    return option;
}