
// 						SWIPER
// ========================================================
// ========================================================

const swiperContent = document.querySelector(".swiper");
if (swiperContent) {
	var swiper = new Swiper(".mySwiper", {
		slidesPerView: 1.33,
		spaceBetween: 24,
		grabCursor: true,
		breakpoints: {
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 24,
			},
			1200: {
				slidesPerView: 2.5,
				spaceBetween: 24,
			},
		},
		
	});
}

// 						BUTTON MORE
// ========================================================
// ========================================================

const loadMoreButton = document.getElementById('loadMore');

if (loadMoreButton) {

	const searchCard = document.getElementById('searchCard');
	const counterItems = document.getElementById('counterItem');
	const hiddenImage = [...searchCard.querySelectorAll('.hidden')];
	const itemCard = hiddenImage.length - 4;

	if(window.innerWidth > 1399) {
		hiddenImage.splice(0, 4).forEach(
			elem => elem.classList.remove('hidden'),
			counterItems.innerHTML = hiddenImage.length,
			//console.log(hiddenImage.length)
		);

		loadMoreButton.addEventListener('click', function(e) {
			e.preventDefault();
			
			hiddenImage.splice(0, 4).forEach(
				elem => elem.classList.remove('hidden'),
				counterItems.innerHTML = hiddenImage.length,
			)
		});
	} else {
		hiddenImage.splice(0, 3).forEach(
			elem => elem.classList.remove('hidden'),
			counterItems.innerHTML = hiddenImage.length,
			//console.log(hiddenImage.length)
		);

		loadMoreButton.addEventListener('click', function(e) {
			e.preventDefault();
			
			hiddenImage.splice(0, 3).forEach(
				elem => elem.classList.remove('hidden'),
				counterItems.innerHTML = hiddenImage.length,
			)
		});
	}

	
}

// 						COUNTDOWN TIMER
// ========================================================
// ========================================================	


const countdownTimer = document.getElementById('countdownTimer');

if (countdownTimer) {	

	const counterdown = setInterval(function() {

		const today = new Date()
		const tomorrow = new Date(today)
		tomorrow.setDate(tomorrow.getDate() + 1);

		const endOffer = tomorrow.setHours(0,0,0,0) - today;

		const hours = Math.floor((endOffer % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		const minutes = Math.floor((endOffer % (1000 * 60 * 60)) / (1000 * 60));
		const seconds = Math.floor((endOffer % (1000 * 60)) / 1000);

		document.getElementById("countdownTimer-hours").innerHTML = hours;
		document.getElementById("countdownTimer-minutes").innerHTML = minutes;
		document.getElementById("countdownTimer-seconds").innerHTML = seconds;
		
		if (endOffer < 0) {
			clearInterval(counterdown);
			document.getElementById("countdownTimer-wrapper").innerHTML = "EXPIRED";
		}
	}, 1000);
}

// 						FAVORITE ITEMS
// ========================================================
// ========================================================	

