
// 						SWIPER
// ========================================================
// ========================================================

const swiperContent = document.querySelector(".swiper");
if (swiperContent) {
	var swiper = new Swiper(".mySwiper", {
		slidesPerView: 1.33,
		spaceBetween: 24,
		grabCursor: true,
		breakpoints: {
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 24,
			},
			1200: {
				slidesPerView: 2.5,
				spaceBetween: 24,
			},
		},
		
	});
	var swiper = new Swiper(".dropdownSwiper", {
		slidesPerView: 1.5,			
		breakpoints: {	
			768: {
				slidesPerView: 2,
			},
			992: {
				slidesPerView: 3
			},
		},
	});
}

// 						BUTTON MORE
// ========================================================
// ========================================================

// const loadMoreButton = document.getElementById('loadMore');

// if (loadMoreButton) {

// 	const searchCard = document.getElementById('searchCard');
// 	const counterItems = document.getElementById('counterItem');
// 	const hiddenImage = [...searchCard.querySelectorAll('.hidden')];
// 	const itemCard = hiddenImage.length - 4;

// 	if(window.innerWidth > 1399) {
// 		hiddenImage.splice(0, 4).forEach(
// 			elem => elem.classList.remove('hidden'),
// 			counterItems.innerHTML = hiddenImage.length,
// 			//console.log(hiddenImage.length)
// 		);

// 		loadMoreButton.addEventListener('click', function(e) {
// 			e.preventDefault();
			
// 			hiddenImage.splice(0, 4).forEach(
// 				elem => elem.classList.remove('hidden'),
// 				counterItems.innerHTML = hiddenImage.length,
// 			)
// 		});
// 	} else {
// 		hiddenImage.splice(0, 3).forEach(
// 			elem => elem.classList.remove('hidden'),
// 			counterItems.innerHTML = hiddenImage.length,
// 			//console.log(hiddenImage.length)
// 		);

// 		loadMoreButton.addEventListener('click', function(e) {
// 			e.preventDefault();
			
// 			hiddenImage.splice(0, 3).forEach(
// 				elem => elem.classList.remove('hidden'),
// 				counterItems.innerHTML = hiddenImage.length,
// 			)
// 		});
// 	}

	
// }

// 						COUNTDOWN TIMER
// ========================================================
// ========================================================	


const countdownTimer = document.getElementById('countdownTimer');

if (countdownTimer) {	

	const counterdown = setInterval(function() {

		const today = new Date()
		const tomorrow = new Date(today)
		tomorrow.setDate(tomorrow.getDate() + 1);

		const endOffer = tomorrow.setHours(0,0,0,0) - today;

		const hours = Math.floor((endOffer % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		const minutes = Math.floor((endOffer % (1000 * 60 * 60)) / (1000 * 60));
		const seconds = Math.floor((endOffer % (1000 * 60)) / 1000);

		document.getElementById("countdownTimer-hours").innerHTML = hours;
		document.getElementById("countdownTimer-minutes").innerHTML = minutes;
		document.getElementById("countdownTimer-seconds").innerHTML = seconds;
		
		if (endOffer < 0) {
			clearInterval(counterdown);
			document.getElementById("countdownTimer-wrapper").innerHTML = "EXPIRED";
		}
	}, 1000);
}

// 							M
// ========================================================
// ========================================================

const buttonActive = document.querySelector('.buttonActive');

buttonActive.addEventListener('click', (event) => {
	if (!event.target.classList.contains('bi-check2-circle')) {
		event.target.parentNode.parentNode.classList.add('active');
		event.target.classList.add('bi-check2-circle', 'text-primary');		
		event.target.classList.remove('bi-circle', 'text-gray');
	} else {
		event.target.parentNode.parentNode.classList.remove('active');
		event.target.classList.add('bi-circle', 'text-gray');
		event.target.classList.remove('bi-check2-circle', 'text-primary');
		// alert('active');
	} 
  console.log('user clicked: ', event.target.parentNode.parentNode);

});

// 							CART 
// ========================================================
// ========================================================

const productItems = document.querySelectorAll('.productItem');

const howManyProducts = productItems.length;
if(howManyProducts > 1) {
	document.getElementById('howManyProducts').innerHTML = productItems.length + ' items';
} else {
	document.getElementById('howManyProducts').innerHTML = productItems.length + ' item';
}

productItems.forEach((productItem) => {
	
	var unitPrice = productItem.querySelector('.unitPrice').innerHTML;
	var productNumber = productItem.querySelector('.productNumber').innerHTML;
	var totalCost = productItem.querySelector('.totalCost').innerHTML = productNumber * unitPrice;

	productItem.querySelector('.counterCardUp').addEventListener("click", () => {
		const counter = productItem.querySelector('.productNumber').innerHTML++;
		productItem.querySelector('.totalCost').innerHTML = (counter+1) * unitPrice;
	});

	productItem.querySelector('.counterCardDown').addEventListener("click", () => {
		const counter = productItem.querySelector('.productNumber').innerHTML--;
		productItem.querySelector('.totalCost').innerHTML = (counter-1) * unitPrice;
	});

	
});



// 							SEARCH 
// ========================================================
// ========================================================


//on click add height

if(window.innerWidth < 991.98) {
	document.getElementById('searchDropdown').addEventListener('click', (e) => {		
		//const distanceFromTop = (e.target.parentNode.parentNode.offsetTop * -1) + "px";
		//e.target.parentNode.parentNode.style.setProperty("--move-y", distanceFromTop);
		e.target.parentNode.parentNode.setAttribute('style', 'top: 0; background:  linear-gradient(90deg, #171718 0%, #242626 116.58%), linear-gradient(0deg, rgba(11, 11, 11, 0.4), rgba(11, 11, 11, 0.4)), #D9D9D9;')
		e.target.parentNode.parentNode.classList.add("element-up");
		e.target.nextElementSibling.classList.add("dropdown-up");
		e.target.parentNode.nextElementSibling.classList.add("d-none");

	});

	document.querySelector('.btn-gray').addEventListener('click', (e) => {
		document.getElementById('searchDropdown').parentNode.parentNode.setAttribute('style', 'bottom: 0; background: rgba(0, 0, 0, 0.8);');
		document.getElementById('searchDropdown').nextElementSibling.classList.remove("show");
		document.getElementById('searchDropdown').parentNode.nextElementSibling.classList.remove("d-none");
	});
}