
// 						SWIPER
// ========================================================
// ========================================================

const swiperContent = document.querySelector(".swiper");
if (swiperContent) {
	var swiper = new Swiper(".mySwiper", {
		slidesPerView: 1.33,
		spaceBetween: 24,
		grabCursor: true,
		breakpoints: {
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 24,
			},
			1200: {
				slidesPerView: 2.5,
				spaceBetween: 24,
			},
		},
		
	});
	var swiper = new Swiper(".dropdownSwiper", {
		slidesPerView: 1.5,			
		breakpoints: {	
			768: {
				slidesPerView: 2,
			},
			992: {
				slidesPerView: 3
			},
		},
	});

	var swiper = new Swiper(".myFavorites", {
		slidesPerView: 1.75,
		spaceBetween: 24,
		grabCursor: true,	
		breakpoints: {	
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 44,
			},
			1200: {
				slidesPerView: 3,
				spaceBetween: 80,
			},
		},
	});
}

// 						COUNTDOWN TIMER
// ========================================================
// ========================================================	


const countdownTimer = document.getElementById('countdownTimer');

if (countdownTimer) {	

	const counterdown = setInterval(function() {

		const today = new Date()
		const tomorrow = new Date(today)
		tomorrow.setDate(tomorrow.getDate() + 1);

		const endOffer = tomorrow.setHours(0,0,0,0) - today;

		const hours = Math.floor((endOffer % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		const minutes = Math.floor((endOffer % (1000 * 60 * 60)) / (1000 * 60));
		const seconds = Math.floor((endOffer % (1000 * 60)) / 1000);

		document.getElementById("countdownTimer-hours").innerHTML = hours;
		document.getElementById("countdownTimer-minutes").innerHTML = minutes;
		document.getElementById("countdownTimer-seconds").innerHTML = seconds;
		
		if (endOffer < 0) {
			clearInterval(counterdown);
			document.getElementById("countdownTimer-wrapper").innerHTML = "EXPIRED";
		}
	}, 1000);
}

// 							ACTIVE BUTTONS
// ========================================================
// ========================================================

const buttonActive = document.querySelector('.buttonActive');
if(buttonActive) {
	buttonActive.addEventListener('click', (event) => {
		if (!event.target.classList.contains('bi-check2-circle')) {
			event.target.parentNode.parentNode.classList.add('active');
			event.target.classList.add('bi-check2-circle', 'text-primary');		
			event.target.classList.remove('bi-circle', 'text-gray');
		} else {
			event.target.parentNode.parentNode.classList.remove('active');
			event.target.classList.add('bi-circle', 'text-gray');
			event.target.classList.remove('bi-check2-circle', 'text-primary');
			// alert('active');
		} 
		console.log('user clicked: ', event.target.parentNode.parentNode);

	});
}



const chooseMachine = document.querySelector('.chooseMachine');

if (chooseMachine) {

const passValueBox = document.querySelector('.passValueBox');
const typeg = chooseMachine.querySelector('.btn-check:checked+.chooseMachine11');


passValueBox.addEventListener('click', () => {

console.log(typeg.textContent);

document.querySelector('.switchVehicleItem-title').innerHTML = typeg.textContent;

})

	

	
	
	
	


}

// 							CART 
// ========================================================
// ========================================================

const productItems = document.querySelectorAll('.productItem');

if (productItems) {

	const howManyProducts = productItems.length;
	if(howManyProducts > 1) {
		document.getElementById('howManyProducts').innerHTML = productItems.length + ' items';
	} else {
		document.getElementById('howManyProducts').innerHTML = productItems.length + ' item';
	}

	productItems.forEach((productItem) => {
		
		var unitPrice = productItem.querySelector('.unitPrice').innerHTML;
		var productNumber = productItem.querySelector('.productNumber').innerHTML;
		var totalCost = productItem.querySelector('.totalCost').innerHTML = productNumber * unitPrice;

		productItem.querySelector('.counterCardUp').addEventListener("click", () => {
			const counter = productItem.querySelector('.productNumber').innerHTML++;
			productItem.querySelector('.totalCost').innerHTML = (counter+1) * unitPrice;
		});

		productItem.querySelector('.counterCardDown').addEventListener("click", () => {
			const counter = productItem.querySelector('.productNumber').innerHTML--;
			productItem.querySelector('.totalCost').innerHTML = (counter-1) * unitPrice;
		});

		
	});

}

// 							SEARCH MOBILE
// ========================================================
// ========================================================


//on click add height

if(document.getElementById('searchDropdown')) {

	if(window.innerWidth < 991.98) {

		const searchDropdown = document.getElementById('searchDropdown');
		searchDropdown.setAttribute("data-bs-auto-close", "false");
		const parentparent = document.getElementById('parentparent');
		const closeDropdown = document.querySelector('.closeDropdown');

		searchDropdown.addEventListener('click', (e) => {	

			if (e.target.classList.contains("show")) {
				e.target.parentNode.parentNode.classList.add('dropdownAnimation');
			} else {
				e.target.parentNode.parentNode.classList.remove('dropdownAnimation');
			}


		});
		closeDropdown.addEventListener('click', (e) => {
			parentparent.classList.remove('dropdownAnimation');
			searchDropdown.nextElementSibling.classList.remove("show");
			searchDropdown.classList.remove("show");
		});

	}

}







// 							SELECT BOX
// ========================================================
// ========================================================

if (document.querySelector(".select-beast")) {

	document.querySelectorAll('.select-beast').forEach((el)=>{
		if (el.classList.contains('select-flag')) {
			var settings = {
				render: {
			 		option: function (data, escape) {
						return `<div class="text-center px-0"><img class="me-2 text-center" src="${data.src}" width="26">${data.text}</div>`;
					},
					item: function (item, escape) {
						return `<div><img class="me-3" src="${item.src}" width="26">${item.text}</div>`;
					}
				}
			}
		} 
		else if (el.classList.contains('select-category')) {
			var settings = {
				render: {
			 		option: function(data, escape) {
						return `<div>${data.text}<span class="align-text-top text-xxxs lh-1 text-primary d-inline-block">${data.category}</span></div>` 
					},
					item: function (item, escape) {
						return `<div class="text-md lh-1 text-uppercase"><span class="text-gray">SELECTED:&nbsp;</span> ${item.text}&nbsp;<span class="text-xxxs lh-1 text-primary d-flx align-self-start">${item.category}</span></div>`;
					}
				}
			}
		} 
		else {
			var settings = {
				create: true,
			}
		}
		
	 	new TomSelect(el, settings);
	});		
}


