
// 						SWIPERS
// ========================================================
// ========================================================

const swiperContent = document.querySelector(".swiper");
if (swiperContent) {
	var swiper = new Swiper(".mySwiper", {
		slidesPerView: 1.33,
		spaceBetween: 24,
		grabCursor: true,
		breakpoints: {
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 24,
			},
			1200: {
				slidesPerView: 2.5,
				spaceBetween: 24,
			},
		},
		
	});
	var dropdownSwiper = new Swiper(".dropdownSwiper", {
		slidesPerView: 1.5,			
		breakpoints: {	
			768: {
				slidesPerView: 2,
			},
			992: {
				slidesPerView: 3
			},
		},
	});

	var myFavoritesSwiper = new Swiper(".myFavorites", {
		slidesPerView: 1.75,
		spaceBetween: 24,
		grabCursor: true,	
		breakpoints: {	
			768: {
				slidesPerView: 1.75,
				spaceBetween: 24,
			},
			992: {
				slidesPerView: 3,
				spaceBetween: 44,
			},
			1200: {
				slidesPerView: 3,
				spaceBetween: 80,
			},
		},
	});

	var cartSwiper = new Swiper(".cartSwiper", {
		slidesPerView: 1.5,
		spaceBetween: 24,
		breakpoints: {	
			992: {
				slidesPerView: 3,				
			},
			1200: {
				slidesPerView: 3.5,
			},
			1400: {
				slidesPerView: 4,
			},
		},
	});
	
	(function() {

		'use strict';
	  
		// breakpoint where swiper will be destroyed
		// and switches to a dual-column layout
		const breakpoint = window.matchMedia( '(min-width:992px)' );
	  
		// keep track of swiper instances to destroy later
		let mySwiper;
	  
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
	  
		const breakpointChecker = function() {
	  
		  // if larger viewport and multi-row layout needed
		  if ( breakpoint.matches === true ) {
	  
			// clean up old instances and inline styles when available
			if ( mySwiper !== undefined ) mySwiper.destroy( true, true );
	  
			// or/and do nothing
			return;
	  
			// else if a small viewport and single column layout needed
			} else if ( breakpoint.matches === false ) {
	  
			  // fire small viewport version of swiper
			  return enableSwiper();
	  
			}
	  
		};
		
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
	  
		const enableSwiper = function() {
	  
		  mySwiper = new Swiper ('.slider-cards', {
			slidesPerView: 1,	  
			spaceBetween: 30,
			centeredSlides: true,
			breakpoints: {
				767: {
					slidesPerView: 1,
				}
			},
			keyboardControl: true,
			grabCursor: true,
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev",
			},
		  });
	  
		};
	  
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
		//////////////////////////////////////////////////////////////////
	  
		// keep an eye on viewport size changes
		breakpoint.addListener(breakpointChecker);
	  
		// kickstart
		breakpointChecker();
	  
	  
	  
	  })(); /* IIFE end */

}
// 					COUNTDOWN TIMER
// ========================================================
// ========================================================	


const countdownTimer = document.getElementById('countdownTimer');

if (countdownTimer) {	

	const counterdown = setInterval(function() {

		const today = new Date()
		const tomorrow = new Date(today)
		tomorrow.setDate(tomorrow.getDate() + 1);

		const endOffer = tomorrow.setHours(0,0,0,0) - today;

		const hours = Math.floor((endOffer % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		const minutes = Math.floor((endOffer % (1000 * 60 * 60)) / (1000 * 60));
		const seconds = Math.floor((endOffer % (1000 * 60)) / 1000);

		document.getElementById("countdownTimer-hours").innerHTML = hours;
		document.getElementById("countdownTimer-minutes").innerHTML = minutes;
		document.getElementById("countdownTimer-seconds").innerHTML = seconds;
		
		if (endOffer < 0) {
			clearInterval(counterdown);
			document.getElementById("countdownTimer-wrapper").innerHTML = "EXPIRED";
		}
	}, 1000);
}

// 							ACTIVE BUTTONS
// ========================================================
// ========================================================

const buttonActive = document.querySelector('.buttonActive');
if(buttonActive) {
	buttonActive.addEventListener('click', (event) => {
		if (!event.target.classList.contains('bi-check2-circle')) {
			event.target.parentNode.parentNode.classList.add('active');
			event.target.classList.add('bi-check2-circle', 'text-primary');		
			event.target.classList.remove('bi-circle', 'text-gray');
		} else {
			event.target.parentNode.parentNode.classList.remove('active');
			event.target.classList.add('bi-circle', 'text-gray');
			event.target.classList.remove('bi-check2-circle', 'text-primary');
		} 
		console.log('user clicked: ', event.target.parentNode.parentNode);

	});
}



const chooseMachine = document.querySelector('.chooseMachine');

if (chooseMachine) {

const passValueBox = document.querySelector('.passValueBox');
const typeg = chooseMachine.querySelector('.btn-check:checked+.chooseMachine11');


passValueBox.addEventListener('click', () => {

console.log(typeg.textContent);

document.querySelector('.switchVehicleItem-title').innerHTML = typeg.textContent;

})

}


// 							REMOVE BUTTONS
// ========================================================
// ========================================================

const removeButton = document.querySelectorAll('.removeButton');

if (removeButton) {
	removeButton.forEach((remBtn) => {
		remBtn.addEventListener('click', () => {
			remBtn.parentNode.parentNode.remove();
		})
		
	});
}

// 							CART 
// ========================================================
// ========================================================

const cartContainers = document.querySelectorAll('.cart-container');

if (cartContainers) {
	cartContainers.forEach((cartContainer) => {

		const productItems = cartContainer.querySelectorAll('.productItem');
		const howManyProducts = productItems.length;
		const dispalyNumber = cartContainer.querySelector(".productsNumber");
		
		if(howManyProducts > 1) {
			cartContainer.querySelector(".productsNumber").innerHTML = productItems.length + ' items';
		} else {
			cartContainer.querySelector(".productsNumber").innerHTML = productItems.length + ' item';
		}

		if(cartContainer.querySelector('.productNumber')) {
			cartContainer.querySelectorAll('.productItem').forEach((productItem) => {
				
				const unitPrice = productItem.querySelector('.unitPrice').innerHTML;
				const productNumber = productItem.querySelector('.productNumber').innerHTML;


				productItem.querySelector('.counterCardUp').addEventListener("click", () => {
					const counter = productItem.querySelector('.productNumber').innerHTML++;
					productItem.querySelector('.totalCost').innerHTML = (counter+1) * unitPrice;
				});

				productItem.querySelector('.counterCardDown').addEventListener("click", () => {
					const counter = productItem.querySelector('.productNumber').innerHTML--;
					productItem.querySelector('.totalCost').innerHTML = (counter-1) * unitPrice;

				});
			});
		}
			

	});

}

// 					SEARCH MOBILE
// ========================================================
// ========================================================

window.addEventListener("load", () => {
	if(document.getElementById('searchDropdown')) {
		dropdownMenu();
		window.addEventListener("resize", dropdownMenu);
	}
   
});

function dropdownMenu() {
	if(window.innerWidth < 991.98) {

		const searchDropdown = document.getElementById('searchDropdown');
		searchDropdown.setAttribute("data-bs-auto-close", "false");
		const parentparent = document.getElementById('parentparent');
		const closeDropdown = document.querySelector('.closeDropdown');

		searchDropdown.addEventListener('click', (e) => {	

			if (e.target.classList.contains("show")) {
				e.target.parentNode.parentNode.classList.add('dropdownAnimation');
			} else {
				e.target.parentNode.parentNode.classList.remove('dropdownAnimation');
			}


		});
		closeDropdown.addEventListener('click', (e) => {
			parentparent.classList.remove('dropdownAnimation');
			searchDropdown.nextElementSibling.classList.remove("show");
			searchDropdown.classList.remove("show");
		});

	}
}
	



// // 					SHOW CONTENT		
// // ========================================================
// // ========================================================


const sideMenu = document.querySelector('.content-item');

window.addEventListener("load", () => {
	if (sideMenu) {
		showContent();
		window.addEventListener("resize", showContent);
	}
   
});

function showContent() {
	if (window.innerWidth < 991.98) {
		const buttonShowContent = document.querySelector('.buttonShowContent');
		const buttonCloseContent = document.querySelector('.buttonCloseContent');

		buttonShowContent.addEventListener('click', () => {
			sideMenu.classList.add('active');
		});
		buttonCloseContent.addEventListener('click', () => {
			sideMenu.classList.remove('active');
		});
	}
}



// 							SELECT BOX
// ========================================================
// ========================================================

if (document.querySelector(".select-beast")) {

	document.querySelectorAll('.select-beast').forEach((el)=>{
		if (el.classList.contains('select-flag')) {
			var settings = {
				render: {
			 		option: function (data, escape) {
						return `<div class="text-center px-0"><img class="me-2 text-center" src="${data.src}" width="26">${data.text}</div>`;
					},
					item: function (item, escape) {
						return `<div><img class="me-3" src="${item.src}" width="26">${item.text}</div>`;
					}
				},
				plugins: ['dropdown_input'],
			}
		} 
		else if (el.classList.contains('select-category')) {
			var settings = {
				render: {
			 		option: function(data, escape) {
						return `<div>${data.text}<span class="align-text-top text-xxxs lh-1 text-primary d-inline-block">${data.category}</span></div>` 
					},
					item: function (item, escape) {
						return `<div class="text-md lh-1 text-uppercase"><span class="text-gray">SELECTED:&nbsp;</span> ${item.text}&nbsp;<span class="text-xxxs lh-1 text-primary d-flx align-self-start">${item.category}</span></div>`;
					}
				},
				plugins: ['dropdown_input'],
			}
		} 
		else if (el.classList.contains('select-sort')) {
			var settings = {
				render: {
			 		option: function(data, escape) {
						return `<div class="text-md lh-1 text-uppercase">${data.text}</div>` 
					},
					item: function (item, escape) {
						return `<div class="text-md lh-1 text-uppercase"><span class="text-gray">${item.sort}:&nbsp;</span> ${item.text}</div>`;
					}
				},
				plugins: ['dropdown_input'],
			}
		} 
		else {
			var settings = {
				// create: true,
				plugins: ['dropdown_input'],
			}
		}
				
	 	new TomSelect(el, settings);
	});		
}