<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>ORV HeadQuarters - Garage</title>
	<meta name="description" content="ATV & SxS performance shop that offers customization, upgrades along with your everyday maintenance! 42 Union Street, Smiths Falls, ON, Canada K7A 5C4.">

	<!-- Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://use.typekit.net/ymo0arc.css">
	<link rel="stylesheet" type="text/css" href="assets/font/proxima-nova.css">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" type="text/css" href="assets/bootstrap/css/bootstrap.min.css">


	<!-- Bootstrap ICONS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
	<!-- ICONSAX ICONS -->
	<link rel="stylesheet" type="text/css" href="assets/iconsax/style.css">
	<!-- FONTAWESOME ICONS -->
	<link rel="stylesheet" type="text/css" href="assets/font-awesome/css/all.css">
	
	<!-- Swiper CSS -->
	<link rel="stylesheet" href="assets/swiper/swiper-bundle.min.css">

	<!-- Tom Select CSS -->
	<!-- <link rel="stylesheet" href="assets/tom-select/tom-select.css"> -->
	<!-- <link rel="stylesheet" href="assets/tom-select/tom-select.min.css.map"> -->
	<link href="https://cdn.jsdelivr.net/npm/tom-select@2.1.0/dist/css/tom-select.css" rel="stylesheet">


	<!-- Bootstrap Plus CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/bootstrap-plus.css">



	<!-- CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">

</head>
<body class="bg-dark bg-noise text-white">
	<header>
		<a href="my-garage.php" class="mobile-navbar d-block d-lg-none bg-gradient-dark border-bottom border-1 border-white border-opacity-50 rounded-bottom text-primary text-md text-600 lh-sm text-center text-decoration-none p-4">
			<i class="icon-arrow-left-2 me-2"></i>
			YOUR GARAGE
		</a>
		<?php include './src/navbar.php' ?>
	</header>
	<main>		
		<section class="my-vehicle mb-5">
			<div class="container pb-xl-5 mb-xl -3">
				<div class="row justify-content-center">
					<div class="col-12 col-xl-10 mb-4 pb-2">
						<a href="my-garage.php" class="text-xs text-700 lh-1 text-uppercase text-primary text-decoration-none d-none d-lg-flex align-items-center">
							<i class="icon-arrow-left-2 me-2"></i>
							YOUR GARAGE
						</a>
					</div>
					<div class="col-1 d-none d-xl-block"></div>
					<div class="col-12 col-lg-6 col-xxl-5 order-2 order-lg-1">
						<h2 class="headline-2 text-800 lh-1 text-uppercase mb-4 text-center text-lg-start">
							MY ATV 
							<span class="d-inline-block">XXXC 2013</span>
						</h2>
						<div class="card bg-dark-opacity-40 rounded-3 p-3 vehicle-info">
							<div class="text-end">
								<a href="#" class="text-decoration-none">
									<i class="icon-setting-2 text-white text-xs"></i>
								</a>
							</div>
							<div class="row px-3 pb-4 pt-1">
								<div class="col-6 col-xl-4 mb-3 mb-lg-4 pb-lg-2">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">type</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">atv</p>
								</div>
								<div class="col-6 col-xl-4 mb-3 mb-lg-4 pb-lg-2">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">brand</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">renegade</p>
								</div>
								<div class="col-6 col-xl-4 mb-3 mb-lg-4 pb-lg-2">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">model</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">xxc 1000</p>
								</div>
								<div class="col-6 col-xl-4">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">engine cap.</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">1000 cm <sup>3</sup></p>
								</div>
								<div class="col-6 col-xl-4">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">year</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">2013</p>
								</div>
								<div class="col-6 col-xl-4">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-3 pb-1">engine type</p>
									<p class="text-lg text-bebas lh-1 text-uppercase mb-0">four-stroke</p>
								</div>
							</div>
						</div>
					</div>
					<div class="col-12 col-lg-6 col-xl-5 col-xxl-6 position-relative text-center order-1 order-lg-2">
						<h2 class="headline-1 text-800 lh-1 bg-text position-absolute top-0 end-0 text-white z-index_-1 text-opacity-05">GARAGE</h2>
						<img src="assets/images/buggy.png" class="img-fluid mt-5" alt="buggy">
					</div>
				</div>	
			</div>
		</section>
		<div class="section-cart bg-dark-opacity-40 py-4 px-3 p-lg-3">
			<div class="container-fluid px-0">
				<div class="row justify-content-center justify-content-lg-between">
					<div class="col-12 col-lg-9 col-xxl-10">
						<div class="row">	
							<div class="col-6 col-md-3 col-xl-2 mb-4 mb-md-0">
								<div class="square rounded-1 bg-black bg-black bg-opacity-20 position-relative">
									<i class="icon-heart position-absolute top-0 end-0 m-2 text-xxxs"></i>
									<img src="assets/images/Products/Helm_2.png" alt="helmet" class="position-absolute w-75 top-0 start-0 end-0 bottom-0 m-auto">
								</div>
							</div>
							<div class="col-6 col-md-3 col-xl-2 mb-4 mb-md-0">
								<div class="square rounded-1 bg-black bg-black bg-opacity-20 position-relative">
									<i class="icon-heart position-absolute top-0 end-0 m-2 text-xxxs"></i>
									<img src="assets/images/Products/air_filter.png" alt="ait filter" class="position-absolute w-75 top-0 start-0 end-0 bottom-0 m-auto">
								</div>
							</div>
							<div class="col-6 col-md-3 col-xl-2">
								<div class="square rounded-1 bg-black bg-black bg-opacity-20 position-relative">
									<i class="icon-heart position-absolute top-0 end-0 m-2 text-xxxs"></i>
									<img src="assets/images/Products/belt_engine.png" alt="belt-engine" class="position-absolute w-75 top-0 start-0 end-0 bottom-0 m-auto">
								</div>
							</div>
							<div class="col-6 col-md-3 col-xl-2">
								<div class="square rounded-1 bg-black bg-black bg-opacity-20 position-relative">
									<i class="icon-heart position-absolute top-0 end-0 m-2 text-xxxs"></i>							
									<img src="assets/images/Products/wheel.png" alt="wheel" class="position-absolute w-75 top-0 start-0 end-0 bottom-0 m-auto">		
								</div>
								
							</div>
						</div>
					</div>
					<div class="col-10 col-md-5 col-lg-3 col-xxl-2 d-flex align-items-center ms-lg-auto mt-4 mt-lg-0 pt-2 pt-lg-0">
						<a href="#" class="btn btn-primary w-100">
							<span class="btn-text">BUY NOW</span> 
						</a>
					</div>
				</div>
			</div>			
		</div>
	</main>
	<?php include './src/footer.php' ?>
	<?php
		include './src/navbar-offcanvas-chat.php';
		include './src/navbar-offcanvas-cart.php';
		include './src/navbar-offcanvas-user-panel.php';
	?>
	
	<!-- Bootstrap JS -->	
	<script type="text/javascript" src="assets/bootstrap/js/bootstrap.bundle.min.js" async></script>

	<!-- Tom Select JS -->
	<script src="https://cdn.jsdelivr.net/npm/tom-select@2.1.0/dist/js/tom-select.complete.min.js"></script>

	<!-- Swiper JS -->
	<script src="assets/swiper/swiper-bundle.min.js" defer></script>
	<!-- JS -->
	<script type="text/javascript" src="assets/js/calender.js" defer></script>
	<script type="text/javascript" src="assets/js/script.js" defer></script>
</body>
</html>
