

// 				 SWIPER PRODUCTS - VERTICAL	
// ========================================================
// ========================================================

let productsSwiper = new Swiper(".productsSwiper", {
	grid: {	
		fill: 'row',
		rows: 1,
	},
	spaceBetween: 30,
	height: 500,
	mousewheel: true,
	direction: "vertical",
	navigation: {
		nextEl: ".swiper-button-next",
		prevEl: ".swiper-button-prev",
	},
	pagination: {
		el: ".swiper-pagination",
		clickable: true,
		renderBullet: function (index, className) {
			return '<span class="'
			+ 'text-bebas text-md lh-base lh-1 text-white text-opacity-50 mx-2 d-block '
			+ className + '">' + ('0' + (index + 1)).slice(-2) + "</span>";
		},
	},
	breakpoints: {
		992: {
			grid: {	
				fill: 'row',
				rows: 3,
			},
		}
	}
});

// 						RANGE PRICE			
// ========================================================
// ========================================================

window.onload = function() {
	slideOne();
	slideTwo();
}

let sliderOne = document.getElementById('slider-1');
let sliderTwo = document.getElementById('slider-2');
let displayValOne = document.getElementById('range1');
let displayValTwo = document.getElementById('range2');
let minGap = 0;
let sliderTrack = document.querySelector('.slider-track');
let sliderMaxValue = sliderOne.max;

function slideOne() {
	if (parseInt(sliderTwo.value) - parseInt(sliderOne.value) <= minGap) {
		sliderOne.value = parseInt(sliderTwo.value) - minGap;
	}
	displayValOne.textContent = sliderOne.value;
	fillColor();
}
function slideTwo() {
	if (parseInt(sliderTwo.value) - parseInt(sliderOne.value) <= minGap) {
		sliderTwo.value = parseInt(sliderOne.value) + minGap;
	}
	displayValTwo.textContent = sliderTwo.value;
	fillColor();
}
function fillColor() {
	percent1 = ((sliderOne.value / sliderMaxValue) * 100);
	percent2 = ((sliderTwo.value / sliderMaxValue) * 100);
	sliderTrack.style.background = `linear-gradient(to right, #8c8c8c ${percent1}% , #FF7109 ${percent1}% , #FF7109 ${percent2}%, #8c8c8c ${percent2}%)`;

}

// 				BOTTOM BAR - SEE MORE OPTION		
// ========================================================
// ========================================================

const moreOptions = document.querySelector('.more-options');
const moreOptionsImg = moreOptions.querySelector('.more-option-arrow')

moreOptions.addEventListener('click', () => {
	document.querySelectorAll('.see-more-options .see-more-item').forEach((moreOption) => {
		if(moreOption.classList.contains('seeAll')) {
			moreOption.classList.remove('seeAll');
			moreOptionsImg.style.transform = "rotate(0deg)";
		} else {
			moreOption.classList.add('seeAll');
			moreOptionsImg.style.transform = "rotate(180deg)";
			moreOptionsImg.style.transition = "all 0.5s linear"
		}
	});
	
})


