<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>ORV HeadQuarters - Single Product</title>
	<meta name="description" content="ATV & SxS performance shop that offers customization, upgrades along with your everyday maintenance! 42 Union Street, Smiths Falls, ON, Canada K7A 5C4.">

	<meta name="format-detection" content="telephone=no">
	
	<!-- Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://use.typekit.net/ymo0arc.css">
	<link rel="stylesheet" type="text/css" href="assets/font/proxima-nova.css">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" type="text/css" href="assets/bootstrap/css/bootstrap.min.css">

	<!-- Isonax ICONS -->
	<link rel="stylesheet" href="assets/iconsax/style.css">
    <!-- FONTAWESOME ICONS -->
	<link rel="stylesheet" type="text/css" href="assets/font-awesome/css/all.css">
	<!-- Bootstrap ICONS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">	

	<!-- Swiper CSS -->
	<link rel="stylesheet" href="assets/swiper/swiper-bundle.min.css">

	<!-- Tom Select CSS -->
	<link rel="stylesheet" href="assets/tom-select/tom-select.css">

	<!-- Bootstrap Plus CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/bootstrap-plus.css">
	<!-- CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">

</head>
<body class="bg-dark bg-noise text-white">
	<header>
		<a href="products-page.php" class="mobile-navbar d-block d-lg-none bg-gradient-dark border-bottom border-1 border-white border-opacity-05 rounded-bottom text-primary text-md text-600 lh-sm text-center text-decoration-none p-4">
			<i class="bi bi-arrow-left me-2"></i>
			BACK TO SEARCHING RESULTS
		</a>
		<?php include './src/navbar.php' ?>
	</header>
	<main>
		<section class="section-product position-relative mb-5 pb-5 mb-lg-0 pb-lg-0">	
			<div class="container-lg mb-3 mb-lg-0">
				<div class="row justify-content-center justify-content-lg-start">
					
					<div class="col-10 col-md-8 col-lg-6 col-xl-5 col-xxl-6 position-relative text-center order-4 order-lg-2 mb-5 mb-lg-0">
						<h1 class="headline-1 text-800 lh-1 position-absolute top-0 w-100 text-white z-index_-1 d-none d-xxl-block text-opacity-05">DETAILS</h1>
						<div id="carouselProduct" class="carousel slide  mt-5 pt-lg-3" data-bs-ride="false">
							<div class="carousel-inner">
								<div class="carousel-item active text-center">
									<img src="assets/images/Products/Helm_2.png" alt="product helmet" class="img-fluid w-65">
								</div>
								<div class="carousel-item text-center">
									<img src="assets/images/Products/Helm_2_front.png" alt="product helmet front" class="img-fluid w-65">
								</div>	
								<div class="carousel-item text-center">
									<img src="assets/images/Products/Helm_2_back.png" alt="product helmet back" class="img-fluid w-65">
								</div>							
							</div>
							<button class="carousel-control-prev bg-dark-opacity-50 opacity-100 rounded-1 top-50 bottom-50 my-auto boxSize-md ms-xl-4 d-none d-xxl-block" type="button" data-bs-target="#carouselProduct" data-bs-slide="prev">
								<span class="carousel-control-prev-icon carousel-control-icon" aria-hidden="true"></span>
								<span class="visually-hidden">Previous</span>
							</button>
							<button class="carousel-control-next bg-dark-opacity-50 opacity-100 rounded-1 top-50 bottom-50 my-auto boxSize-md me-xl-4 d-none d-xxl-block" type="button" data-bs-target="#carouselProduct" data-bs-slide="next">
								<span class="carousel-control-next-icon carousel-control-icon" aria-hidden="true"></span>
								<span class="visually-hidden">Next</span>
							</button>
						</div>
					</div>
					<div class="col-12 col-sm-11 col-md-10 col-lg-6 col-xl-7 col-xxl-6 mt-6 mt-lg-0 pt-sm-5 pt-lg-0 mb-md-5 mb-lg-4 mb-xxl-0 pb-5 order-2">
						<div class="">
							<div class="row mb-4 d-none d-lg-flex">
								<div class="col-12 col-xl-8">
									<a href="#" class="text-xs text-700 lh-1 text-uppercase text-primary text-decoration-none d-flex align-items-center">
										<i class="icon-arrow-left-2 me-2"></i>
										BACK TO SEARCHING RESULTS
									</a>
								</div>
								<div class="col-4 text-end d-none d-xxl-block">
									<a href="#" class="me-4 text-white text-decoration-none d-inline-block" target="_blank">
										<i class="icon-export-1 text-xs me-2"></i>
										<p class="text-xxs lh-1 text-600 mb-0 d-inline-block align-text-top">Share</p>
									</a>
									<a	href="#" class="text-white text-decoration-none d-inline-block align-top" target="_blank">
										<i class="icon-heart like-symbol text-xxs"></i>
									</a>
								</div>
							</div>
							<h2 class="headline-2 text-800 lh-1 text-uppercase mb-6 mb-lg-3 text-center text-md-start">
								CROSS X1
								<span class="d-inline-block"> OFFROAD HELMET</span>
							</h2>
						</div>
						<div class="card card-bg-dark rounded-3 py-3 px-sm-3">
							<div class="row px-3 pb-4 pt-1">
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">COUNTRY</p>
									<div class="form-control form-control form-control-sm form-control-fs-up rounded-1 w-100">POLAND</div>		
									<!-- <input class="form-control form-control-xs rounded-1" type="text" value="POLAND"> -->
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">COLOR</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="Red">Red</option>
										<option value="Yellow">Yellow</option>
										<option value="Blue">Blue</option>
										<option value="Green">Green</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">TYPE</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="Type1">Type1</option>
										<option value="Type2">Type2</option>
										<option value="Type3">Type3</option>
										<option value="Type4">Type4</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 4</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="1234567890">1234567890</option>
										<option value="3456789012">3456789012</option>
										<option value="5678901234">5678901234</option>
										<option value="7890123456">7890123456</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 5</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="1,405000">1,405000</option>
										<option value="3,405000">3,405000</option>
										<option value="9,405000">9,405000</option>
										<option value="0,405000">0,405000</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 pb-sm-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 6</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="abcdefgh">abcdefgh</option>
										<option value="ijklmnop">ijklmnop</option>
										<option value="rstuuwyz">rstuuwyz</option>
										<option value="qwertyui">qwertyui</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 mb-xl-0 pb-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 7</p>
									<div class="form-control form-control form-control-sm form-control-fs-up rounded-1">abcde</div>
									<!-- <input class="form-control form-control-xs rounded-1" type="text" value="abcde"> -->
								</div>
								<div class="col-12 col-sm-6 col-xl-4 mb-4 mb-xl-0 pb-2 pb-xl-0">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 8</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="yes">yes</option>
										<option value="no">no</option>
									</select>
								</div>
								<div class="col-12 col-sm-6 col-xl-4">
									<p class="text-xs text-500 lh-1 text-uppercase opacity-60 mb-2 mb-sm-3">OPT 9</p>
									<select class="select-beast select-beast-lg-fs-up">
										<option value="NO DETAILS">NO DETAILS</option>
										<option value="DETAILS-1">DETAILS 1</option>
										<option value="DETAILS-2">DETAILS 2</option>
										<option value="DETAILS-3">DETAILS 3</option>
									</select>
								</div>
							</div>
						</div>
					</div>
					<div class="col-12 order-4 order-lg-3 mb-5 mb-lg-0 product-thumbnails">
						<div class="row justify-content-center justify-content-lg-start g-0">
							<div class="col-9 col-sm-10 col-md-8 col-lg-6 col-xl-5 col-xxl-6 position-relative">
								<button class="carousel-product-control carousel-control-prev bg-dark-opacity-50 opacity-100 rounded-1 my-auto boxSize-md ms-xl-4 d-lg-none" type="button" data-bs-target="#carouselProduct" data-bs-slide="prev">
									<span class="carousel-control-prev-icon carousel-control-icon" aria-hidden="true"></span>
									<span class="visually-hidden">Previous</span>
								</button>
								<button class="carousel-product-control carousel-control-next bg-dark-opacity-50 opacity-100 rounded-1 my-auto boxSize-md me-xl-4 d-lg-none" type="button" data-bs-target="#carouselProduct" data-bs-slide="next">
									<span class="carousel-control-next-icon carousel-control-icon" aria-hidden="true"></span>
									<span class="visually-hidden">Next</span>
								</button>
								<div class="carousel-indicators carouselProduct-indicators position-relative m-0" id="indicators">
									<button type="button" data-bs-target="#carouselProduct" data-bs-slide-to="0" class="active position-relative w-100	h-100 opacity-100 m-0 bg-dark-opacity-40 border-0" style="background-color: rgba(11, 11, 11, 0.4);" aria-current="true" aria-label="Slide 1">
										<img src="assets/images/Products/Helm_2.png" alt="product helmet" class="h-100 position-absolute top-50 start-50 translate-middle p-2 p-sm-4">
									</button>
									<button type="button" data-bs-target="#carouselProduct" data-bs-slide-to="1" class="position-relative w-100	h-100 opacity-100 m-0 bg-dark-opacity-40 border-0" style="background-color: rgba(11, 11, 11, 0.4);" aria-label="Slide 2">
										<img src="assets/images/Products/Helm_2_front.png" alt="product helmet" class="h-100 position-absolute top-50 start-50 translate-middle p-2 p-sm-4">
									</button>
									<button type="button" data-bs-target="#carouselProduct" data-bs-slide-to="2" class="position-relative w-100	h-100 opacity-100 m-0 bg-dark-opacity-40 border-0" style="background-color: rgba(11, 11, 11, 0.4);" aria-label="Slide 3">
										<img src="assets/images/Products/Helm_2_back.png" alt="product helmet" class="h-100 position-absolute top-50 start-50 translate-middle p-2 p-sm-4">
									</button>
								</div>
							</div>
						</div>						
					</div>
					<div class="product-summary position-absolute bg-dark-opacity-40 border-top border-white border-opacity-05 bottom-0 end-0 w-100 col-12 order-2 order-lg-4 py-4_5 py-lg-0">
						<div class="container h-100 px-0">
							<div class="row align-items-center justify-content-center justify-content-lg-end h-100 ms-lg-aut0">
								<div class="col-7 col-sm-6 col-md-4 col-lg-2 col-xl-3 col-xxl-2 mb-4 mb-sm-0">
									<p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-2 text-start w-auto">fix price</p>
									<div class="d-flex align-items-center">
										<p class="text-bebas text-xxl lh-1 mb-0 me-3 d-inline">$500.00</p>
										<img src="assets/images/Icon/Info_duotone_line.svg" alt="icon info" class="ps-1">
									</div>						
								</div>
								<div class="col-1 d-none d-md-block"></div>
								<div class="col-10 col-sm-6 col-md-5 col-lg-3">
									<button class="btn btn-primary w-100" data-bs-toggle="modal" data-bs-target="#addedToCard">
										<span class="btn-text">BUY NOW</span> 
									</button>
								</div>
							</div>
						</div>
						
					</div>
					
				</div>
			</div>
		</section>
		<!-- <section class="section-product-summary sticky-bottom ">
			<div class="container">
				<div class="row align-items-center">
					
				</div>
			</div>			
		</section> -->
	</main>


		<!-- Modal addedToCard _____________________________________________________________________________________________________________________________________ -->
		<div class="modal fade addedToCard" id="addedToCard" tabindex="-1" aria-labelledby="addedToCard" aria-hidden="true">
			<button type="button" class="btn-close m-0 p-0 opacity-100 text-white bg-img-none position-absolute top-0 start-0 p-3" data-bs-dismiss="modal" aria-label="Close">
				<i class="icon-arrow-left"></i>
			</button>
			<div class="modal-dialog modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg modal-fullscreen-lg-down">
				<div class="modal-content bg-dark">
					<div class="searchModal-body modal-body p-0 h-100">						
						<div class="card border-0 rounded-3 bg-radial-gray border border-2 border-white">
							<div class="position-relative w-100 h-100 border-anim">
								<!-- <span class="boxSize-sm bg-white position-absolute top-0 start-50 translate-middle"></span> -->
								<div class="d-none d-lg-flex bg-white justify-content-center align-items-center boxSize-sm position-fixed start-50 translate-middle rounded-circle">
									<i class="icon-tick-circle1 text-primary text-hook"></i>
								</div>	
								<div class="card-body px-4 py-5 p-sm-5 position-relative z-index_3">
									<button type="button" class="btn-close p-4 p-sm-5 opacity-100 text-white d-inline-block d-lg-none w-auto text-end position-absolute top-0 end-0 bg-img-none h-auto" data-bs-dismiss="modal" aria-label="Close">
										<i class="icon-close-circle text-md"></i>
									</button>
									<div class="row justify-content-center">
										<div class="col-8 col-md-6 col-lg-5 mb-5 mb-lg-0">
											<img src="assets/images/Products/Helm_2_front.png" alt="product helemt" class="img-fluid">
										</div>
										<div class="col-sm-10 col-md-8 col-lg-7 d-flex flex-column text-center text-lg-start">
											<h3 class="headline-3 lh-1 text-800 text-uppercase mb-4 pb-3 text-center text-lg-start">PRODUCT ADDED TO YOUR CART</h3>
											<p class="text-md text-primary lh-1 text-600 mb-5 mb-lg-auto">Do you want to go to the cart for buying?</p>	
											<div class="row mb-lg-5 mt-5 justify-content-center">
												<div class="col-md-11 col-lg-6 order-2 order-lg-1">
													<button class="btn btn-dark-gray btn-center w-100 btn-xs" data-bs-dismiss="modal" aria-label="Close">
														<span class="btn-text">close</span> 
													</button>
												</div>
												<div class="col-md-11 col-lg-6 mb-4 order-1 order-lg-2">
													<a href="cart-page.php" class="btn btn-primary btn-center w-100 btn-xs">
														<span class="btn-text">go to cart</span> 
													</a>	
												</div>
											</div>												
										</div>	
									</div>																	
								</div>
							</div>
						</div>
					</div>					
				</div>
			</div>
		</div>

		<?php 
			include './src/navbar-modal.php';
		?>
		
		<?php 
			include './src/navbar-offcanvas-chat.php';
			include './src/navbar-offcanvas-cart.php';
			include './src/navbar-offcanvas-user-panel.php';
		?>



	<!-- Bootstrap JS -->	
	<script type="text/javascript" src="assets/bootstrap/js/bootstrap.bundle.min.js" async></script>	

	<!-- Tom Select JS -->
	<script src="https://cdn.jsdelivr.net/npm/tom-select@2.1.0/dist/js/tom-select.complete.min.js"></script>

	<!-- Swiper JS -->
	<script src="assets/swiper/swiper-bundle.min.js" defer></script>

	<!-- JS -->
	<script type="text/javascript" src="assets/js/calender.js" defer></script>	
	<script type="text/javascript" src="assets/js/single-product-script.js" defer></script>
	<script type="text/javascript" src="assets/js/script.js" defer></script>
</body>
</html>