// 						ACCOUNT NAVBAR
// ========================================================
// ========================================================

      window.onload = function() {
        if(window.location.hash) {
          let tabID = window.location.hash.replace(/#/g, '');
          let triggerEl = document.getElementById('v-'+ tabID + '-tab');
          let tabTrigger = new bootstrap.Tab(triggerEl);
          let openTab = bootstrap.Tab.getInstance(triggerEl).show();
    
          location.hash = "";
          history.replaceState("", "", location.pathname);
        }
      }
   
      const accountBtns = document.querySelectorAll(".btn-account");
      accountBtns.forEach((accountBtn) => {
        accountBtn.onclick = function(e) {      
          let triggerEl = document.getElementById('v-'+ e.target.id + '-tab');
          let tabTrigger = new bootstrap.Tab(triggerEl);
          let openTab = bootstrap.Tab.getInstance(triggerEl).show();

          let myOffCanvas = document.getElementById('offcanvasRight');
          let openedCanvas = bootstrap.Offcanvas.getInstance(myOffCanvas);
          openedCanvas.hide();

          window.scrollTo({
            top: 0,
            behavior: 'smooth'
          });

          location.hash = "";
          history.replaceState("", "", location.pathname);
        }
      })
    
// 						      SWIPER
// ========================================================
// ========================================================


window.addEventListener("load", onLoadSwiper);

	function onLoadSwiper(e){
		enableSwiper();
		window.addEventListener("resize", enableSwiper);
	}

const enableSwiper = function() {
  const addSwiper =  document.querySelector('.slider-cards');

  if (window.innerWidth < 991.98) {	
   
   addSwiper.classList.add("swiper");
   addSwiper.firstElementChild.classList.add("swiper-wrapper");
  
   console.log(addSwiper);
   //swiper
  var sliderCards = new Swiper ('.slider-cards', {
    slidesPerView: 1,	  
    spaceBetween: 30,
    centeredSlides: true,
    breakpoints: {
        767: {
            slidesPerView: 1,
        }
    },
    keyboardControl: true,
    grabCursor: true,
    navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
    },
  });
  } else {
    addSwiper.classList.remove("swiper");
   addSwiper.firstElementChild.classList.remove("swiper-wrapper");
  }
};


// 			          	BUTTONS EDIT
// ========================================================
// ========================================================

const changeDetails = document.getElementById('v-user-details');
const changeBtns = changeDetails.querySelectorAll('.btn-change-content');
changeBtns.forEach((changeBtn) => {
  changeBtn.onclick = function(e){
    const getIdEl = changeBtn.getAttribute('for');
    const changeContent = document.getElementById(getIdEl);

    if (changeBtn.firstElementChild.textContent === "Change") {
      changeContent.removeAttribute("disabled");   
      document.body.classList.add('blackBackground'); 
      changeBtn.classList.add('activeContent');
      changeContent.classList.add('activeContent'); 
      changeBtn.firstElementChild.textContent ='Save new';  
    } else {

      if(changeContent.id === 'changeEmail') {
        var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
        var invalid = "Invalid Email Address";
        var correct = "Correct Email Address"
      } else if (changeContent.id === 'changePassword') {
        var reg = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$/
        var invalid = "Must contain at least one number and one uppercase and lowercase letter, and at least 8 or more characters";
        var correct = "Correct Password"
      } else {
        var reg =/^(.{1,})$/;
        var invalid = "Invalid";
        var correct = "Correct"
      } 
      
      if(reg.test(changeContent.value) == false) {
          alert(invalid);
      } else {
        alert(correct);
        changeBtn.firstElementChild.textContent = 'Change';
        document.body.classList.remove('blackBackground'); 
        changeBtn.classList.remove('activeContent');
        changeContent.classList.remove('activeContent');  
        changeContent.setAttribute("disabled", "");
      } 
    }
    
    
  }
})



document.querySelectorAll('.changeInformation').forEach((changeInfo) => {

  const changeInfoBtn = changeInfo.querySelector('.btn-change-info');
  const changeElements = changeInfo.querySelectorAll('.contentText')

  changeInfoBtn.onclick = function(e){
    if (changeInfoBtn.firstElementChild.textContent === "Change" || changeInfoBtn.firstElementChild.textContent === "Edit") {
      changeInfoBtn.firstElementChild.textContent ='Save new';  
      // changeInfo.classList.add('activeContent');
      changeInfoBtn.classList.add('activeContent');      
      changeElements.forEach((changeEl) => {
        changeEl.removeAttribute("disabled");       
        changeEl.classList.add('activeContent');
      });
      document.body.classList.add('blackBackground');
    } else {
      
      changeInfoBtn.firstElementChild.textContent = 'Change';
      changeInfoBtn.classList.remove('activeContent');
      changeElements.forEach((changeEl) => {
        changeEl.setAttribute("disabled", "");
        changeEl.classList.remove('activeContent');


        var pattern = changeEl.getAttribute('pattern');
        var inputName = changeEl.getAttribute('name');
        var inputPattern = changeEl.getAttribute('placeholder');
        var exp = new RegExp('^(' + pattern + ')$');
        console.log(exp);
        if(exp.test(changeEl.value) == false) {
          alert('Invalid ' + inputName + ". The correct version is " + inputPattern)
        } 

        
      })
      document.body.classList.remove('blackBackground');
    }
  }
})

