<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>ORV HeadQuarters - Thank you!</title>
	<meta name="description" content="ATV & SxS performance shop that offers customization, upgrades along with your everyday maintenance! 42 Union Street, Smiths Falls, ON, Canada K7A 5C4.">

	<meta name="format-detection" content="telephone=no">
	
	<!-- Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://use.typekit.net/ymo0arc.css">
	<link rel="stylesheet" type="text/css" href="assets/font/proxima-nova.css">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" type="text/css" href="assets/bootstrap/css/bootstrap.min.css">


	<!-- Isonax ICONS -->
	<link rel="stylesheet" href="assets/iconsax/style.css">
    <!-- FONTAWESOME ICONS -->
	<link rel="stylesheet" type="text/css" href="assets/font-awesome/css/all.css">
    
	<!-- Bootstrap ICONS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">

	<!-- Swiper CSS -->
	<link rel="stylesheet" href="assets/swiper/swiper-bundle.min.css">

	<!-- Tom Select CSS -->
	<link rel="stylesheet" href="assets/tom-select/tom-select.css">

	<!-- Bootstrap Plus CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/bootstrap-plus.css">
	<!-- CSS -->
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">

</head>
<body class="bg-dark bg-noise text-white">
	<header>
		<a href="my-account.php" class="mobile-navbar d-block d-lg-none bg-gradient-dark border-bottom border-1 border-white border-opacity-05 rounded-bottom text-primary text-md text-600 lh-sm text-center text-decoration-none p-4">
			<i class="bi bi-arrow-left me-2"></i>
			CONTINUE SHOPPING
		</a>

		<?php include './src/navbar.php';?>	
	
	</header>

	<main>
		<section class="section-thank-you mt-5 mt-lg-0 mb-5 pb-5">
            <div class="container">
                <div class="row justify-content-center mb-lg-5 pb-lg-5">
                    <div class="col-12 col-md-8 col-lg-10 text-center">
                        <h2 class="headline-2 text-800 lh-1 text-uppercase mb-4 pb-2 pb-lg-0">Thank you</h2>
                        <p class="text-xl lh-1 text-600 mb-4 pb-2 pb-lg-0">
                            Your order 
                            <span class="text-primary text-800 order-number">#00231667</span>                            
                           	<span class="d-inline-block"> has been recived</span>
                        </p>
                        <p class="text-xs lh-sm mb-6 pb-3 pb-lg-0">
                            We have sent a message to your e-mail with the summary 
                            <span class="d-lg-block">and confirmation of the order</span>  
                        </p>
                    </div>
                    <div class="col-12 col-xxl-10 mb-5 pb-5 pb-xxl-4 cart-container">
                    	<div class="text-md lh-sm d-lg-none w-100 mb-5 border-bottom border-white">
                            <div class="text-start text-400 d-inline-flex text-capitalize">
                                <span class="productsNumber">Items</span>
                            </div>
                        </div>   
                        <div class="card-bg-dark rounded-3 p-lg-4">

                            <table class="d-block d-lg-table table text-white mb-0">
                                <thead>
                                    <tr class="text-uppercase text-xxs lh-1 d-none d-lg-table-row">
                                        <th scope="col" class="d-none"></th>
                                        <th scope="col" class="text-start text-400 pb-4">item</th>
                                        <th scope="col" class="text-center text-400 pb-4">unit price</th>   
                                        <th scope="col" class="text-center text-400 pb-4">quantity</th>
                                        <th scope="col" class="text-center text-400 pb-4">final price</th>
                                    </tr>                                       
                                </thead>
                                <tbody class="text-xs text-700 lh-1 align-middle">
                                    <tr class="productItem mb-5 mb-lg-0 d-block d-lg-table-row px-3 px-sm-0">                                   
                                        <td class="d-none d-sm-flex align-items-center d-lg-none cell-img ms-4 me-4 me-md-5 p-0">
                                            <img src="assets/images/Products/air_filter.png" alt="" class="d-inline-flex  d-lg-none img-fluid">
                                        </td>
                                        
                                        <td class="text-start mb-4 mb-sm-2 mb-lg-0 pt-4 pb-0 py-lg-3 d-inline-block d-lg-table-cell cell-item">
                                            <img src="assets/images/Products/air_filter.png" alt="" class="me-2 d-inline d-sm-none d-lg-inline boxSize-md h-auto">
                                            <span class=""></span>Air Engine Filter
                                        </td>
                                        <td class="text-lg-center mb-2 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-price">
                                            <span class="text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">UNIT PRICE </span>
                                            $<span class="unitPrice">500.00</span>
                                        </td>
                                        <td class="text-lg-center mb-3 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-quantity"> 
                                           <span class="text-xs text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">QUANTITY</span>
                                            <span class="text-xs text-700 mb-0 text-center d-inline-block">10</span>                                         
                                           
                                        </td>
                                        <td class="text-lg-center pb-4 pt-0 py-lg-3 d-inline-flex align-items-center d-lg-table-cell cell-final-price">
                                            <span class="text-white text-400 d-inline d-lg-none text-uppercase me-auto me-sm-4">FINAL PRICE </span>
                                            $<span class="totalCost">500.00</span>
                                        </td>
                                    </tr>

                                    <tr class="productItem mb-5 mb-lg-0 d-block d-lg-table-row px-3 px-sm-0">

                                        <td class="d-none d-sm-flex align-items-center d-lg-none cell-img ms-4 me-4 me-md-5 p-0">
                                            <img src="assets/images/Products/belt_engine.png" alt="" class="d-inline-flex  d-lg-none img-fluid">
                                        </td>

                                        <td class="text-start mb-4 mb-sm-2 mb-lg-0 pt-4 pb-0 py-lg-3 d-inline-block d-lg-table-cell cell-item">
                                            <img src="assets/images/Products/belt_engine.png" alt="" class="me-2 d-inline d-sm-none d-lg-inline boxSize-md h-auto">
                                            Engine Belt
                                        </td>
                                        <td class="text-lg-center mb-2 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-price">
                                            <span class="text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">UNIT PRICE </span>
                                            $<span class="unitPrice">100.00</span>
                                        </td>
                                        <td class="text-lg-center mb-3 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-quantity"> 
                                            <span class="text-xs text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">QUANTITY</span>
                                            <p class="text-xs text-700 mb-0 text-center d-inline-block">10</p>
                                        </td>
                                        <td class="text-lg-center pb-4 pt-0 py-lg-3 d-inline-flex align-items-center d-lg-table-cell cell-final-price">
                                            <span class="text-white text-400 d-inline d-lg-none text-uppercase me-4">FINAL PRICE </span>
                                            $<span class="totalCost">100.00</span>
                                        </td>
                                    </tr>
                                    <tr class="productItem mb-5 mb-lg-0 d-block d-lg-table-row px-3 px-sm-0">

                                        <td class="d-none d-sm-flex align-items-center d-lg-none cell-img ms-4 me-4 me-md-5 p-0">
                                            <img src="assets/images/Products/badge.jpg" alt="" class="d-inline-flex  d-lg-none img-fluid">
                                        </td>

                                        <td class="text-start mb-4 mb-sm-2 mb-lg-0 pt-4 pb-0 py-lg-3 d-inline-block d-lg-table-cell cell-item">
                                            <img src="assets/images/Products/badge.jpg" alt="" class="me-2 d-inline d-sm-none d-lg-inline boxSize-md h-auto">
                                            ORV Club Badge
                                        </td>
                                        <td class="text-lg-center mb-2 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-price"> 
                                            <span class="text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">UNIT PRICE </span>
                                            $<span class="unitPrice">0.00</span>
                                        </td>
                                        <td class="text-lg-center mb-3 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-quantity"> 
                                            <span class="text-xs text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">QUANTITY</span>
                                            <p class="text-xs text-700 mb-0 text-center d-inline-block">10</p>
                                        </td>
                                        <td class="text-lg-center pb-4 pt-0 py-lg-3 d-inline-flex align-items-center d-lg-table-cell cell-final-price">
                                            <span class="text-white text-400 d-inline d-lg-none text-uppercase me-4">FINAL PRICE </span>
                                            <span class="totalCost">FREE</span>
                                        </td>
                                    </tr>
                                    <tr class="productItem mb-5 mb-lg-0 d-block d-lg-table-row px-3 px-sm-0 border border-white border-opacity-0">

                                        <td class="d-none d-sm-flex align-items-center d-lg-none cell-img ms-4 me-4 me-md-5 p-0">
                                            <img src="assets/images/Products/badge.jpg" alt="" class="d-inline-flex  d-lg-none img-fluid">
                                        </td>

                                        <td class="text-start mb-4 mb-sm-2 mb-lg-0 pt-4 pb-0 py-lg-3 d-inline-block d-lg-table-cell cell-item">
                                            <img src="assets/images/Products/badge.jpg" alt="" class="me-2 d-inline d-sm-none d-lg-inline boxSize-md h-auto">
                                            ORV Club Badge
                                        </td>
                                            <td class="text-lg-center mb-2 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-price">
                                            <span class="text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">UNIT PRICE </span>
                                            $<span class="unitPrice">0.00</span>
                                        </td>
                                        <td class="text-lg-center mb-3 mb-lg-0 py-0 py-lg-3 d-inline-block d-lg-table-cell cell-quantity"> 
                                            <span class="text-xs text-white text-400 text-opacity-80 d-inline d-lg-none text-uppercase">QUANTITY</span>
                                            <p class="text-xs text-700 mb-0 text-center d-inline-block">10</p>
                                        </td>
                                        <td class="text-lg-center pb-4 pt-0 py-lg-3 d-inline-flex align-items-center d-lg-table-cell cell-final-price">
                                            <span class="text-white text-400 d-inline d-lg-none text-uppercase me-4">FINAL PRICE </span>
                                            <span class="totalCost">FREE</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="text-center mt-3">
                                <a href="my-account.php#my-orders" class="btn btn-center btn-primary">VIEW OR MANAGE ORDER</a>
                            </div>                            
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center mb-4 mb-lg-5 pb-4">
                    <div class="col-12">
                        <h2 class="headline-2 text-800 lh-1 text-uppercase mb-4 text-center text-lg-start">YOU MAY <span class="d-block d-lg-inline-block">ALSO LIKE</span></h2>
                    </div>
                    <div class="col-12 mb-5">
                        <div class="swiper cartSwiper">
                            <div class="swiper-wrapper pt-5">
                                <div class="swiper-slide pt-5 mt-5">
                                    <div class="card card-product rounded-3 border-0 position-relative card-bg-dark pt-5">
                                        <img src="assets/images/Products/Helm_1.png" class="position-absolute top-0 start-50 translate-middle card-img mx-90  object-fit-contain" alt="" height="180">
                                        <div class="card-body mt-5 pt-md-5 pb-4 px-4">
                                            <h4 class="card-title headline-4 text-700 lh-1 mb-4 mt-5 mt-lg-4 pt-sm-3 pt-lg-0">Can-Am X1 Helment</h4>                              
                                            <div class="d-flex justify-content-between align-items-center mb-3 mb-lg-1 pt-2">
                                                <p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-0">fix price</p>
                                                <p class="mb-0" role="button">
                                                    <i class="icon-heart like-symbol text-xxxs d-inline-block align-middle"></i>
                                                </p>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-end mb-2 mb-lg-0">
                                                <p class="text-bebas text-xl lh-1 mb-0">$500.00</p>
                                                <a href="single-product.php" class="btn-link text-xxs lh-1 text-500 text-uppercase text-decoration-none text-white mb-1 d-flex align-items-center">
                                                    details 
                                                    <i class="icon-arrow-right-3 ms-2 text-4xs"></i>
                                                </a>
                                            </div>                                      
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide pt-5 mt-5">
                                    <div class="card card-product rounded-3 border-0 position-relative card-bg-dark pt-5">
										<img src="assets/images/Products/Helm_1.png" class="position-absolute top-0 start-50 translate-middle card-img mx-90  object-fit-contain" alt="" height="180">
										<div class="card-body mt-5 pt-md-5 pb-4 px-4">
											<h4 class="card-title headline-4 text-700 lh-1 mb-4 mt-5 mt-lg-4 pt-sm-3 pt-lg-0">Can-Am X1 Helment</h4>								
											<div class="d-flex justify-content-between align-items-center mb-3 mb-lg-2 pt-2">
												<p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-0">fix price</p>
												<p class="mb-0" role="button">
													<i class="icon-heart like-symbol text-xxxs d-inline-block align-middle"></i>
												</p>
											</div>
											<div class="d-flex justify-content-between align-items-end mb-2 mb-lg-0">
												<p class="text-bebas text-xl lh-1 mb-0">$500.00</p>
												<a href="single-product.php" class="btn-link text-xxs lh-1 text-500 text-uppercase text-decoration-none text-white  d-flex align-items-center">
													details 
													<i class="icon-arrow-right-3 ms-2 text-4xs"></i>
												</a>
											</div>										
										</div>
									</div>
                                </div>
                                <div class="swiper-slide pt-5 mt-5">
                                    <div class="card card-product rounded-3 border-0 position-relative card-bg-dark pt-5">
										<img src="assets/images/Products/Helm_1.png" class="position-absolute top-0 start-50 translate-middle card-img mx-90  object-fit-contain" alt="" height="180">
										<div class="card-body mt-5 pt-md-5 pb-4 px-4">
											<h4 class="card-title headline-4 text-700 lh-1 mb-4 mt-5 mt-lg-4 pt-sm-3 pt-lg-0">Can-Am X1 Helment</h4>								
											<div class="d-flex justify-content-between align-items-center mb-3 mb-lg-2 pt-2">
												<p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-0">fix price</p>
												<p class="mb-0" role="button">
													<i class="icon-heart like-symbol text-xxxs d-inline-block align-middle"></i>
												</p>
											</div>
											<div class="d-flex justify-content-between align-items-end mb-2 mb-lg-0">
												<p class="text-bebas text-xl lh-1 mb-0">$500.00</p>
												<a href="single-product.php" class="btn-link text-xxs lh-1 text-500 text-uppercase text-decoration-none text-white  d-flex align-items-center">
													details 
													<i class="icon-arrow-right-3 ms-2 text-4xs"></i>
												</a>
											</div>										
										</div>
									</div>
                                </div>
                                <div class="swiper-slide pt-5 mt-5">
                                    <div class="card card-product rounded-3 border-0 position-relative card-bg-dark pt-5">
										<img src="assets/images/Products/Helm_1.png" class="position-absolute top-0 start-50 translate-middle card-img mx-90  object-fit-contain" alt="" height="180">
										<div class="card-body mt-5 pt-md-5 pb-4 px-4">
											<h4 class="card-title headline-4 text-700 lh-1 mb-4 mt-5 mt-lg-4 pt-sm-3 pt-lg-0">Can-Am X1 Helment</h4>								
											<div class="d-flex justify-content-between align-items-center mb-3 mb-lg-2 pt-2">
												<p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-0">fix price</p>
												<p class="mb-0" role="button">
													<i class="icon-heart like-symbol text-xxxs d-inline-block align-middle"></i>
												</p>
											</div>
											<div class="d-flex justify-content-between align-items-end mb-2 mb-lg-0">
												<p class="text-bebas text-xl lh-1 mb-0">$500.00</p>
												<a href="single-product.php" class="btn-link text-xxs lh-1 text-500 text-uppercase text-decoration-none text-white  d-flex align-items-center">
													details 
													<i class="icon-arrow-right-3 ms-2 text-4xs"></i>
												</a>
											</div>										
										</div>
									</div>
                                </div>
                                <div class="swiper-slide pt-5 mt-5">
                                    <div class="card card-product rounded-3 border-0 position-relative card-bg-dark pt-5">
										<img src="assets/images/Products/Helm_1.png" class="position-absolute top-0 start-50 translate-middle card-img mx-90  object-fit-contain" alt="" height="180">
										<div class="card-body mt-5 pt-md-5 pb-4 px-4">
											<h4 class="card-title headline-4 text-700 lh-1 mb-4 mt-5 mt-lg-4 pt-sm-3 pt-lg-0">Can-Am X1 Helment</h4>								
											<div class="d-flex justify-content-between align-items-center mb-3 mb-lg-2 pt-2">
												<p class="text-xxs lh-1 text-700 text-uppercase text-primary mb-0">fix price</p>
												<p class="mb-0" role="button">
													<i class="icon-heart like-symbol text-xxxs d-inline-block align-middle"></i>
												</p>
											</div>
											<div class="d-flex justify-content-between align-items-end mb-2 mb-lg-0">
												<p class="text-bebas text-xl lh-1 mb-0">$500.00</p>
												<a href="#" class="btn-link text-xxs lh-1 text-500 text-uppercase text-decoration-none text-white  d-flex align-items-center">
													details 
													<i class="icon-arrow-right-3 ms-2 text-4xs"></i>
												</a>
											</div>										
										</div>
									</div>
                                </div>
                            </div>
                        </div>                      
                    </div>
                    <div class="col-10 col-sm-8 col-md-6 col-lg-4 col-xxl-3 text-center">
                        <a href="products-page.php" class="btn btn-center btn-primary w-100">VIEW MORE ITEMS</a>
                    </div>
                </div>
            </div>
        </section>
        <section class="section-newsletter bg-primary py-4 py-lg-5 position-relative overflow-hidden">
            <div class="container-xl py-2">
                <div class="row align-items-center justify-content-center justify-content-lg-between position-relative z-index_3">
                    <div class="col-10 col-md-8 col-xl-7">
                        <h2 class="headline-2 text-800 lh-1 text-uppercase mb-4 mb-lg-0 text-center text-lg-start">CHECK OUR WHEELS</h2>
                    </div>                  
                    <div class="col-10 col-sm-8 col-lg-4"> 
                        <a href="products-page.php" class="btn btn-center btn-outline-white w-100 px-1 px-xl-4">
                            <span class="btn-text">Check what we got for you</span> 
                        </a>
                    </div>
                </div>
                <img src="assets/images/Background/Trace.png" class="position-absolute start-50 top-50 opacity-25 w-50 z-index_0 banner-bg-img" alt="">
            </div>
        </section>  
    </main>
    
	<?php include './src/footer.php';?>	
	<?php include './src/navbar-offcanvas-chat.php';?>
    <?php include './src/navbar-offcanvas-cart.php';?>
    <?php include './src/navbar-offcanvas-user-panel.php';?>
    <?php include './src/navbar-modal.php';?>

	<!-- Bootstrap JS -->	
	<script type="text/javascript" src="assets/bootstrap/js/bootstrap.bundle.min.js" async></script>	

	<!-- Tom Select JS -->
	<script src="https://cdn.jsdelivr.net/npm/tom-select@2.1.0/dist/js/tom-select.complete.min.js"></script>

	<!-- Swiper JS -->
	<script src="assets/swiper/swiper-bundle.min.js" defer></script>

	<!-- JS -->
	<script type="text/javascript" src="assets/js/calender.js" defer></script>
	<script type="text/javascript" src="assets/js/script.js" defer></script>
</body>
</html>
