$(document).ready(function () {
// *************************************
// *********** CALENDAR ****************
// *************************************
  $('.datepicker').datepicker({
    format: "yyyy-mm-dd",
    autoclose: true,
    todayHighlight: true,
    orientation: "auto"
  });

  $('.accordion-item .form-switch .form-check-input').change(function () {
    if (this.checked) {
      $(this).parents('.accordion-item').find('.btn-pause').removeClass('d-none');
      $(this).parents('.accordion-item').find('.last-use').addClass('d-none');
      $(this).parents('.accordion-item').find('.timer').removeClass('d-none');
    }else{
      $(this).parents('.accordion-item').find('.last-use').removeClass('d-none');
      $(this).parents('.accordion-item').find('.timer').addClass('d-none');
      $(this).parents('.accordion-item').find('.btn-pause').addClass('d-none');
    }
    if ($('.accordion-item .form-switch .form-check-input:checked').length > 1) {
      var myModal = new bootstrap.Modal(document.getElementById('conflictModal'));
      myModal.show();
    }
  });

});

// *************************************
// *********** POPUP *******************
// *************************************

function submitForm() {
  var obj = document.getElementById('password');
  var res = obj.value.length > 3;

  if (!res) {
    Swal.fire({
      icon: 'error',
      title: 'Invalid password',
      text: 'The password you enetered is invalid. Please try again. Minimum 4 characters...',
      confirmButtonText: 'Close',
      confirmButtonColor: '#669fe0'
    });
    return false;
  }
  window.location.href = 'start-page.html';
  return false;
}

function forgotPassword() {
  Swal.fire({
    title: 'Forgot Password?',
    text: 'Your password is the same password you use to sign in to your Microsoft Services. If uo forgot your password please contact your system administrator.',
    confirmButtonText: 'Close',
    confirmButtonColor: '#669fe0'
  });
}

// *************************************
// *********** CLOCK *******************
// *************************************
var clockEl = document.getElementById('clock');
if (clockEl) {
  runClock();
}
function runClock() {
  var inc = 1000;

  function clock() {
    const date = new Date();

    const hours = ((date.getHours() + 11) % 12 + 1);
    const minutes = date.getMinutes();
    const seconds = date.getSeconds();

    const hour = hours * 30;
    const minute = minutes * 6;
    const second = seconds * 6;

    document.querySelector('.hour').style.transform = `rotate(${hour}deg)`
    document.querySelector('.minute').style.transform = `rotate(${minute}deg)`
    document.querySelector('.second').style.transform = `rotate(${second}deg)`
  }

  setInterval(clock, inc);

}
// *************************************
// *********** CHART *******************
// *************************************
var chartEl = document.getElementById('chart');
if (chartEl) {
  chart();
}

function chart() {
  var labels = [
    'Czas Rozpoczęcia',
    'Event',
    'Calkowity czas pracy'
  ];
  var colorHex = ['#90EE90', '#87CEFA', '#FFD700', '#FF69B4'];
  const ctx = document.getElementById('chart').getContext('2d');
  const myChart = new Chart(ctx, {
    type: 'pie',
    data: {
      datasets: [{
        data: [55, 20, 10, 15],
        backgroundColor: colorHex
      }],
      labels: labels
    },
    options: {
      plugins: {
        legend: {
          display: false
        },
        datalabels: {
          color: 'red'
        }
      }
    }
  });
}