$(document).ready(function () {
  $('.js-btn').click(function(){
    if(!$(this).hasClass('active')){
      $(this).parents('ul').find('.js-btn').removeClass('active');
      $(this).addClass('active');
    }
  });


  
  $('.accordion-item a.btn-pause').click(function(){
    $(this).parents('.accordion-item').find('.form-check-input').removeClass('bg-success').addClass('bg-primary');
    $(this).find('i.mdi-pause-circle-outline').removeClass('mdi-pause-circle-outline text-secondary').addClass('mdi-pause-circle text-primary opacity-100');
  });

  $('.accordion-item .form-switch .form-check-input').change(function () {
    if (this.checked) {
      $(this).removeClass('bg-danger').addClass('bg-success');
      $(this).parents('.accordion-item').find('.btn-pause').removeClass('d-none');
      $(this).parents('.accordion-item').find('.last-use').addClass('d-none');
      $(this).parents('.accordion-item').find('.timer').removeClass('d-none');
    }else{
      $(this).removeClass('bg-success').addClass('bg-danger');
      $(this).parents('.accordion-item').find('.last-use').removeClass('d-none');
      $(this).parents('.accordion-item').find('.timer').addClass('d-none');
      $(this).parents('.accordion-item').find('.btn-pause').addClass('d-none');
      $(this).parents('.accordion-item').find('i').removeClass('mdi-pause-circle-outline mdi-pause-circle text-danger opacity-100').addClass('mdi-pause-circle-outline text-secondary');
    }
    if ($('.accordion-item .form-switch .form-check-input:checked').length > 1) {
      var myModal = new bootstrap.Modal(document.getElementById('conflictModal'));
      myModal.show();
    }
  });

});

// *************************************
// *********** POPUP *******************
// *************************************

function submitForm() {
  var obj = document.getElementById('password');
  var res = obj.value.length > 3;

  if (!res) {
    Swal.fire({
      icon: 'error',
      title: 'Invalid password',
      text: 'The password you enetered is invalid. Please try again. Minimum 4 characters...',
      confirmButtonText: 'Close',
      confirmButtonColor: '#669fe0'
    });
    return false;
  }
  window.location.href = 'start-page.html';
  return false;
}

function forgotPassword() {
  Swal.fire({
    title: 'Forgot Password?',
    text: 'Your password is the same password you use to sign in to your Microsoft Services. If uo forgot your password please contact your system administrator.',
    confirmButtonText: 'Close',
    confirmButtonColor: '#669fe0'
  });
}

// *************************************
// *********** CLOCK *******************
// *************************************
var clockEl = document.getElementById('clock');
if (clockEl) {
  runClock();
}
function runClock() {

        const hr = document.querySelector('.hr')
        const min = document.querySelector('.min')
        const sec = document.querySelector('.sec')
  
        setInterval(() => {
  
            let day = new Date()
            let hour = day.getHours()
            let minutes = day.getMinutes()
            let seconds = day.getSeconds()
  
            let hrrotation = (30 * hour) + (0.5 * minutes);
            let minrotation = 6 * minutes;
            let secrotation = 6 * seconds;
  
            hr.style.transform =
                `translate(-50%,-100%) rotate(${hrrotation}deg)`
            min.style.transform =
                `translate(-50%,-100%) rotate(${minrotation}deg)`
            sec.style.transform =
                `translate(-50%,-85%) rotate(${secrotation}deg)`
        });

      }

// *************************************
// *********** CHART *******************
// *************************************
var chartEl = document.getElementById('chart');
if (chartEl) {
  chart();
}

function chart() {
  var labels = [
    'Czas Rozpoczęcia',
    'Event',
    'Calkowity czas pracy',
    'End'
  ];
  var colorHex = ['#198754', '#0d6efd', '#ffc107', '#dc3545'];
  const ctx = document.getElementById('chart').getContext('2d');
  const myChart = new Chart(ctx, {
    type: 'pie',
    data: {
      datasets: [{
        data: [55, 20, 10, 15],
        backgroundColor: colorHex
      }],
      labels: labels
    },
    options: {
      plugins: {
        legend: {
          display: false
        },
        datalabels: {
          color: 'red'
        }
      }
    }
  });
}