const modal = document.getElementById('modalMain');

/* **************** API RESULT ******************* */
let result = {
    "hidden": {
        "uuid": "726347sdjkhs-nwshjf-k874ryf",
        "current_step": "1"
    },
    "content": [
        {
            "type": "h2",
            "html": "hello, this is my heading",
            "class": "headline-2 text-700 lh-sm text-capitalize mb-4 text-center"
        },
        {
            "type": "p",
            "html": "This is the body paragraph where I can use <strong>HTML<\/strong> elements.",
            "class": "text-md lh-sm text-center mb-5 mb-lg-4 mb-xl-5"
        },
        {
            "type": "p",
            "html": "",
            "class": "text-secondary text-md lh-sm text-center mb-4"
        }
    ],
    "questions": [
        {
            "type": "text",
            "required": true,
            "name": "BusinessName",
            "value": "",
            "placeholder": "Your Business Name",
            "class": "form-control form-control-xl mb-4"
        },
        {
            "type": "select",
            "required": true,
            "name": "BusinessField",
            "value": "",
            "placeholder": "Choose your business field",
            "class": "select-box mb-4 mb-lg-4 mb-xl-5",
            "options": [
                {
                    "text": "Choose your field",
                    "value": "1"
                },
                {
                    "text": "Options-1",
                    "value": "2"
                },
                {
                    "text": "Options-2",
                    "value": "3"
                },
                {
                    "text": "Options-3",
                    "value": "4"
                },
                {
                    "text": "",
                    "value": ""
                }
            ]
        },
        {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "Continue",
            "icon-left": "",
            "icon-right": "far fa-chevron-right ms-3 text-sm",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-primary"
        }
    ],
    "footer": {
        "back": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "",
            "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
            "icon-right": "",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-trasparent w-100"
        },
        "help": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "",
            "icon-left": "",
            "icon-right": "",
            "action": "link",
            "action-data": "tel:+16135550123"
        },
        "next": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "",
            "icon-left": "",
            "icon-right": "far fa-chevron-right ms-3 text-sm",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-primary w-100"
        }
    }
}
/* **************** END API RESULT ******************* */
showModal(result);


function showModal(modalData) {

    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');
    questionList.classList = 'col-10 col-xl-8';
    let modalFooter = document.getElementById('modalFooter');

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].type;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTIONS ****************** */

    let form = document.createElement('form')
    form.action = '';
    form.className = 'text-center';

    questionList.append(form);

    for (let j in modalData.questions) {

        if(modalData.questions[j].type === 'text'){
            let inputText =  createInputText(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value);
            form.append(inputText);

        } else if(modalData.questions[j].type === 'select'){
            let eleSelect = createSelect(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value, modalData.questions[j].options);
            form.append(eleSelect);

        } else if(modalData.questions[j].type === 'button'){
            let button =  createButton(modalData.questions[j].text, modalData.questions[j].action, modalData.questions[j]['action-data'], modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].value, modalData.questions[j].class, modalData.questions[j]['icon-left'], modalData.questions[j]['icon-right']);
            form.append(button);
        }
    }



    console.log(modalData);

    document.querySelectorAll('.tom-select').forEach((el)=>{
        let settings = {};
         new TomSelect(el,settings);
    });
}


/*********************** CREATE ELEMENTY WITH TEXT ***************************/

function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT ***************************/

function createInputText(name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = 'text';
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/

function createSelect(name, placeholder, className, required, value, options) {
    var element= document.createElement('select');
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/

function createButton(text, action, actionData, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 
    element.action = action; 
    element.dataset.action = actionData; 
    element.type = type; 
    element.name = name;
    element.value = value;

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.append(icon);

    }
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if(className){
        element.className = className;
    }

    return element;

}