const modal = document.getElementById('modalMain');

/* **************** API RESULT ******************* */
let result = {
    "hidden": {
        "uuid": "726347sdjkhs-nwshjf-k874ryf",
        "current_step": "1"
    },
    "content": [
        {
            "type": "h2",
            "html": "hello, this is my heading",
            "class": "headline-2 text-700 lh-sm text-capitalize mb-4 text-center"
        },
        {
            "type": "p",
            "html": "This is the body paragraph where I can use <strong>HTML<\/strong> elements.",
            "class": "text-md lh-sm text-center mb-5 mb-lg-4 mb-xl-5"
        },
        {
            "type": "p",
            "html": "",
            "class": "text-secondary text-md lh-sm text-center mb-4"
        }
    ],
    "items": [
        {
            "item_type": "img_checkbox",
            "name": "bussinessType[]",
            "id": "option123",
            "col": "col-12 col-md-6 mb-4",
            "img": "assets/images/icon-popup/shopping-basket.svg",
            "img-alt": "Product Image",
            "text": "Products",
            "text-class": "d-block text-md lh-sm text-500 text-secondary text-capitalize text-center"
        },
        {
            "item_type": "img_checkbox",
            "name": "bussinessType[]",
            "id": "option2321",
            "col": "col-12 col-md-6 mb-4",
            "img": "assets/images/icon-popup/settings.svg",
            "img-alt": "Service Image",
            "text": "Services",
            "text-class": "d-block text-md lh-sm text-500 text-secondary text-capitalize text-center"
        },
        {
            "item_type": "img_checkbox_small",
            "name": "bussinessType[]",
            "id": "option1212",
            "col": "col-12 col-md-6 col-lg-4 mb-4",
            "img": "assets/images/icon-popup/rocket-launch.svg",
            "img-alt": "Product Image",
            "text": "Boost Sales",
            "text-class": "d-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title"
        },
        {
            "item_type": "img_checkbox_small",
            "name": "bussinessType[]",
            "id": "option232231",
            "col": "col-12 col-md-6 col-lg-4 mb-4",
            "img": "assets/images/icon-popup/settings.svg",
            "img-alt": "Service Image",
            "text": "Provide Information",
            "text-class": "d-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title"
        },
        {
            "item_type": "img_checkbox_small",
            "name": "bussinessType[]",
            "id": "option223321",
            "col": "col-12 col-md-6 col-lg-4 mb-4",
            "img": "assets/images/icon-popup/box.svg",
            "img-alt": "Service Image",
            "text": "Show Products",
            "text-class": "d-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title"
        },
        {
            "item_type": "page_checkbox",
            "name": "bussinessType[]",
            "id": "test1",
            "text": "Home Page",
        },
        {
            "item_type": "page_checkbox",
            "name": "bussinessType[]",
            "id": "test23",
            "text": "About Us",
        },
        {
            "item_type": "page_checkbox",
            "name": "bussinessType[]",
            "id": "test33",
            "text": "Contact Us",
        },
        {
            "item_type": "page_checkbox",
            "name": "bussinessType[]",
            "id": "test44",
            "text": "Product Page",
            "checked": true,
            "number" : {
                "type": "number",
                "required": true,
                "name": "quantity[]",
                "value": "1",
                "placeholder": "Your Business Name",
                "class": "text-light text-md lh-sm text-500 border-0 bg-trasparent text-center",
                "btn-minus": "border-0 bg-trasparent text-light btn-step step-down",
                "btn-plus": "border-0 bg-trasparent text-light btn-step step-up",
                "min": "0",
                "step": "1"
            }
        }
    ],
    "questions": [
        {
            "type": "text",
            "required": true,
            "name": "BusinessName",
            "value": "",
            "placeholder": "Your Business Name",
            "class": "form-control form-control-xl mb-4"
        },
        {
            "type": "select",
            "required": true,
            "name": "BusinessField",
            "value": "",
            "placeholder": "Choose your business field",
            "class": "select-box mb-4 mb-lg-4 mb-xl-4",
            "options": [
                {
                    "text": "Choose your business field",
                    "value": ""
                },
                {
                    "text": "option-0",
                    "value": "1"
                },
                {
                    "text": "Options-1",
                    "value": "2"
                },
                {
                    "text": "Options-2",
                    "value": "3"
                },
                {
                    "text": "Options-3",
                    "value": "4"
                }
            ]
        },
        {
            "type": "number",
            "required": true,
            "name": "quantity[]",
            "value": "100",
            "placeholder": "Your Business Name",
            "class": "form-control form-control-xl rounded-3 text-center w-100",
            "btn-minus": "btn btn-lg text-light btn-step step-down position-absolute start-0 top-50 translate-middle-y",
            "btn-plus": "btn btn-lg text-light btn-step step-up position-absolute end-0 top-50 translate-middle-y",
            "min": "0",
            "step": "1"
        },
        {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "Continue",
            "icon-left": "",
            "icon-right": "far fa-chevron-right ms-3 text-sm",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-primary my-3 mt-xl-0"
        }
    ],
    "footer": {
        "back": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "Back",
            "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
            "icon-right": "",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-trasparent w-100"
        },
        "help": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "Need help?",
            "icon-left": "",
            "icon-right": "",
            "action": "link",
            "action-data": "tel:+16135550123",
            "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
        },
        "next": {
            "type": "button",
            "name": "Step",
            "value": "1",
            "text": "Continue",
            "icon-left": "",
            "icon-right": "far fa-chevron-right ms-3 text-sm",
            "action": "submit",
            "action-data": "",
            "class" : "btn btn-xl btn-primary w-100"
        }
    }
}
/* **************** END API RESULT ******************* */
showModal(result);


function showModal(modalData) {

    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');
    questionList.classList.add('col-xl-8');

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].type;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTIONS ****************** */
    let form = document.createElement('form')
    form.action = '';
    form.className = 'text-center';

    questionList.append(form);

    for (let j in modalData.questions) {

        if(modalData.questions[j].type === 'text'){
            let inputText =  createInputText(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value);
            form.append(inputText);

        } else if(modalData.questions[j].type === 'select'){
            let eleSelect = createSelect(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value, modalData.questions[j].options);
            form.append(eleSelect);

        } else if(modalData.questions[j].type === 'button'){
            let button =  createButton(modalData.questions[j].text, modalData.questions[j].action, modalData.questions[j]['action-data'], modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].value, modalData.questions[j].class, modalData.questions[j]['icon-left'], modalData.questions[j]['icon-right']);
            form.append(button);

        } else if(modalData.questions[j].type === 'number'){
            let numberGroup = createInputNumber(modalData.questions[j].value, modalData.questions[j].name, modalData.questions[j].class, modalData.questions[j]['btn-minus'], modalData.questions[j]['btn-plus'], modalData.questions[j].min, modalData.questions[j].step);
            form.append(numberGroup);
        }
    }

    if (modalData.items){
        questionList.classList.remove('col-xl-8');

        let row = document.createElement('div');
        row.className = 'row';

        for( let i in modalData.items){
            if (modalData.items[i].item_type === 'img_checkbox'){
                let checkbox = createCheckbox(modalData.items[i].id, modalData.items[i].name, modalData.items[i].col, modalData.items[i].img, modalData.items[i]['img-alt'], modalData.items[i].text, modalData.items[i]['text-class']);
                row.append(checkbox);
            } else  if (modalData.items[i].item_type === 'page_checkbox'){
                let checkboxWithNumb = createPageCheckbox(modalData.items[i].id, modalData.items[i].name, modalData.items[i].text, modalData.items[i].number);
                row.append(checkboxWithNumb);
            } else if(modalData.items[i].item_type === 'img_checkbox_small'){
                let checkboxSmall = createCheckbox(modalData.items[i].id, modalData.items[i].name, modalData.items[i].col, modalData.items[i].img, modalData.items[i]['img-alt'], modalData.items[i].text, modalData.items[i]['text-class']);
                row.append(checkboxSmall);
            }
        }

        form.append(row);
    }

    /* ******************* FOOTER ****************** */
    showFooter(modalData.footer);
    
  /*  ********************** ADD MY TOM SELECT ************************** */
    document.querySelectorAll('.tom-select').forEach((el)=>{
        let settings = {};
         new TomSelect(el,settings);
    });

    console.log(modalData);

}


/*********************** CREATE FOOTER ***************************/
function showFooter(footer){
    let modalFooter = document.getElementById('modalFooter');

    if (!footer.back && !footer.next){
        modalFooter.classList.add('d-none');

        return;
    }

    if (footer.back) {
        let backBtn = document.getElementById('footerBackDiv');
        let elementBtn = createButton(footer.back.text, footer.back.action, footer.back['action-data'], footer.back.type, footer.back.name, footer.back.value, footer.back.class, footer.back['icon-left'], footer.back['icon-right']);
        backBtn.append(elementBtn);
    }
    if (footer.help) {
        let helpBtn = document.getElementById('footerHelpDiv');
        let elementBtn = createButton(footer.help.text, footer.help.action, footer.help['action-data'], footer.help.type, footer.help.name, footer.help.value, footer.help.class, footer.help['icon-left'], footer.help['icon-right']);
       
        let subText = document.createElement('span');  /**** <--- change line-height and mobile ver. font-size*****/
        subText.innerHTML = 'Speak with someone live';
        subText.className = 'text-sm d-block text-decoration-underline';
        subText.style.fontWeight = '400'; 
        elementBtn.append(subText);

        helpBtn.append(elementBtn);
    }

    if (footer.next) {
        let nextBtn = document.getElementById('footerNextDiv');
        let elementBtn = createButton(footer.next.text, footer.next.action, footer.next['action-data'], footer.next.type, footer.next.name, footer.next.value, footer.next.class, footer.next['icon-left'], footer.next['icon-right']);
        nextBtn.append(elementBtn);
    }
}


/*********************** CREATE ELEMENTY WITH TEXT ***************************/
function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT ***************************/
function createInputText(name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = 'text';
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/
function createSelect(name, placeholder, className, required, value, options) {
    var element= document.createElement('select');
    element.name = name;
    element.setAttribute('placeholder', placeholder);
    element.required = required;
    element.value = value;

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/
function createButton(text, action, actionData, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 
    element.action = action; 
    element.dataset.action = actionData; 
    element.type = type; 
    element.name = name;
    element.value = value;

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.prepend(icon);

    }
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if(className){
        element.className = className;
    }

    return element;

}

// /*********************** CREATE CHECKBOX ***************************/
function createCheckbox(id, name, col, imgLink, imgAlt, text, textClass) {

    let column = document.createElement('div');
    column.className = col;
    

    let element = document.createElement('input');
    element.type = 'checkbox'; 
    element.className = 'btn-check',
    element.id = id;
    element.name = name;
    element.setAttribute('autocomplete', 'off');
    column.append(element);


    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex flex-column justify-content-center align-items-center py-3_5 px-4';
    label.htmlFor = id;
    column.append(label);

    let image = document.createElement('img');
    image.src = imgLink;
    image.alt = imgAlt;
    image.className = 'label-check-icon mb-3';
    image.style.height = '132px';
    label.append(image);

    let textCheckbox = document.createElement('span');
    textCheckbox.innerHTML = text;
    textCheckbox.className = textClass;
    label.append(textCheckbox);

    return column;

}

/*********************** CREATE NUMBER ***************************/
function createInputNumber(value, name, className, btnMinusClass, btnPlusClass, minNum, stepNum, disabled) {

    let inputGroup = document.createElement('div');
    inputGroup.className = 'number-input position-relative text-end';

    let btnMinus = document.createElement('button');
    btnMinus.className = btnMinusClass;
    btnMinus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepDown()');
    inputGroup.append(btnMinus);

    let iconMinus = document.createElement('i');
    iconMinus.className = 'fal fa-minus';
    btnMinus.append(iconMinus);

    let element = document.createElement('input');
    element.type = 'number'; 
    element.value = value;
    element.name = name;
    element.className = className;
    element.setAttribute('min', minNum);
    element.setAttribute('step', stepNum);
    inputGroup.append(element);

    let btnPlus = document.createElement('button');
    btnPlus.className = btnPlusClass;
    btnPlus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepUp()');
    inputGroup.append(btnPlus);

    let iconPlus = document.createElement('i');
    iconPlus.className = 'fal fa-plus';
    btnPlus.append(iconPlus);

    if (disabled){
        btnMinus.disabled = true;
        element.disabled = true;
        btnPlus.disabled = true;
    }

    return inputGroup;

}

/*********************** CREATE PAGE CHECKBOX ***************************/

function createPageCheckbox(id, name, text, number) {
    let col = document.createElement('div');
    col.className =  'col-12 col-lg-6 mb-4';

    let elementCheckbox = document.createElement('input');
    elementCheckbox.type = 'checkbox';
    elementCheckbox.id = id;
    elementCheckbox.name = name;
    elementCheckbox.setAttribute('autocomplete', 'off');
    elementCheckbox.className = 'btn-check btn-check-text';
    col.append(elementCheckbox);

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    label.htmlFor = id;
    col.append(label);
    
    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);

    let nameCheckbox = document.createElement('span');
    nameCheckbox.className = 'checkbox-text text-md lh-sm text-500 text-light';
    nameCheckbox.innerHTML = text;
    div.append(nameCheckbox);


    if (number){
        let inputNumber = createInputNumber(number.value, number.name, number.class, number['btn-minus'], number['btn-plus'], number.min, number.step, true);
        div.append(inputNumber);
        div.className = 'd-flex justify-content-between w-100 align-items-center';

        let divIconText = document.createElement('div');
        divIconText.className = 'd-flex';
        divIconText.append(icon);
        divIconText.append(nameCheckbox);
        div.prepend(divIconText);

        let input = inputNumber.querySelector('input');
        input.style.width = '30px';

        // elementCheckbox.onchange = function(){
        //     let btns = inputNumber.querySelectorAll('button')[0];
        //     console.log(btns);
        // }
   
    }

    /* let colAddPage = document.createElement('div');
    colAddPage.className = 'col-12 text-center'; */
    

    return col;
}