const modal = document.getElementById('modalMain');

/*********************** FUNCTION COUNT ID ***************************/
var id_count = 0;
/* Returns the next unique ID to use */
function nextID() {
    return ++id_count;
}

/*********************** UPDATE CHECKBOX VALUE ***************************/
function updateCheckboxValue(inputText, id) {
    /* get the current input text value */
    /* Set the value of the checkbox to be the text in the input (using the id passed in the function)*/

    document.getElementById(id).value = inputText.value;

}

let currentStep = 0;


/*********************** GET API STEP ***************************/
function getApiStep(step) {

    if (step == 1){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "1",
            },
            "content": [
                {
                    "type": "h2",
                    "html": "Get An Instant <span class=\'text-primary'\>Quote.<\/span>",
                    "class": "headline-2 text-700 lh-sm text-capitalize mb-4 text-center"
                },
                {
                    "type": "p",
                    "html": "Doing business online means different things to different businesses. We've got the tools to get your business online easily.",
                    "class": "text-md lh-sm text-center mb-5 mb-lg-4 mb-xl-5"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                 {
                    "type": "text",
                    "required": true,
                    "name": "BusinessName",
                    "value": "",
                    "placeholder": "Your business name",
                    "class": "form-control form-control-xl mb-4"
                }, 
                {
                    "type": "select",
                    "required": true,
                    "name": "BusinessField",
                    "value": "",
                    "placeholder": "Choose your business field",
                    "class": "select-box mb-4 mb-lg-4 mb-xl-4",
                    "options": [
                        {
                            "text": "Choose your business field",
                            "value": ""
                        },
                        {
                            "text": "option-0",
                            "value": "1"
                        },
                        {
                            "text": "Options-1",
                            "value": "2"
                        },
                        {
                            "text": "Options-2",
                            "value": "3"
                        },
                        {
                            "text": "Options-3",
                            "value": "4"
                        }
                    ]
                },
                {
                    "type": "button",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary my-4"
                }
            ],
            "footer": {}
        }
    } else if (step == 2){

        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "2"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "Do you sell <span class=\"d-md-block\">product or services?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "Doing business online means different things to different businesses. We've got the tools to get your business online easily.",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Check all boxes that apply)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "checkbox",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "item_type": "img_checkbox",
                            "value": "option23",
                            "checked": false, 
                            "img": "assets/images/icon-popup/shopping-basket.svg",
                            "img-alt": "Product Image",
                            "text": "Products"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option2321",
                            "checked": false,
                            "img": "assets/images/icon-popup/settings.svg",
                            "img-alt": "Service Image",
                            "text": "Services"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 3){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "3"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "How many product/services <span class=\"d-md-block\">are you selling?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "Doing business online means different things to different businesses. We've got the tools to get your business online easily.",
                    "class": "text-md lh-sm text-center mb-3"
                },
                {
                    "type": "p",
                    "html": "(Type a number)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "number",
                    "required": true,
                    "name": "quantity[]",
                    "value": "100",
                    "placeholder": "Your Business Name",
                    "class": "form-control form-control-xl rounded-3 text-center w-100 mb-4",
                    "btn-minus": "btn btn-lg text-light btn-step step-down position-absolute start-0 top-50 translate-middle-y",
                    "btn-plus": "btn btn-lg text-light btn-step step-up position-absolute end-0 top-50 translate-middle-y",
                    "min": "0",
                    "step": "1"
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 4){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "4"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "What are you looking to <span class=\"d-md-block\">product or services?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": ""
                },
                {
                    "type": "p",
                    "html": "(Check all boxes that apply)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "checkbox",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "item_type": "img_checkbox",
                            "value": "option23",
                            "checked": false, 
                            "img": "assets/images/icon-popup/rocket-launch.svg",
                            "img-alt": "Boost Sales",
                            "text": "Boost Sales"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option2321",
                            "checked": false,
                            "img": "assets/images/icon-popup/settings.svg",
                            "img-alt": "Provide Information",
                            "text": "Provide Information"
                        },
                         {
                            "item_type": "img_checkbox",
                            "value": "option1212",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Show Products",
                            "text": "Show Products"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option232231",
                            "checked": false,
                            "img": "assets/images/icon-popup/settings.svg",
                            "img-alt": "Service Image",
                            "text": "Provide Information"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option223321",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option22asasas",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 5){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "5"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "What kind of sections do you want <span class=\"d-md-block\">to include on your website?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Check all boxes that apply)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "checkbox",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "item_type": "img_checkbox",
                            "value": "option23",
                            "checked": false, 
                            "img": "assets/images/icon-popup/4-Line.svg",
                            "img-alt": "About Us",
                            "text": "Testimonials"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option2321",
                            "checked": false,
                            "img": "assets/images/icon-popup/Side-Pic-and-Info.svg",
                            "img-alt": "Provide Information",
                            "text": "Testimonials"
                        },
                         {
                            "item_type": "img_checkbox",
                            "value": "option1212",
                            "checked": false,
                            "img": "assets/images/icon-popup/Gallery-4x125.svg",
                            "img-alt": "Show Products",
                            "text": "Gallery"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option232231",
                            "checked": false,
                            "img": "assets/images/icon-popup/settings.svg",
                            "img-alt": "Service Image",
                            "text": "Provide Information"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option223321",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option22asasas",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 6){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "6"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "What features do you want <span class=\"d-md-block\">on your website?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Check all boxes that apply)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "checkbox",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "item_type": "img_checkbox",
                            "value": "option23",
                            "checked": false, 
                            "img": "assets/images/icon-popup/shopping-cart.svg",
                            "img-alt": "About Us",
                            "text": "Shopping Cart"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option2321",
                            "checked": false,
                            "img": "assets/images/icon-popup/heart.svg",
                            "img-alt": "Provide Information",
                            "text": "Social Media Intgrations"
                        },
                         {
                            "item_type": "img_checkbox",
                            "value": "option1212",
                            "checked": false,
                            "img": "assets/images/icon-popup/card-payment.svg",
                            "img-alt": "Show Products",
                            "text": "Payment Gateways"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option232231",
                            "checked": false,
                            "img": "assets/images/icon-popup/settings.svg",
                            "img-alt": "Service Image",
                            "text": "Provide Information"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option223321",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        },
                        {
                            "item_type": "img_checkbox",
                            "value": "option22asasas",
                            "checked": false,
                            "img": "assets/images/icon-popup/box.svg",
                            "img-alt": "Service Image",
                            "text": "Show Products"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 7){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "7"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "What style of <span class=\"d-md-block\">website do you want?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Choose one option below)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "radio",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "value": "option4545",
                            "checked": false, 
                            "img": "assets/images/icon-popup/file.svg",
                            "img-alt": "Product Image",
                            "text": "Single Page"
                        },
                        {
                            "value": "option6767",
                            "checked": false, 
                            "img": "assets/images/icon-popup/papers.svg",
                            "img-alt": "Product Image",
                            "text": "Multi Page"
                        }
                    ]
                },
                {
                    "type": "button",
                    "name": "help_button",
                    "value": "",
                    "text": "I’m not sure, help me decide what what style I need",
                    "icon-left": "icon-message-question me-sm-4 fs-2",
                    "icon-right": "",
                    "action": "",
                    "action-data": "",
                    "class" : "btn p-0 text-md lh-sm text-center text-500 text-secondary mb-4 d-flex align-items-md-center m-auto"
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 8){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "8"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "Will you be supplying us with text or would you like us to generate a professional website text for you?",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Choose one option below)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "radio",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "value": "option4545",
                            "checked": false, 
                            "img": "assets/images/icon-popup/file-check.svg",
                            "img-alt": "Product Image",
                            "text": "I will supply thefinal text"
                        },
                        {
                            "value": "option6767",
                            "checked": false, 
                            "img": "assets/images/icon-popup/file-add.svg",
                            "img-alt": "Product Image",
                            "text": "I will supply key points"
                        },
                        {
                            "value": "option6767",
                            "checked": false, 
                            "img": "assets/images/icon-popup/file-search.svg",
                            "img-alt": "Product Image",
                            "text": "I would like you to prepare the text"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 9){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "9"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "Do you have images you <span class=\"d-md-block\">want to include on the website?<\/span>",
                    "class": "headline-4 text-700 lh-sm mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Choose one option below)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "radio",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "value": "option4545",
                            "checked": false, 
                            "img": "assets/images/icon-popup/image.svg",
                            "img-alt": "Product Image",
                            "text": "Yes, I have images"
                        },
                        {
                            "value": "option6767",
                            "checked": false, 
                            "img": "assets/images/icon-popup/image-gallery.svg",
                            "img-alt": "Product Image",
                            "text": "No, I would like to use stock images"
                        }
                    ]
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 10){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "10"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "Where Should We Send <span class=\"text-primary fst-italic text-900\">Your Estimate<\/span>?",
                    "class": "headline-4 text-800 lh-sm text-capitalize mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Choose one option below)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "text",
                    "required": true,
                    "name": "BusinessName",
                    "value": "",
                    "placeholder": "Your Name",
                    "class": "form-control form-control-xl mb-4"
                }, 
                {
                    "type": "email",
                    "required": true,
                    "name": "BusinessName",
                    "value": "",
                    "placeholder": "Your Mail",
                    "class": "form-control form-control-xl mb-4"
                },
                {
                    "type": "text",
                    "required": true,
                    "name": "BusinessName",
                    "value": "",
                    "placeholder": "Your Phone Number",
                    "class": "form-control form-control-xl mb-4"
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 11){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "11"
            },
            "content": [
                {
                    "type": "h4",
                    "html": "What pages do you want <span class=\"d-md-block\">to have on your website?<\/span>",
                    "class": "headline-4 text-700 lh-sm text-capitalize mb-3 text-center"
                },
                {
                    "type": "p",
                    "html": "",
                    "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                },
                {
                    "type": "p",
                    "html": "(Choose one option below)",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "checkbox",
                    "required": true,
                    "name": "bussinessType",
                    "class": "",
                    "items": [
                        {
                            "item_type": "page_checkbox",
                            "value": "test1",
                            "checked": false,
                            "text": "Home Page",
                        },
                        {
                            "item_type": "page_checkbox",
                            "value": "test23",
                            "checked": false,
                            "text": "About Us",
                        },
                        {
                            "item_type": "page_checkbox",
                            "value": "test33",
                            "checked": false,
                            "text": "Contact Us",
                        },
                        {
                            "item_type": "page_checkbox",
                            "value": "test44",
                            "text": "Product Page",
                            "checked": false,
                            "number" : {
                                "type": "number",
                                "required": true,
                                "name": "quantity[]",
                                "value": "1",
                                "class": "text-light text-md lh-sm text-500 border-0 bg-trasparent text-center",
                                "btn-minus": "border-0 bg-trasparent text-light btn-step step-down",
                                "btn-plus": "border-0 bg-trasparent text-light btn-step step-up",
                                "min": "0",
                                "step": "1"
                            }
                        },
                        {
                            "item_type": "page_checkbox",
                            "value": "test44",
                            "checked": false,
                            "text": "Get A Quote",
                        }
                    ]
                },
                {
                    "type": "button",
                    "name": "add_page",
                    "value": "",
                    "text": "Add New Page",
                    "icon-left": "icon-note-remove1 d-md-inline fs-2 me-3",
                    "icon-right": "",
                    "action": "",
                    "action-data": "",
                    "class" : "btn btn-lg text-primary border border-2 border-primary rounded-4 font-500 mb-4 d-flex align-items-center m-auto"
                }
            ],
            "footer": {
                "back": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Back",
                    "text": "Back",
                    "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                    "icon-right": "",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-trasparent w-100"
                },
                "help": {
                    "type": "button",
                    "name": "",
                    "value": "",
                    "text": "Need help?",
                    "icon-left": "",
                    "icon-right": "",
                    "action": "link",
                    "action-data": "tel:+16135550123",
                    "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                },
                "next": {
                    "type": "submit",
                    "name": "Step",
                    "value": "Next",
                    "text": "Continue",
                    "icon-left": "",
                    "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                    "action": "submit",
                    "action-data": "",
                    "class" : "btn btn-xl btn-primary w-100"
                }
            }
        }
    } else if (step == 12){
        return {
            "hidden": {
                "uuid": "726347sdjkhs-nwshjf-k874ryf",
                "current_step": "12"
            },
            "content": [
                {
                    "type": "h2",
                    "html": "Your estimate <span class=\"d-md-inline-block\">has been <span class=\"text-primary fst-italic text-900\">sent?<\/span><\/span>",
                    "class": "headline-2 text-800 lh-sm text-capitalize mb-4 text-center"
                },
                {
                    "type": "p",
                    "html": "Your estimate has been generated and sent to your email address: user@host.com",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                },
                {
                    "type": "p",
                    "html": "If you do not see and e-mail from us with a copy of your estimate in the next couple minutes, please check your Junk / SPAM folder incase it landed up in there.",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                },
                {
                    "type": "p",
                    "html": "If after 5 minutes you still don’t see an e-mail in your Inbox or in your Junk / SPAM folder, please contact us directly and we will resend a copy of your estimate.",
                    "class": "text-secondary text-md lh-sm text-center mb-6"
                }
            ],
            "questions": [
                {
                    "type": "button",
                    "items": [
                        {
                            "name": "",
                            "value": "",
                            "text": "Call Us",
                            "icon-left": "",
                            "icon-right": "",
                            "action": "",
                            "action-data": "tel:+16135550123",
                            "class" : "btn btn-xl btn-outline-primary me-1 me-md-3 mb-4"
                        },
                        {
                            "name": "",
                            "value": "",
                            "text": "Finish",
                            "icon-left": "",
                            "icon-right": "",
                            "action": "",
                            "action-data": "",
                            "class" : "btn btn-xl btn-primary ms-1 ms-md-3 mb-4"
                        }
                    ]
                }
            ],
            "footer": {}
        }
    }
}

/* **************** END API RESULT ******************* */
showModal(1);

function showModal(step) {
    let modalData = getApiStep(step);
    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');
    
    contentHeader.innerHTML = '';
    questionList.innerHTML = '';

   /* ******************* HEADER EXTRA PADDING STEP 1 ****************** */
    if (modalData.hidden.current_step == 1) {
        contentHeader.className = 'col-10 col-xl-8 pt-5 pt-lg-4 pt-xl-5';
    } else {
        contentHeader.className = 'col-10 col-xl-8';
    }

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].type;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTIONS ****************** */
    let col = document.createElement('div');
    col.className = 'col-10'
    questionList.append(col);

    for (let j in modalData.questions) {
        if(modalData.questions[j].type === 'text' || modalData.questions[j].type === 'email'){
            col.classList.add('col-xl-8');

            let input =  createInputTextAndEmail(modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value);
            col.append(input);
        } else if(modalData.questions[j].type === 'select'){
            col.classList.add('col-xl-8');

            let eleSelect = createSelect(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value, modalData.questions[j].options);
            col.append(eleSelect);

        }else if(modalData.questions[j].type === 'number'){
            col.classList.add('col-xl-8');

            let numberGroup = createInputNumber(modalData.questions[j].value, modalData.questions[j].name, modalData.questions[j].class, modalData.questions[j]['btn-minus'], modalData.questions[j]['btn-plus'], modalData.questions[j].min, modalData.questions[j].step);
            col.append(numberGroup);
        } else if(modalData.questions[j].type === 'button'){
            if (modalData.questions[j].items) {
                col.classList.add('text-center');

                let items = modalData.questions[j].items;
                for(let q in items){
                    let btn = items[q];
                    let button =  createButton(btn.text, btn.action, btn['action-data'], 'button', btn.name, btn.value, btn.class, btn['icon-left'], btn['icon-right']);
    
                    if (btn.text === 'Finish'){
                        button.setAttribute('data-bs-dismiss', 'modal');
                    }   

                    col.append(button);
                }
            } else {
                col.classList.add('text-center');

                let button =  createButton(modalData.questions[j].text, modalData.questions[j].action, modalData.questions[j]['action-data'], modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].value, modalData.questions[j].class, modalData.questions[j]['icon-left'], modalData.questions[j]['icon-right']);
                if (modalData.questions[j].name === 'add_page'){
                    button.setAttribute('onClick', 'addNewPage(this)');
                } else if(modalData.questions[j].value === 'Next'){
                    /* ******** NEXT STEP ***** */
                    let nextStep = parseInt(modalData.hidden.current_step)+1;
                    button.setAttribute('onClick', `showModal(${nextStep})`);
                     
                    animateModalContent(button); 
                }
                col.append(button);
            }
        } else if(modalData.questions[j].type === 'checkbox'){
            let items = modalData.questions[j].items;
            let name = modalData.questions[j].name;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row);

            for( let a in items){

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-md-6 mb-4';

                let item = items[a];
                             
                if (item.item_type === 'img_checkbox'){
                    
                    let itemCount = items.filter(item => item.item_type =='img_checkbox').length;
                    if(!(itemCount < 3 || itemCount == 4)){
                        checkboxCol.classList.add('col-xl-4');
                    }
                       
                    let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                    let {input, label} = createCheckbox(item.value, modalData.questions[j].type, name, item.img, item['img-alt'], item.text, textClass, item.checked);
                    checkboxCol.append(input);
                    checkboxCol.append(label);

                } else  if (item.item_type === 'page_checkbox'){
                    let {input, label} = createPageCheckbox(item.value, name, item.text, item.number, item.checked);
                    checkboxCol.append(input);
                    checkboxCol.append(label);

                }

                row.append(checkboxCol);
            }

        } else if(modalData.questions[j].type === 'radio'){
            let items = modalData.questions[j].items;
            let name = modalData.questions[j].name;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row);

            for( let b in items){

                let radioCol = document.createElement('div');
                radioCol.className = 'col-12 col-md-6 mb-4';

                if(!(items.length < 3 || items.length == 4)){
                    radioCol.classList.add('col-xl-4');
                }
                let item = items[b];
                   
                let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                let {input, label} = createCheckbox(item.value, modalData.questions[j].type, name, item.img, item['img-alt'], item.text, textClass, item.checked);
                radioCol.append(input);
                radioCol.append(label);
                row.append(radioCol);
            }
        }
    }


    /* ******************* FOOTER ****************** */
    showFooter(modalData.footer, modalData.hidden.current_step);
    
    /* *********************** ADD MY TOM SELECT ************************** */
    document.querySelectorAll('.tom-select').forEach((el)=>{
        let settings = {};
         new TomSelect(el,settings);
    });

}
/* ******************* ANIMATION MODAL CONTENT ****************** */
function animateModalContent(btn) {
    let questionList = document.getElementById('questionList');
   
    btn.addEventListener('click', () => {
        questionList.classList.add('animate-modal');
        setTimeout(function() {
            questionList.classList.remove('animate-modal');
          }, 500);
      });
}


/*********************** CREATE FOOTER ***************************/
function showFooter(footer, step){
    let modalFooter = document.getElementById('modalFooter');
  
    modalFooter.classList.add('d-none');

    if (footer.back && footer.next){
        modalFooter.classList.remove('d-none');
        
        if (footer.back) {
            let backBtnDiv = document.getElementById('footerBackDiv');
            backBtnDiv.innerHTML = '';
            let elementBtn = createButton(footer.back.text, footer.back.action, footer.back['action-data'], footer.back.type, footer.back.name, footer.back.value, footer.back.class, footer.back['icon-left'], footer.back['icon-right']);
            backBtnDiv.append(elementBtn);
        }
        if (footer.help) {
            let helpBtnDiv = document.getElementById('footerHelpDiv');
            helpBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.help.text, footer.help.action, footer.help['action-data'], footer.help.type, footer.help.name, footer.help.value, footer.help.class, footer.help['icon-left'], footer.help['icon-right']);
           
            let subText = document.createElement('span');  
            subText.innerHTML = 'Speak with someone live';
            subText.className = 'button text-sm d-block text-decoration-underline';
            subText.style.fontWeight = '400'; 
            elementBtn.append(subText);
    
            helpBtnDiv.append(elementBtn);
        }
    
        if (footer.next) {
            let nextBtnDiv = document.getElementById('footerNextDiv');
            nextBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.next.text, footer.next.action, footer.next['action-data'], footer.next.type, footer.next.name, footer.next.value, footer.next.class, footer.next['icon-left'], footer.next['icon-right']);
            /* ******** NEXT STEP ***** */
            let nextStep = parseInt(step)+1;
            elementBtn.setAttribute('onClick', `showModal(${nextStep})`);

            animateModalContent(elementBtn);

            nextBtnDiv.append(elementBtn);
        }
    }

    
}

/*********************** CREATE ELEMENTY WITH TEXT ***************************/
function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT AND MAIL ***************************/
function createInputTextAndEmail(type, name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = type;
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/
function createSelect(name, placeholder, className, required, value, options) {
    var element= document.createElement('select');
    element.name = name;
    element.setAttribute('placeholder', placeholder);
    element.required = required;
    element.value = value;

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/
function createButton(text, action, actionData, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 
    element.action = action; 
    element.dataset.action = actionData; 
    element.type = type; 
    element.name = name;
    element.value = value;

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.prepend(icon);

    }
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if(className){
        element.className = className;
    }

    return element;

}

/*********************** CREATE INPUT NUMBER ***************************/
function createInputNumber(value, name, className, btnMinusClass, btnPlusClass, minNum, stepNum, disabled) {

    let inputGroup = document.createElement('div');
    inputGroup.className = 'number-input position-relative text-end';

    let btnMinus = document.createElement('button');
    btnMinus.className = btnMinusClass;
    btnMinus.type = 'button';
    btnMinus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepDown()');
    inputGroup.append(btnMinus);

    let iconMinus = document.createElement('i');
    iconMinus.className = 'fal fa-minus';
    btnMinus.append(iconMinus);

    let element = document.createElement('input');
    element.type = 'number'; 
    element.value = value;
    element.name = name;
    element.className = className;
    element.setAttribute('min', minNum);
    element.setAttribute('step', stepNum);
    inputGroup.append(element);

    let btnPlus = document.createElement('button');
    btnPlus.className = btnPlusClass;
    btnPlus.type = 'button';
    btnPlus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepUp()');
    inputGroup.append(btnPlus);

    let iconPlus = document.createElement('i');
    iconPlus.className = 'fal fa-plus';
    btnPlus.append(iconPlus);

    if (disabled){
        btnMinus.disabled = true;
        element.disabled = true;
        btnPlus.disabled = true;
    }

    return inputGroup;

}

// /*********************** CREATE CHECKBOX ***************************/
function createCheckbox(value, type, name, imgLink, imgAlt, text, textClass) {

    let input = document.createElement('input');
    input.type = type; 
    input.className = 'btn-check',
    input.value = value;
    input.id = value;
    input.name = name;
    input.setAttribute('autocomplete', 'off');

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex flex-column justify-content-center align-items-center py-3_5 px-4';
    label.htmlFor = value;

    let image = document.createElement('img');
    image.src = imgLink;
    image.alt = imgAlt;
    image.className = 'label-check-icon mb-3';
    image.style.height = '132px';
    label.append(image);

    let textCheckbox = document.createElement('span');
    textCheckbox.innerHTML = text;
    textCheckbox.className = textClass;
    label.append(textCheckbox);

    return {input, label};
}

/*********************** CREATE PAGE CHECKBOX ***************************/
function createPageCheckbox(value, name, text, number) {
 
    let input = document.createElement('input');
    input.type = 'checkbox';
    input.id = value;
    input.value = value;
    input.name = name;
    input.setAttribute('autocomplete', 'off');
    input.className = 'btn-check btn-check-text';

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    label.htmlFor = value;
    
    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);

    let nameCheckbox = document.createElement('span');
    nameCheckbox.className = 'checkbox-text text-md lh-sm text-500 text-light';
    nameCheckbox.innerHTML = text;
    div.append(nameCheckbox);


    if (number){
        let inputNumberBlock = createInputNumber(number.value, number.name, number.class, number['btn-minus'], number['btn-plus'], number.min, number.step, true);
        div.append(inputNumberBlock);
        div.className = 'd-flex justify-content-between w-100 align-items-center';

        let divIconText = document.createElement('div');
        divIconText.className = 'd-flex';
        divIconText.append(icon);
        divIconText.append(nameCheckbox);
        div.prepend(divIconText);

        let inputNumber = inputNumberBlock.querySelector('input');
        inputNumber.style.width = '30px';

        input.onchange = function() {
        var numberElements = this.parentNode.querySelector('.number-input').children;
        let elDisabled = !this.checked;
            for(let el in numberElements ) {
                numberElements[el].disabled = elDisabled;
            }
        };
   
    }

    return {input, label};
}

/*********************** BUTTON ADD NEW PAGE ***************************/
function addNewPage(btn){

    var id = nextID();

    let col = document.createElement('div');
    col.className = 'col-12 col-md-6 mb-4'
    
    let inputCheckbox = document.createElement('input');
    inputCheckbox.type = 'checkbox';
    /*Add name*/
    inputCheckbox.name = ''; /* <--  ???name*/  
    /*Add vlaue*/
    inputCheckbox.value = '';
    inputCheckbox.className = 'btn-check btn-check-text';
    inputCheckbox.checked = true;
    inputCheckbox.id = `newPage-${id}`;
    col.append(inputCheckbox);

    let label = document.createElement('label');
    label.setAttribute('for' , `newPage-${id}`);
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    col.append(label);

    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);
   
    let inputText = document.createElement('input');
    inputText.type = 'text';
    inputText.value = '';
    inputText.id = nextID();
    inputText.setAttribute('onchange', `updateCheckboxValue(this, '${inputCheckbox.id}')`);
    inputText.placeholder = 'Your site';
    inputText.className = 'checkbox-text inputValid border-0 text-md lh-sm text-500 text-light bg-transparent';
    div.append(inputText);

    btn.parentNode.querySelector('.row').append(col);

    document.getElementById(`newPage-${id}`).focus();

}