const modal = document.getElementById('modalMain');

/*********************** FUNCTION COUNT ID ***************************/
var id_count = 0;
/* Returns the next unique ID to use */
function nextID() {
    return ++id_count;
}

/*********************** UPDATE CHECKBOX VALUE ***************************/
function updateCheckboxValue(inputText, id) {

    let checkbox = document.getElementById(id);
    checkbox.value = inputText.value;

    let label = inputText.parentElement.parentElement;

    let checkboxListContainer = document.getElementById('checkboxList');

    let inputCheckboxes = checkboxListContainer.querySelectorAll('input[type="checkbox"]');

    let count = 0;

    for (const inputCheckbox of inputCheckboxes) {
        if (inputCheckbox.value.toLowerCase() === checkbox.value.toLowerCase()){
            count++;
        }
    }

    if (count > 1){
        label.classList.add('checkbox-invalid');
        inputText.style.setProperty('color', 'red', 'important');
        checkbox.checked = false;
        checkbox.disabled = true;

    } else {
        label.classList.remove('checkbox-invalid');
        inputText.style.color = '#815AF0';
        checkbox.disabled = false;
    }
}


/*********************** CHECKBOX INPUT FOCUS OUT ***************************/
function checkboxInputFocusOut(inputText) {

    let element = inputText;

    let inputCheckbox = inputText.closest('.col-page-checkbox').querySelector('input[type="checkbox"]');

    if (element.value == 0){
        inputCheckbox.checked = false;
    } else if (!inputText.closest('.col-page-checkbox').querySelector('label.checkbox-invalid')){
        inputCheckbox.checked = true;
    }
}


function chekedValidation() {
    
}

/*********************** GET API ***************************/
function callApiPost(action, callback){
    let url = 'https://ivannah.buildmy.ca/private/webarray/BuildMy_ca/api/api.php';
    if (action){
        url = url + `?action=${action}`;
    }
    var xhr = new XMLHttpRequest();
    xhr.open('POST', url, true);
    xhr.onload = function() {

       var jsonData = JSON.parse(xhr.responseText);
       if(callback) callback(jsonData);
 
       if (xhr.readyState == 4 && xhr.status == 200) {
          console.log('ok');
     }  else {
           console.log('error');
     }};
     
     var formData = new FormData(document.getElementById('estimate-form')); 
     xhr.send(formData);

    }

/*********************** GET API STEP ***************************/

getApi('');

function getApi(step){

    callApiPost(step, function(jsonData){
        if(jsonData.status.code == 200){
            if (jsonData.result.hidden.current_step == 4){
                let jsonTest = {
                    "hidden": {
                        "uuid": "726347sdjkhs-nwshjf-k874ryf",
                        "current_step": "4"
                    },
                    "content": [
                        {
                            "type": "h4",
                            "html": "What pages do you want <span class=\"d-md-block\">to have on your website?<\/span>",
                            "class": "headline-4 text-700 lh-sm text-capitalize mb-3 text-center"
                        },
                        {
                            "type": "p",
                            "html": "",
                            "class": "text-md lh-sm text-center mb-3 mb-lg-4"
                        },
                        {
                            "type": "p",
                            "html": "(Choose one option below)",
                            "class": "text-secondary text-md lh-sm text-center mb-6"
                        }
                    ],
                    "questions": [
                        {
                            "type": "page_checkbox",
                            "required": true,
                            "name": "bussinessType",
                            "options": [
                                {
                                    "value": "test1",
                                    "checked": false,
                                    "text": "Home Page",
                                },
                                {
                                    "value": "test23",
                                    "checked": false,
                                    "text": "About Us",
                                },
                                {
                                    "value": "test33",
                                    "checked": false,
                                    "text": "Contact Us",
                                },
                                {
                                    "value": "test44",
                                    "text": "Product Page",
                                    "checked": false,
                                    "number" : {
                                        "type": "number",
                                        "required": true,
                                        "name": "quantity[]",
                                        "value": "1",
                                        "class": "text-light text-md lh-sm text-500 border-0 bg-trasparent text-center",
                                        "btn-minus": "border-0 bg-trasparent text-light btn-step step-down",
                                        "btn-plus": "border-0 bg-trasparent text-light btn-step step-up",
                                        "min": "0",
                                        "step": "1"
                                    }
                                },
                                {
                                    "value": "test234",
                                    "checked": false,
                                    "text": "Get A Quote",
                                }
                            ]
                        },
                        {
                            "type": "button",
                            "name": "add_page",
                            "value": "",
                            "text": "Add New Page",
                            "icon-left": "icon-note-remove1 d-md-inline fs-2 me-3",
                            "icon-right": "",
                            "action": "",
                            "action-data": "",
                            "class" : "btn btn-lg text-primary border border-2 border-primary rounded-4 font-500 mb-4 d-flex align-items-center m-auto"
                        }
                    ],
                    "footer": {
                        "back": {
                            "type": "submit",
                            "name": "Step",
                            "value": "Back",
                            "text": "Back",
                            "icon-left": "far fa-chevron-left me-3 text-sm d-none d-md-inline",
                            "icon-right": "",
                            "action": "submit",
                            "action-data": "",
                            "class" : "btn btn-xl btn-trasparent w-100"
                        },
                        "help": {
                            "type": "button",
                            "name": "",
                            "value": "",
                            "text": "Need help?",
                            "icon-left": "",
                            "icon-right": "",
                            "action": "link",
                            "action-data": "tel:+16135550123",
                            "class" : "button lh-sm text-md text-700 text-secondary-50 border-0 bg-transparent"
                        },
                        "next": {
                            "type": "submit",
                            "name": "Step",
                            "value": "Next",
                            "text": "Continue",
                            "icon-left": "",
                            "icon-right": "far fa-chevron-right ms-3 text-sm d-none d-md-inline",
                            "action": "submit",
                            "action-data": "",
                            "class" : "btn btn-xl btn-primary w-100"
                        }
                    }
                }
                showModal(jsonTest);
            } else{
                showModal(jsonData.result);

                animateModalContent(step);
            }
       
        }
     });
 }

/* **************** END API RESULT ******************* */

function showModal(modalData) {

    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');
    
    contentHeader.innerHTML = '';
    questionList.innerHTML = '';

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].type;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTIONS ****************** */
    let col = document.createElement('div');
    col.className = 'col-10'
    questionList.append(col);

    for (let j in modalData.questions) {
        if(modalData.questions[j].type === 'text' || modalData.questions[j].type === 'email'){
            col.classList.add('col-xl-8');

            let input =  createInputTextAndEmail(modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value);
            col.append(input);
        } else if(modalData.questions[j].type === 'select'){
            col.classList.add('col-xl-8');

            let eleSelect = createSelect(modalData.questions[j].name, modalData.questions[j].placeholder, modalData.questions[j].class, modalData.questions[j].required, modalData.questions[j].value, modalData.questions[j].options);
            col.append(eleSelect);

        } else if(modalData.questions[j].type === 'number'){
            col.classList.add('col-xl-8');

            let numberGroup = createInputNumber(modalData.questions[j].value, modalData.questions[j].name, modalData.questions[j].class,  modalData.questions[j].min, modalData.questions[j].step);
            col.append(numberGroup);
        } else if(modalData.questions[j].type === 'button'){
            if (modalData.questions[j].items) {
                col.classList.add('text-center');

                let items = modalData.questions[j].items;
                for(let q in items){
                    let btn = items[q];
                    let button =  createButton(btn.text, btn.action, btn['action-data'], 'button', btn.name, btn.value, btn.class, btn['icon-left'], btn['icon-right']);
    
                    if (btn.text === 'Finish'){
                        button.setAttribute('data-bs-dismiss', 'modal');
                    }   

                    col.append(button);
                }
            } else {
                col.classList.add('text-center');

                let button =  createButton(modalData.questions[j].text, modalData.questions[j].action, modalData.questions[j]['action-data'], modalData.questions[j].type, modalData.questions[j].name, modalData.questions[j].value, modalData.questions[j].class, modalData.questions[j]['icon-left'], modalData.questions[j]['icon-right']);
                if (modalData.questions[j].name === 'add_page'){
                    button.setAttribute('onClick', 'addNewPage(this)');
                } else if(modalData.questions[j].value === 'next'){
                    button.setAttribute('onClick', 'getApi("next")');
                }
                col.append(button);
            }
        } else if(modalData.questions[j].type === 'image_checkbox'){

            let name = modalData.questions[j].name;
            let items = modalData.questions[j].options;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row); 

            
            for( let a in items){

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-md-6 mb-4';
                
                if(!(items.length < 3 || items.length == 4)){
                    checkboxCol.classList.add('col-xl-4');
                }

                let item = items[a];

                let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                let {input, label} = createCheckbox(item.value, item.selected, item.text, name, item.image, item.image_alt, item.input,textClass);
                checkboxCol.append(input);
                checkboxCol.append(label);

                row.append(checkboxCol);

            }

        } else  if (modalData.questions[j].type === 'page_checkbox'){

            let name = modalData.questions[j].name;
            let items = modalData.questions[j].options;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row); 

            
            for( let s in items){
                row.id = 'checkboxList';

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-md-6 mb-4';
                

                let item = items[s];

                let {input, label} = createPageCheckbox(name, item.text, item.number, item.checked);
                checkboxCol.append(input);
                checkboxCol.append(label);
            
                row.append(checkboxCol);


            }

        } else if(modalData.questions[j].type === 'radio'){
            let items = modalData.questions[j].items;
            let name = modalData.questions[j].name;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row);

            for( let b in items){

                let radioCol = document.createElement('div');
                radioCol.className = 'col-12 col-md-6 mb-4';

                if(!(items.length < 3 || items.length == 4)){
                    radioCol.classList.add('col-xl-4');
                }
                let item = items[b];
                   
                let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                let {input, label} = createCheckbox(item.value, modalData.questions[j].type, name, item.img, item['img-alt'], item.text, textClass, item.checked);
                radioCol.append(input);
                radioCol.append(label);
                row.append(radioCol);
            }
        }
    }


    /* ******************* FOOTER ****************** */
    showFooter(modalData.footer); 
    
    /* *********************** ADD MY TOM SELECT ************************** */
    document.querySelectorAll('.tom-select').forEach((el)=>{
        let settings = {};
         new TomSelect(el,settings);
    });

}
/* ******************* ANIMATION MODAL CONTENT ****************** */
function animateModalContent(step) {
    let questionList = document.getElementById('questionList');
    if (step == 'next'){
        questionList.classList.add('animate-modal');
        setTimeout(function() {
            questionList.classList.remove('animate-modal');
          }, 500);
    } /* else if (step == 'back'){
        questionList.classList.add('animate-modal-back');
        setTimeout(function() {
            questionList.classList.remove('animate-modal-back');
        }, 500);
    } */
}


/*********************** CREATE FOOTER ***************************/
function showFooter(footer){
    let modalFooter = document.getElementById('modalFooter');
  
    modalFooter.classList.add('d-none');

    if (footer.back && footer.next){
        modalFooter.classList.remove('d-none');
        
        if (footer.back) {
            let backBtnDiv = document.getElementById('footerBackDiv');
            backBtnDiv.innerHTML = '';
            backBtnDiv.setAttribute('onClick', 'getApi("back")');

            let elementBtn = createButton(footer.back.text, footer.back.action, footer.back['action-data'], footer.back.type, footer.back.name, footer.back.value, footer.back.class, footer.back['icon-left'], footer.back['icon-right']);
            
            backBtnDiv.append(elementBtn);
        }
        if (footer.help) {
            let helpBtnDiv = document.getElementById('footerHelpDiv');
            helpBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.help.text, footer.help.action, footer.help['action-data'], footer.help.type, footer.help.name, footer.help.value, footer.help.class, footer.help['icon-left'], footer.help['icon-right']);
           
            let subText = document.createElement('span');  
            subText.innerHTML = 'Speak with someone live';
            subText.className = 'button text-sm d-block text-decoration-underline';
            subText.style.fontWeight = '400'; 
            elementBtn.append(subText);
    
            helpBtnDiv.append(elementBtn);
        }
    
        if (footer.next) {
            let nextBtnDiv = document.getElementById('footerNextDiv');
            nextBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.next.text, footer.next.action, footer.next['action-data'], footer.next.type, footer.next.name, footer.next.value, footer.next.class, footer.next['icon-left'], footer.next['icon-right']);
            /* ******** NEXT STEP ***** */
            elementBtn.setAttribute('onClick', 'getApi("next")');

           /*  animateModalContent(elementBtn); */

            nextBtnDiv.append(elementBtn);
        }
    }
}

/*********************** CREATE ELEMENTY WITH TEXT ***************************/
function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT AND MAIL ***************************/
function createInputTextAndEmail(type, name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = type;
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/
function createSelect(name, placeholder, className, required, value, options) {
    var element= document.createElement('select');
    element.name = name;
    element.setAttribute('placeholder', placeholder);
    element.required = required;
    element.value = value;

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/
function createButton(text, action, actionData, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 
    element.action = action; 
    element.dataset.action = actionData; 
    if (type){
        element.type = type; 
    } else {
        element.type = 'button';
    }
    element.name = name;
    element.value = value;

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.prepend(icon);

    }
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if(className){
        element.className = className;
    }

    return element;

}

/*********************** CREATE INPUT NUMBER ***************************/
function createInputNumber(value, name, className, minNum, stepNum, disabled) {

    let inputGroup = document.createElement('div');
    inputGroup.className = 'number-input position-relative text-end';

    let btnMinus = document.createElement('button');
    btnMinus.className = 'btn btn-lg text-light btn-step step-down position-absolute start-0 top-50 translate-middle-y';
    btnMinus.type = 'button';
    btnMinus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepDown()');
    inputGroup.append(btnMinus);

    let iconMinus = document.createElement('i');
    iconMinus.className = 'fal fa-minus';
    btnMinus.append(iconMinus);

    let element = document.createElement('input');
    element.type = 'number'; 
    element.value = value;
    element.name = name;
    element.className = className;
    element.setAttribute('min', minNum);
    element.setAttribute('step', stepNum);
    inputGroup.append(element);

    let btnPlus = document.createElement('button');
    btnPlus.className = 'btn btn-lg text-light btn-step step-up position-absolute end-0 top-50 translate-middle-y';
    btnPlus.type = 'button';
    btnPlus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepUp()');
    inputGroup.append(btnPlus);

    let iconPlus = document.createElement('i');
    iconPlus.className = 'fal fa-plus';
    btnPlus.append(iconPlus);

    if (disabled){
        btnMinus.disabled = true;
        element.disabled = true;
        btnPlus.disabled = true;
    }

    return inputGroup;

}

// /*********************** CREATE CHECKBOX ***************************/
function createCheckbox(value, selected, text, name, imgLink, imgAlt, inputValue, textClass) {

    let input = document.createElement('input');
    input.type = 'checkbox'; 
    input.className = 'btn-check',
    input.value = value;
    input.id = value;
    input.name = name;
    input.setAttribute('autocomplete', 'off');

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex flex-column justify-content-center align-items-center py-3_5 px-4';
    label.htmlFor = value;

    let image = document.createElement('img');
    image.src = imgLink;
    image.alt = imgAlt;
    image.className = 'label-check-icon mb-3';
    image.style.height = '132px';
    label.append(image);

    let textCheckbox = document.createElement('span');
    textCheckbox.innerHTML = text;
    textCheckbox.className = textClass;
    label.append(textCheckbox);

    return {input, label};
}

/*********************** CREATE PAGE CHECKBOX ***************************/
function createPageCheckbox(name, text, number) {
    let id = nextID();
    let input = document.createElement('input');
    input.type = 'checkbox';
    input.id = id;
    input.value = text;
    input.name = name;
    input.setAttribute('autocomplete', 'off');
    input.className = 'btn-check btn-check-text';

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    label.htmlFor = id;
    
    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);

    let nameCheckbox = document.createElement('span');
    nameCheckbox.className = 'checkbox-text text-md lh-sm text-500 text-light';
    nameCheckbox.innerHTML = text;
    div.append(nameCheckbox);


    if (number){
        let inputNumberBlock = createInputNumber(number.value, number.name, number.class, number.min, number.step, true);
        div.append(inputNumberBlock);
        div.className = 'd-flex justify-content-between w-100 align-items-center';

        let divIconText = document.createElement('div');
        divIconText.className = 'd-flex';
        divIconText.append(icon);
        divIconText.append(nameCheckbox);
        div.prepend(divIconText);

        let inputNumber = inputNumberBlock.querySelector('input');
        inputNumber.style.width = '30px';

        inputNumberBlock.lastChild.className = 'border-0 bg-trasparent text-light btn-step step-down';
        inputNumberBlock.firstChild.className = 'border-0 bg-trasparent text-light btn-step step-up';




        input.onchange = function() {
        var numberElements = this.parentNode.querySelector('.number-input').children;
        let elDisabled = !this.checked;
            for(let el in numberElements ) {
                numberElements[el].disabled = elDisabled;
            }
        };
   
    }

    return {input, label};
}

/*********************** BUTTON ADD NEW PAGE ***************************/
function addNewPage(btn){

    var id = nextID();

    let col = document.createElement('div');
    col.className = 'col-12 col-md-6 mb-4 col-page-checkbox'
    
    let inputCheckbox = document.createElement('input');
    inputCheckbox.type = 'checkbox';
    /*Add name*/
    inputCheckbox.name = btn.parentNode.querySelector('[name]').name; 
    /*Add vlaue*/
    inputCheckbox.value = '';
    inputCheckbox.className = 'btn-check btn-check-text';
    inputCheckbox.checked = true;
    inputCheckbox.id = `newPage-${id}`;
    col.append(inputCheckbox);

    let label = document.createElement('label');
    label.setAttribute('for' , `newPage-${id}`);
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    col.append(label);

    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);
   
    let inputText = document.createElement('input');
    inputText.type = 'text';
    inputText.value = '';
    inputText.id = nextID();
    inputText.setAttribute('onchange', `updateCheckboxValue(this, '${inputCheckbox.id}')`);
    inputText.setAttribute('onfocusout', 'checkboxInputFocusOut(this)');
    inputText.placeholder = 'Your site';
    inputText.className = 'checkbox-text inputValid border-0 text-md lh-sm text-500 text-light bg-transparent';
    div.append(inputText);

    btn.parentNode.querySelector('.row').append(col);

    document.getElementById(`newPage-${id}`).focus();

}