const modal = document.getElementById('modalMain');
let stepCount = 1;
let currentStep = 1;

/*********************** FUNCTION COUNT ID ***************************/
var id_count = 0;
/* Returns the next unique ID to use */
function nextID() {
    return ++id_count;
}

/*********************** UPDATE CHECKBOX VALUE ***************************/
function updateCheckboxValue(inputText, id) {

    let checkbox = document.getElementById(id);
    checkbox.value = inputText.value;

    let label = inputText.parentElement.parentElement;

    let checkboxListContainer = document.getElementById('checkboxList');

    let inputCheckboxes = checkboxListContainer.querySelectorAll('input[type="checkbox"]');

    let count = 0;

    for (const inputCheckbox of inputCheckboxes) {
        if (inputCheckbox.value.toLowerCase().trim() === checkbox.value.toLowerCase().trim()){
            count++;
        }
    }

    if (count > 1){
        label.classList.add('checkbox-invalid');
        inputText.style.setProperty('color', 'red', 'important');
        checkbox.checked = false;
        checkbox.disabled = true;

    } else {
        label.classList.remove('checkbox-invalid');
        inputText.style.color = '#815AF0';
        checkbox.disabled = false;
    }
}


/*********************** CHECKBOX INPUT FOCUS OUT ***************************/
function checkboxInputFocusOut(inputText) {

    let inputCheckbox = inputText.closest('.col-page-checkbox').querySelector('input[type="checkbox"]');

    if (inputText.value == 0){
        inputCheckbox.checked = false;
    } else if (!inputText.closest('.col-page-checkbox').querySelector('label.checkbox-invalid')){
        inputCheckbox.checked = true;
    }
}


/*********************** GET API ***************************/
function callApiPost(action, callback){

    let url = `https://ivannah.buildmy.ca/private/webarray/BuildMy_ca/api/2022-09-27/${action}.php`;

    var xhr = new XMLHttpRequest();
    xhr.open('POST', url, true);
    xhr.onload = function() {

    var jsonData = JSON.parse(xhr.responseText);
    if(callback) callback(jsonData);
 
    if (xhr.readyState == 4 && xhr.status == 200) {
      console.log('ok');
    } else {
       console.log('error');
    }};
     
     var formData = new FormData(document.getElementById('estimate-form')); 
     xhr.send(formData);

    }


/*********************** GET API STEP ***************************/

getApi(stepCount);

function getApi(step){

    let animateClass; 
    if (currentStep < step){
        animateClass = 'animate-modal-next';
    } else {
        animateClass = 'animate-modal-back';
    }

    callApiPost(step, function(jsonData){
        if(jsonData.status.code == 200){

            showModal(jsonData.result);

            let modalBody = document.querySelector('#modalMain .modal-body');
            modalBody.classList.add(animateClass);
            setTimeout(function() {
                modalBody.classList.remove(animateClass);
            }, 900);
        }
     });
 }

/* **************** END API RESULT ******************* */
function showModal(modalData) {

    currentStep = modalData.session.step;
    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');
    
    contentHeader.innerHTML = '';
    questionList.innerHTML = '';

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].element;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTION ****************** */
    let col = document.createElement('div');
    col.className = 'col-10'
    questionList.append(col);

    let elementClass;
    
    for (let j in modalData.question) {

        if(modalData.question[j].type === 'text' || modalData.question[j].type === 'email'){
            col.classList.add('col-xl-8');

            elementClass = 'form-control form-control-xl mb-4';

            let input =  createInputTextAndEmail(modalData.question[j].type, modalData.question[j].name, modalData.question[j].placeholder, elementClass, modalData.question[j].required, modalData.question[j].value);
            col.append(input);

        } else if(modalData.question[j].element === 'select'){
            col.classList.add('col-xl-8');

            elementClass = 'select-box mb-4 mb-lg-4 mb-xl-4';

            let eleSelect = createSelect(modalData.question[j].name, modalData.question[j].placeholder, elementClass, modalData.question[j].required, modalData.question[j].selected, modalData.question[j].options);
            col.append(eleSelect);

        } else if(modalData.question[j].type === 'number'){

            col.classList.add('col-xl-8');

            elementClass = 'form-control form-control-xl rounded-3 text-center w-100 mb-4';

            let numberGroup = createInputNumber(modalData.question[j].value, modalData.question[j].name, elementClass,  modalData.question[j].min, modalData.question[j].step);
            col.append(numberGroup);
        } else if(modalData.question[j].element === 'button'){
            if(modalData.question[j].items) {

                col.classList.add('text-center');

                let items = modalData.question[j].items;

                for(let q in items){
                    let btn = items[q];
                    let button =  createButton(btn.text, btn.action, 'button', btn.name, btn.value, btn.class, btn.icon_left, btn.icon_right);
    
                    if (btn.text === 'Finish'){
                        button.setAttribute('data-bs-dismiss', 'modal');
                    }   

                    col.append(button);
                }
            } else {
                col.classList.add('text-center');

                let button =  createButton(modalData.question[j].text, modalData.question[j].action, modalData.question[j].type, modalData.question[j].name, modalData.question[j].value, modalData.question[j].class, modalData.question[j].icon_left, modalData.question[j].icon_right);
                
                if (modalData.question[j].name === 'add_page'){
                    button.setAttribute('onClick', 'addNewPage(this)');

                } else if(modalData.question[j].value === 'start'){
                    button.setAttribute('onclick', 'nextStep()');
                }

                col.append(button);
            }
        } else if(modalData.question[j].type === 'image_checkbox'){

            let name = modalData.question[j].name;
            let items = modalData.question[j].options;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row); 

            
            for( let a in items){

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-md-6 mb-4';
                
                if(!(items.length < 3 || items.length == 4)){
                    checkboxCol.classList.add('col-xl-4');
                }

                let item = items[a];

                let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                let type = 'checkbox';

                let {input, label} = createCheckbox(item.value, type, item.selected, item.text, name, item.image, item.image_alt, item.input, textClass);
                checkboxCol.append(input);
                checkboxCol.append(label);

                row.append(checkboxCol);

            }

        } else if(modalData.question[j].type === 'page_checkbox'){

            let name = modalData.question[j].name;
            let items = modalData.question[j].options;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row); 

            
            for( let s in items){
                row.id = 'checkboxList';

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-md-6 mb-4';
                

                let item = items[s];

                let {input, label} = createPageCheckbox(name, item.text, item.number, item.checked);
                checkboxCol.append(input);
                checkboxCol.append(label);
            
                row.append(checkboxCol);


            }

        } else if(modalData.question[j].type === 'image_radio'){
            
            let name = modalData.question[j].name;
            let items = modalData.question[j].options;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row);

            for( let b in items){

                let radioCol = document.createElement('div');
                radioCol.className = 'col-12 col-md-6 mb-4';

                if(!(items.length < 3 || items.length == 4)){
                    radioCol.classList.add('col-xl-4');
                }
                let item = items[b];

                   
                let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-capitalize text-center label-title';
                let type = 'radio';

                let {input, label} = createCheckbox(item.value, type, item.selected, item.text, name, item.image_url, item.image_alt, item.input, textClass);
                radioCol.append(input);
                radioCol.append(label);
                row.append(radioCol);
            }
        }
    }


    /* ******************* FOOTER ****************** */
    showFooter(modalData.footer); 
    
    /* *********************** ADD MY TOM SELECT ************************** */
    document.querySelectorAll('.tom-select').forEach((el)=>{
        let settings = {};
         new TomSelect(el,settings);
    });

}
/* ******************* ANIMATION MODAL CONTENT ****************** */
/* function animateModalContent(step) {
    let questionList = document.getElementById('questionList');
    if (step == 'next'){
        questionList.classList.add('animate-modal-next');
        setTimeout(function() {
            questionList.classList.remove('animate-modal-next');
          }, 900);
    } else if (step == 'back'){
        questionList.classList.add('animate-modal-back');
        setTimeout(function() {
            questionList.classList.remove('animate-modal-back');
        }, 900);
    }
} */

// let qList = document.querySelector('#modalMain .modal-body');

/* ******** BACK STEP ***** */
function backStep() {
    stepCount--;
    getApi(stepCount);
    /* ******************* ANIMATION MODAL CONTENT ****************** */
    // qList.classList.add('animate-modal-back');
    //     setTimeout(function() {
    //         qList.classList.remove('animate-modal-back');
    //     }, 900);
}

 /* ******** NEXT STEP ***** */
function nextStep() {
    stepCount++;
    getApi(stepCount);

/* ******************* ANIMATION MODAL CONTENT ****************** */
    // qList.classList.add('animate-modal-next');
    //     setTimeout(function() {
    //         qList.classList.remove('animate-modal-next');
    //       }, 900);
}

/* let form = document.getElementById('estimate-form');
form.onsubmit = 'return false'; */

/*********************** CREATE FOOTER ***************************/
function showFooter(footer){
    let modalFooter = document.getElementById('modalFooter');
  
    modalFooter.classList.add('d-none');

    if (footer.back && footer.next){
        modalFooter.classList.remove('d-none');
        
        if (footer.back) {
            let backBtnDiv = document.getElementById('footerBackDiv');
            backBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.back.text, footer.back.action, footer.back.type, footer.back.name, footer.back.value, footer.back.class, footer.back.icon_left, footer.back.icon_right);
             
            elementBtn.setAttribute('onclick', 'backStep()');

            backBtnDiv.append(elementBtn);
        }
        if (footer.help) {
            let helpBtnDiv = document.getElementById('footerHelpDiv');
            helpBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.help.text, footer.help.action, footer.help.type, footer.help.name, footer.help.value, footer.help.class, footer.help.icon_left, footer.help.icon_right);
    
            helpBtnDiv.append(elementBtn);
        }
        if (footer.next) {
            let nextBtnDiv = document.getElementById('footerNextDiv');
            nextBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.next.text, footer.next.action, footer.next.type, footer.next.name, footer.next.value, footer.next.class, footer.next.icon_left, footer.next.icon_right);
            
            elementBtn.setAttribute('onclick', 'nextStep()');

            nextBtnDiv.append(elementBtn);
        }
    }
}

/*********************** CREATE ELEMENTY WITH TEXT ***************************/
function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT AND MAIL ***************************/
function createInputTextAndEmail(type, name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = type;
    element.name = name;
    element.placeholder = placeholder;
    element.required = required;
    element.value = value;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/
function createSelect(name, placeholder, className, required, selected, options) {
    var element= document.createElement('select');
    element.name = name;
    element.setAttribute('placeholder', placeholder);
    element.required = required;
    element.selected = selected; /* <-- ??? */
    //element.value = value; remove on selected

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        option.selected = options[i].selected;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/
function createButton(text, action, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 
    element.action = action; 

    if (type){
        element.type = type; 
    } else {
        element.type = 'button';
    }
    element.name = name;
    element.value = value;

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.prepend(icon);
    }
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if (className){
        element.className = className;
    }

    return element;

}

/*********************** CREATE INPUT NUMBER ***************************/
function createInputNumber(value, name, className, minNum, stepNum, disabled) {

    let inputGroup = document.createElement('div');
    inputGroup.className = 'number-input position-relative text-end';

    let btnMinus = document.createElement('button');
    btnMinus.className = 'btn btn-lg text-light btn-step step-down position-absolute start-0 top-50 translate-middle-y';
    btnMinus.type = 'button';
    btnMinus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepDown()');
    inputGroup.append(btnMinus);

    let iconMinus = document.createElement('i');
    iconMinus.className = 'fal fa-minus';
    btnMinus.append(iconMinus);

    let element = document.createElement('input');
    element.type = 'number'; 
    element.value = value;
    element.name = name;
    element.className = className;
    element.setAttribute('min', minNum);
    element.setAttribute('step', stepNum);
    inputGroup.append(element);

    let btnPlus = document.createElement('button');
    btnPlus.className = 'btn btn-lg text-light btn-step step-up position-absolute end-0 top-50 translate-middle-y';
    btnPlus.type = 'button';
    btnPlus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepUp()');
    inputGroup.append(btnPlus);

    let iconPlus = document.createElement('i');
    iconPlus.className = 'fal fa-plus';
    btnPlus.append(iconPlus);

    if (disabled){
        btnMinus.disabled = true;
        element.disabled = true;
        btnPlus.disabled = true;
    }

    return inputGroup;

}

// /*********************** CREATE CHECKBOX ***************************/
function createCheckbox(value, type, selected, text, name, imgLink, imgAlt, inputValue, textClass) {

    let input = document.createElement('input');
    input.type = type; 
    input.className = 'btn-check',
    input.value = value;
    input.id = value;
    input.name = name;
    input.setAttribute('autocomplete', 'off');

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex flex-column justify-content-center align-items-center py-3_5 px-4';
    label.htmlFor = value;

    let image = document.createElement('img');
    image.src = `assets/images/icon-popup/${imgLink}`;
    image.alt = imgAlt;
    image.className = 'label-check-icon mb-3';
    image.style.height = '132px';
    label.append(image);

    let textCheckbox = document.createElement('span');
    textCheckbox.innerHTML = text;
    textCheckbox.className = textClass;
    label.append(textCheckbox);

    return {input, label};
}

/*********************** CREATE PAGE CHECKBOX ***************************/
function createPageCheckbox(name, text, number) {
    let id = nextID();
    let input = document.createElement('input');
    input.type = 'checkbox';
    input.id = id;
    input.value = text;
    input.name = name;
    input.setAttribute('autocomplete', 'off');
    input.className = 'btn-check btn-check-text';

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    label.htmlFor = id;
    
    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);

    let nameCheckbox = document.createElement('span');
    nameCheckbox.className = 'checkbox-text text-md lh-sm text-500 text-light';
    nameCheckbox.innerHTML = text;
    div.append(nameCheckbox);


    if (number){
        let inputNumberBlock = createInputNumber(number.value, number.name, number.class, number.min, number.step, true);
        div.append(inputNumberBlock);
        div.className = 'd-flex justify-content-between w-100 align-items-center';

        let divIconText = document.createElement('div');
        divIconText.className = 'd-flex';
        divIconText.append(icon);
        divIconText.append(nameCheckbox);
        div.prepend(divIconText);

        let inputNumber = inputNumberBlock.querySelector('input');
        inputNumber.style.width = '30px';

        inputNumberBlock.lastChild.className = 'border-0 bg-trasparent text-light btn-step step-down';
        inputNumberBlock.firstChild.className = 'border-0 bg-trasparent text-light btn-step step-up';

        input.onchange = function() {
        var numberElements = this.parentNode.querySelector('.number-input').children;
        let elDisabled = !this.checked;
            for(let el in numberElements ) {
                numberElements[el].disabled = elDisabled;
            }
        };
   
    }

    return {input, label};
}

/*********************** BUTTON ADD NEW PAGE ***************************/
function addNewPage(btn){

    var id = nextID();

    let col = document.createElement('div');
    col.className = 'col-12 col-md-6 mb-4 col-page-checkbox'
    
    let inputCheckbox = document.createElement('input');
    inputCheckbox.type = 'checkbox';
    inputCheckbox.name = btn.parentNode.querySelector('[name]').name; 
    inputCheckbox.value = '';
    inputCheckbox.className = 'btn-check btn-check-text';
    inputCheckbox.checked = true;
    inputCheckbox.id = `newPage-${id}`;
    col.append(inputCheckbox);

    let label = document.createElement('label');
    label.setAttribute('for' , `newPage-${id}`);
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    col.append(label);

    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);
   
    let inputText = document.createElement('input');
    inputText.type = 'text';
    inputText.value = '';
    inputText.id = nextID();
    inputText.setAttribute('onchange', `updateCheckboxValue(this, '${inputCheckbox.id}')`);
    inputText.setAttribute('onfocusout', 'checkboxInputFocusOut(this)');
    inputText.placeholder = 'Your site';
    inputText.className = 'checkbox-text inputValid border-0 text-md lh-sm text-500 text-light bg-transparent';
    div.append(inputText);

    btn.parentNode.querySelector('.row').append(col);

    document.getElementById(`newPage-${id}`).focus();

}