let stepAction;
var id_count = 0;

/*********************** FUNCTION SHOW MODAL ***************************/
function showModal() {
    setHiddenActionInput('action', 'new');

    callApiPost(function(jsonData){
        
        if(jsonData.status.code == 200){
            createModal(jsonData.result);
        }
        
        checkRequired();

        const modal = new bootstrap.Modal(document.getElementById('modalQuote'), {});
        modal.show();
     });
}

/*********************** FUNCTION COUNT ID ***************************/
function nextID() {
    return ++id_count;
}

/*********************** UPDATE CHECKBOX VALUE ***************************/
function updateCheckboxValue(inputText, id) {

    let checkbox = document.getElementById(id);
    checkbox.value = inputText.value;

    if(checkbox.value){
        checkbox.checked = true;
    }

    let label = inputText.parentElement.parentElement;

    let checkboxListContainer = document.getElementById('checkboxList');

    let inputCheckboxes = checkboxListContainer.querySelectorAll('input[type="checkbox"]');

    let count = 0;

    for (const inputCheckbox of inputCheckboxes) {
        if (inputCheckbox.value.toLowerCase().trim() === checkbox.value.toLowerCase().trim()){
            count++;
        }
    }

    if (count > 1){
        label.classList.add('checkbox-invalid');
        inputText.style.setProperty('color', 'red', 'important');
        checkbox.checked = false;
        checkbox.disabled = true;

    } else {
        label.classList.remove('checkbox-invalid');
        inputText.style.color = '#815AF0';
        checkbox.disabled = false;
    }
}


/*********************** CHECKBOX INPUT FOCUS OUT ***************************/
function checkboxInputFocusOut(inputText) {

    let inputCheckbox = inputText.closest('.col-page-checkbox').querySelector('input[type="checkbox"]');

    if (inputText.value == 0){
        inputCheckbox.checked = false;
    } else if (!inputText.closest('.col-page-checkbox').querySelector('label.checkbox-invalid')){
        inputCheckbox.checked = true;
    }
}

/*********************** CHECK REQUIRED ***************************/
function checkRequired() {
    let formModal = document.getElementById('estimate-form');
    let allAreFilled = true;

    formModal.querySelectorAll('[required]').forEach(function(i) {
        if (!allAreFilled) return;

        if (i.type === 'radio') {
          let radioValueCheck = false;
          formModal.querySelectorAll(`[name=${i.name}]`).forEach(function(r) {
            if (r.checked) radioValueCheck = true;
          })
          allAreFilled = radioValueCheck;

          return;
        }

        if (i.type === 'checkbox') {
          let checkboxValueCheck = false;
          formModal.querySelectorAll(`[name="${i.name}"]`).forEach(function(j) {
            if (j.checked) checkboxValueCheck = true;
          })
          allAreFilled = checkboxValueCheck;

          return;
        }

        if (i.type === 'email') {
            let checkboxValueCheck = false;

            if (i.matches(':valid')){
                checkboxValueCheck = true;
            }
            allAreFilled = checkboxValueCheck;
  
            return;
        }

        if (!i.value) {
          allAreFilled = false;

          return;

          }
    })

    let button = formModal.querySelector('button[value="start"],button[value="next"],button[value="continue"]');
    button.disabled = !allAreFilled;
}


/*********************** GET API ***************************/
function callApiPost(callback){

    let url = 'https://buildmy.ca/estimate/api/index.php';

    var xhr = new XMLHttpRequest();
    xhr.open('POST', url, true);
    xhr.withCredentials = true;
    xhr.onload = function() {

        var jsonData = JSON.parse(xhr.responseText);
        if(callback) callback(jsonData);
    
        if (xhr.readyState == 4 && xhr.status == 200) {
        console.log('ok');
        } else {
        console.log('error');
        }
    };
     
     var formData = new FormData(document.getElementById('estimate-form')); 
     xhr.send(formData);

    }

/*********************** GET API STEP ***************************/
function getApi(step){

    let animateClass; 
    
    if (step == 'next'){
        animateClass = 'animate-modal-next';
    } else if(step == 'back'){
        animateClass = 'animate-modal-back';
    }

    callApiPost(function(jsonData){
        if(jsonData.status.code == 200){

            let modalBody = document.querySelector('#modalQuote .modal-body')
            modalBody.classList.add(animateClass);
            setTimeout(function() {
                modalBody.classList.remove(animateClass);
            }, 900);

            createModal(jsonData.result);
            checkRequired();
        }
     });
 }

/* **************** END API RESULT ******************* */
function createModal(modalData) {
    let contentHeader = document.getElementById('contentHeader');
    let questionList = document.getElementById('questionList');

    contentHeader.innerHTML = '';
    questionList.innerHTML = '';

    /* ******************* HIDDEN SESSION ****************** */
    for (let name in modalData.session) {
       let inputHidden = createHiddenInput(name, modalData.session[name]);
       contentHeader.append(inputHidden);
    }

    /* ******************* HEADER CONTENT ****************** */
    for (let i in modalData.content) {
        let type = modalData.content[i].element;
        let text = modalData.content[i].html;
        let className = modalData.content[i].class;
        if (text) {
            let title = createElementWithText(type, text, className);
            contentHeader.append(title);
        }
    }

    /* ******************* FORM QUESTION ****************** */
    let col = document.createElement('div');
    col.className = 'col-10'
    questionList.append(col);

    let elementClass;
    
    for (let j in modalData.question) {

        if(modalData.question[j].type === 'text' || modalData.question[j].type === 'email'){
            col.classList.add('col-xl-8');

            elementClass = 'form-control form-control-xl mb-4';

            let input =  createInputTextAndEmail(modalData.question[j].type, modalData.question[j].name, modalData.question[j].placeholder, elementClass, modalData.question[j].required, modalData.question[j].value);
            col.append(input);

        } else if(modalData.question[j].element === 'select'){
            col.classList.add('col-xl-8');

            elementClass = 'select-box mb-4 mb-lg-4 mb-xl-4';

            let eleSelect = createSelect(modalData.question[j].name, modalData.question[j].placeholder, elementClass, modalData.question[j].required, modalData.question[j].selected, modalData.question[j].options);
            col.append(eleSelect);

        } else if(modalData.question[j].type === 'number'){

            col.classList.add('col-xl-8');

            elementClass = 'form-control form-control-xl rounded-3 text-center w-100 mb-4';

            let numberGroup = createInputNumber(modalData.question[j].value, modalData.question[j].name, elementClass, modalData.question[j].required);
            col.append(numberGroup);

        } else if(modalData.question[j].element === 'button'){
            col.classList.add('text-center');

            let button =  createButton(modalData.question[j].text, modalData.question[j].action, modalData.question[j].type, modalData.question[j].name, modalData.question[j].value, modalData.question[j].class, modalData.question[j].icon_left, modalData.question[j].icon_right);
            
            if (modalData.question[j].type === 'function'){
                button.setAttribute('onClick', 'addNewPage(this)');

            } else if(modalData.question[j].value === 'start' || modalData.question[j].value === 'continue' || modalData.question[j].value === 'type_help'){
                button.setAttribute('onclick', 'nextStep(this)');

            } else if (modalData.question[j].type === 'href'){
                button.setAttribute('onclick', `window.location.href='${modalData.question[j].action}'`);

            } else if (modalData.question[j].type === 'dismiss'){
                button.setAttribute('data-bs-dismiss', 'modal');
            }

            col.append(button);
       
        } else if(modalData.question[j].type === 'image_checkbox'){

           let checkboxRow = createCheckboxElement(modalData.question[j], 'checkbox');
           col.append(checkboxRow);

        } else if(modalData.question[j].type === 'regular_checkbox'){

            let name = modalData.question[j].name;
            let items = modalData.question[j].options;
            let required = modalData.question[j].required;

            let row = document.createElement('div');
            row.className = 'row';
            col.append(row); 

            
            for( let s in items){
                row.id = 'checkboxList';

                let checkboxCol = document.createElement('div');
                checkboxCol.className = 'col-12 col-xl-6 mb-4';
                
                let item = items[s];

                let {input, label} = createPageCheckbox(name, item.text, item.input, item.selected, required, item.checked);
                checkboxCol.append(input);
                checkboxCol.append(label);
            
                row.append(checkboxCol);
            }

        } else if(modalData.question[j].type === 'image_radio'){
            
            let checkboxRow = createCheckboxElement(modalData.question[j], 'radio');
            col.append(checkboxRow);
      
        }
    }


    /* ******************* FOOTER ****************** */
    showFooter(modalData.footer); 
    
    /* *********************** ADD MY TOM SELECT ************************** */
    document.querySelectorAll('.tom-select').forEach((el)=>{
        
         new TomSelect(el,{maxOptions: null});
    });

    /* *********************** CHECK REQUIRED ************************** */
    document.getElementById('estimate-form').querySelectorAll('[required]').forEach(function(el){
        el.addEventListener('change', (event) => {
          checkRequired();
        });
    });
}

/* ******** CREATE INPUT CHECKBOX AND RADIO ***** */
function createCheckboxElement(elementData, elementType){
    let name = elementData.name;
    let items = elementData.options;
    let required = elementData.required;
    let type = elementType;
    
    let row = document.createElement('div');
    row.className = 'row';
   
    for( let a in items){

        let checkboxCol = document.createElement('div');
        checkboxCol.className = 'col-12 col-md-6 mb-4';
        
        if(!(items.length < 3 || items.length == 4)){
            checkboxCol.classList.add('col-xl-4');
        }

        let item = items[a];

        let textClass = 'd-flex align-items-center text-md lh-sm text-500 text-secondary text-center label-title';

        let {input, label} = createCheckbox(item.value, type, item.selected, required, item.text, name, item.image_filename, item.image_alt, item.input, textClass);
        checkboxCol.append(input);
        checkboxCol.append(label);

        row.append(checkboxCol);

    }

    return row;
}
/* ******** HIDDEN ACTION INPUT ***** */

function setHiddenActionInput(name, value) {
    let inputHiddenAction = document.getElementById('hiddenAction');
    inputHiddenAction.name = name;
    inputHiddenAction.value = value;
}

/* ******** BACK STEP ***** */
function backStep(button) {

    setHiddenActionInput(button.name, button.value);

    stepAction = 'back';

    getApi(stepAction);
}

 /* ******** NEXT STEP ***** */
function nextStep(button) {

    setHiddenActionInput(button.name, button.value);

    stepAction = 'next';
    
    getApi(stepAction);
}


/*********************** CREATE FOOTER ***************************/
function showFooter(footer){
    let modalFooter = document.getElementById('modalFooter');

    modalFooter.classList.add('d-none');

    if (footer.back && footer.next){
        modalFooter.classList.remove('d-none');
        
        if (footer.back) {
            let backBtnDiv = document.getElementById('footerBackDiv');
            backBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.back.text, footer.back.action, footer.back.type, footer.back.name, footer.back.value, footer.back.class, footer.back.icon_left, footer.back.icon_right);
             
            elementBtn.setAttribute('onclick', 'backStep(this)');

            backBtnDiv.append(elementBtn);
        }
        if (footer.help) {
            let helpBtnDiv = document.getElementById('footerHelpDiv');
            helpBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.help.text, footer.help.action, footer.help.type, footer.help.name, footer.help.value, footer.help.class, footer.help.icon_left, footer.help.icon_right);
    
            helpBtnDiv.append(elementBtn);
        }
        if (footer.next) {
            let nextBtnDiv = document.getElementById('footerNextDiv');
            nextBtnDiv.innerHTML = '';

            let elementBtn = createButton(footer.next.text, footer.next.action, footer.next.type, footer.next.name, footer.next.value, footer.next.class, footer.next.icon_left, footer.next.icon_right);
            
            elementBtn.setAttribute('onclick', 'nextStep(this)');

            nextBtnDiv.append(elementBtn);
        }
    }
}

/*********************** CREATE ELEMENTY WITH TEXT ***************************/
function createElementWithText(elementType, text, className){
    let element = document.createElement(elementType);
    element.innerHTML = text;

    if(className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE INPUT TEXT AND MAIL ***************************/
function createInputTextAndEmail(type, name, placeholder, className, required, value){
    let element = document.createElement('input');
    element.type = type;
    element.placeholder = placeholder;
    element.required = required;

    if (name != null){
        element.name = name;
    }

    if (value != null){
        element.setAttribute('value', value);
    }

    if (className){
        element.className = className;
    }

    return element;
}

/*********************** CREATE SELECT ***************************/
function createSelect(name, placeholder, className, required, selected, options) {
    var element= document.createElement('select');
    element.name = name;
    element.setAttribute('placeholder', placeholder);
    element.required = required;
    element.selected = selected; 

    var placeholderOption = document.createElement('option');
    element.appendChild(placeholderOption);

    for( let i in options){
        var option = document.createElement('option');
        option.text = options[i].text;
        option.value = options[i].value;
        option.selected = options[i].selected;
        element.appendChild(option);
    }

    if(className){
        element.className = className + ' tom-select';
    }

    return element;

}

/*********************** CREATE BUTTONS ***************************/
function createButton(text, action, type, name, value, className, iconLeft, iconRight) {

    let element = document.createElement('button');
    element.innerHTML = text; 

    if (action != null && type != 'href') {
        element.setAttribute('action', action);
    }

    if (type) {
        element.type = type; 

    } else {
        element.type = 'button';
    }

    if (name != null) {
        element.name = name;
    }

    if (value != null) {
        element.value = value;
    }

    let icon = document.createElement('i');
    if (iconLeft) {
        icon.className = iconLeft;
        element.prepend(icon);
    }
    
    if (iconRight){
        icon.className = iconRight;
        element.append(icon);
    }

    if (className){
        element.className = className;
    }

    return element;

}

/*********************** CREATE INPUT NUMBER ***************************/
function createInputNumber(value, name, className, required, disabled) {

    let inputGroup = document.createElement('div');
    inputGroup.className = 'number-input position-relative text-end';

    let btnMinus = document.createElement('button');
    btnMinus.className = 'btn btn-lg text-light btn-step step-down position-absolute start-0 top-50 translate-middle-y';
    btnMinus.type = 'button';
    btnMinus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepDown()');
    inputGroup.append(btnMinus);

    let iconMinus = document.createElement('i');
    iconMinus.className = 'fal fa-minus';
    btnMinus.append(iconMinus);

    let element = document.createElement('input');
    element.type = 'number'; 
    element.className = className;
    element.required = required;
    element.setAttribute('min', '1');

    if (name != null){
        element.name = name;
    }

    if (value != null){
        element.setAttribute('value', value);
    }

    inputGroup.append(element);

    let btnPlus = document.createElement('button');
    btnPlus.className = 'btn btn-lg text-light btn-step step-up position-absolute end-0 top-50 translate-middle-y';
    btnPlus.type = 'button';
    btnPlus.setAttribute('onclick', 'this.parentNode.querySelector(\'input[type=number]\').stepUp()');
    inputGroup.append(btnPlus);

    let iconPlus = document.createElement('i');
    iconPlus.className = 'fal fa-plus';
    btnPlus.append(iconPlus);

    if (disabled){
        btnMinus.disabled = true;
        element.disabled = true;
        btnPlus.disabled = true;
    }

    return inputGroup;

}

// /*********************** CREATE CHECKBOX ***************************/
function createCheckbox(value, type, selected, required, text, name, imgLink, imgAlt, inputValue, textClass) {  

    let input = document.createElement('input');
    input.type = type; 
    input.className = 'btn-check',
    input.required = required;
    input.checked = selected;

    input.id = value;
    input.setAttribute('autocomplete', 'off');

    if(value != null){
        input.value = value;
    }

    if(name != null){
        if(type == 'checkbox'){
            input.name = name + '[]';
        } else {
            input.name = name;
        }
    }

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex flex-column justify-content-center align-items-center py-3_5 px-4';
    label.htmlFor = value;

    let image = document.createElement('img');
    image.src = imgLink;
    image.className = 'label-check-icon mb-3';
    image.style.height = '132px';

    if(imgAlt != null){
        image.alt = imgAlt;
    }

    label.append(image);

    let textCheckbox = document.createElement('span');
    textCheckbox.innerHTML = text;
    textCheckbox.className = textClass;
    label.append(textCheckbox);

    return {input, label};
}

/*********************** CREATE PAGE CHECKBOX ***************************/
function createPageCheckbox(name, text, number, selected, required) {
    let id = nextID();
    let input = document.createElement('input');
    input.type = 'checkbox';
    input.id = id;
    input.setAttribute('autocomplete', 'off');
    input.className = 'btn-check btn-check-text';
    input.selected = selected;
    input.required = required;

    if(name != null){
        input.name = name + '[]';
    }

    if(text != null){
        input.value = text;
    }

    let label = document.createElement('label');
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    label.htmlFor = id;
    
    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);

    let nameCheckbox = document.createElement('span');
    nameCheckbox.className = 'checkbox-text text-md lh-sm text-500 text-light';
    nameCheckbox.innerHTML = text;
    div.append(nameCheckbox);


    if (number){
        let elementClass = 'text-light text-md lh-sm text-500 border-0 bg-trasparent text-center';
        let inputNumberBlock = createInputNumber(number.value, number.name, elementClass, required, true);
        div.append(inputNumberBlock);
        div.className = 'd-flex justify-content-between w-100 align-items-center';

        let divIconText = document.createElement('div');
        divIconText.className = 'd-flex';
        divIconText.append(icon);
        divIconText.append(nameCheckbox);
        div.prepend(divIconText);

        let inputNumber = inputNumberBlock.querySelector('input');
        inputNumber.style.width = '2rem';
        inputNumber.required = required;

        inputNumberBlock.lastChild.className = 'border-0 bg-trasparent text-light btn-step step-down';
        inputNumberBlock.firstChild.className = 'border-0 bg-trasparent text-light btn-step step-up';

        input.onchange = function() {
        let numberElements = this.parentNode.querySelector('.number-input').children;
        let elDisabled = !this.checked;
            for(let el in numberElements ) {
                numberElements[el].disabled = elDisabled;
            }
        };
   
    }

    return {input, label};
}

/*********************** BUTTON ADD NEW PAGE ***************************/
function addNewPage(btn){

    var id = nextID();

    let col = document.createElement('div');
    col.className = 'col-12 col-xl-6 mb-4 col-page-checkbox'
    
    let inputCheckbox = document.createElement('input');
    inputCheckbox.type = 'checkbox';
    inputCheckbox.name = btn.parentNode.querySelector('[name]').name; 
    inputCheckbox.value = '';
    inputCheckbox.className = 'btn-check btn-check-text focus-new-page';
    inputCheckbox.checked = false;
    inputCheckbox.id = `newPage-${id}`;
    col.append(inputCheckbox);

    let label = document.createElement('label');
    label.setAttribute('for' , `newPage-${id}`);
    label.className = 'label-check border border-2 border-light-gray w-100 d-flex align-items-center p-4';
    col.append(label);

    let div = document.createElement('div');
    div.className = 'd-flex align-items-center w-100';
    label.append(div);

    let icon = document.createElement('i');
    icon.className = 'far fa-circle text-light me-3 pe-1 text-xl position-relative';
    div.append(icon);


    let inputText = document.createElement('input');
    inputText.type = 'text';
    inputText.value = '';
    inputText.id = nextID();
    inputText.setAttribute('onkeydown', `updateCheckboxValue(this, '${inputCheckbox.id}')`);
    inputText.setAttribute('onfocus', 'this.value = this.value');
    inputText.setAttribute('onfocusout', 'checkboxInputFocusOut(this)');
    inputText.placeholder = 'Your site';
    inputText.className = 'checkbox-text inputValid border-0 text-md lh-sm text-500 text-light bg-transparent';
    div.append(inputText);


    btn.parentNode.querySelector('.row').append(col);

    document.getElementById(`newPage-${id}`).parentNode.querySelector('input[type="text"]').focus();
}
/*********************** CREATE HIDDEN INPUT ***************************/
function createHiddenInput(name, value){
    let element = document.createElement('input');
    element.setAttribute('hidden', true);

    if(name){
        element.name = name;
    }

    if(value){
        element.value = value;
    }

    return element;
}