const monthArr = ['January','February','March','April','May','June','July','August','September','October','November','December'];
const minYear = 2000;
const maxYear = 2099;


document.querySelectorAll('.js-calendar').forEach(function(el) {
    initCalendar(el);

    el.querySelector('.calendar-month-prev').addEventListener('click', (event) => {
        initPrevMonthCalendar(event)

    });

    el.querySelector('.calendar-month-next').addEventListener('click', (event) => {
        initNextMonthCalendar(event)

    });
});

function initPrevMonthCalendar(event) {
    let calEl = event.target.closest('.js-calendar');

    var date = new Date(parseInt(calEl.dataset.calYear), parseInt(calEl.dataset.calMonth), 1);
    
    if (date.getMonth() == 0) {
        date.setYear(date.getFullYear() - 1);
        date.setMonth(11);
    } else {
        date.setMonth(date.getMonth() - 1);
    }

    calEl.dataset.calYear = date.getFullYear();
    calEl.dataset.calMonth = date.getMonth();

    initCalendar(calEl);
}

function initNextMonthCalendar(event) {
    let calEl = event.target.closest('.js-calendar');

    var date = new Date(parseInt(calEl.dataset.calYear), parseInt(calEl.dataset.calMonth), 1);
    if (date.getMonth() == 11)
    {
        date.setYear(date.getFullYear() + 1);
        date.setMonth(0);
    } else {
        date.setMonth(date.getMonth() + 1);
    }

    calEl.dataset.calYear = date.getFullYear();
    calEl.dataset.calMonth = date.getMonth();

    initCalendar(calEl);
}

function initCalendar(calEl) {
    let calMonth = parseInt(calEl.dataset.calMonth), 
    calYear = parseInt(calEl.dataset.calYear), 
    /* calHour = parseInt(calEl.dataset.calHour), 
    calMin = parseInt(calEl.dataset.calMin),  */
    monthName,
    dateNow = new Date(),
    selectedDayValue = calEl.querySelector('input.js-selected-date').value;

    dateNow.setHours(0,0,0,0);

    if (!calMonth && calMonth != 0 || calMonth < 0 || calMonth >= 12 || !calYear || calYear <= minYear || calYear > maxYear){
        calMonth = dateNow.getMonth();
        calYear = dateNow.getFullYear();

        calEl.dataset.calMonth = calMonth;
        calEl.dataset.calYear = calYear;
        
        calEl.querySelector('input.js-selected-date').value = `${dateNow.getFullYear()}-${dateNow.getMonth()+1}-${dateNow.getDate()}`;
        selectedDayValue = `${dateNow.getFullYear()}-${dateNow.getMonth()+1}-${dateNow.getDate()}`;
    }

    monthName = monthArr[calMonth];
/* 
    if (!calHour || calHour < 0 || calHour > 23 || !calMin || calMin < 0 || calMin > 59) {
        calHour = 00;
        calMin = 00;

        calEl.dataset.calHour = calHour;
        calEl.dataset.calMin = calMin;
    } */

    calEl.querySelector('.calendar-month-name').innerHTML = `${monthName} ${calYear}`;

    let calendarDaysContainer = calEl.querySelector('.calendar-days');
    calendarDaysContainer.innerHTML = '';

    let firstMonthDay = new Date(calYear, calMonth, 1);
    let firstMonthDayIndex = firstMonthDay.getDay();

    if (firstMonthDayIndex != 0) {

        let daysBefore = new Date(firstMonthDay.getFullYear(), firstMonthDay.getMonth(), 1);
        daysBefore.setDate(1 - firstMonthDayIndex); 

        for (let index = daysBefore.getDate(); index < daysBefore.getDate() + firstMonthDayIndex; index++) {
            let day = new Date(daysBefore.getFullYear(), daysBefore.getMonth(), index);
            appendDay(day, 'calendar-day text-light');
        }
    }

    let lastMonthDay = new Date(calYear, calMonth + 1, 0);
    let lastMonthDayIndex = lastMonthDay.getDay();
    
    for (let index = 1; index <= lastMonthDay.getDate(); index++) {
        let day = new Date(lastMonthDay.getFullYear(), lastMonthDay.getMonth(), index);
        appendDay(day);
    }

    if (lastMonthDay != 6) {
        let nextMonthYear, nextMonthNumber;

        if (lastMonthDay.getMonth() == 11) {
            nextMonthYear = lastMonthDay.getFullYear() + 1;
            nextMonthNumber = 0;
        } else {
            nextMonthYear = lastMonthDay.getFullYear();
            nextMonthNumber = lastMonthDay.getMonth() + 1;
        }

        for (let index = 1; index <= 6 - lastMonthDayIndex; index++) {
            let day = new Date(nextMonthYear, nextMonthNumber, index);
            day.toISOString
            appendDay(day, 'calendar-day text-light');
        }
    }

    if (selectedDayValue) {
        calendarDaysContainer.querySelectorAll('.calendar-day').forEach((day) => {
            if (day.dataset.date == selectedDayValue) {
                day.classList.add('active');
            }
        });
    }

    function appendDay(day, dayClass = 'calendar-day') {
        let dayDiv = document.createElement('div');
        dayDiv.className = dayClass;
        dayDiv.innerHTML = day.getDate();
        dayDiv.dataset.date = `${day.getFullYear()}-${day.getMonth()+1}-${day.getDate()}`;
        calendarDaysContainer.append(dayDiv);

        if (day < dateNow){
            dayDiv.classList.add('day-disabled');
        }
    }

    calendarDaysContainer.querySelectorAll('.calendar-day').forEach(function(el) {
        el.addEventListener('click', () => {
            activeDay(el);
        })
    })

    function activeDay(el) {
        let curActive = el.parentElement.querySelector('.active');
    
        if (curActive) {
            curActive.classList.remove('active');
        }
    
        el.classList.add('active');
        el.closest('.js-calendar').querySelector('input.js-selected-date').value = el.dataset.date;
    }
}

/* TOM SELECT */
let modalWebsiteConsultation = document.getElementById('modalWebsiteConsultation')
modalWebsiteConsultation.addEventListener('show.bs.modal', function (event) {
    let websiteConsultationHour = document.getElementById('websiteConsultationHour');

    if (websiteConsultationHour) {
        for (let index = 1; index < 13; index++) {
            let option = document.createElement('option');
            option.value = index;
            option.innerHTML = index;
            websiteConsultationHour.append(option);
        }
    
        let settings = { controlInput: null }
    
        new TomSelect(websiteConsultationHour, settings);
    }
    
    let websiteConsultationMinutes = document.getElementById('websiteConsultationMinutes');
    
    if (websiteConsultationMinutes) {
        let settings = { controlInput: null }
    
        new TomSelect(websiteConsultationMinutes, settings);
    }
    
    let websiteConsultationTimeType = document.getElementById('websiteConsultationTimeType');
    
    if (websiteConsultationTimeType) {
        let settings = { controlInput: null }
    
        new TomSelect(websiteConsultationTimeType, settings);	
    }
    
    let timeZone = document.getElementById('timeZone');
    
    if (timeZone) {
        let settings = { controlInput: null }
    
        new TomSelect(timeZone, settings);	
    }
})


/* FORM */
let websiteConsultationForm = document.getElementById('websiteConsultationForm');

websiteConsultationForm.addEventListener('submit', function(event) {

    event.preventDefault();	

    var formData = new FormData(websiteConsultationForm);

    grecaptcha.ready(function() {

        grecaptcha.execute('6LdMLa4cAAAAALe3fZb0afV_C_TMjLxsMwqDqD_l', {action:'submit'}).then(function(token) {

            formData.append('wa-recaptcha', token);

            var req = new XMLHttpRequest();

            req.open('POST', 'https://mailer.apps.webarray.com/post/kloaZDPTQDDy29dyu9CPiZyT1uhuy4ZK', false);

            req.onreadystatechange = function() {

                if (this.readyState === XMLHttpRequest.DONE && this.status === 200) {

                    Swal.fire({
                        icon: 'success',
                        title: 'Thank You!',
                        text: 'Your submission has been sent.'
                    })

                    let bsModalWebsiteConsultation = bootstrap.Modal.getInstance(modalWebsiteConsultation);
                    bsModalWebsiteConsultation.hide();

                    websiteConsultationForm.reset();

                }	

                else {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!'
                    })
                }
            }

            req.send(formData);

        });

    });

});