/* OFFCANVAS */
var offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'))
var offcanvasList = offcanvasElementList.map(function (offcanvasEl) {
  return new bootstrap.Offcanvas(offcanvasEl)
})

/* MASONRY OFFER */
var masonryOfferEl = document.getElementById('masonryOffer');
if (masonryOfferEl) {
	var masonryOfferDescEl = document.getElementById('masonryOfferDesc');
	var masonryOfferDescCollapseElementList = [].slice.call(masonryOfferDescEl.querySelectorAll('.collapse'))
	var masonryOfferDescCollapseList = masonryOfferDescCollapseElementList.map(function (collapseEl) {
	  return new bootstrap.Collapse(collapseEl, {
		toggle: false
	  })
	})
	
	var masonryOfferCollapseElementList = [].slice.call(masonryOfferEl.querySelectorAll('.collapse'))
	var masonryOfferCollapseList = masonryOfferCollapseElementList.map(function (collapseEl) {
	  var collapse = new bootstrap.Collapse(collapseEl, {
		toggle: false
	  });
	
	  collapseEl.addEventListener('hide.bs.collapse', function () {
		for (const key in masonryOfferDescCollapseList) {
		  masonryOfferDescCollapseList[key].hide();
		} 
	  })  
	
	  return collapse;
	})
}
/* GO_TO_TAB */
function goToTab(el) {
	window.location.href = el.href;
	location.reload();
}

/* DROP ZONE*/
document.querySelectorAll('.drop-zone-input').forEach((inputElement) => {
	addDropZoneEvents(inputElement);
});

function addDropZoneEvents(inputElement) {
	const dropZoneElement = inputElement.closest('.drop-zone');

	dropZoneElement.addEventListener('click', (e) => {
		inputElement.click();
	});

	inputElement.addEventListener('change', (e) => {
		if (inputElement.files.length) {
			updateThumbnail(dropZoneElement, inputElement.files[0]);
		}
	});

	dropZoneElement.addEventListener('dragover', (e) => {
		e.preventDefault();
		dropZoneElement.classList.add('drop-zone-over');
	});

	['dragleave', 'dragend'].forEach((type) => {
		dropZoneElement.addEventListener(type, (e) => {
			dropZoneElement.classList.remove('drop-zone-over');
		});
	});

	dropZoneElement.addEventListener('drop', (e) => {
		e.preventDefault();

		if (e.dataTransfer.files.length) {
			inputElement.files = e.dataTransfer.files;
			updateThumbnail(dropZoneElement, e.dataTransfer.files[0]);
		}

		dropZoneElement.classList.remove('drop-zone-over');
	});
}

function updateThumbnail(dropZoneElement, file) {
	let thumbnailElement = dropZoneElement.querySelector('.drop-zone-thumb');

	if (dropZoneElement.querySelector('.drop-zone-prompt')) {
		dropZoneElement.querySelector('.drop-zone-prompt').remove();
	}	

	if (!thumbnailElement) {
		thumbnailElement = document.createElement('div');
		thumbnailElement.classList.add('drop-zone-thumb');
		dropZoneElement.appendChild(thumbnailElement);		
	}

	let dropZoneElementName = dropZoneElement.querySelector('.drop-zone-thumb-name');

	if (!dropZoneElementName) {
		dropZoneElementName = document.createElement('div');
		dropZoneElementName.classList.add('drop-zone-thumb-name');
		dropZoneElementName.innerText = file.name;
		thumbnailElement.appendChild(dropZoneElementName);		

		let deleteThumbnailBtn = document.createElement('span');
		deleteThumbnailBtn.className = 'fi-rr-cross drop-zone-delete-thumbnail'
		dropZoneElementName.appendChild(deleteThumbnailBtn);

		deleteThumbnailBtn.addEventListener('click', (e) => {

			dropZoneElement.remove();
			e.stopImmediatePropagation();
		});
	}

	if (file.type.startsWith('image/')) {
		const reader = new FileReader();

		reader.readAsDataURL(file);
		reader.onload = () => {
			thumbnailElement.style.backgroundImage = `url('${reader.result}')`;
		};
	} else if (file.name.split('.').pop() == 'pdf') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PDF.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'docx') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/DOC.svg)';
		thumbnailElement.classList.add('bg-not-cover');

	} else if (file.name.split('.').pop() == 'psd') {
		thumbnailElement.style.backgroundImage = 'url(../../../dist/images/icons/PSD.svg)';
		thumbnailElement.classList.add('bg-not-cover');
	} 
	else {
		thumbnailElement.style.backgroundImage = null;
	}
	addDropZone();

}

function addDropZone() {
	let dropZoneContainer = document.getElementById('dropZone');
	
	let dropZone = document.createElement('div');
	dropZone.className = 'drop-zone mb-4';
	dropZoneContainer.append(dropZone);

	let dropZonePrompt = document.createElement('div');
	dropZonePrompt.className = 'drop-zone-prompt';
	dropZone.append(dropZonePrompt);

	let dropZonePromptIcon = document.createElement('span');
	dropZonePromptIcon.className = 'drop-zone-prompt-img fi-rr-upload me-2';
	dropZonePrompt.append(dropZonePromptIcon);


	let dropZonePromptTitle = document.createElement('span');
	dropZonePromptTitle.innerText = 'Drag & Drop Project Files';
	dropZonePrompt.append(dropZonePromptTitle);
	
	let dropZoneInput = document.createElement('input');
	dropZoneInput.type = 'file';
	dropZoneInput.className = 'drop-zone-input';
	dropZone.append(dropZoneInput);

	addDropZoneEvents(dropZoneInput);
}

/* IMAGES BACKROUND SRC */
let list = document.getElementsByClassName('js-image-src');

for (let i = 0; i < list.length; i++) {
  let src = list[i].getAttribute('data-image-src');
  list[i].style.backgroundImage="url('" + src + "')";
}

/* FORM SUBSCRIBE NUMBER  */
let formSubscribeNumberInput = document.getElementById('formSubscribeNumber').querySelector('#formSubscribeNumberInput');
let modalRequestCallBack = document.getElementById('modalRequestCallBack');
let formRequestCallBackNumInput = modalRequestCallBack.querySelector('#formRequestCallBackNumInput');

modalRequestCallBack.addEventListener('show.bs.modal', function () {
	formRequestCallBackNumInput.value = formSubscribeNumberInput.value;
})


/* FORMS */
let bsModalUploadedFilesEl = document.getElementById('modalFormUploadedFiles');
let bsModalFormSuccessEl = document.getElementById('modalRequestSendSuccess');
let bsModalFormErrorEl = document.getElementById('modalRequestSendError');
let btnTryAgain = document.getElementById('btnTryAgain');

if (bsModalFormSuccessEl) {
	bsModalFormSuccessEl.addEventListener('shown.bs.modal', function () {
		if (modalRequestCallBack) {
			bootstrap.Modal.getOrCreateInstance(modalRequestCallBack).hide();
		}

		if (bsModalUploadedFilesEl) {
			bootstrap.Modal.getOrCreateInstance(bsModalUploadedFilesEl).hide(); 
		}
	})
}

if (bsModalFormErrorEl) {
	bsModalFormErrorEl.addEventListener('shown.bs.modal', function () {
		if (modalRequestCallBack) {
			bootstrap.Modal.getOrCreateInstance(modalRequestCallBack).hide();
		}

		if (bsModalUploadedFilesEl) {
			bootstrap.Modal.getOrCreateInstance(bsModalUploadedFilesEl).hide(); 
		}
	})
}

let kayMailer = 'ASwvlV3rN1b9DiC0r8f85c4MBI9KGShb';

/*  MODAL FORM CALL YOU BACK */

let formRequestCallBack = document.getElementById('formRequestCallBack');

formRequestCallBack.addEventListener('submit', function(event) {

	event.preventDefault();

	if (!formRequestCallBack.checkValidity()) {

		formRequestCallBack.classList.add('form-validated')
		
		    return false;
		}

	let formData = new FormData(formRequestCallBack);

	sendForm(formData, formRequestCallBack.id);

});

/* FORM CONTACT US */
let contactUsForm = document.getElementById('contactUsForm');

if(contactUsForm){
	contactUsForm.addEventListener('submit', function(event) {

		event.preventDefault();

		if (!contactUsForm.checkValidity()) {

			contactUsForm.classList.add('form-validated')

				return false;
			}
	
		let formData = new FormData(contactUsForm);
	
		sendForm(formData, contactUsForm.id);
	});
}

/* FORM GET A QUOTE */
let formGetAQuote = document.getElementById('formGetAQuote');

if(formGetAQuote){
	formGetAQuote.addEventListener('submit', function(event) {

		event.preventDefault();

		if (!formGetAQuote.checkValidity()) {

			formGetAQuote.classList.add('form-validated')

				return false;
			}

		let formData = new FormData(formGetAQuote);
	
		var inputsFile = formGetAQuote.querySelectorAll('input[type="file"]');
		if(inputsFile){
			bootstrap.Modal.getOrCreateInstance(bsModalUploadedFilesEl).show();
			inputsFile.forEach(input =>{
				if(input.files.length == 1){
					formData.append("FileUpload[]",input.files[0]);
				}
			})
		}
	
		sendForm(formData, formGetAQuote.id);
	});	
}


function sendForm(formData, formId) {
	grecaptcha.ready(function() {
	
		grecaptcha.execute('6LdMLa4cAAAAALe3fZb0afV_C_TMjLxsMwqDqD_l', {action:'submit'}).then(function(token) {

			formData.append('wa-recaptcha', token);

			var req = new XMLHttpRequest();
			req.open('POST', `https://mailer.apps.webarray.com/post/${kayMailer}`, false);

			req.onreadystatechange = function() {

				if (this.readyState === XMLHttpRequest.DONE && this.status === 200) {

					bootstrap.Modal.getOrCreateInstance(bsModalFormSuccessEl).show(); // show success message
					
					
				} else {

					bootstrap.Modal.getOrCreateInstance(bsModalFormErrorEl).show(); // show error message
					
					btnTryAgain.href = `#${formId}`;
				}
			}
			req.send(formData);
		});
	});
}



/* *********************** AOS ************************** */
$(window).on('load', function() {
	AOS.init({
		// Global settings:
		disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
		startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
		initClassName: 'aos-init', // class applied after initialization
		animatedClassName: 'aos-animate', // class applied on animation
		useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
		disableMutationObserver: false, // disables automatic mutations' detections (advanced)
		debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
		throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)
		
	
		// Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
		offset: 120, // offset (in px) from the original trigger point
		delay: 0, // values from 0 to 3000, with step 50ms
		duration: 400, // values from 0 to 3000, with step 50ms
		easing: 'ease', // default easing for AOS animations
		once: true, // whether animation should happen only once - while scrolling down
		mirror: false, // whether elements should animate out while scrolling past them
		anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation
	});
});



