
//  MENU TOGGLE
//--------------

const toggle = document.querySelector(".toggle");
const menu = document.querySelector(".top-navbar");
const items = document.querySelectorAll(".menu-item");

/* Toggle mobile menu */
function toggleMenu() {
  if (menu.classList.contains("active")) {
    menu.classList.remove("active");
    toggle.querySelector("a").innerHTML = "<i class='bi bi-list'></i>";
  } else {
    menu.classList.add("active");
    toggle.querySelector("a").innerHTML = "<i class='bi bi-x'></i>";
  }
}

/* Event Listeners */
toggle.addEventListener("click", toggleMenu, false);





//  CALENDER
//-----------

const date = new Date();

const months = [
	"January",
	"February",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December",
];

const weekDay = [
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday", 
	"Sunday"
	];


var renderCalender = () => {

	date.setDate(1);
	
	const lastDay = new Date(date.getUTCFullYear(), date.getMonth()+1, 0).getDate();

	const prevLastDay = new Date(date.getUTCFullYear(), date.getMonth(), 0).getDate();
	
	const firstDayIndex = date.getDay();

	const lastDayIndex = new Date(date.getUTCFullYear(), date.getMonth()+1, 0).getDay();
	const nextDays = 7 - lastDayIndex;

	
	
	const year = date.getUTCFullYear();

	let currentDate = document.querySelectorAll('#cal .current, #card .current');

	for(let q = 0; q < currentDate.length; q++) {
		currentDate[q].innerHTML = months[date.getMonth()] + ' '+ year;
	}
	
	let monthDays = document.querySelector('#cal .dates');
	let monthDaysModal = document.querySelector('#card .dates');


	let days = "";	

	for(let x = firstDayIndex; x > 1; x--) {
		days += `<div class="prev-date">${prevLastDay - x + 1}</div>`;
	}

	for(let i = 1; i <= lastDay; i++) {
		if( i === new Date().getDate() && date.getMonth() === new Date().getMonth() ) {
			days += `<div class="date today" onclick="getDate(this)">${i}</div>`;
			//days += `<div class="date today">${i}</div>`;
		} else {
			days += `<div class="date" onclick="getDate(this)">${i}</div>`;
			// days += `<div class="date">${i}</div>`;
		} 		
	}

	for(let y = 1; y <= nextDays; y++) {
		days += `<div class="next-date">${y}</div>`;
		monthDays.innerHTML = days;
		monthDaysModal.innerHTML = days;
	}
}


//change month

document.getElementById("prev1").addEventListener("click", () => {
	date.setMonth(date.getMonth()-1);
	renderCalender();
});
document.getElementById("prev2").addEventListener("click", () => {
	date.setMonth(date.getMonth()-1);
	renderCalender();
});


document.getElementById("next1").addEventListener("click", () => {
	date.setMonth(date.getMonth()+1);
	renderCalender();
});
document.getElementById("next2").addEventListener("click", () => {
	date.setMonth(date.getMonth()+1);
	renderCalender();
});


renderCalender();



//  GET DATE
//--------------------------

function getDate($this) {

		let myModal = new bootstrap.Modal(document.getElementById("bookCall"), {});

		if (document.getElementById("bookCall").classList.contains("show")) {		

			let getMonth = date.getMonth()+1;
			let month = ('0' + getMonth).slice(-2);
			let getYear = date.getFullYear();
			let weekDayName = weekDay[date.getUTCDay()];			
		 	
		 	let styleElems = document.querySelectorAll(".date");
			for(let i=0;i<styleElems.length;i++){			 
				styleElems[i].style.cssText = "border: 1px solid #fff;";
				event.target.style.cssText = "border: 1px solid #EB008B; color: #EB008B; background-color: #fff";
			}


			//modal 1
			document.getElementById('date-display').innerHTML = 'Choosed date: ' + $this.innerHTML + '.' + month + '.' + getYear;


			//modal 2
			document.getElementById('full-date').innerHTML = weekDayName + ', ' + months[date.getMonth()] + ' ' + $this.innerHTML + ', ' + getYear;

		} else {
			myModal.show();
		}

}




//  GET HOUR
//--------------------------

function getHour() {
	let val = event.target.innerText;
	document.getElementById("setHour").innerHTML = val;
}


//  MODAL - TABLE WITH HOURS
//--------------------------

// Add active class to the current button (highlight it)
	let sectionHours = document.getElementById("sectionHours");
	let hourBox = sectionHours.getElementsByClassName("hourBox");

	for (let i = 0; i < hourBox.length; i++) {

		hourBox[i].addEventListener("click", function() {

			let current = document.getElementsByClassName("active");

			if (current.length > 0) { 
				current[0].className = current[0].className.replace(" active", "");
			}

	  		this.className += " active";

		});
	};



//  POPOVER
//--------------------------

	var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
	
	var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
		return new bootstrap.Popover(popoverTriggerEl)
	});

//popover dismiss
	var popover = new bootstrap.Popover(document.querySelector('.popover-dismiss'), {
	  trigger: 'focus'
	});









